/*
 * Decompiled with CFR 0.152.
 */
package android.os;

import android.os.Binder;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.RemoteException;

public interface IHintSession
extends IInterface {
    public static final String DESCRIPTOR = "android.os.IHintSession";

    public void updateTargetWorkDuration(long var1) throws RemoteException;

    public void reportActualWorkDuration(long[] var1, long[] var2) throws RemoteException;

    public void close() throws RemoteException;

    public void sendHint(int var1) throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements IHintSession {
        static final int TRANSACTION_updateTargetWorkDuration = 1;
        static final int TRANSACTION_reportActualWorkDuration = 2;
        static final int TRANSACTION_close = 3;
        static final int TRANSACTION_sendHint = 4;

        public Stub() {
            this.attachInterface(this, IHintSession.DESCRIPTOR);
        }

        public static IHintSession asInterface(IBinder obj) {
            if (obj == null) {
                return null;
            }
            IInterface iin = obj.queryLocalInterface(IHintSession.DESCRIPTOR);
            if (iin != null && iin instanceof IHintSession) {
                return (IHintSession)iin;
            }
            return new Proxy(obj);
        }

        @Override
        public IBinder asBinder() {
            return this;
        }

        public static String getDefaultTransactionName(int transactionCode) {
            switch (transactionCode) {
                case 1: {
                    return "updateTargetWorkDuration";
                }
                case 2: {
                    return "reportActualWorkDuration";
                }
                case 3: {
                    return "close";
                }
                case 4: {
                    return "sendHint";
                }
            }
            return null;
        }

        @Override
        public String getTransactionName(int transactionCode) {
            return Stub.getDefaultTransactionName(transactionCode);
        }

        @Override
        public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
            String descriptor = IHintSession.DESCRIPTOR;
            if (code >= 1 && code <= 0xFFFFFF) {
                data.enforceInterface(descriptor);
            }
            switch (code) {
                case 1598968902: {
                    reply.writeString(descriptor);
                    return true;
                }
            }
            switch (code) {
                case 1: {
                    long _arg0 = data.readLong();
                    data.enforceNoDataAvail();
                    this.updateTargetWorkDuration(_arg0);
                    break;
                }
                case 2: {
                    long[] _arg0 = data.createLongArray();
                    long[] _arg1 = data.createLongArray();
                    data.enforceNoDataAvail();
                    this.reportActualWorkDuration(_arg0, _arg1);
                    break;
                }
                case 3: {
                    this.close();
                    break;
                }
                case 4: {
                    int _arg0 = data.readInt();
                    data.enforceNoDataAvail();
                    this.sendHint(_arg0);
                    break;
                }
                default: {
                    return super.onTransact(code, data, reply, flags);
                }
            }
            return true;
        }

        @Override
        public int getMaxTransactionId() {
            return 3;
        }

        private static class Proxy
        implements IHintSession {
            private IBinder mRemote;

            Proxy(IBinder remote) {
                this.mRemote = remote;
            }

            @Override
            public IBinder asBinder() {
                return this.mRemote;
            }

            public String getInterfaceDescriptor() {
                return IHintSession.DESCRIPTOR;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void updateTargetWorkDuration(long targetDurationNanos) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(IHintSession.DESCRIPTOR);
                    _data.writeLong(targetDurationNanos);
                    boolean bl = this.mRemote.transact(1, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void reportActualWorkDuration(long[] actualDurationNanos, long[] timeStampNanos) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(IHintSession.DESCRIPTOR);
                    _data.writeLongArray(actualDurationNanos);
                    _data.writeLongArray(timeStampNanos);
                    boolean bl = this.mRemote.transact(2, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            @Override
            public void close() throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(IHintSession.DESCRIPTOR);
                    boolean bl = this.mRemote.transact(3, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void sendHint(int hint) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(IHintSession.DESCRIPTOR);
                    _data.writeInt(hint);
                    boolean bl = this.mRemote.transact(4, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }
        }
    }

    public static class Default
    implements IHintSession {
        @Override
        public void updateTargetWorkDuration(long targetDurationNanos) throws RemoteException {
        }

        @Override
        public void reportActualWorkDuration(long[] actualDurationNanos, long[] timeStampNanos) throws RemoteException {
        }

        @Override
        public void close() throws RemoteException {
        }

        @Override
        public void sendHint(int hint) throws RemoteException {
        }

        @Override
        public IBinder asBinder() {
            return null;
        }
    }
}

