/*
 * Decompiled with CFR 0.152.
 */
package android.os;

import android.os.Binder;
import android.os.FabricatedOverlayInfo;
import android.os.FabricatedOverlayInternal;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.RemoteException;
import java.util.ArrayList;
import java.util.List;

public interface IIdmap2
extends IInterface {
    public static final String DESCRIPTOR = "android.os.IIdmap2";

    public String getIdmapPath(String var1, int var2) throws RemoteException;

    public boolean removeIdmap(String var1, int var2) throws RemoteException;

    public boolean verifyIdmap(String var1, String var2, String var3, int var4, boolean var5, int var6) throws RemoteException;

    public String createIdmap(String var1, String var2, String var3, int var4, boolean var5, int var6) throws RemoteException;

    public FabricatedOverlayInfo createFabricatedOverlay(FabricatedOverlayInternal var1) throws RemoteException;

    public boolean deleteFabricatedOverlay(String var1) throws RemoteException;

    public int acquireFabricatedOverlayIterator() throws RemoteException;

    public void releaseFabricatedOverlayIterator(int var1) throws RemoteException;

    public List<FabricatedOverlayInfo> nextFabricatedOverlayInfos(int var1) throws RemoteException;

    public String dumpIdmap(String var1) throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements IIdmap2 {
        static final int TRANSACTION_getIdmapPath = 1;
        static final int TRANSACTION_removeIdmap = 2;
        static final int TRANSACTION_verifyIdmap = 3;
        static final int TRANSACTION_createIdmap = 4;
        static final int TRANSACTION_createFabricatedOverlay = 5;
        static final int TRANSACTION_deleteFabricatedOverlay = 6;
        static final int TRANSACTION_acquireFabricatedOverlayIterator = 7;
        static final int TRANSACTION_releaseFabricatedOverlayIterator = 8;
        static final int TRANSACTION_nextFabricatedOverlayInfos = 9;
        static final int TRANSACTION_dumpIdmap = 10;

        public Stub() {
            this.attachInterface(this, IIdmap2.DESCRIPTOR);
        }

        public static IIdmap2 asInterface(IBinder obj) {
            if (obj == null) {
                return null;
            }
            IInterface iin = obj.queryLocalInterface(IIdmap2.DESCRIPTOR);
            if (iin != null && iin instanceof IIdmap2) {
                return (IIdmap2)iin;
            }
            return new Proxy(obj);
        }

        @Override
        public IBinder asBinder() {
            return this;
        }

        public static String getDefaultTransactionName(int transactionCode) {
            switch (transactionCode) {
                case 1: {
                    return "getIdmapPath";
                }
                case 2: {
                    return "removeIdmap";
                }
                case 3: {
                    return "verifyIdmap";
                }
                case 4: {
                    return "createIdmap";
                }
                case 5: {
                    return "createFabricatedOverlay";
                }
                case 6: {
                    return "deleteFabricatedOverlay";
                }
                case 7: {
                    return "acquireFabricatedOverlayIterator";
                }
                case 8: {
                    return "releaseFabricatedOverlayIterator";
                }
                case 9: {
                    return "nextFabricatedOverlayInfos";
                }
                case 10: {
                    return "dumpIdmap";
                }
            }
            return null;
        }

        @Override
        public String getTransactionName(int transactionCode) {
            return Stub.getDefaultTransactionName(transactionCode);
        }

        @Override
        public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
            String descriptor = IIdmap2.DESCRIPTOR;
            if (code >= 1 && code <= 0xFFFFFF) {
                data.enforceInterface(descriptor);
            }
            switch (code) {
                case 1598968902: {
                    reply.writeString(descriptor);
                    return true;
                }
            }
            switch (code) {
                case 1: {
                    String _arg0 = data.readString();
                    int _arg1 = data.readInt();
                    data.enforceNoDataAvail();
                    String _result = this.getIdmapPath(_arg0, _arg1);
                    reply.writeNoException();
                    reply.writeString(_result);
                    break;
                }
                case 2: {
                    String _arg0 = data.readString();
                    int _arg1 = data.readInt();
                    data.enforceNoDataAvail();
                    boolean _result = this.removeIdmap(_arg0, _arg1);
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 3: {
                    String _arg0 = data.readString();
                    String _arg1 = data.readString();
                    String _arg2 = data.readString();
                    int _arg3 = data.readInt();
                    boolean _arg4 = data.readBoolean();
                    int _arg5 = data.readInt();
                    data.enforceNoDataAvail();
                    boolean _result = this.verifyIdmap(_arg0, _arg1, _arg2, _arg3, _arg4, _arg5);
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 4: {
                    String _arg0 = data.readString();
                    String _arg1 = data.readString();
                    String _arg2 = data.readString();
                    int _arg3 = data.readInt();
                    boolean _arg4 = data.readBoolean();
                    int _arg5 = data.readInt();
                    data.enforceNoDataAvail();
                    String _result = this.createIdmap(_arg0, _arg1, _arg2, _arg3, _arg4, _arg5);
                    reply.writeNoException();
                    reply.writeString(_result);
                    break;
                }
                case 5: {
                    FabricatedOverlayInternal _arg0 = data.readTypedObject(FabricatedOverlayInternal.CREATOR);
                    data.enforceNoDataAvail();
                    FabricatedOverlayInfo _result = this.createFabricatedOverlay(_arg0);
                    reply.writeNoException();
                    reply.writeTypedObject(_result, 1);
                    break;
                }
                case 6: {
                    String _arg0 = data.readString();
                    data.enforceNoDataAvail();
                    boolean _result = this.deleteFabricatedOverlay(_arg0);
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 7: {
                    int _result = this.acquireFabricatedOverlayIterator();
                    reply.writeNoException();
                    reply.writeInt(_result);
                    break;
                }
                case 8: {
                    int _arg0 = data.readInt();
                    data.enforceNoDataAvail();
                    this.releaseFabricatedOverlayIterator(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 9: {
                    int _arg0 = data.readInt();
                    data.enforceNoDataAvail();
                    List<FabricatedOverlayInfo> _result = this.nextFabricatedOverlayInfos(_arg0);
                    reply.writeNoException();
                    reply.writeTypedList(_result, 1);
                    break;
                }
                case 10: {
                    String _arg0 = data.readString();
                    data.enforceNoDataAvail();
                    String _result = this.dumpIdmap(_arg0);
                    reply.writeNoException();
                    reply.writeString(_result);
                    break;
                }
                default: {
                    return super.onTransact(code, data, reply, flags);
                }
            }
            return true;
        }

        @Override
        public int getMaxTransactionId() {
            return 9;
        }

        private static class Proxy
        implements IIdmap2 {
            private IBinder mRemote;

            Proxy(IBinder remote) {
                this.mRemote = remote;
            }

            @Override
            public IBinder asBinder() {
                return this.mRemote;
            }

            public String getInterfaceDescriptor() {
                return IIdmap2.DESCRIPTOR;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public String getIdmapPath(String overlayApkPath, int userId) throws RemoteException {
                String _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IIdmap2.DESCRIPTOR);
                    _data.writeString(overlayApkPath);
                    _data.writeInt(userId);
                    boolean _status = this.mRemote.transact(1, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readString();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean removeIdmap(String overlayApkPath, int userId) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IIdmap2.DESCRIPTOR);
                    _data.writeString(overlayApkPath);
                    _data.writeInt(userId);
                    boolean _status = this.mRemote.transact(2, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean verifyIdmap(String targetApkPath, String overlayApkPath, String overlayName, int fulfilledPolicies, boolean enforceOverlayable, int userId) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IIdmap2.DESCRIPTOR);
                    _data.writeString(targetApkPath);
                    _data.writeString(overlayApkPath);
                    _data.writeString(overlayName);
                    _data.writeInt(fulfilledPolicies);
                    _data.writeBoolean(enforceOverlayable);
                    _data.writeInt(userId);
                    boolean _status = this.mRemote.transact(3, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public String createIdmap(String targetApkPath, String overlayApkPath, String overlayName, int fulfilledPolicies, boolean enforceOverlayable, int userId) throws RemoteException {
                String _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IIdmap2.DESCRIPTOR);
                    _data.writeString(targetApkPath);
                    _data.writeString(overlayApkPath);
                    _data.writeString(overlayName);
                    _data.writeInt(fulfilledPolicies);
                    _data.writeBoolean(enforceOverlayable);
                    _data.writeInt(userId);
                    boolean _status = this.mRemote.transact(4, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readString();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public FabricatedOverlayInfo createFabricatedOverlay(FabricatedOverlayInternal overlay) throws RemoteException {
                FabricatedOverlayInfo _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IIdmap2.DESCRIPTOR);
                    _data.writeTypedObject(overlay, 0);
                    boolean _status = this.mRemote.transact(5, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readTypedObject(FabricatedOverlayInfo.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean deleteFabricatedOverlay(String path) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IIdmap2.DESCRIPTOR);
                    _data.writeString(path);
                    boolean _status = this.mRemote.transact(6, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int acquireFabricatedOverlayIterator() throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IIdmap2.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(7, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void releaseFabricatedOverlayIterator(int iteratorId) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IIdmap2.DESCRIPTOR);
                    _data.writeInt(iteratorId);
                    boolean _status = this.mRemote.transact(8, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public List<FabricatedOverlayInfo> nextFabricatedOverlayInfos(int iteratorId) throws RemoteException {
                ArrayList<FabricatedOverlayInfo> _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IIdmap2.DESCRIPTOR);
                    _data.writeInt(iteratorId);
                    boolean _status = this.mRemote.transact(9, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.createTypedArrayList(FabricatedOverlayInfo.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public String dumpIdmap(String overlayApkPath) throws RemoteException {
                String _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IIdmap2.DESCRIPTOR);
                    _data.writeString(overlayApkPath);
                    boolean _status = this.mRemote.transact(10, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readString();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }
        }
    }

    public static class Default
    implements IIdmap2 {
        @Override
        public String getIdmapPath(String overlayApkPath, int userId) throws RemoteException {
            return null;
        }

        @Override
        public boolean removeIdmap(String overlayApkPath, int userId) throws RemoteException {
            return false;
        }

        @Override
        public boolean verifyIdmap(String targetApkPath, String overlayApkPath, String overlayName, int fulfilledPolicies, boolean enforceOverlayable, int userId) throws RemoteException {
            return false;
        }

        @Override
        public String createIdmap(String targetApkPath, String overlayApkPath, String overlayName, int fulfilledPolicies, boolean enforceOverlayable, int userId) throws RemoteException {
            return null;
        }

        @Override
        public FabricatedOverlayInfo createFabricatedOverlay(FabricatedOverlayInternal overlay) throws RemoteException {
            return null;
        }

        @Override
        public boolean deleteFabricatedOverlay(String path) throws RemoteException {
            return false;
        }

        @Override
        public int acquireFabricatedOverlayIterator() throws RemoteException {
            return 0;
        }

        @Override
        public void releaseFabricatedOverlayIterator(int iteratorId) throws RemoteException {
        }

        @Override
        public List<FabricatedOverlayInfo> nextFabricatedOverlayInfos(int iteratorId) throws RemoteException {
            return null;
        }

        @Override
        public String dumpIdmap(String overlayApkPath) throws RemoteException {
            return null;
        }

        @Override
        public IBinder asBinder() {
            return null;
        }
    }
}

