/*
 * Decompiled with CFR 0.152.
 */
package android.os;

import android.os.Binder;
import android.os.IBinder;
import android.os.IInterface;
import android.os.IVoldListener;
import android.os.IVoldMountCallback;
import android.os.IVoldTaskListener;
import android.os.Parcel;
import android.os.RemoteException;
import android.os.incremental.IncrementalFileSystemControlParcel;
import java.io.FileDescriptor;

public interface IVold
extends IInterface {
    public static final int FSTRIM_FLAG_DEEP_TRIM = 1;
    public static final int MOUNT_FLAG_PRIMARY = 1;
    public static final int MOUNT_FLAG_VISIBLE_FOR_READ = 2;
    public static final int MOUNT_FLAG_VISIBLE_FOR_WRITE = 4;
    public static final int PARTITION_TYPE_PUBLIC = 0;
    public static final int PARTITION_TYPE_PRIVATE = 1;
    public static final int PARTITION_TYPE_MIXED = 2;
    public static final int STORAGE_FLAG_DE = 1;
    public static final int STORAGE_FLAG_CE = 2;
    public static final int REMOUNT_MODE_NONE = 0;
    public static final int REMOUNT_MODE_DEFAULT = 1;
    public static final int REMOUNT_MODE_INSTALLER = 2;
    public static final int REMOUNT_MODE_PASS_THROUGH = 3;
    public static final int REMOUNT_MODE_ANDROID_WRITABLE = 4;
    public static final int VOLUME_STATE_UNMOUNTED = 0;
    public static final int VOLUME_STATE_CHECKING = 1;
    public static final int VOLUME_STATE_MOUNTED = 2;
    public static final int VOLUME_STATE_MOUNTED_READ_ONLY = 3;
    public static final int VOLUME_STATE_FORMATTING = 4;
    public static final int VOLUME_STATE_EJECTING = 5;
    public static final int VOLUME_STATE_UNMOUNTABLE = 6;
    public static final int VOLUME_STATE_REMOVED = 7;
    public static final int VOLUME_STATE_BAD_REMOVAL = 8;
    public static final int VOLUME_TYPE_PUBLIC = 0;
    public static final int VOLUME_TYPE_PRIVATE = 1;
    public static final int VOLUME_TYPE_EMULATED = 2;
    public static final int VOLUME_TYPE_ASEC = 3;
    public static final int VOLUME_TYPE_OBB = 4;
    public static final int VOLUME_TYPE_STUB = 5;

    public void setListener(IVoldListener var1) throws RemoteException;

    public void abortFuse() throws RemoteException;

    public void monitor() throws RemoteException;

    public void reset() throws RemoteException;

    public void shutdown() throws RemoteException;

    public void onUserAdded(int var1, int var2, int var3) throws RemoteException;

    public void onUserRemoved(int var1) throws RemoteException;

    public void onUserStarted(int var1) throws RemoteException;

    public void onUserStopped(int var1) throws RemoteException;

    public void addAppIds(String[] var1, int[] var2) throws RemoteException;

    public void addSandboxIds(int[] var1, String[] var2) throws RemoteException;

    public void onSecureKeyguardStateChanged(boolean var1) throws RemoteException;

    public void partition(String var1, int var2, int var3) throws RemoteException;

    public void forgetPartition(String var1, String var2) throws RemoteException;

    public void mount(String var1, int var2, int var3, IVoldMountCallback var4) throws RemoteException;

    public void unmount(String var1) throws RemoteException;

    public void format(String var1, String var2) throws RemoteException;

    public void benchmark(String var1, IVoldTaskListener var2) throws RemoteException;

    public void moveStorage(String var1, String var2, IVoldTaskListener var3) throws RemoteException;

    public void remountUid(int var1, int var2) throws RemoteException;

    public void remountAppStorageDirs(int var1, int var2, String[] var3) throws RemoteException;

    public void unmountAppStorageDirs(int var1, int var2, String[] var3) throws RemoteException;

    public void setupAppDir(String var1, int var2) throws RemoteException;

    public void fixupAppDir(String var1, int var2) throws RemoteException;

    public void ensureAppDirsCreated(String[] var1, int var2) throws RemoteException;

    public String createObb(String var1, int var2) throws RemoteException;

    public void destroyObb(String var1) throws RemoteException;

    public void fstrim(int var1, IVoldTaskListener var2) throws RemoteException;

    public void runIdleMaint(boolean var1, IVoldTaskListener var2) throws RemoteException;

    public void abortIdleMaint(IVoldTaskListener var1) throws RemoteException;

    public int getStorageLifeTime() throws RemoteException;

    public void setGCUrgentPace(int var1, int var2, float var3, float var4, int var5, int var6, int var7) throws RemoteException;

    public void refreshLatestWrite() throws RemoteException;

    public int getWriteAmount() throws RemoteException;

    public FileDescriptor mountAppFuse(int var1, int var2) throws RemoteException;

    public void unmountAppFuse(int var1, int var2) throws RemoteException;

    public void fbeEnable() throws RemoteException;

    public void initUser0() throws RemoteException;

    public void mountFstab(String var1, String var2, String var3) throws RemoteException;

    public void encryptFstab(String var1, String var2, boolean var3, String var4, String var5) throws RemoteException;

    public void setStorageBindingSeed(byte[] var1) throws RemoteException;

    public void createUserKey(int var1, int var2, boolean var3) throws RemoteException;

    public void destroyUserKey(int var1) throws RemoteException;

    public void setUserKeyProtection(int var1, String var2) throws RemoteException;

    public int[] getUnlockedUsers() throws RemoteException;

    public void unlockUserKey(int var1, int var2, String var3) throws RemoteException;

    public void lockUserKey(int var1) throws RemoteException;

    public void prepareUserStorage(String var1, int var2, int var3, int var4) throws RemoteException;

    public void destroyUserStorage(String var1, int var2, int var3) throws RemoteException;

    public void prepareSandboxForApp(String var1, int var2, String var3, int var4) throws RemoteException;

    public void destroySandboxForApp(String var1, String var2, int var3) throws RemoteException;

    public void startCheckpoint(int var1) throws RemoteException;

    public boolean needsCheckpoint() throws RemoteException;

    public boolean needsRollback() throws RemoteException;

    public boolean isCheckpointing() throws RemoteException;

    public void abortChanges(String var1, boolean var2) throws RemoteException;

    public void commitChanges() throws RemoteException;

    public void prepareCheckpoint() throws RemoteException;

    public void restoreCheckpoint(String var1) throws RemoteException;

    public void restoreCheckpointPart(String var1, int var2) throws RemoteException;

    public void markBootAttempt() throws RemoteException;

    public boolean supportsCheckpoint() throws RemoteException;

    public boolean supportsBlockCheckpoint() throws RemoteException;

    public boolean supportsFileCheckpoint() throws RemoteException;

    public void resetCheckpoint() throws RemoteException;

    public void earlyBootEnded() throws RemoteException;

    public String createStubVolume(String var1, String var2, String var3, String var4, String var5, int var6) throws RemoteException;

    public void destroyStubVolume(String var1) throws RemoteException;

    public FileDescriptor openAppFuseFile(int var1, int var2, int var3, int var4) throws RemoteException;

    public boolean incFsEnabled() throws RemoteException;

    public IncrementalFileSystemControlParcel mountIncFs(String var1, String var2, int var3, String var4) throws RemoteException;

    public void unmountIncFs(String var1) throws RemoteException;

    public void setIncFsMountOptions(IncrementalFileSystemControlParcel var1, boolean var2, boolean var3, String var4) throws RemoteException;

    public void bindMount(String var1, String var2) throws RemoteException;

    public void destroyDsuMetadataKey(String var1) throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements IVold {
        public static final String DESCRIPTOR = "android.os.IVold";
        static final int TRANSACTION_setListener = 1;
        static final int TRANSACTION_abortFuse = 2;
        static final int TRANSACTION_monitor = 3;
        static final int TRANSACTION_reset = 4;
        static final int TRANSACTION_shutdown = 5;
        static final int TRANSACTION_onUserAdded = 6;
        static final int TRANSACTION_onUserRemoved = 7;
        static final int TRANSACTION_onUserStarted = 8;
        static final int TRANSACTION_onUserStopped = 9;
        static final int TRANSACTION_addAppIds = 10;
        static final int TRANSACTION_addSandboxIds = 11;
        static final int TRANSACTION_onSecureKeyguardStateChanged = 12;
        static final int TRANSACTION_partition = 13;
        static final int TRANSACTION_forgetPartition = 14;
        static final int TRANSACTION_mount = 15;
        static final int TRANSACTION_unmount = 16;
        static final int TRANSACTION_format = 17;
        static final int TRANSACTION_benchmark = 18;
        static final int TRANSACTION_moveStorage = 19;
        static final int TRANSACTION_remountUid = 20;
        static final int TRANSACTION_remountAppStorageDirs = 21;
        static final int TRANSACTION_unmountAppStorageDirs = 22;
        static final int TRANSACTION_setupAppDir = 23;
        static final int TRANSACTION_fixupAppDir = 24;
        static final int TRANSACTION_ensureAppDirsCreated = 25;
        static final int TRANSACTION_createObb = 26;
        static final int TRANSACTION_destroyObb = 27;
        static final int TRANSACTION_fstrim = 28;
        static final int TRANSACTION_runIdleMaint = 29;
        static final int TRANSACTION_abortIdleMaint = 30;
        static final int TRANSACTION_getStorageLifeTime = 31;
        static final int TRANSACTION_setGCUrgentPace = 32;
        static final int TRANSACTION_refreshLatestWrite = 33;
        static final int TRANSACTION_getWriteAmount = 34;
        static final int TRANSACTION_mountAppFuse = 35;
        static final int TRANSACTION_unmountAppFuse = 36;
        static final int TRANSACTION_fbeEnable = 37;
        static final int TRANSACTION_initUser0 = 38;
        static final int TRANSACTION_mountFstab = 39;
        static final int TRANSACTION_encryptFstab = 40;
        static final int TRANSACTION_setStorageBindingSeed = 41;
        static final int TRANSACTION_createUserKey = 42;
        static final int TRANSACTION_destroyUserKey = 43;
        static final int TRANSACTION_setUserKeyProtection = 44;
        static final int TRANSACTION_getUnlockedUsers = 45;
        static final int TRANSACTION_unlockUserKey = 46;
        static final int TRANSACTION_lockUserKey = 47;
        static final int TRANSACTION_prepareUserStorage = 48;
        static final int TRANSACTION_destroyUserStorage = 49;
        static final int TRANSACTION_prepareSandboxForApp = 50;
        static final int TRANSACTION_destroySandboxForApp = 51;
        static final int TRANSACTION_startCheckpoint = 52;
        static final int TRANSACTION_needsCheckpoint = 53;
        static final int TRANSACTION_needsRollback = 54;
        static final int TRANSACTION_isCheckpointing = 55;
        static final int TRANSACTION_abortChanges = 56;
        static final int TRANSACTION_commitChanges = 57;
        static final int TRANSACTION_prepareCheckpoint = 58;
        static final int TRANSACTION_restoreCheckpoint = 59;
        static final int TRANSACTION_restoreCheckpointPart = 60;
        static final int TRANSACTION_markBootAttempt = 61;
        static final int TRANSACTION_supportsCheckpoint = 62;
        static final int TRANSACTION_supportsBlockCheckpoint = 63;
        static final int TRANSACTION_supportsFileCheckpoint = 64;
        static final int TRANSACTION_resetCheckpoint = 65;
        static final int TRANSACTION_earlyBootEnded = 66;
        static final int TRANSACTION_createStubVolume = 67;
        static final int TRANSACTION_destroyStubVolume = 68;
        static final int TRANSACTION_openAppFuseFile = 69;
        static final int TRANSACTION_incFsEnabled = 70;
        static final int TRANSACTION_mountIncFs = 71;
        static final int TRANSACTION_unmountIncFs = 72;
        static final int TRANSACTION_setIncFsMountOptions = 73;
        static final int TRANSACTION_bindMount = 74;
        static final int TRANSACTION_destroyDsuMetadataKey = 75;

        public Stub() {
            this.attachInterface(this, DESCRIPTOR);
        }

        public static IVold asInterface(IBinder obj) {
            if (obj == null) {
                return null;
            }
            IInterface iin = obj.queryLocalInterface(DESCRIPTOR);
            if (iin != null && iin instanceof IVold) {
                return (IVold)iin;
            }
            return new Proxy(obj);
        }

        @Override
        public IBinder asBinder() {
            return this;
        }

        public static String getDefaultTransactionName(int transactionCode) {
            switch (transactionCode) {
                case 1: {
                    return "setListener";
                }
                case 2: {
                    return "abortFuse";
                }
                case 3: {
                    return "monitor";
                }
                case 4: {
                    return "reset";
                }
                case 5: {
                    return "shutdown";
                }
                case 6: {
                    return "onUserAdded";
                }
                case 7: {
                    return "onUserRemoved";
                }
                case 8: {
                    return "onUserStarted";
                }
                case 9: {
                    return "onUserStopped";
                }
                case 10: {
                    return "addAppIds";
                }
                case 11: {
                    return "addSandboxIds";
                }
                case 12: {
                    return "onSecureKeyguardStateChanged";
                }
                case 13: {
                    return "partition";
                }
                case 14: {
                    return "forgetPartition";
                }
                case 15: {
                    return "mount";
                }
                case 16: {
                    return "unmount";
                }
                case 17: {
                    return "format";
                }
                case 18: {
                    return "benchmark";
                }
                case 19: {
                    return "moveStorage";
                }
                case 20: {
                    return "remountUid";
                }
                case 21: {
                    return "remountAppStorageDirs";
                }
                case 22: {
                    return "unmountAppStorageDirs";
                }
                case 23: {
                    return "setupAppDir";
                }
                case 24: {
                    return "fixupAppDir";
                }
                case 25: {
                    return "ensureAppDirsCreated";
                }
                case 26: {
                    return "createObb";
                }
                case 27: {
                    return "destroyObb";
                }
                case 28: {
                    return "fstrim";
                }
                case 29: {
                    return "runIdleMaint";
                }
                case 30: {
                    return "abortIdleMaint";
                }
                case 31: {
                    return "getStorageLifeTime";
                }
                case 32: {
                    return "setGCUrgentPace";
                }
                case 33: {
                    return "refreshLatestWrite";
                }
                case 34: {
                    return "getWriteAmount";
                }
                case 35: {
                    return "mountAppFuse";
                }
                case 36: {
                    return "unmountAppFuse";
                }
                case 37: {
                    return "fbeEnable";
                }
                case 38: {
                    return "initUser0";
                }
                case 39: {
                    return "mountFstab";
                }
                case 40: {
                    return "encryptFstab";
                }
                case 41: {
                    return "setStorageBindingSeed";
                }
                case 42: {
                    return "createUserKey";
                }
                case 43: {
                    return "destroyUserKey";
                }
                case 44: {
                    return "setUserKeyProtection";
                }
                case 45: {
                    return "getUnlockedUsers";
                }
                case 46: {
                    return "unlockUserKey";
                }
                case 47: {
                    return "lockUserKey";
                }
                case 48: {
                    return "prepareUserStorage";
                }
                case 49: {
                    return "destroyUserStorage";
                }
                case 50: {
                    return "prepareSandboxForApp";
                }
                case 51: {
                    return "destroySandboxForApp";
                }
                case 52: {
                    return "startCheckpoint";
                }
                case 53: {
                    return "needsCheckpoint";
                }
                case 54: {
                    return "needsRollback";
                }
                case 55: {
                    return "isCheckpointing";
                }
                case 56: {
                    return "abortChanges";
                }
                case 57: {
                    return "commitChanges";
                }
                case 58: {
                    return "prepareCheckpoint";
                }
                case 59: {
                    return "restoreCheckpoint";
                }
                case 60: {
                    return "restoreCheckpointPart";
                }
                case 61: {
                    return "markBootAttempt";
                }
                case 62: {
                    return "supportsCheckpoint";
                }
                case 63: {
                    return "supportsBlockCheckpoint";
                }
                case 64: {
                    return "supportsFileCheckpoint";
                }
                case 65: {
                    return "resetCheckpoint";
                }
                case 66: {
                    return "earlyBootEnded";
                }
                case 67: {
                    return "createStubVolume";
                }
                case 68: {
                    return "destroyStubVolume";
                }
                case 69: {
                    return "openAppFuseFile";
                }
                case 70: {
                    return "incFsEnabled";
                }
                case 71: {
                    return "mountIncFs";
                }
                case 72: {
                    return "unmountIncFs";
                }
                case 73: {
                    return "setIncFsMountOptions";
                }
                case 74: {
                    return "bindMount";
                }
                case 75: {
                    return "destroyDsuMetadataKey";
                }
            }
            return null;
        }

        @Override
        public String getTransactionName(int transactionCode) {
            return Stub.getDefaultTransactionName(transactionCode);
        }

        @Override
        public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
            String descriptor = DESCRIPTOR;
            if (code >= 1 && code <= 0xFFFFFF) {
                data.enforceInterface(descriptor);
            }
            switch (code) {
                case 1598968902: {
                    reply.writeString(descriptor);
                    return true;
                }
            }
            switch (code) {
                case 1: {
                    IVoldListener _arg0 = IVoldListener.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    this.setListener(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 2: {
                    this.abortFuse();
                    reply.writeNoException();
                    break;
                }
                case 3: {
                    this.monitor();
                    reply.writeNoException();
                    break;
                }
                case 4: {
                    this.reset();
                    reply.writeNoException();
                    break;
                }
                case 5: {
                    this.shutdown();
                    reply.writeNoException();
                    break;
                }
                case 6: {
                    int _arg0 = data.readInt();
                    int _arg1 = data.readInt();
                    int _arg2 = data.readInt();
                    data.enforceNoDataAvail();
                    this.onUserAdded(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    break;
                }
                case 7: {
                    int _arg0 = data.readInt();
                    data.enforceNoDataAvail();
                    this.onUserRemoved(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 8: {
                    int _arg0 = data.readInt();
                    data.enforceNoDataAvail();
                    this.onUserStarted(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 9: {
                    int _arg0 = data.readInt();
                    data.enforceNoDataAvail();
                    this.onUserStopped(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 10: {
                    String[] _arg0 = data.createStringArray();
                    int[] _arg1 = data.createIntArray();
                    data.enforceNoDataAvail();
                    this.addAppIds(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                case 11: {
                    int[] _arg0 = data.createIntArray();
                    String[] _arg1 = data.createStringArray();
                    data.enforceNoDataAvail();
                    this.addSandboxIds(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                case 12: {
                    boolean _arg0 = data.readBoolean();
                    data.enforceNoDataAvail();
                    this.onSecureKeyguardStateChanged(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 13: {
                    String _arg0 = data.readString();
                    int _arg1 = data.readInt();
                    int _arg2 = data.readInt();
                    data.enforceNoDataAvail();
                    this.partition(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    break;
                }
                case 14: {
                    String _arg0 = data.readString();
                    String _arg1 = data.readString();
                    data.enforceNoDataAvail();
                    this.forgetPartition(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                case 15: {
                    String _arg0 = data.readString();
                    int _arg1 = data.readInt();
                    int _arg2 = data.readInt();
                    IVoldMountCallback _arg3 = IVoldMountCallback.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    this.mount(_arg0, _arg1, _arg2, _arg3);
                    reply.writeNoException();
                    break;
                }
                case 16: {
                    String _arg0 = data.readString();
                    data.enforceNoDataAvail();
                    this.unmount(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 17: {
                    String _arg0 = data.readString();
                    String _arg1 = data.readString();
                    data.enforceNoDataAvail();
                    this.format(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                case 18: {
                    String _arg0 = data.readString();
                    IVoldTaskListener _arg1 = IVoldTaskListener.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    this.benchmark(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                case 19: {
                    String _arg0 = data.readString();
                    String _arg1 = data.readString();
                    IVoldTaskListener _arg2 = IVoldTaskListener.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    this.moveStorage(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    break;
                }
                case 20: {
                    int _arg0 = data.readInt();
                    int _arg1 = data.readInt();
                    data.enforceNoDataAvail();
                    this.remountUid(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                case 21: {
                    int _arg0 = data.readInt();
                    int _arg1 = data.readInt();
                    String[] _arg2 = data.createStringArray();
                    data.enforceNoDataAvail();
                    this.remountAppStorageDirs(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    break;
                }
                case 22: {
                    int _arg0 = data.readInt();
                    int _arg1 = data.readInt();
                    String[] _arg2 = data.createStringArray();
                    data.enforceNoDataAvail();
                    this.unmountAppStorageDirs(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    break;
                }
                case 23: {
                    String _arg0 = data.readString();
                    int _arg1 = data.readInt();
                    data.enforceNoDataAvail();
                    this.setupAppDir(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                case 24: {
                    String _arg0 = data.readString();
                    int _arg1 = data.readInt();
                    data.enforceNoDataAvail();
                    this.fixupAppDir(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                case 25: {
                    String[] _arg0 = data.createStringArray();
                    int _arg1 = data.readInt();
                    data.enforceNoDataAvail();
                    this.ensureAppDirsCreated(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                case 26: {
                    String _arg0 = data.readString();
                    int _arg1 = data.readInt();
                    data.enforceNoDataAvail();
                    String _result = this.createObb(_arg0, _arg1);
                    reply.writeNoException();
                    reply.writeString(_result);
                    break;
                }
                case 27: {
                    String _arg0 = data.readString();
                    data.enforceNoDataAvail();
                    this.destroyObb(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 28: {
                    int _arg0 = data.readInt();
                    IVoldTaskListener _arg1 = IVoldTaskListener.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    this.fstrim(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                case 29: {
                    boolean _arg0 = data.readBoolean();
                    IVoldTaskListener _arg1 = IVoldTaskListener.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    this.runIdleMaint(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                case 30: {
                    IVoldTaskListener _arg0 = IVoldTaskListener.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    this.abortIdleMaint(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 31: {
                    int _result = this.getStorageLifeTime();
                    reply.writeNoException();
                    reply.writeInt(_result);
                    break;
                }
                case 32: {
                    int _arg0 = data.readInt();
                    int _arg1 = data.readInt();
                    float _arg2 = data.readFloat();
                    float _arg3 = data.readFloat();
                    int _arg4 = data.readInt();
                    int _arg5 = data.readInt();
                    int _arg6 = data.readInt();
                    data.enforceNoDataAvail();
                    this.setGCUrgentPace(_arg0, _arg1, _arg2, _arg3, _arg4, _arg5, _arg6);
                    reply.writeNoException();
                    break;
                }
                case 33: {
                    this.refreshLatestWrite();
                    reply.writeNoException();
                    break;
                }
                case 34: {
                    int _result = this.getWriteAmount();
                    reply.writeNoException();
                    reply.writeInt(_result);
                    break;
                }
                case 35: {
                    int _arg0 = data.readInt();
                    int _arg1 = data.readInt();
                    data.enforceNoDataAvail();
                    FileDescriptor _result = this.mountAppFuse(_arg0, _arg1);
                    reply.writeNoException();
                    reply.writeRawFileDescriptor(_result);
                    break;
                }
                case 36: {
                    int _arg0 = data.readInt();
                    int _arg1 = data.readInt();
                    data.enforceNoDataAvail();
                    this.unmountAppFuse(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                case 37: {
                    this.fbeEnable();
                    reply.writeNoException();
                    break;
                }
                case 38: {
                    this.initUser0();
                    reply.writeNoException();
                    break;
                }
                case 39: {
                    String _arg0 = data.readString();
                    String _arg1 = data.readString();
                    String _arg2 = data.readString();
                    data.enforceNoDataAvail();
                    this.mountFstab(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    break;
                }
                case 40: {
                    String _arg0 = data.readString();
                    String _arg1 = data.readString();
                    boolean _arg2 = data.readBoolean();
                    String _arg3 = data.readString();
                    String _arg4 = data.readString();
                    data.enforceNoDataAvail();
                    this.encryptFstab(_arg0, _arg1, _arg2, _arg3, _arg4);
                    reply.writeNoException();
                    break;
                }
                case 41: {
                    byte[] _arg0 = data.createByteArray();
                    data.enforceNoDataAvail();
                    this.setStorageBindingSeed(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 42: {
                    int _arg0 = data.readInt();
                    int _arg1 = data.readInt();
                    boolean _arg2 = data.readBoolean();
                    data.enforceNoDataAvail();
                    this.createUserKey(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    break;
                }
                case 43: {
                    int _arg0 = data.readInt();
                    data.enforceNoDataAvail();
                    this.destroyUserKey(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 44: {
                    int _arg0 = data.readInt();
                    String _arg1 = data.readString();
                    data.enforceNoDataAvail();
                    this.setUserKeyProtection(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                case 45: {
                    int[] _result = this.getUnlockedUsers();
                    reply.writeNoException();
                    reply.writeIntArray(_result);
                    break;
                }
                case 46: {
                    int _arg0 = data.readInt();
                    int _arg1 = data.readInt();
                    String _arg2 = data.readString();
                    data.enforceNoDataAvail();
                    this.unlockUserKey(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    break;
                }
                case 47: {
                    int _arg0 = data.readInt();
                    data.enforceNoDataAvail();
                    this.lockUserKey(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 48: {
                    String _arg0 = data.readString();
                    int _arg1 = data.readInt();
                    int _arg2 = data.readInt();
                    int _arg3 = data.readInt();
                    data.enforceNoDataAvail();
                    this.prepareUserStorage(_arg0, _arg1, _arg2, _arg3);
                    reply.writeNoException();
                    break;
                }
                case 49: {
                    String _arg0 = data.readString();
                    int _arg1 = data.readInt();
                    int _arg2 = data.readInt();
                    data.enforceNoDataAvail();
                    this.destroyUserStorage(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    break;
                }
                case 50: {
                    String _arg0 = data.readString();
                    int _arg1 = data.readInt();
                    String _arg2 = data.readString();
                    int _arg3 = data.readInt();
                    data.enforceNoDataAvail();
                    this.prepareSandboxForApp(_arg0, _arg1, _arg2, _arg3);
                    reply.writeNoException();
                    break;
                }
                case 51: {
                    String _arg0 = data.readString();
                    String _arg1 = data.readString();
                    int _arg2 = data.readInt();
                    data.enforceNoDataAvail();
                    this.destroySandboxForApp(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    break;
                }
                case 52: {
                    int _arg0 = data.readInt();
                    data.enforceNoDataAvail();
                    this.startCheckpoint(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 53: {
                    boolean _result = this.needsCheckpoint();
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 54: {
                    boolean _result = this.needsRollback();
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 55: {
                    boolean _result = this.isCheckpointing();
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 56: {
                    String _arg0 = data.readString();
                    boolean _arg1 = data.readBoolean();
                    data.enforceNoDataAvail();
                    this.abortChanges(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                case 57: {
                    this.commitChanges();
                    reply.writeNoException();
                    break;
                }
                case 58: {
                    this.prepareCheckpoint();
                    reply.writeNoException();
                    break;
                }
                case 59: {
                    String _arg0 = data.readString();
                    data.enforceNoDataAvail();
                    this.restoreCheckpoint(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 60: {
                    String _arg0 = data.readString();
                    int _arg1 = data.readInt();
                    data.enforceNoDataAvail();
                    this.restoreCheckpointPart(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                case 61: {
                    this.markBootAttempt();
                    reply.writeNoException();
                    break;
                }
                case 62: {
                    boolean _result = this.supportsCheckpoint();
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 63: {
                    boolean _result = this.supportsBlockCheckpoint();
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 64: {
                    boolean _result = this.supportsFileCheckpoint();
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 65: {
                    this.resetCheckpoint();
                    reply.writeNoException();
                    break;
                }
                case 66: {
                    this.earlyBootEnded();
                    reply.writeNoException();
                    break;
                }
                case 67: {
                    String _arg0 = data.readString();
                    String _arg1 = data.readString();
                    String _arg2 = data.readString();
                    String _arg3 = data.readString();
                    String _arg4 = data.readString();
                    int _arg5 = data.readInt();
                    data.enforceNoDataAvail();
                    String _result = this.createStubVolume(_arg0, _arg1, _arg2, _arg3, _arg4, _arg5);
                    reply.writeNoException();
                    reply.writeString(_result);
                    break;
                }
                case 68: {
                    String _arg0 = data.readString();
                    data.enforceNoDataAvail();
                    this.destroyStubVolume(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 69: {
                    int _arg0 = data.readInt();
                    int _arg1 = data.readInt();
                    int _arg2 = data.readInt();
                    int _arg3 = data.readInt();
                    data.enforceNoDataAvail();
                    FileDescriptor _result = this.openAppFuseFile(_arg0, _arg1, _arg2, _arg3);
                    reply.writeNoException();
                    reply.writeRawFileDescriptor(_result);
                    break;
                }
                case 70: {
                    boolean _result = this.incFsEnabled();
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 71: {
                    String _arg0 = data.readString();
                    String _arg1 = data.readString();
                    int _arg2 = data.readInt();
                    String _arg3 = data.readString();
                    data.enforceNoDataAvail();
                    IncrementalFileSystemControlParcel _result = this.mountIncFs(_arg0, _arg1, _arg2, _arg3);
                    reply.writeNoException();
                    reply.writeTypedObject(_result, 1);
                    break;
                }
                case 72: {
                    String _arg0 = data.readString();
                    data.enforceNoDataAvail();
                    this.unmountIncFs(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 73: {
                    IncrementalFileSystemControlParcel _arg0 = data.readTypedObject(IncrementalFileSystemControlParcel.CREATOR);
                    boolean _arg1 = data.readBoolean();
                    boolean _arg2 = data.readBoolean();
                    String _arg3 = data.readString();
                    data.enforceNoDataAvail();
                    this.setIncFsMountOptions(_arg0, _arg1, _arg2, _arg3);
                    reply.writeNoException();
                    break;
                }
                case 74: {
                    String _arg0 = data.readString();
                    String _arg1 = data.readString();
                    data.enforceNoDataAvail();
                    this.bindMount(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                case 75: {
                    String _arg0 = data.readString();
                    data.enforceNoDataAvail();
                    this.destroyDsuMetadataKey(_arg0);
                    reply.writeNoException();
                    break;
                }
                default: {
                    return super.onTransact(code, data, reply, flags);
                }
            }
            return true;
        }

        @Override
        public int getMaxTransactionId() {
            return 74;
        }

        private static class Proxy
        implements IVold {
            private IBinder mRemote;

            Proxy(IBinder remote) {
                this.mRemote = remote;
            }

            @Override
            public IBinder asBinder() {
                return this.mRemote;
            }

            public String getInterfaceDescriptor() {
                return Stub.DESCRIPTOR;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setListener(IVoldListener listener) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongInterface(listener);
                    boolean _status = this.mRemote.transact(1, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void abortFuse() throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(2, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void monitor() throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(3, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void reset() throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(4, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void shutdown() throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(5, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onUserAdded(int userId, int userSerial, int sharesStorageWithUserId) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(userId);
                    _data.writeInt(userSerial);
                    _data.writeInt(sharesStorageWithUserId);
                    boolean _status = this.mRemote.transact(6, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onUserRemoved(int userId) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(userId);
                    boolean _status = this.mRemote.transact(7, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onUserStarted(int userId) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(userId);
                    boolean _status = this.mRemote.transact(8, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onUserStopped(int userId) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(userId);
                    boolean _status = this.mRemote.transact(9, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void addAppIds(String[] packageNames, int[] appIds) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStringArray(packageNames);
                    _data.writeIntArray(appIds);
                    boolean _status = this.mRemote.transact(10, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void addSandboxIds(int[] appIds, String[] sandboxIds) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeIntArray(appIds);
                    _data.writeStringArray(sandboxIds);
                    boolean _status = this.mRemote.transact(11, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onSecureKeyguardStateChanged(boolean isShowing) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeBoolean(isShowing);
                    boolean _status = this.mRemote.transact(12, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void partition(String diskId, int partitionType, int ratio) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(diskId);
                    _data.writeInt(partitionType);
                    _data.writeInt(ratio);
                    boolean _status = this.mRemote.transact(13, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void forgetPartition(String partGuid, String fsUuid) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(partGuid);
                    _data.writeString(fsUuid);
                    boolean _status = this.mRemote.transact(14, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void mount(String volId, int mountFlags, int mountUserId, IVoldMountCallback callback) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(volId);
                    _data.writeInt(mountFlags);
                    _data.writeInt(mountUserId);
                    _data.writeStrongInterface(callback);
                    boolean _status = this.mRemote.transact(15, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void unmount(String volId) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(volId);
                    boolean _status = this.mRemote.transact(16, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void format(String volId, String fsType) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(volId);
                    _data.writeString(fsType);
                    boolean _status = this.mRemote.transact(17, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void benchmark(String volId, IVoldTaskListener listener) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(volId);
                    _data.writeStrongInterface(listener);
                    boolean _status = this.mRemote.transact(18, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void moveStorage(String fromVolId, String toVolId, IVoldTaskListener listener) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(fromVolId);
                    _data.writeString(toVolId);
                    _data.writeStrongInterface(listener);
                    boolean _status = this.mRemote.transact(19, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void remountUid(int uid, int remountMode) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(uid);
                    _data.writeInt(remountMode);
                    boolean _status = this.mRemote.transact(20, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void remountAppStorageDirs(int uid, int pid, String[] packageNames) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(uid);
                    _data.writeInt(pid);
                    _data.writeStringArray(packageNames);
                    boolean _status = this.mRemote.transact(21, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void unmountAppStorageDirs(int uid, int pid, String[] packageNames) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(uid);
                    _data.writeInt(pid);
                    _data.writeStringArray(packageNames);
                    boolean _status = this.mRemote.transact(22, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setupAppDir(String path, int appUid) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(path);
                    _data.writeInt(appUid);
                    boolean _status = this.mRemote.transact(23, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void fixupAppDir(String path, int appUid) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(path);
                    _data.writeInt(appUid);
                    boolean _status = this.mRemote.transact(24, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void ensureAppDirsCreated(String[] paths, int appUid) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStringArray(paths);
                    _data.writeInt(appUid);
                    boolean _status = this.mRemote.transact(25, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public String createObb(String sourcePath, int ownerGid) throws RemoteException {
                String _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(sourcePath);
                    _data.writeInt(ownerGid);
                    boolean _status = this.mRemote.transact(26, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readString();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void destroyObb(String volId) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(volId);
                    boolean _status = this.mRemote.transact(27, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void fstrim(int fstrimFlags, IVoldTaskListener listener) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(fstrimFlags);
                    _data.writeStrongInterface(listener);
                    boolean _status = this.mRemote.transact(28, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void runIdleMaint(boolean needGC, IVoldTaskListener listener) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeBoolean(needGC);
                    _data.writeStrongInterface(listener);
                    boolean _status = this.mRemote.transact(29, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void abortIdleMaint(IVoldTaskListener listener) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongInterface(listener);
                    boolean _status = this.mRemote.transact(30, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int getStorageLifeTime() throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(31, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setGCUrgentPace(int neededSegments, int minSegmentThreshold, float dirtyReclaimRate, float reclaimWeight, int gcPeriod, int minGCSleepTime, int targetDirtyRatio) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(neededSegments);
                    _data.writeInt(minSegmentThreshold);
                    _data.writeFloat(dirtyReclaimRate);
                    _data.writeFloat(reclaimWeight);
                    _data.writeInt(gcPeriod);
                    _data.writeInt(minGCSleepTime);
                    _data.writeInt(targetDirtyRatio);
                    boolean _status = this.mRemote.transact(32, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void refreshLatestWrite() throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(33, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int getWriteAmount() throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(34, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public FileDescriptor mountAppFuse(int uid, int mountId) throws RemoteException {
                FileDescriptor _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(uid);
                    _data.writeInt(mountId);
                    boolean _status = this.mRemote.transact(35, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readRawFileDescriptor();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void unmountAppFuse(int uid, int mountId) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(uid);
                    _data.writeInt(mountId);
                    boolean _status = this.mRemote.transact(36, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void fbeEnable() throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(37, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void initUser0() throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(38, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void mountFstab(String blkDevice, String mountPoint, String zonedDevice) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(blkDevice);
                    _data.writeString(mountPoint);
                    _data.writeString(zonedDevice);
                    boolean _status = this.mRemote.transact(39, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void encryptFstab(String blkDevice, String mountPoint, boolean shouldFormat, String fsType, String zonedDevice) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(blkDevice);
                    _data.writeString(mountPoint);
                    _data.writeBoolean(shouldFormat);
                    _data.writeString(fsType);
                    _data.writeString(zonedDevice);
                    boolean _status = this.mRemote.transact(40, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setStorageBindingSeed(byte[] seed) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeByteArray(seed);
                    boolean _status = this.mRemote.transact(41, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void createUserKey(int userId, int userSerial, boolean ephemeral) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(userId);
                    _data.writeInt(userSerial);
                    _data.writeBoolean(ephemeral);
                    boolean _status = this.mRemote.transact(42, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void destroyUserKey(int userId) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(userId);
                    boolean _status = this.mRemote.transact(43, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setUserKeyProtection(int userId, String secret) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(userId);
                    _data.writeString(secret);
                    boolean _status = this.mRemote.transact(44, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int[] getUnlockedUsers() throws RemoteException {
                int[] _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(45, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.createIntArray();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void unlockUserKey(int userId, int userSerial, String secret) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(userId);
                    _data.writeInt(userSerial);
                    _data.writeString(secret);
                    boolean _status = this.mRemote.transact(46, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void lockUserKey(int userId) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(userId);
                    boolean _status = this.mRemote.transact(47, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void prepareUserStorage(String uuid, int userId, int userSerial, int storageFlags) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(uuid);
                    _data.writeInt(userId);
                    _data.writeInt(userSerial);
                    _data.writeInt(storageFlags);
                    boolean _status = this.mRemote.transact(48, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void destroyUserStorage(String uuid, int userId, int storageFlags) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(uuid);
                    _data.writeInt(userId);
                    _data.writeInt(storageFlags);
                    boolean _status = this.mRemote.transact(49, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void prepareSandboxForApp(String packageName, int appId, String sandboxId, int userId) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(packageName);
                    _data.writeInt(appId);
                    _data.writeString(sandboxId);
                    _data.writeInt(userId);
                    boolean _status = this.mRemote.transact(50, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void destroySandboxForApp(String packageName, String sandboxId, int userId) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(packageName);
                    _data.writeString(sandboxId);
                    _data.writeInt(userId);
                    boolean _status = this.mRemote.transact(51, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void startCheckpoint(int retry) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(retry);
                    boolean _status = this.mRemote.transact(52, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean needsCheckpoint() throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(53, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean needsRollback() throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(54, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean isCheckpointing() throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(55, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void abortChanges(String device, boolean retry) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(device);
                    _data.writeBoolean(retry);
                    boolean _status = this.mRemote.transact(56, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void commitChanges() throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(57, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void prepareCheckpoint() throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(58, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void restoreCheckpoint(String device) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(device);
                    boolean _status = this.mRemote.transact(59, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void restoreCheckpointPart(String device, int count) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(device);
                    _data.writeInt(count);
                    boolean _status = this.mRemote.transact(60, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void markBootAttempt() throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(61, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean supportsCheckpoint() throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(62, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean supportsBlockCheckpoint() throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(63, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean supportsFileCheckpoint() throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(64, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void resetCheckpoint() throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(65, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void earlyBootEnded() throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(66, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public String createStubVolume(String sourcePath, String mountPath, String fsType, String fsUuid, String fsLabel, int flags) throws RemoteException {
                String _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(sourcePath);
                    _data.writeString(mountPath);
                    _data.writeString(fsType);
                    _data.writeString(fsUuid);
                    _data.writeString(fsLabel);
                    _data.writeInt(flags);
                    boolean _status = this.mRemote.transact(67, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readString();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void destroyStubVolume(String volId) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(volId);
                    boolean _status = this.mRemote.transact(68, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public FileDescriptor openAppFuseFile(int uid, int mountId, int fileId, int flags) throws RemoteException {
                FileDescriptor _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(uid);
                    _data.writeInt(mountId);
                    _data.writeInt(fileId);
                    _data.writeInt(flags);
                    boolean _status = this.mRemote.transact(69, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readRawFileDescriptor();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean incFsEnabled() throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(70, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public IncrementalFileSystemControlParcel mountIncFs(String backingPath, String targetDir, int flags, String sysfsName) throws RemoteException {
                IncrementalFileSystemControlParcel _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(backingPath);
                    _data.writeString(targetDir);
                    _data.writeInt(flags);
                    _data.writeString(sysfsName);
                    boolean _status = this.mRemote.transact(71, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readTypedObject(IncrementalFileSystemControlParcel.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void unmountIncFs(String dir) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(dir);
                    boolean _status = this.mRemote.transact(72, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setIncFsMountOptions(IncrementalFileSystemControlParcel control, boolean enableReadLogs, boolean enableReadTimeouts, String sysfsName) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedObject(control, 0);
                    _data.writeBoolean(enableReadLogs);
                    _data.writeBoolean(enableReadTimeouts);
                    _data.writeString(sysfsName);
                    boolean _status = this.mRemote.transact(73, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void bindMount(String sourceDir, String targetDir) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(sourceDir);
                    _data.writeString(targetDir);
                    boolean _status = this.mRemote.transact(74, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void destroyDsuMetadataKey(String dsuSlot) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(dsuSlot);
                    boolean _status = this.mRemote.transact(75, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }
        }
    }

    public static class Default
    implements IVold {
        @Override
        public void setListener(IVoldListener listener) throws RemoteException {
        }

        @Override
        public void abortFuse() throws RemoteException {
        }

        @Override
        public void monitor() throws RemoteException {
        }

        @Override
        public void reset() throws RemoteException {
        }

        @Override
        public void shutdown() throws RemoteException {
        }

        @Override
        public void onUserAdded(int userId, int userSerial, int sharesStorageWithUserId) throws RemoteException {
        }

        @Override
        public void onUserRemoved(int userId) throws RemoteException {
        }

        @Override
        public void onUserStarted(int userId) throws RemoteException {
        }

        @Override
        public void onUserStopped(int userId) throws RemoteException {
        }

        @Override
        public void addAppIds(String[] packageNames, int[] appIds) throws RemoteException {
        }

        @Override
        public void addSandboxIds(int[] appIds, String[] sandboxIds) throws RemoteException {
        }

        @Override
        public void onSecureKeyguardStateChanged(boolean isShowing) throws RemoteException {
        }

        @Override
        public void partition(String diskId, int partitionType, int ratio) throws RemoteException {
        }

        @Override
        public void forgetPartition(String partGuid, String fsUuid) throws RemoteException {
        }

        @Override
        public void mount(String volId, int mountFlags, int mountUserId, IVoldMountCallback callback) throws RemoteException {
        }

        @Override
        public void unmount(String volId) throws RemoteException {
        }

        @Override
        public void format(String volId, String fsType) throws RemoteException {
        }

        @Override
        public void benchmark(String volId, IVoldTaskListener listener) throws RemoteException {
        }

        @Override
        public void moveStorage(String fromVolId, String toVolId, IVoldTaskListener listener) throws RemoteException {
        }

        @Override
        public void remountUid(int uid, int remountMode) throws RemoteException {
        }

        @Override
        public void remountAppStorageDirs(int uid, int pid, String[] packageNames) throws RemoteException {
        }

        @Override
        public void unmountAppStorageDirs(int uid, int pid, String[] packageNames) throws RemoteException {
        }

        @Override
        public void setupAppDir(String path, int appUid) throws RemoteException {
        }

        @Override
        public void fixupAppDir(String path, int appUid) throws RemoteException {
        }

        @Override
        public void ensureAppDirsCreated(String[] paths, int appUid) throws RemoteException {
        }

        @Override
        public String createObb(String sourcePath, int ownerGid) throws RemoteException {
            return null;
        }

        @Override
        public void destroyObb(String volId) throws RemoteException {
        }

        @Override
        public void fstrim(int fstrimFlags, IVoldTaskListener listener) throws RemoteException {
        }

        @Override
        public void runIdleMaint(boolean needGC, IVoldTaskListener listener) throws RemoteException {
        }

        @Override
        public void abortIdleMaint(IVoldTaskListener listener) throws RemoteException {
        }

        @Override
        public int getStorageLifeTime() throws RemoteException {
            return 0;
        }

        @Override
        public void setGCUrgentPace(int neededSegments, int minSegmentThreshold, float dirtyReclaimRate, float reclaimWeight, int gcPeriod, int minGCSleepTime, int targetDirtyRatio) throws RemoteException {
        }

        @Override
        public void refreshLatestWrite() throws RemoteException {
        }

        @Override
        public int getWriteAmount() throws RemoteException {
            return 0;
        }

        @Override
        public FileDescriptor mountAppFuse(int uid, int mountId) throws RemoteException {
            return null;
        }

        @Override
        public void unmountAppFuse(int uid, int mountId) throws RemoteException {
        }

        @Override
        public void fbeEnable() throws RemoteException {
        }

        @Override
        public void initUser0() throws RemoteException {
        }

        @Override
        public void mountFstab(String blkDevice, String mountPoint, String zonedDevice) throws RemoteException {
        }

        @Override
        public void encryptFstab(String blkDevice, String mountPoint, boolean shouldFormat, String fsType, String zonedDevice) throws RemoteException {
        }

        @Override
        public void setStorageBindingSeed(byte[] seed) throws RemoteException {
        }

        @Override
        public void createUserKey(int userId, int userSerial, boolean ephemeral) throws RemoteException {
        }

        @Override
        public void destroyUserKey(int userId) throws RemoteException {
        }

        @Override
        public void setUserKeyProtection(int userId, String secret) throws RemoteException {
        }

        @Override
        public int[] getUnlockedUsers() throws RemoteException {
            return null;
        }

        @Override
        public void unlockUserKey(int userId, int userSerial, String secret) throws RemoteException {
        }

        @Override
        public void lockUserKey(int userId) throws RemoteException {
        }

        @Override
        public void prepareUserStorage(String uuid, int userId, int userSerial, int storageFlags) throws RemoteException {
        }

        @Override
        public void destroyUserStorage(String uuid, int userId, int storageFlags) throws RemoteException {
        }

        @Override
        public void prepareSandboxForApp(String packageName, int appId, String sandboxId, int userId) throws RemoteException {
        }

        @Override
        public void destroySandboxForApp(String packageName, String sandboxId, int userId) throws RemoteException {
        }

        @Override
        public void startCheckpoint(int retry) throws RemoteException {
        }

        @Override
        public boolean needsCheckpoint() throws RemoteException {
            return false;
        }

        @Override
        public boolean needsRollback() throws RemoteException {
            return false;
        }

        @Override
        public boolean isCheckpointing() throws RemoteException {
            return false;
        }

        @Override
        public void abortChanges(String device, boolean retry) throws RemoteException {
        }

        @Override
        public void commitChanges() throws RemoteException {
        }

        @Override
        public void prepareCheckpoint() throws RemoteException {
        }

        @Override
        public void restoreCheckpoint(String device) throws RemoteException {
        }

        @Override
        public void restoreCheckpointPart(String device, int count) throws RemoteException {
        }

        @Override
        public void markBootAttempt() throws RemoteException {
        }

        @Override
        public boolean supportsCheckpoint() throws RemoteException {
            return false;
        }

        @Override
        public boolean supportsBlockCheckpoint() throws RemoteException {
            return false;
        }

        @Override
        public boolean supportsFileCheckpoint() throws RemoteException {
            return false;
        }

        @Override
        public void resetCheckpoint() throws RemoteException {
        }

        @Override
        public void earlyBootEnded() throws RemoteException {
        }

        @Override
        public String createStubVolume(String sourcePath, String mountPath, String fsType, String fsUuid, String fsLabel, int flags) throws RemoteException {
            return null;
        }

        @Override
        public void destroyStubVolume(String volId) throws RemoteException {
        }

        @Override
        public FileDescriptor openAppFuseFile(int uid, int mountId, int fileId, int flags) throws RemoteException {
            return null;
        }

        @Override
        public boolean incFsEnabled() throws RemoteException {
            return false;
        }

        @Override
        public IncrementalFileSystemControlParcel mountIncFs(String backingPath, String targetDir, int flags, String sysfsName) throws RemoteException {
            return null;
        }

        @Override
        public void unmountIncFs(String dir) throws RemoteException {
        }

        @Override
        public void setIncFsMountOptions(IncrementalFileSystemControlParcel control, boolean enableReadLogs, boolean enableReadTimeouts, String sysfsName) throws RemoteException {
        }

        @Override
        public void bindMount(String sourceDir, String targetDir) throws RemoteException {
        }

        @Override
        public void destroyDsuMetadataKey(String dsuSlot) throws RemoteException {
        }

        @Override
        public IBinder asBinder() {
            return null;
        }
    }
}

