/*
 * Decompiled with CFR 0.152.
 */
package android.os;

import android.os.Parcel;
import android.os.Parcelable;
import java.time.Duration;

public class ParcelDuration
implements Parcelable {
    private final long mSeconds;
    private final int mNanos;
    public static final Parcelable.Creator<ParcelDuration> CREATOR = new Parcelable.Creator<ParcelDuration>(){

        @Override
        public ParcelDuration createFromParcel(Parcel source) {
            return new ParcelDuration(source);
        }

        public ParcelDuration[] newArray(int size) {
            return new ParcelDuration[size];
        }
    };

    public ParcelDuration(long ms) {
        this(Duration.ofMillis(ms));
    }

    public ParcelDuration(Duration duration) {
        this.mSeconds = duration.getSeconds();
        this.mNanos = duration.getNano();
    }

    private ParcelDuration(Parcel parcel) {
        this.mSeconds = parcel.readLong();
        this.mNanos = parcel.readInt();
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel parcel, int parcelableFlags) {
        parcel.writeLong(this.mSeconds);
        parcel.writeInt(this.mNanos);
    }

    public Duration getDuration() {
        return Duration.ofSeconds(this.mSeconds, this.mNanos);
    }

    public String toString() {
        return this.getDuration().toString();
    }
}

