/*
 * Decompiled with CFR 0.152.
 */
package android.os;

import android.os.ServiceManager;
import com.android.internal.util.Preconditions;
import com.android.tools.layoutlib.create.OverrideMethod;
import java.io.Closeable;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.ref.Reference;

public class PerformanceHintManager {
    private final long mNativeManagerPtr;

    public static PerformanceHintManager create() throws ServiceManager.ServiceNotFoundException {
        long nativeManagerPtr = PerformanceHintManager.nativeAcquireManager();
        if (nativeManagerPtr == 0L) {
            throw new ServiceManager.ServiceNotFoundException("performance_hint");
        }
        return new PerformanceHintManager(nativeManagerPtr);
    }

    private PerformanceHintManager(long nativeManagerPtr) {
        this.mNativeManagerPtr = nativeManagerPtr;
    }

    public Session createHintSession(int[] tids, long initialTargetWorkDurationNanos) {
        Preconditions.checkNotNull(tids, "tids cannot be null");
        Preconditions.checkArgumentPositive(initialTargetWorkDurationNanos, "the hint target duration should be positive.");
        long nativeSessionPtr = PerformanceHintManager.nativeCreateSession(this.mNativeManagerPtr, tids, initialTargetWorkDurationNanos);
        if (nativeSessionPtr == 0L) {
            return null;
        }
        return new Session(nativeSessionPtr);
    }

    public long getPreferredUpdateRateNanos() {
        return PerformanceHintManager.nativeGetPreferredUpdateRateNanos(this.mNativeManagerPtr);
    }

    private static long nativeAcquireManager() {
        return OverrideMethod.invokeL("android.os.PerformanceHintManager#nativeAcquireManager()J", true, null);
    }

    private static long nativeGetPreferredUpdateRateNanos(long l) {
        return OverrideMethod.invokeL("android.os.PerformanceHintManager#nativeGetPreferredUpdateRateNanos(J)J", true, null);
    }

    private static long nativeCreateSession(long l, int[] nArray, long l2) {
        return OverrideMethod.invokeL("android.os.PerformanceHintManager#nativeCreateSession(J[IJ)J", true, null);
    }

    private static int[] nativeGetThreadIds(long l) {
        return (int[])OverrideMethod.invokeA("android.os.PerformanceHintManager#nativeGetThreadIds(J)[I", true, null);
    }

    private static void nativeUpdateTargetWorkDuration(long l, long l2) {
        OverrideMethod.invokeV("android.os.PerformanceHintManager#nativeUpdateTargetWorkDuration(JJ)V", true, null);
    }

    private static void nativeReportActualWorkDuration(long l, long l2) {
        OverrideMethod.invokeV("android.os.PerformanceHintManager#nativeReportActualWorkDuration(JJ)V", true, null);
    }

    private static void nativeCloseSession(long l) {
        OverrideMethod.invokeV("android.os.PerformanceHintManager#nativeCloseSession(J)V", true, null);
    }

    private static void nativeSendHint(long l, int n) {
        OverrideMethod.invokeV("android.os.PerformanceHintManager#nativeSendHint(JI)V", true, null);
    }

    private static void nativeSetThreads(long l, int[] nArray) {
        OverrideMethod.invokeV("android.os.PerformanceHintManager#nativeSetThreads(J[I)V", true, null);
    }

    public static class Session
    implements Closeable {
        private long mNativeSessionPtr;
        public static final int CPU_LOAD_UP = 0;
        public static final int CPU_LOAD_DOWN = 1;
        public static final int CPU_LOAD_RESET = 2;
        public static final int CPU_LOAD_RESUME = 3;

        public Session(long nativeSessionPtr) {
            this.mNativeSessionPtr = nativeSessionPtr;
        }

        protected void finalize() throws Throwable {
            try {
                this.close();
            }
            finally {
                super.finalize();
            }
        }

        public void updateTargetWorkDuration(long targetDurationNanos) {
            Preconditions.checkArgumentPositive(targetDurationNanos, "the hint target duration should be positive.");
            PerformanceHintManager.nativeUpdateTargetWorkDuration(this.mNativeSessionPtr, targetDurationNanos);
        }

        public void reportActualWorkDuration(long actualDurationNanos) {
            Preconditions.checkArgumentPositive(actualDurationNanos, "the actual duration should be positive.");
            PerformanceHintManager.nativeReportActualWorkDuration(this.mNativeSessionPtr, actualDurationNanos);
        }

        @Override
        public void close() {
            if (this.mNativeSessionPtr != 0L) {
                PerformanceHintManager.nativeCloseSession(this.mNativeSessionPtr);
                this.mNativeSessionPtr = 0L;
            }
        }

        public void sendHint(int hint) {
            Preconditions.checkArgumentNonNegative(hint, "the hint ID should be at least zero.");
            try {
                PerformanceHintManager.nativeSendHint(this.mNativeSessionPtr, hint);
            }
            finally {
                Reference.reachabilityFence(this);
            }
        }

        public void setThreads(int[] tids) {
            if (this.mNativeSessionPtr == 0L) {
                return;
            }
            if (tids.length == 0) {
                throw new IllegalArgumentException("Thread id list can't be empty.");
            }
            PerformanceHintManager.nativeSetThreads(this.mNativeSessionPtr, tids);
        }

        public int[] getThreadIds() {
            return PerformanceHintManager.nativeGetThreadIds(this.mNativeSessionPtr);
        }

        @Retention(value=RetentionPolicy.SOURCE)
        public static @interface Hint {
        }
    }
}

