/*
 * Decompiled with CFR 0.152.
 */
package android.os;

import android.app.AppOpsManager;
import android.content.AttributionSource;
import android.content.Context;
import android.content.PermissionChecker;

public class PermissionEnforcer {
    private final Context mContext;
    private static final String ACCESS_DENIED = "Access denied, requires: ";

    protected PermissionEnforcer() {
        this.mContext = null;
    }

    public PermissionEnforcer(Context context) {
        this.mContext = context;
    }

    protected int checkPermission(String permission2, AttributionSource source) {
        return PermissionChecker.checkPermissionForDataDelivery(this.mContext, permission2, -1, source, "");
    }

    protected int checkPermission(String permission2, int pid, int uid) {
        if (this.mContext.checkPermission(permission2, pid, uid) == 0) {
            return 0;
        }
        return 2;
    }

    private boolean anyAppOps(String[] permissions) {
        for (String permission2 : permissions) {
            if (AppOpsManager.permissionToOpCode(permission2) == -1) continue;
            return true;
        }
        return false;
    }

    public void enforcePermission(String permission2, AttributionSource source) throws SecurityException {
        int result = this.checkPermission(permission2, source);
        if (result != 0) {
            throw new SecurityException(ACCESS_DENIED + permission2);
        }
    }

    public void enforcePermission(String permission2, int pid, int uid) throws SecurityException {
        if (AppOpsManager.permissionToOpCode(permission2) != -1) {
            AttributionSource source = new AttributionSource(uid, null, null);
            this.enforcePermission(permission2, source);
            return;
        }
        int result = this.checkPermission(permission2, pid, uid);
        if (result != 0) {
            throw new SecurityException(ACCESS_DENIED + permission2);
        }
    }

    public void enforcePermissionAllOf(String[] permissions, AttributionSource source) throws SecurityException {
        for (String permission2 : permissions) {
            int result = this.checkPermission(permission2, source);
            if (result == 0) continue;
            throw new SecurityException("Access denied, requires: allOf={" + String.join((CharSequence)", ", permissions) + "}");
        }
    }

    public void enforcePermissionAllOf(String[] permissions, int pid, int uid) throws SecurityException {
        if (this.anyAppOps(permissions)) {
            AttributionSource source = new AttributionSource(uid, null, null);
            this.enforcePermissionAllOf(permissions, source);
            return;
        }
        for (String permission2 : permissions) {
            int result = this.checkPermission(permission2, pid, uid);
            if (result == 0) continue;
            throw new SecurityException("Access denied, requires: allOf={" + String.join((CharSequence)", ", permissions) + "}");
        }
    }

    public void enforcePermissionAnyOf(String[] permissions, AttributionSource source) throws SecurityException {
        for (String permission2 : permissions) {
            int result = this.checkPermission(permission2, source);
            if (result != 0) continue;
            return;
        }
        throw new SecurityException("Access denied, requires: anyOf={" + String.join((CharSequence)", ", permissions) + "}");
    }

    public void enforcePermissionAnyOf(String[] permissions, int pid, int uid) throws SecurityException {
        if (this.anyAppOps(permissions)) {
            AttributionSource source = new AttributionSource(uid, null, null);
            this.enforcePermissionAnyOf(permissions, source);
            return;
        }
        for (String permission2 : permissions) {
            int result = this.checkPermission(permission2, pid, uid);
            if (result != 0) continue;
            return;
        }
        throw new SecurityException("Access denied, requires: anyOf={" + String.join((CharSequence)", ", permissions) + "}");
    }

    public static PermissionEnforcer fromContext(Context context) {
        return context.getSystemService(PermissionEnforcer.class);
    }
}

