/*
 * Decompiled with CFR 0.152.
 */
package android.os;

import android.os.BatteryConsumer;
import android.os.BatteryStats;
import android.util.proto.ProtoOutputStream;
import com.android.modules.utils.TypedXmlPullParser;
import com.android.modules.utils.TypedXmlSerializer;
import java.io.IOException;
import java.io.PrintWriter;
import org.xmlpull.v1.XmlPullParserException;

class PowerComponents {
    private final BatteryConsumer.BatteryConsumerData mData;

    PowerComponents(Builder builder) {
        this.mData = builder.mData;
    }

    PowerComponents(BatteryConsumer.BatteryConsumerData data) {
        this.mData = data;
    }

    public double getConsumedPower(BatteryConsumer.Dimensions dimensions) {
        if (dimensions.powerComponent != -1) {
            return this.mData.getDouble(this.mData.getKeyOrThrow((int)dimensions.powerComponent, (int)dimensions.processState).mPowerColumnIndex);
        }
        if (dimensions.processState != 0) {
            if (!this.mData.layout.processStateDataIncluded) {
                throw new IllegalArgumentException("No data included in BatteryUsageStats for " + dimensions);
            }
            BatteryConsumer.Key[] keys = this.mData.layout.processStateKeys[dimensions.processState];
            double totalPowerMah = 0.0;
            for (int i = keys.length - 1; i >= 0; --i) {
                totalPowerMah += this.mData.getDouble(keys[i].mPowerColumnIndex);
            }
            return totalPowerMah;
        }
        return this.mData.getDouble(this.mData.layout.totalConsumedPowerColumnIndex);
    }

    public double getConsumedPower(BatteryConsumer.Key key) {
        return this.mData.getDouble(key.mPowerColumnIndex);
    }

    public double getConsumedPowerForCustomComponent(int componentId) {
        int index = componentId - 1000;
        if (index >= 0 && index < this.mData.layout.customPowerComponentCount) {
            return this.mData.getDouble(this.mData.layout.firstCustomConsumedPowerColumn + index);
        }
        throw new IllegalArgumentException("Unsupported custom power component ID: " + componentId);
    }

    public String getCustomPowerComponentName(int componentId) {
        int index = componentId - 1000;
        if (index >= 0 && index < this.mData.layout.customPowerComponentCount) {
            try {
                return this.mData.layout.customPowerComponentNames[index];
            }
            catch (ArrayIndexOutOfBoundsException e) {
                throw new IllegalArgumentException("Unsupported custom power component ID: " + componentId);
            }
        }
        throw new IllegalArgumentException("Unsupported custom power component ID: " + componentId);
    }

    int getPowerModel(BatteryConsumer.Key key) {
        if (key.mPowerModelColumnIndex == -1) {
            throw new IllegalStateException("Power model IDs were not requested in the BatteryUsageStatsQuery");
        }
        return this.mData.getInt(key.mPowerModelColumnIndex);
    }

    public long getUsageDurationMillis(BatteryConsumer.Key key) {
        return this.mData.getLong(key.mDurationColumnIndex);
    }

    public long getUsageDurationForCustomComponentMillis(int componentId) {
        int index = componentId - 1000;
        if (index >= 0 && index < this.mData.layout.customPowerComponentCount) {
            return this.mData.getLong(this.mData.layout.firstCustomUsageDurationColumn + index);
        }
        throw new IllegalArgumentException("Unsupported custom power component ID: " + componentId);
    }

    public void dump(PrintWriter pw, boolean skipEmptyComponents) {
        String separator = "";
        StringBuilder sb = new StringBuilder();
        for (int componentId = 0; componentId < 18; ++componentId) {
            for (BatteryConsumer.Key key : this.mData.getKeys(componentId)) {
                double componentPower = this.getConsumedPower(key);
                long durationMs = this.getUsageDurationMillis(key);
                if (skipEmptyComponents && componentPower == 0.0 && durationMs == 0L) continue;
                sb.append(separator);
                separator = " ";
                sb.append(key.toShortString());
                sb.append("=");
                sb.append(BatteryStats.formatCharge(componentPower));
                if (durationMs == 0L) continue;
                sb.append(" (");
                BatteryStats.formatTimeMsNoSpace(sb, durationMs);
                sb.append(")");
            }
        }
        int customComponentCount = this.mData.layout.customPowerComponentCount;
        for (int customComponentId = 1000; customComponentId < 1000 + customComponentCount; ++customComponentId) {
            double customComponentPower = this.getConsumedPowerForCustomComponent(customComponentId);
            if (skipEmptyComponents && customComponentPower == 0.0) continue;
            sb.append(separator);
            separator = " ";
            sb.append(this.getCustomPowerComponentName(customComponentId));
            sb.append("=");
            sb.append(BatteryStats.formatCharge(customComponentPower));
        }
        pw.print(sb);
    }

    boolean hasStatsProtoData() {
        return this.writeStatsProtoImpl(null);
    }

    void writeStatsProto(ProtoOutputStream proto) {
        this.writeStatsProtoImpl(proto);
    }

    private boolean writeStatsProtoImpl(ProtoOutputStream proto) {
        boolean interestingData = false;
        for (int componentId = 0; componentId < 18; ++componentId) {
            BatteryConsumer.Key[] keys;
            for (BatteryConsumer.Key key : keys = this.mData.getKeys(componentId)) {
                long powerDeciCoulombs = BatteryConsumer.convertMahToDeciCoulombs(this.getConsumedPower(key));
                long durationMs = this.getUsageDurationMillis(key);
                if (powerDeciCoulombs == 0L && durationMs == 0L) continue;
                interestingData = true;
                if (proto == null) {
                    return true;
                }
                if (key.processState == 0) {
                    this.writePowerComponentUsage(proto, 0x20B00000002L, componentId, powerDeciCoulombs, durationMs);
                    continue;
                }
                this.writePowerUsageSlice(proto, componentId, powerDeciCoulombs, durationMs, key.processState);
            }
        }
        for (int idx = 0; idx < this.mData.layout.customPowerComponentCount; ++idx) {
            int componentId = 1000 + idx;
            long powerDeciCoulombs = BatteryConsumer.convertMahToDeciCoulombs(this.getConsumedPowerForCustomComponent(componentId));
            long durationMs = this.getUsageDurationForCustomComponentMillis(componentId);
            if (powerDeciCoulombs == 0L && durationMs == 0L) continue;
            interestingData = true;
            if (proto == null) {
                return true;
            }
            this.writePowerComponentUsage(proto, 0x20B00000002L, componentId, powerDeciCoulombs, durationMs);
        }
        return interestingData;
    }

    private void writePowerUsageSlice(ProtoOutputStream proto, int componentId, long powerDeciCoulombs, long durationMs, int processState) {
        int procState;
        long slicesToken = proto.start(2246267895811L);
        this.writePowerComponentUsage(proto, 0x10B00000001L, componentId, powerDeciCoulombs, durationMs);
        switch (processState) {
            case 1: {
                procState = 1;
                break;
            }
            case 2: {
                procState = 2;
                break;
            }
            case 3: {
                procState = 3;
                break;
            }
            case 4: {
                procState = 4;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown process state: " + processState);
            }
        }
        proto.write(1159641169922L, procState);
        proto.end(slicesToken);
    }

    private void writePowerComponentUsage(ProtoOutputStream proto, long tag, int componentId, long powerDeciCoulombs, long durationMs) {
        long token = proto.start(tag);
        proto.write(0x10500000001L, componentId);
        proto.write(1112396529666L, powerDeciCoulombs);
        proto.write(0x10300000003L, durationMs);
        proto.end(token);
    }

    void writeToXml(TypedXmlSerializer serializer) throws IOException {
        serializer.startTag(null, "power_components");
        for (int componentId = 0; componentId < 18; ++componentId) {
            BatteryConsumer.Key[] keys;
            for (BatteryConsumer.Key key : keys = this.mData.getKeys(componentId)) {
                double powerMah = this.getConsumedPower(key);
                long durationMs = this.getUsageDurationMillis(key);
                if (powerMah == 0.0 && durationMs == 0L) continue;
                serializer.startTag(null, "component");
                serializer.attributeInt(null, "id", componentId);
                if (key.processState != 0) {
                    serializer.attributeInt(null, "process_state", key.processState);
                }
                if (powerMah != 0.0) {
                    serializer.attributeDouble(null, "power", powerMah);
                }
                if (durationMs != 0L) {
                    serializer.attributeLong(null, "duration", durationMs);
                }
                if (this.mData.layout.powerModelsIncluded) {
                    serializer.attributeInt(null, "model", this.getPowerModel(key));
                }
                serializer.endTag(null, "component");
            }
        }
        int customComponentEnd = 1000 + this.mData.layout.customPowerComponentCount;
        for (int componentId = 1000; componentId < customComponentEnd; ++componentId) {
            double powerMah = this.getConsumedPowerForCustomComponent(componentId);
            long durationMs = this.getUsageDurationForCustomComponentMillis(componentId);
            if (powerMah == 0.0 && durationMs == 0L) continue;
            serializer.startTag(null, "custom_component");
            serializer.attributeInt(null, "id", componentId);
            if (powerMah != 0.0) {
                serializer.attributeDouble(null, "power", powerMah);
            }
            if (durationMs != 0L) {
                serializer.attributeLong(null, "duration", durationMs);
            }
            serializer.endTag(null, "custom_component");
        }
        serializer.endTag(null, "power_components");
    }

    static void parseXml(TypedXmlPullParser parser, Builder builder) throws XmlPullParserException, IOException {
        int eventType = parser.getEventType();
        if (eventType != 2 || !parser.getName().equals("power_components")) {
            throw new XmlPullParserException("Invalid XML parser state");
        }
        while (!(eventType == 3 && parser.getName().equals("power_components") || eventType == 1)) {
            if (eventType == 2) {
                switch (parser.getName()) {
                    case "component": {
                        int componentId = -1;
                        int processState = 0;
                        double powerMah = 0.0;
                        long durationMs = 0L;
                        int model = 0;
                        block33: for (int i = 0; i < parser.getAttributeCount(); ++i) {
                            switch (parser.getAttributeName(i)) {
                                case "id": {
                                    componentId = parser.getAttributeInt(i);
                                    continue block33;
                                }
                                case "process_state": {
                                    processState = parser.getAttributeInt(i);
                                    continue block33;
                                }
                                case "power": {
                                    powerMah = parser.getAttributeDouble(i);
                                    continue block33;
                                }
                                case "duration": {
                                    durationMs = parser.getAttributeLong(i);
                                    continue block33;
                                }
                                case "model": {
                                    model = parser.getAttributeInt(i);
                                }
                            }
                        }
                        BatteryConsumer.Key key = builder.mData.getKey(componentId, processState);
                        builder.setConsumedPower(key, powerMah, model);
                        builder.setUsageDurationMillis(key, durationMs);
                        break;
                    }
                    case "custom_component": {
                        int componentId = -1;
                        double powerMah = 0.0;
                        long durationMs = 0L;
                        block34: for (int i = 0; i < parser.getAttributeCount(); ++i) {
                            switch (parser.getAttributeName(i)) {
                                case "id": {
                                    componentId = parser.getAttributeInt(i);
                                    continue block34;
                                }
                                case "power": {
                                    powerMah = parser.getAttributeDouble(i);
                                    continue block34;
                                }
                                case "duration": {
                                    durationMs = parser.getAttributeLong(i);
                                }
                            }
                        }
                        builder.setConsumedPowerForCustomComponent(componentId, powerMah);
                        builder.setUsageDurationForCustomComponentMillis(componentId, durationMs);
                        break;
                    }
                }
            }
            eventType = parser.next();
        }
    }

    static class Builder {
        private static final byte POWER_MODEL_UNINITIALIZED = -1;
        private final BatteryConsumer.BatteryConsumerData mData;

        Builder(BatteryConsumer.BatteryConsumerData data) {
            this.mData = data;
            BatteryConsumer.Key[][] keyArray = this.mData.layout.keys;
            int n = keyArray.length;
            for (int i = 0; i < n; ++i) {
                BatteryConsumer.Key[] keys;
                for (BatteryConsumer.Key key : keys = keyArray[i]) {
                    if (key.mPowerModelColumnIndex == -1) continue;
                    this.mData.putInt(key.mPowerModelColumnIndex, -1);
                }
            }
        }

        public Builder setConsumedPower(BatteryConsumer.Key key, double componentPower, int powerModel) {
            this.mData.putDouble(key.mPowerColumnIndex, componentPower);
            if (key.mPowerModelColumnIndex != -1) {
                this.mData.putInt(key.mPowerModelColumnIndex, powerModel);
            }
            return this;
        }

        public Builder setConsumedPowerForCustomComponent(int componentId, double componentPower) {
            int index = componentId - 1000;
            if (index < 0 || index >= this.mData.layout.customPowerComponentCount) {
                throw new IllegalArgumentException("Unsupported custom power component ID: " + componentId);
            }
            this.mData.putDouble(this.mData.layout.firstCustomConsumedPowerColumn + index, componentPower);
            return this;
        }

        public Builder setUsageDurationMillis(BatteryConsumer.Key key, long componentUsageDurationMillis) {
            this.mData.putLong(key.mDurationColumnIndex, componentUsageDurationMillis);
            return this;
        }

        public Builder setUsageDurationForCustomComponentMillis(int componentId, long componentUsageDurationMillis) {
            int index = componentId - 1000;
            if (index < 0 || index >= this.mData.layout.customPowerComponentCount) {
                throw new IllegalArgumentException("Unsupported custom power component ID: " + componentId);
            }
            this.mData.putLong(this.mData.layout.firstCustomUsageDurationColumn + index, componentUsageDurationMillis);
            return this;
        }

        public void addPowerAndDuration(Builder other) {
            this.addPowerAndDuration(other.mData);
        }

        public void addPowerAndDuration(PowerComponents other) {
            this.addPowerAndDuration(other.mData);
        }

        private void addPowerAndDuration(BatteryConsumer.BatteryConsumerData otherData) {
            if (this.mData.layout.customPowerComponentCount != otherData.layout.customPowerComponentCount) {
                throw new IllegalArgumentException("Number of custom power components does not match: " + otherData.layout.customPowerComponentCount + ", expected: " + this.mData.layout.customPowerComponentCount);
            }
            for (int componentId = 17; componentId >= 0; --componentId) {
                BatteryConsumer.Key[] keys;
                for (BatteryConsumer.Key key : keys = this.mData.layout.keys[componentId]) {
                    BatteryConsumer.Key otherKey = null;
                    for (BatteryConsumer.Key aKey : otherData.layout.keys[componentId]) {
                        if (!aKey.equals(key)) continue;
                        otherKey = aKey;
                        break;
                    }
                    if (otherKey == null) continue;
                    this.mData.putDouble(key.mPowerColumnIndex, this.mData.getDouble(key.mPowerColumnIndex) + otherData.getDouble(otherKey.mPowerColumnIndex));
                    this.mData.putLong(key.mDurationColumnIndex, this.mData.getLong(key.mDurationColumnIndex) + otherData.getLong(otherKey.mDurationColumnIndex));
                    if (key.mPowerModelColumnIndex == -1) continue;
                    boolean undefined = false;
                    if (otherKey.mPowerModelColumnIndex == -1) {
                        undefined = true;
                    } else {
                        int powerModel = this.mData.getInt(key.mPowerModelColumnIndex);
                        int otherPowerModel = otherData.getInt(otherKey.mPowerModelColumnIndex);
                        if (powerModel == -1) {
                            this.mData.putInt(key.mPowerModelColumnIndex, otherPowerModel);
                        } else if (powerModel != otherPowerModel && otherPowerModel != -1) {
                            undefined = true;
                        }
                    }
                    if (!undefined) continue;
                    this.mData.putInt(key.mPowerModelColumnIndex, 0);
                }
            }
            for (int i = this.mData.layout.customPowerComponentCount - 1; i >= 0; --i) {
                int powerColumnIndex = this.mData.layout.firstCustomConsumedPowerColumn + i;
                int otherPowerColumnIndex = otherData.layout.firstCustomConsumedPowerColumn + i;
                this.mData.putDouble(powerColumnIndex, this.mData.getDouble(powerColumnIndex) + otherData.getDouble(otherPowerColumnIndex));
                int usageColumnIndex = this.mData.layout.firstCustomUsageDurationColumn + i;
                int otherDurationColumnIndex = otherData.layout.firstCustomUsageDurationColumn + i;
                this.mData.putLong(usageColumnIndex, this.mData.getLong(usageColumnIndex) + otherData.getLong(otherDurationColumnIndex));
            }
        }

        public double getTotalPower() {
            double totalPowerMah = 0.0;
            for (int componentId = 0; componentId < 18; ++componentId) {
                totalPowerMah += this.mData.getDouble(this.mData.getKeyOrThrow((int)componentId, (int)0).mPowerColumnIndex);
            }
            for (int i = 0; i < this.mData.layout.customPowerComponentCount; ++i) {
                totalPowerMah += this.mData.getDouble(this.mData.layout.firstCustomConsumedPowerColumn + i);
            }
            return totalPowerMah;
        }

        public PowerComponents build() {
            this.mData.putDouble(this.mData.layout.totalConsumedPowerColumnIndex, this.getTotalPower());
            BatteryConsumer.Key[][] keyArray = this.mData.layout.keys;
            int n = keyArray.length;
            for (int i = 0; i < n; ++i) {
                BatteryConsumer.Key[] keys;
                for (BatteryConsumer.Key key : keys = keyArray[i]) {
                    if (key.mPowerModelColumnIndex == -1 || this.mData.getInt(key.mPowerModelColumnIndex) != -1) continue;
                    this.mData.putInt(key.mPowerModelColumnIndex, 0);
                }
            }
            return new PowerComponents(this);
        }
    }
}

