/*
 * Decompiled with CFR 0.152.
 */
package android.os;

import android.animation.ValueAnimator;
import android.annotation.SystemApi;
import android.app.ActivityManager;
import android.app.ActivityThread;
import android.app.IActivityManager;
import android.app.IUnsafeIntentStrictModeCallback;
import android.app.compat.CompatChanges;
import android.compat.annotation.UnsupportedAppUsage;
import android.content.Context;
import android.content.Intent;
import android.content.pm.ApplicationInfo;
import android.net.Uri;
import android.os.Binder;
import android.os.DeadObjectException;
import android.os.FileUriExposedException;
import android.os.Handler;
import android.os.INetworkManagementService;
import android.os.Looper;
import android.os.MessageQueue;
import android.os.NetworkOnMainThreadException;
import android.os.Parcel;
import android.os.Parcelable;
import android.os.Process;
import android.os.RemoteException;
import android.os.ServiceManager;
import android.os.SystemClock;
import android.os.SystemProperties;
import android.os.UserHandle;
import android.os._Original_Build;
import android.os.storage.IStorageManager;
import android.os.strictmode.CleartextNetworkViolation;
import android.os.strictmode.ContentUriWithoutPermissionViolation;
import android.os.strictmode.CredentialProtectedWhileLockedViolation;
import android.os.strictmode.CustomViolation;
import android.os.strictmode.DiskReadViolation;
import android.os.strictmode.DiskWriteViolation;
import android.os.strictmode.ExplicitGcViolation;
import android.os.strictmode.FileUriExposedViolation;
import android.os.strictmode.ImplicitDirectBootViolation;
import android.os.strictmode.IncorrectContextUseViolation;
import android.os.strictmode.InstanceCountViolation;
import android.os.strictmode.IntentReceiverLeakedViolation;
import android.os.strictmode.LeakedClosableViolation;
import android.os.strictmode.NetworkViolation;
import android.os.strictmode.NonSdkApiUsedViolation;
import android.os.strictmode.ResourceMismatchViolation;
import android.os.strictmode.ServiceConnectionLeakedViolation;
import android.os.strictmode.SqliteObjectLeakedViolation;
import android.os.strictmode.UnbufferedIoViolation;
import android.os.strictmode.UnsafeIntentLaunchViolation;
import android.os.strictmode.UntaggedSocketViolation;
import android.os.strictmode.Violation;
import android.os.strictmode.WebViewMethodCalledOnWrongThreadViolation;
import android.util.ArrayMap;
import android.util.Log;
import android.util.Printer;
import android.util.Singleton;
import android.util.SparseLongArray;
import android.view.IWindowManager;
import com.android.internal.annotations.GuardedBy;
import com.android.internal.os.BackgroundThread;
import com.android.internal.os.RuntimeInit;
import com.android.internal.util.FastPrintWriter;
import com.android.internal.util.HexDump;
import dalvik.system.BlockGuard;
import dalvik.system.CloseGuard;
import dalvik.system.VMDebug;
import dalvik.system.VMRuntime;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.HashMap;
import java.util.concurrent.Executor;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;

public class StrictMode {
    private static final String TAG = "StrictMode";
    private static final boolean LOG_V = Log.isLoggable("StrictMode", 2);
    public static final String DISABLE_PROPERTY = "persist.sys.strictmode.disable";
    public static final String VISUAL_PROPERTY = "persist.sys.strictmode.visual";
    private static final String CLEARTEXT_PROPERTY = "persist.sys.strictmode.clear";
    private static final boolean DISABLE = false;
    private static final long MIN_VM_INTERVAL_MS = 1000L;
    private static final long MIN_LOG_INTERVAL_MS = 1000L;
    private static final long MIN_DIALOG_INTERVAL_MS = 30000L;
    private static final long MIN_DROPBOX_INTERVAL_MS = 3000L;
    private static final int MAX_SPAN_TAGS = 20;
    private static final int MAX_OFFENSES_PER_LOOP = 10;
    private static final int DETECT_THREAD_DISK_WRITE = 1;
    private static final int DETECT_THREAD_DISK_READ = 2;
    private static final int DETECT_THREAD_NETWORK = 4;
    private static final int DETECT_THREAD_CUSTOM = 8;
    private static final int DETECT_THREAD_RESOURCE_MISMATCH = 16;
    private static final int DETECT_THREAD_UNBUFFERED_IO = 32;
    private static final int DETECT_THREAD_EXPLICIT_GC = 64;
    private static final int DETECT_THREAD_ALL = 65535;
    private static final int DETECT_VM_CURSOR_LEAKS = 1;
    private static final int DETECT_VM_CLOSABLE_LEAKS = 2;
    private static final int DETECT_VM_ACTIVITY_LEAKS = 4;
    private static final int DETECT_VM_INSTANCE_LEAKS = 8;
    private static final int DETECT_VM_REGISTRATION_LEAKS = 16;
    private static final int DETECT_VM_FILE_URI_EXPOSURE = 32;
    private static final int DETECT_VM_CLEARTEXT_NETWORK = 64;
    private static final int DETECT_VM_CONTENT_URI_WITHOUT_PERMISSION = 128;
    private static final int DETECT_VM_UNTAGGED_SOCKET = 256;
    private static final int DETECT_VM_NON_SDK_API_USAGE = 512;
    private static final int DETECT_VM_IMPLICIT_DIRECT_BOOT = 1024;
    private static final int DETECT_VM_CREDENTIAL_PROTECTED_WHILE_LOCKED = 2048;
    private static final int DETECT_VM_INCORRECT_CONTEXT_USE = 4096;
    private static final int DETECT_VM_UNSAFE_INTENT_LAUNCH = 8192;
    private static final int DETECT_VM_ALL = 65535;
    public static final int PENALTY_GATHER = Integer.MIN_VALUE;
    public static final int PENALTY_LOG = 0x40000000;
    public static final int PENALTY_DIALOG = 0x20000000;
    public static final int PENALTY_DEATH = 0x10000000;
    public static final int PENALTY_FLASH = 0x8000000;
    public static final int PENALTY_DROPBOX = 0x4000000;
    public static final int PENALTY_DEATH_ON_NETWORK = 0x2000000;
    public static final int PENALTY_DEATH_ON_CLEARTEXT_NETWORK = 0x1000000;
    public static final int PENALTY_DEATH_ON_FILE_URI_EXPOSURE = 0x800000;
    public static final int PENALTY_ALL = -65536;
    public static final int NETWORK_POLICY_ACCEPT = 0;
    public static final int NETWORK_POLICY_LOG = 1;
    public static final int NETWORK_POLICY_REJECT = 2;
    static final long DETECT_EXPLICIT_GC = 3400644L;
    private static final HashMap<Class, Integer> EMPTY_CLASS_LIMIT_MAP = new HashMap();
    private static volatile VmPolicy sVmPolicy = VmPolicy.LAX;
    private static final ViolationLogger LOGCAT_LOGGER;
    private static volatile ViolationLogger sLogger;
    private static final ThreadLocal<OnThreadViolationListener> sThreadViolationListener;
    private static final ThreadLocal<Executor> sThreadViolationExecutor;
    private static final AtomicInteger sDropboxCallsInFlight;
    private static final Consumer<String> sNonSdkApiUsageConsumer;
    private static final ThreadLocal<ArrayList<ViolationInfo>> gatheredViolations;
    @UnsupportedAppUsage
    private static final ThreadLocal<ArrayList<ViolationInfo>> violationsBeingTimed;
    private static final ThreadLocal<Handler> THREAD_HANDLER;
    private static final ThreadLocal<AndroidBlockGuardPolicy> THREAD_ANDROID_POLICY;
    private static final BlockGuard.VmPolicy VM_ANDROID_POLICY;
    private static long sLastInstanceCountCheckMillis;
    private static boolean sIsIdlerRegistered;
    private static final MessageQueue.IdleHandler sProcessIdleHandler;
    private static volatile boolean sUserKeyUnlocked;
    @UnsupportedAppUsage
    private static final HashMap<Integer, Long> sLastVmViolationTime;
    private static final SparseLongArray sRealLastVmViolationTime;
    private static final Span NO_OP_SPAN;
    private static final ThreadLocal<ThreadSpanState> sThisThreadSpanState;
    @UnsupportedAppUsage
    private static Singleton<IWindowManager> sWindowManager;
    @GuardedBy(value={"StrictMode.class"})
    private static final HashMap<Class, Integer> sExpectedActivityInstanceCount;

    public static void setViolationLogger(ViolationLogger listener) {
        if (listener == null) {
            listener = LOGCAT_LOGGER;
        }
        sLogger = listener;
    }

    private StrictMode() {
    }

    public static void setThreadPolicy(ThreadPolicy policy) {
        StrictMode.setThreadPolicyMask(policy.mask);
        sThreadViolationListener.set(policy.mListener);
        sThreadViolationExecutor.set(policy.mCallbackExecutor);
    }

    public static void setThreadPolicyMask(int threadPolicyMask) {
        StrictMode.setBlockGuardPolicy(threadPolicyMask);
        Binder.setThreadStrictModePolicy(threadPolicyMask);
    }

    private static void setBlockGuardPolicy(int threadPolicyMask) {
        AndroidBlockGuardPolicy androidPolicy;
        if (threadPolicyMask == 0) {
            BlockGuard.setThreadPolicy(BlockGuard.LAX_POLICY);
            return;
        }
        BlockGuard.Policy policy = BlockGuard.getThreadPolicy();
        if (policy instanceof AndroidBlockGuardPolicy) {
            androidPolicy = (AndroidBlockGuardPolicy)policy;
        } else {
            androidPolicy = THREAD_ANDROID_POLICY.get();
            BlockGuard.setThreadPolicy(androidPolicy);
        }
        androidPolicy.setThreadPolicyMask(threadPolicyMask);
    }

    private static void setBlockGuardVmPolicy(int vmPolicyMask) {
        if ((vmPolicyMask &= 0x800) != 0) {
            BlockGuard.setVmPolicy(VM_ANDROID_POLICY);
        } else {
            BlockGuard.setVmPolicy(BlockGuard.LAX_VM_POLICY);
        }
    }

    private static void setCloseGuardEnabled(boolean enabled) {
        if (!(CloseGuard.getReporter() instanceof AndroidCloseGuardReporter)) {
            CloseGuard.setReporter(new AndroidCloseGuardReporter());
        }
        CloseGuard.setEnabled(enabled);
    }

    @UnsupportedAppUsage
    public static int getThreadPolicyMask() {
        BlockGuard.Policy policy = BlockGuard.getThreadPolicy();
        if (policy instanceof AndroidBlockGuardPolicy) {
            return ((AndroidBlockGuardPolicy)policy).getThreadPolicyMask();
        }
        return 0;
    }

    public static ThreadPolicy getThreadPolicy() {
        return new ThreadPolicy(StrictMode.getThreadPolicyMask(), sThreadViolationListener.get(), sThreadViolationExecutor.get());
    }

    public static ThreadPolicy allowThreadDiskWrites() {
        return new ThreadPolicy(StrictMode.allowThreadDiskWritesMask(), sThreadViolationListener.get(), sThreadViolationExecutor.get());
    }

    public static int allowThreadDiskWritesMask() {
        int oldPolicyMask = StrictMode.getThreadPolicyMask();
        int newPolicyMask = oldPolicyMask & 0xFFFFFFFC;
        if (newPolicyMask != oldPolicyMask) {
            StrictMode.setThreadPolicyMask(newPolicyMask);
        }
        return oldPolicyMask;
    }

    public static ThreadPolicy allowThreadDiskReads() {
        return new ThreadPolicy(StrictMode.allowThreadDiskReadsMask(), sThreadViolationListener.get(), sThreadViolationExecutor.get());
    }

    public static int allowThreadDiskReadsMask() {
        int oldPolicyMask = StrictMode.getThreadPolicyMask();
        int newPolicyMask = oldPolicyMask & 0xFFFFFFFD;
        if (newPolicyMask != oldPolicyMask) {
            StrictMode.setThreadPolicyMask(newPolicyMask);
        }
        return oldPolicyMask;
    }

    public static ThreadPolicy allowThreadViolations() {
        ThreadPolicy oldPolicy = StrictMode.getThreadPolicy();
        StrictMode.setThreadPolicyMask(0);
        return oldPolicy;
    }

    public static VmPolicy allowVmViolations() {
        VmPolicy oldPolicy = StrictMode.getVmPolicy();
        sVmPolicy = VmPolicy.LAX;
        return oldPolicy;
    }

    public static boolean isBundledSystemApp(ApplicationInfo ai) {
        if (ai == null || ai.packageName == null) {
            return true;
        }
        if (ai.isSystemApp()) {
            if (ai.packageName.equals("com.android.vending") || ai.packageName.equals("com.android.chrome")) {
                return false;
            }
            if (ai.packageName.equals("com.android.phone")) {
                return false;
            }
            if (ai.packageName.equals("android") || ai.packageName.startsWith("android.") || ai.packageName.startsWith("com.android.")) {
                return true;
            }
        }
        return false;
    }

    public static void initThreadDefaults(ApplicationInfo ai) {
        int targetSdkVersion;
        ThreadPolicy.Builder builder = new ThreadPolicy.Builder();
        int n = targetSdkVersion = ai != null ? ai.targetSdkVersion : 10000;
        if (targetSdkVersion >= 11) {
            builder.detectNetwork();
            builder.penaltyDeathOnNetwork();
        }
        if (!_Original_Build.IS_USER && !SystemProperties.getBoolean(DISABLE_PROPERTY, false)) {
            if (_Original_Build.IS_USERDEBUG) {
                if (StrictMode.isBundledSystemApp(ai)) {
                    builder.detectAll();
                    builder.penaltyDropBox();
                    if (SystemProperties.getBoolean(VISUAL_PROPERTY, false)) {
                        builder.penaltyFlashScreen();
                    }
                }
            } else if (_Original_Build.IS_ENG && StrictMode.isBundledSystemApp(ai)) {
                builder.detectAll();
                builder.penaltyDropBox();
                builder.penaltyLog();
                builder.penaltyFlashScreen();
            }
        }
        StrictMode.setThreadPolicy(builder.build());
    }

    public static void initVmDefaults(ApplicationInfo ai) {
        int targetSdkVersion;
        VmPolicy.Builder builder = new VmPolicy.Builder();
        int n = targetSdkVersion = ai != null ? ai.targetSdkVersion : 10000;
        if (targetSdkVersion >= 24) {
            builder.detectFileUriExposure();
            builder.penaltyDeathOnFileUriExposure();
        }
        if (!_Original_Build.IS_USER && !SystemProperties.getBoolean(DISABLE_PROPERTY, false)) {
            if (_Original_Build.IS_USERDEBUG) {
                if (StrictMode.isBundledSystemApp(ai)) {
                    builder.detectAll();
                    builder.permitActivityLeaks();
                    builder.penaltyDropBox();
                }
            } else if (_Original_Build.IS_ENG && StrictMode.isBundledSystemApp(ai)) {
                builder.detectAll();
                builder.penaltyDropBox();
                builder.penaltyLog();
            }
        }
        StrictMode.setVmPolicy(builder.build());
    }

    @UnsupportedAppUsage
    public static void enableDeathOnFileUriExposure() {
        sVmPolicy = new VmPolicy(StrictMode.sVmPolicy.mask | 0x20 | 0x800000, StrictMode.sVmPolicy.classInstanceLimit, StrictMode.sVmPolicy.mListener, StrictMode.sVmPolicy.mCallbackExecutor);
    }

    @UnsupportedAppUsage
    public static void disableDeathOnFileUriExposure() {
        sVmPolicy = new VmPolicy(StrictMode.sVmPolicy.mask & 0xFF7FFFDF, StrictMode.sVmPolicy.classInstanceLimit, StrictMode.sVmPolicy.mListener, StrictMode.sVmPolicy.mCallbackExecutor);
    }

    private static boolean tooManyViolationsThisLoop() {
        return violationsBeingTimed.get().size() >= 10;
    }

    private static void dropboxViolationAsync(int penaltyMask, ViolationInfo info) {
        int outstanding = sDropboxCallsInFlight.incrementAndGet();
        if (outstanding > 20) {
            sDropboxCallsInFlight.decrementAndGet();
            return;
        }
        if (LOG_V) {
            Log.d(TAG, "Dropboxing async; in-flight=" + outstanding);
        }
        BackgroundThread.getHandler().post(() -> {
            StrictMode.handleApplicationStrictModeViolation(penaltyMask, info);
            int outstandingInner = sDropboxCallsInFlight.decrementAndGet();
            if (LOG_V) {
                Log.d(TAG, "Dropbox complete; in-flight=" + outstandingInner);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void handleApplicationStrictModeViolation(int penaltyMask, ViolationInfo info) {
        int oldMask = StrictMode.getThreadPolicyMask();
        try {
            StrictMode.setThreadPolicyMask(0);
            IActivityManager am = ActivityManager.getService();
            if (am == null) {
                Log.w(TAG, "No activity manager; failed to Dropbox violation.");
            } else {
                am.handleApplicationStrictModeViolation(RuntimeInit.getApplicationObject(), penaltyMask, info);
            }
        }
        catch (RemoteException e) {
            if (e instanceof DeadObjectException) {
            } else {
                Log.e(TAG, "RemoteException handling StrictMode violation", e);
            }
        }
        finally {
            StrictMode.setThreadPolicyMask(oldMask);
        }
    }

    static boolean hasGatheredViolations() {
        return gatheredViolations.get() != null;
    }

    static void clearGatheredViolations() {
        gatheredViolations.set(null);
    }

    @UnsupportedAppUsage
    public static void conditionallyCheckInstanceCounts() {
        VmPolicy policy = StrictMode.getVmPolicy();
        int policySize = policy.classInstanceLimit.size();
        if (policySize == 0) {
            return;
        }
        System.gc();
        System.runFinalization();
        System.gc();
        Class[] classes = policy.classInstanceLimit.keySet().toArray(new Class[policySize]);
        long[] instanceCounts = VMDebug.countInstancesOfClasses(classes, false);
        for (int i = 0; i < classes.length; ++i) {
            long instances = instanceCounts[i];
            Class klass = classes[i];
            int limit = policy.classInstanceLimit.get(klass);
            if (instances <= (long)limit) continue;
            StrictMode.onVmPolicyViolation(new InstanceCountViolation(klass, instances, limit));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setVmPolicy(VmPolicy policy) {
        Class<StrictMode> clazz = StrictMode.class;
        synchronized (StrictMode.class) {
            INetworkManagementService netd;
            sVmPolicy = policy;
            StrictMode.setCloseGuardEnabled(StrictMode.vmClosableObjectLeaksEnabled());
            Looper looper = Looper.getMainLooper();
            if (looper != null) {
                MessageQueue mq = looper.mQueue;
                if (policy.classInstanceLimit.size() == 0 || (StrictMode.sVmPolicy.mask & 0xFFFF0000) == 0) {
                    mq.removeIdleHandler(sProcessIdleHandler);
                    sIsIdlerRegistered = false;
                } else if (!sIsIdlerRegistered) {
                    mq.addIdleHandler(sProcessIdleHandler);
                    sIsIdlerRegistered = true;
                }
            }
            int networkPolicy = 0;
            if ((StrictMode.sVmPolicy.mask & 0x40) != 0) {
                networkPolicy = (StrictMode.sVmPolicy.mask & 0x10000000) != 0 || (StrictMode.sVmPolicy.mask & 0x1000000) != 0 ? 2 : 1;
            }
            if ((netd = INetworkManagementService.Stub.asInterface(ServiceManager.getService("network_management"))) != null) {
                try {
                    netd.setUidCleartextNetworkPolicy(Process.myUid(), networkPolicy);
                }
                catch (RemoteException remoteException) {}
            } else if (networkPolicy != 0) {
                Log.w(TAG, "Dropping requested network policy due to missing service!");
            }
            if ((StrictMode.sVmPolicy.mask & 0x200) != 0) {
                VMRuntime.setNonSdkApiUsageConsumer(sNonSdkApiUsageConsumer);
                VMRuntime.setDedupeHiddenApiWarnings(false);
            } else {
                VMRuntime.setNonSdkApiUsageConsumer(null);
                VMRuntime.setDedupeHiddenApiWarnings(true);
            }
            if ((StrictMode.sVmPolicy.mask & 0x2000) != 0) {
                StrictMode.registerIntentMatchingRestrictionCallback();
            }
            StrictMode.setBlockGuardVmPolicy(StrictMode.sVmPolicy.mask);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    private static void registerIntentMatchingRestrictionCallback() {
        block2: {
            try {
                ActivityManager.getService().registerStrictModeCallback(new UnsafeIntentStrictModeCallback());
            }
            catch (RemoteException e) {
                if (e instanceof DeadObjectException) break block2;
                Log.e(TAG, "RemoteException handling StrictMode violation", e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static VmPolicy getVmPolicy() {
        Class<StrictMode> clazz = StrictMode.class;
        synchronized (StrictMode.class) {
            // ** MonitorExit[var0] (shouldn't be in output)
            return sVmPolicy;
        }
    }

    public static void enableDefaults() {
        StrictMode.setThreadPolicy(new ThreadPolicy.Builder().detectAll().penaltyLog().build());
        StrictMode.setVmPolicy(new VmPolicy.Builder().detectAll().penaltyLog().build());
    }

    public static boolean vmSqliteObjectLeaksEnabled() {
        return (StrictMode.sVmPolicy.mask & 1) != 0;
    }

    public static boolean vmClosableObjectLeaksEnabled() {
        return (StrictMode.sVmPolicy.mask & 2) != 0;
    }

    public static boolean vmRegistrationLeaksEnabled() {
        return (StrictMode.sVmPolicy.mask & 0x10) != 0;
    }

    public static boolean vmFileUriExposureEnabled() {
        return (StrictMode.sVmPolicy.mask & 0x20) != 0;
    }

    public static boolean vmCleartextNetworkEnabled() {
        return (StrictMode.sVmPolicy.mask & 0x40) != 0;
    }

    public static boolean vmContentUriWithoutPermissionEnabled() {
        return (StrictMode.sVmPolicy.mask & 0x80) != 0;
    }

    public static boolean vmUntaggedSocketEnabled() {
        return (StrictMode.sVmPolicy.mask & 0x100) != 0;
    }

    public static boolean vmImplicitDirectBootEnabled() {
        return (StrictMode.sVmPolicy.mask & 0x400) != 0;
    }

    public static boolean vmCredentialProtectedWhileLockedEnabled() {
        return (StrictMode.sVmPolicy.mask & 0x800) != 0;
    }

    public static boolean vmIncorrectContextUseEnabled() {
        return (StrictMode.sVmPolicy.mask & 0x1000) != 0;
    }

    public static boolean vmUnsafeIntentLaunchEnabled() {
        return (StrictMode.sVmPolicy.mask & 0x2000) != 0;
    }

    public static void onSqliteObjectLeaked(String message, Throwable originStack) {
        StrictMode.onVmPolicyViolation(new SqliteObjectLeakedViolation(message, originStack));
    }

    @UnsupportedAppUsage
    public static void onWebViewMethodCalledOnWrongThread(Throwable originStack) {
        StrictMode.onVmPolicyViolation(new WebViewMethodCalledOnWrongThreadViolation(originStack));
    }

    public static void onIntentReceiverLeaked(Throwable originStack) {
        StrictMode.onVmPolicyViolation(new IntentReceiverLeakedViolation(originStack));
    }

    public static void onServiceConnectionLeaked(Throwable originStack) {
        StrictMode.onVmPolicyViolation(new ServiceConnectionLeakedViolation(originStack));
    }

    public static void onFileUriExposed(Uri uri, String location) {
        String message = uri + " exposed beyond app through " + location;
        if ((StrictMode.sVmPolicy.mask & 0x800000) != 0) {
            throw new FileUriExposedException(message);
        }
        StrictMode.onVmPolicyViolation(new FileUriExposedViolation(message));
    }

    public static void onContentUriWithoutPermission(Uri uri, String location) {
        StrictMode.onVmPolicyViolation(new ContentUriWithoutPermissionViolation(uri, location));
    }

    public static void onCleartextNetworkDetected(byte[] firstPacket) {
        byte[] rawAddr = null;
        if (firstPacket != null) {
            if (firstPacket.length >= 20 && (firstPacket[0] & 0xF0) == 64) {
                rawAddr = new byte[4];
                System.arraycopy(firstPacket, 16, rawAddr, 0, 4);
            } else if (firstPacket.length >= 40 && (firstPacket[0] & 0xF0) == 96) {
                rawAddr = new byte[16];
                System.arraycopy(firstPacket, 24, rawAddr, 0, 16);
            }
        }
        int uid = Process.myUid();
        StringBuilder msg = new StringBuilder("Detected cleartext network traffic from UID ").append(uid);
        if (rawAddr != null) {
            try {
                msg.append(" to ").append(InetAddress.getByAddress(rawAddr));
            }
            catch (UnknownHostException unknownHostException) {
                // empty catch block
            }
        }
        msg.append(HexDump.dumpHexString(firstPacket).trim()).append(' ');
        boolean forceDeath = (StrictMode.sVmPolicy.mask & 0x1000000) != 0;
        StrictMode.onVmPolicyViolation(new CleartextNetworkViolation(msg.toString()), forceDeath);
    }

    public static void onUntaggedSocket() {
        StrictMode.onVmPolicyViolation(new UntaggedSocketViolation());
    }

    public static void onImplicitDirectBoot() {
        StrictMode.onVmPolicyViolation(new ImplicitDirectBootViolation());
    }

    public static void onIncorrectContextUsed(String message, Throwable originStack) {
        StrictMode.onVmPolicyViolation(new IncorrectContextUseViolation(message, originStack));
    }

    public static void assertConfigurationContext(Context context, String methodName) {
        if (StrictMode.vmIncorrectContextUseEnabled() && !context.isConfigurationContext()) {
            String errorMessage = "Tried to access the API:" + methodName + " which needs to have proper configuration from a non-UI Context:" + context;
            String message = "The API:" + methodName + " needs a proper configuration. Use UI contexts such as an activity or a context created via createWindowContext(Display, int, Bundle) or  createConfigurationContext(Configuration) with a proper configuration.";
            IllegalAccessException exception = new IllegalAccessException(errorMessage);
            StrictMode.onIncorrectContextUsed(message, exception);
            Log.e(TAG, errorMessage + " " + message, exception);
        }
    }

    public static void assertUiContext(Context context, String methodName) {
        if (StrictMode.vmIncorrectContextUseEnabled() && !context.isUiContext()) {
            String errorMessage = "Tried to access UI related API:" + methodName + " from a non-UI Context:" + context;
            String message = methodName + " should be accessed from Activity or other UI Contexts. Use an Activity or a Context created with Context#createWindowContext(int, Bundle), which are adjusted to the configuration and visual bounds of an area on screen.";
            IllegalAccessException exception = new IllegalAccessException(errorMessage);
            StrictMode.onIncorrectContextUsed(message, exception);
            Log.e(TAG, errorMessage + " " + message, exception);
        }
    }

    public static void onUnsafeIntentLaunch(Intent intent) {
        StrictMode.onVmPolicyViolation(new UnsafeIntentLaunchViolation(intent));
    }

    public static void onUnsafeIntentLaunch(Intent intent, String message) {
        StrictMode.onVmPolicyViolation(new UnsafeIntentLaunchViolation(intent, message));
    }

    private static boolean isUserKeyUnlocked(int userId) {
        IStorageManager storage = IStorageManager.Stub.asInterface(ServiceManager.getService("mount"));
        if (storage != null) {
            try {
                return storage.isUserKeyUnlocked(userId);
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
        }
        return false;
    }

    private static void onCredentialProtectedPathAccess(String path, int userId) {
        if (userId == UserHandle.myUserId()) {
            if (sUserKeyUnlocked) {
                return;
            }
            if (StrictMode.isUserKeyUnlocked(userId)) {
                sUserKeyUnlocked = true;
                return;
            }
        } else if (StrictMode.isUserKeyUnlocked(userId)) {
            return;
        }
        StrictMode.onVmPolicyViolation(new CredentialProtectedWhileLockedViolation("Accessed credential protected path " + path + " while user " + userId + " was locked"));
    }

    private static void clampViolationTimeMap(SparseLongArray violationTime, long retainSince) {
        int i = 0;
        while (i < violationTime.size()) {
            if (violationTime.valueAt(i) < retainSince) {
                violationTime.removeAt(i);
                continue;
            }
            ++i;
        }
    }

    public static void onVmPolicyViolation(Violation originStack) {
        StrictMode.onVmPolicyViolation(originStack, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void onVmPolicyViolation(Violation violation, boolean forceDeath) {
        boolean penaltyDropbox = (StrictMode.sVmPolicy.mask & 0x4000000) != 0;
        boolean penaltyDeath = (StrictMode.sVmPolicy.mask & 0x10000000) != 0 || forceDeath;
        boolean penaltyLog = (StrictMode.sVmPolicy.mask & 0x40000000) != 0;
        int penaltyMask = StrictMode.sVmPolicy.mask & 0xFFFF0000;
        ViolationInfo info = new ViolationInfo(violation, penaltyMask);
        info.numAnimationsRunning = 0;
        info.tags = null;
        info.broadcastIntentAction = null;
        Integer fingerprint = info.hashCode();
        long now = SystemClock.uptimeMillis();
        long timeSinceLastViolationMillis = Long.MAX_VALUE;
        if (sLogger == LOGCAT_LOGGER) {
            SparseLongArray sparseLongArray = sRealLastVmViolationTime;
            synchronized (sparseLongArray) {
                if (sRealLastVmViolationTime.indexOfKey(fingerprint) >= 0) {
                    long lastViolationTime = sRealLastVmViolationTime.get(fingerprint);
                    timeSinceLastViolationMillis = now - lastViolationTime;
                }
                if (timeSinceLastViolationMillis > 1000L) {
                    sRealLastVmViolationTime.put(fingerprint, now);
                }
                StrictMode.clampViolationTimeMap(sRealLastVmViolationTime, now - Math.max(1000L, 1000L));
            }
        }
        if (timeSinceLastViolationMillis <= 1000L) {
            return;
        }
        if (penaltyLog && sLogger != null && timeSinceLastViolationMillis > 1000L) {
            sLogger.log(info);
        }
        if (penaltyDropbox) {
            if (penaltyDeath) {
                StrictMode.handleApplicationStrictModeViolation(0x4000000, info);
            } else {
                StrictMode.dropboxViolationAsync(0x4000000, info);
            }
        }
        if (penaltyDeath) {
            System.err.println("StrictMode VmPolicy violation with POLICY_DEATH; shutting down.");
            Process.killProcess(Process.myPid());
            System.exit(10);
        }
        if (StrictMode.sVmPolicy.mListener != null && StrictMode.sVmPolicy.mCallbackExecutor != null) {
            OnVmViolationListener listener = StrictMode.sVmPolicy.mListener;
            try {
                StrictMode.sVmPolicy.mCallbackExecutor.execute(() -> {
                    VmPolicy oldPolicy = StrictMode.allowVmViolations();
                    try {
                        listener.onVmViolation(violation);
                    }
                    finally {
                        StrictMode.setVmPolicy(oldPolicy);
                    }
                });
            }
            catch (RejectedExecutionException e) {
                Log.e(TAG, "VmPolicy penaltyCallback failed", e);
            }
        }
    }

    static void writeGatheredViolationsToParcel(Parcel p) {
        ArrayList<ViolationInfo> violations = gatheredViolations.get();
        if (violations == null) {
            p.writeInt(0);
        } else {
            int size = Math.min(violations.size(), 3);
            p.writeInt(size);
            for (int i = 0; i < size; ++i) {
                violations.get(i).writeToParcel(p, 0);
            }
        }
        gatheredViolations.set(null);
    }

    static void readAndHandleBinderCallViolations(Parcel p) {
        Throwable localCallSite = new Throwable();
        int policyMask = StrictMode.getThreadPolicyMask();
        boolean currentlyGathering = (policyMask & Integer.MIN_VALUE) != 0;
        int size = p.readInt();
        for (int i = 0; i < size; ++i) {
            ViolationInfo info = new ViolationInfo(p, !currentlyGathering);
            info.addLocalStack(localCallSite);
            BlockGuard.Policy policy = BlockGuard.getThreadPolicy();
            if (!(policy instanceof AndroidBlockGuardPolicy)) continue;
            ((AndroidBlockGuardPolicy)policy).handleViolationWithTimingAttempt(info);
        }
    }

    @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
    private static void onBinderStrictModePolicyChange(int newPolicy) {
        StrictMode.setBlockGuardPolicy(newPolicy);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @UnsupportedAppUsage
    public static Span enterCriticalSpan(String name) {
        if (_Original_Build.IS_USER) {
            return NO_OP_SPAN;
        }
        if (name == null || name.isEmpty()) {
            throw new IllegalArgumentException("name must be non-null and non-empty");
        }
        ThreadSpanState state = sThisThreadSpanState.get();
        Span span = null;
        ThreadSpanState threadSpanState = state;
        synchronized (threadSpanState) {
            if (state.mFreeListHead != null) {
                span = state.mFreeListHead;
                state.mFreeListHead = span.mNext;
                --state.mFreeListSize;
            } else {
                span = new Span(state);
            }
            span.mName = name;
            span.mCreateMillis = SystemClock.uptimeMillis();
            span.mNext = state.mActiveHead;
            span.mPrev = null;
            state.mActiveHead = span;
            ++state.mActiveSize;
            if (span.mNext != null) {
                span.mNext.mPrev = span;
            }
            if (LOG_V) {
                Log.d(TAG, "Span enter=" + name + "; size=" + state.mActiveSize);
            }
        }
        return span;
    }

    public static void noteSlowCall(String name) {
        BlockGuard.Policy policy = BlockGuard.getThreadPolicy();
        if (!(policy instanceof AndroidBlockGuardPolicy)) {
            return;
        }
        ((AndroidBlockGuardPolicy)policy).onCustomSlowCall(name);
    }

    @SystemApi(client=SystemApi.Client.MODULE_LIBRARIES)
    public static void noteUntaggedSocket() {
        if (StrictMode.vmUntaggedSocketEnabled()) {
            StrictMode.onUntaggedSocket();
        }
    }

    public static void noteResourceMismatch(Object tag) {
        BlockGuard.Policy policy = BlockGuard.getThreadPolicy();
        if (!(policy instanceof AndroidBlockGuardPolicy)) {
            return;
        }
        ((AndroidBlockGuardPolicy)policy).onResourceMismatch(tag);
    }

    public static void noteUnbufferedIO() {
        BlockGuard.Policy policy = BlockGuard.getThreadPolicy();
        if (!(policy instanceof AndroidBlockGuardPolicy)) {
            return;
        }
        policy.onUnbufferedIO();
    }

    public static void noteDiskRead() {
        BlockGuard.Policy policy = BlockGuard.getThreadPolicy();
        if (!(policy instanceof AndroidBlockGuardPolicy)) {
            return;
        }
        policy.onReadFromDisk();
    }

    public static void noteDiskWrite() {
        BlockGuard.Policy policy = BlockGuard.getThreadPolicy();
        if (!(policy instanceof AndroidBlockGuardPolicy)) {
            return;
        }
        policy.onWriteToDisk();
    }

    public static Object trackActivity(Object instance) {
        return new InstanceTracker(instance);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
    public static void incrementExpectedActivityCount(Class klass) {
        if (klass == null) {
            return;
        }
        Class<StrictMode> clazz = StrictMode.class;
        synchronized (StrictMode.class) {
            if ((StrictMode.sVmPolicy.mask & 4) == 0) {
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return;
            }
            Integer expected = sExpectedActivityInstanceCount.get(klass);
            Integer newExpected = expected == null ? InstanceTracker.getInstanceCount(klass) + 1 : expected + 1;
            sExpectedActivityInstanceCount.put(klass, newExpected);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void decrementExpectedActivityCount(Class klass) {
        if (klass == null) {
            return;
        }
        Class<StrictMode> clazz = StrictMode.class;
        synchronized (StrictMode.class) {
            int newExpected;
            if ((StrictMode.sVmPolicy.mask & 4) == 0) {
                // ** MonitorExit[var2_1] (shouldn't be in output)
                return;
            }
            Integer expected = sExpectedActivityInstanceCount.get(klass);
            int n = newExpected = expected == null || expected == 0 ? 0 : expected - 1;
            if (newExpected == 0) {
                sExpectedActivityInstanceCount.remove(klass);
            } else {
                sExpectedActivityInstanceCount.put(klass, newExpected);
            }
            int limit = newExpected + 1;
            // ** MonitorExit[var2_1] (shouldn't be in output)
            int actual = InstanceTracker.getInstanceCount(klass);
            if (actual <= limit) {
                return;
            }
            System.gc();
            System.runFinalization();
            System.gc();
            long instances = VMDebug.countInstancesOfClass(klass, false);
            if (instances > (long)limit) {
                StrictMode.onVmPolicyViolation(new InstanceCountViolation(klass, instances, limit));
            }
            return;
        }
    }

    static {
        sLogger = LOGCAT_LOGGER = info -> {
            String msg = info.durationMillis != -1 ? "StrictMode policy violation; ~duration=" + info.durationMillis + " ms:" : "StrictMode policy violation:";
            Log.d(TAG, msg + " " + info.getStackTrace());
        };
        sThreadViolationListener = new ThreadLocal();
        sThreadViolationExecutor = new ThreadLocal();
        sDropboxCallsInFlight = new AtomicInteger(0);
        sNonSdkApiUsageConsumer = message -> StrictMode.onVmPolicyViolation(new NonSdkApiUsedViolation((String)message));
        gatheredViolations = new ThreadLocal<ArrayList<ViolationInfo>>(){

            @Override
            protected ArrayList<ViolationInfo> initialValue() {
                return null;
            }
        };
        violationsBeingTimed = new ThreadLocal<ArrayList<ViolationInfo>>(){

            @Override
            protected ArrayList<ViolationInfo> initialValue() {
                return new ArrayList<ViolationInfo>();
            }
        };
        THREAD_HANDLER = new ThreadLocal<Handler>(){

            @Override
            protected Handler initialValue() {
                return new Handler();
            }
        };
        THREAD_ANDROID_POLICY = new ThreadLocal<AndroidBlockGuardPolicy>(){

            @Override
            protected AndroidBlockGuardPolicy initialValue() {
                return new AndroidBlockGuardPolicy(0);
            }
        };
        VM_ANDROID_POLICY = new BlockGuard.VmPolicy(){

            @Override
            public void onPathAccess(String path) {
                if (path == null) {
                    return;
                }
                if (path.startsWith("/data/user/") || path.startsWith("/data/media/") || path.startsWith("/data/system_ce/") || path.startsWith("/data/misc_ce/") || path.startsWith("/data/vendor_ce/") || path.startsWith("/storage/emulated/")) {
                    int second = path.indexOf(47, 1);
                    int third = path.indexOf(47, second + 1);
                    int fourth = path.indexOf(47, third + 1);
                    if (fourth == -1) {
                        return;
                    }
                    try {
                        int userId = Integer.parseInt(path.substring(third + 1, fourth));
                        StrictMode.onCredentialProtectedPathAccess(path, userId);
                    }
                    catch (NumberFormatException numberFormatException) {}
                } else if (path.startsWith("/data/data/")) {
                    StrictMode.onCredentialProtectedPathAccess(path, 0);
                }
            }
        };
        sLastInstanceCountCheckMillis = 0L;
        sIsIdlerRegistered = false;
        sProcessIdleHandler = new MessageQueue.IdleHandler(){

            @Override
            public boolean queueIdle() {
                long now = SystemClock.uptimeMillis();
                if (now - sLastInstanceCountCheckMillis > 30000L) {
                    sLastInstanceCountCheckMillis = now;
                    StrictMode.conditionallyCheckInstanceCounts();
                }
                return true;
            }
        };
        sUserKeyUnlocked = false;
        sLastVmViolationTime = new HashMap();
        sRealLastVmViolationTime = new SparseLongArray();
        NO_OP_SPAN = new Span(){

            @Override
            public void finish() {
            }
        };
        sThisThreadSpanState = new ThreadLocal<ThreadSpanState>(){

            @Override
            protected ThreadSpanState initialValue() {
                return new ThreadSpanState();
            }
        };
        sWindowManager = new Singleton<IWindowManager>(){

            @Override
            protected IWindowManager create() {
                return IWindowManager.Stub.asInterface(ServiceManager.getService("window"));
            }
        };
        sExpectedActivityInstanceCount = new HashMap();
    }

    public static interface ViolationLogger {
        public void log(ViolationInfo var1);
    }

    public static class ThreadPolicy {
        public static final ThreadPolicy LAX = new ThreadPolicy(0, null, null);
        @UnsupportedAppUsage
        final int mask;
        final OnThreadViolationListener mListener;
        final Executor mCallbackExecutor;

        private ThreadPolicy(int mask, OnThreadViolationListener listener, Executor executor) {
            this.mask = mask;
            this.mListener = listener;
            this.mCallbackExecutor = executor;
        }

        public String toString() {
            return "[StrictMode.ThreadPolicy; mask=" + this.mask + "]";
        }

        public static class Builder {
            private int mMask = 0;
            private OnThreadViolationListener mListener;
            private Executor mExecutor;

            public Builder() {
                this.mMask = 0;
            }

            public Builder(ThreadPolicy policy) {
                this.mMask = policy.mask;
                this.mListener = policy.mListener;
                this.mExecutor = policy.mCallbackExecutor;
            }

            public Builder detectAll() {
                this.detectDiskReads();
                this.detectDiskWrites();
                this.detectNetwork();
                int targetSdk = VMRuntime.getRuntime().getTargetSdkVersion();
                if (targetSdk >= 11) {
                    this.detectCustomSlowCalls();
                }
                if (targetSdk >= 23) {
                    this.detectResourceMismatches();
                }
                if (targetSdk >= 26) {
                    this.detectUnbufferedIo();
                }
                if (CompatChanges.isChangeEnabled(3400644L)) {
                    this.detectExplicitGc();
                }
                return this;
            }

            public Builder permitAll() {
                return this.disable(65535);
            }

            public Builder detectNetwork() {
                return this.enable(4);
            }

            public Builder permitNetwork() {
                return this.disable(4);
            }

            public Builder detectDiskReads() {
                return this.enable(2);
            }

            public Builder permitDiskReads() {
                return this.disable(2);
            }

            public Builder detectCustomSlowCalls() {
                return this.enable(8);
            }

            public Builder permitCustomSlowCalls() {
                return this.disable(8);
            }

            public Builder permitResourceMismatches() {
                return this.disable(16);
            }

            public Builder detectUnbufferedIo() {
                return this.enable(32);
            }

            public Builder permitUnbufferedIo() {
                return this.disable(32);
            }

            public Builder detectResourceMismatches() {
                return this.enable(16);
            }

            public Builder detectDiskWrites() {
                return this.enable(1);
            }

            public Builder permitDiskWrites() {
                return this.disable(1);
            }

            public Builder detectExplicitGc() {
                return this.enable(64);
            }

            public Builder permitExplicitGc() {
                return this.disable(64);
            }

            public Builder penaltyDialog() {
                return this.enable(0x20000000);
            }

            public Builder penaltyDeath() {
                return this.enable(0x10000000);
            }

            public Builder penaltyDeathOnNetwork() {
                return this.enable(0x2000000);
            }

            public Builder penaltyFlashScreen() {
                return this.enable(0x8000000);
            }

            public Builder penaltyLog() {
                return this.enable(0x40000000);
            }

            public Builder penaltyDropBox() {
                return this.enable(0x4000000);
            }

            public Builder penaltyListener(Executor executor, OnThreadViolationListener listener) {
                if (executor == null) {
                    throw new NullPointerException("executor must not be null");
                }
                this.mListener = listener;
                this.mExecutor = executor;
                return this;
            }

            public Builder penaltyListener(OnThreadViolationListener listener, Executor executor) {
                return this.penaltyListener(executor, listener);
            }

            private Builder enable(int mask) {
                this.mMask |= mask;
                return this;
            }

            private Builder disable(int mask) {
                this.mMask &= ~mask;
                return this;
            }

            public ThreadPolicy build() {
                if (this.mListener == null && this.mMask != 0 && (this.mMask & 0x74000000) == 0) {
                    this.penaltyLog();
                }
                return new ThreadPolicy(this.mMask, this.mListener, this.mExecutor);
            }
        }
    }

    public static interface OnThreadViolationListener {
        public void onThreadViolation(Violation var1);
    }

    private static class AndroidBlockGuardPolicy
    implements BlockGuard.Policy {
        private int mThreadPolicyMask;
        private ArrayMap<Integer, Long> mLastViolationTime;
        private SparseLongArray mRealLastViolationTime;

        public AndroidBlockGuardPolicy(int threadPolicyMask) {
            this.mThreadPolicyMask = threadPolicyMask;
        }

        public String toString() {
            return "AndroidBlockGuardPolicy; mPolicyMask=" + this.mThreadPolicyMask;
        }

        @Override
        public int getPolicyMask() {
            return this.mThreadPolicyMask;
        }

        @Override
        public void onWriteToDisk() {
            if ((this.mThreadPolicyMask & 1) == 0) {
                return;
            }
            if (StrictMode.tooManyViolationsThisLoop()) {
                return;
            }
            this.startHandlingViolationException(new DiskWriteViolation());
        }

        void onCustomSlowCall(String name) {
            if ((this.mThreadPolicyMask & 8) == 0) {
                return;
            }
            if (StrictMode.tooManyViolationsThisLoop()) {
                return;
            }
            this.startHandlingViolationException(new CustomViolation(name));
        }

        void onResourceMismatch(Object tag) {
            if ((this.mThreadPolicyMask & 0x10) == 0) {
                return;
            }
            if (StrictMode.tooManyViolationsThisLoop()) {
                return;
            }
            this.startHandlingViolationException(new ResourceMismatchViolation(tag));
        }

        @Override
        public void onUnbufferedIO() {
            if ((this.mThreadPolicyMask & 0x20) == 0) {
                return;
            }
            if (StrictMode.tooManyViolationsThisLoop()) {
                return;
            }
            this.startHandlingViolationException(new UnbufferedIoViolation());
        }

        @Override
        public void onReadFromDisk() {
            if ((this.mThreadPolicyMask & 2) == 0) {
                return;
            }
            if (StrictMode.tooManyViolationsThisLoop()) {
                return;
            }
            this.startHandlingViolationException(new DiskReadViolation());
        }

        @Override
        public void onNetwork() {
            if ((this.mThreadPolicyMask & 4) == 0) {
                return;
            }
            if ((this.mThreadPolicyMask & 0x2000000) != 0) {
                throw new NetworkOnMainThreadException();
            }
            if (StrictMode.tooManyViolationsThisLoop()) {
                return;
            }
            this.startHandlingViolationException(new NetworkViolation());
        }

        @Override
        public void onExplicitGc() {
            if ((this.mThreadPolicyMask & 0x40) == 0) {
                return;
            }
            if (StrictMode.tooManyViolationsThisLoop()) {
                return;
            }
            this.startHandlingViolationException(new ExplicitGcViolation());
        }

        public int getThreadPolicyMask() {
            return this.mThreadPolicyMask;
        }

        public void setThreadPolicyMask(int threadPolicyMask) {
            this.mThreadPolicyMask = threadPolicyMask;
        }

        void startHandlingViolationException(Violation e) {
            int penaltyMask = this.mThreadPolicyMask & 0xFFFF0000;
            ViolationInfo info = new ViolationInfo(e, penaltyMask);
            info.violationUptimeMillis = SystemClock.uptimeMillis();
            this.handleViolationWithTimingAttempt(info);
        }

        void handleViolationWithTimingAttempt(ViolationInfo info) {
            IWindowManager windowManager;
            Looper looper = Looper.myLooper();
            if (looper == null || info.mPenaltyMask == 0x10000000) {
                info.durationMillis = -1;
                this.onThreadPolicyViolation(info);
                return;
            }
            ArrayList<ViolationInfo> records = violationsBeingTimed.get();
            if (records.size() >= 10) {
                return;
            }
            records.add(info);
            if (records.size() > 1) {
                return;
            }
            IWindowManager iWindowManager = windowManager = info.penaltyEnabled(0x8000000) ? sWindowManager.get() : null;
            if (windowManager != null) {
                try {
                    windowManager.showStrictModeViolation(true);
                }
                catch (RemoteException remoteException) {
                    // empty catch block
                }
            }
            THREAD_HANDLER.get().postAtFrontOfQueue(() -> {
                long loopFinishTime = SystemClock.uptimeMillis();
                if (windowManager != null) {
                    try {
                        windowManager.showStrictModeViolation(false);
                    }
                    catch (RemoteException remoteException) {
                        // empty catch block
                    }
                }
                for (int n = 0; n < records.size(); ++n) {
                    ViolationInfo v = (ViolationInfo)records.get(n);
                    v.violationNumThisLoop = n + 1;
                    v.durationMillis = (int)(loopFinishTime - v.violationUptimeMillis);
                    this.onThreadPolicyViolation(v);
                }
                records.clear();
            });
        }

        void onThreadPolicyViolation(ViolationInfo info) {
            long timeSinceLastViolationMillis;
            if (LOG_V) {
                Log.d(StrictMode.TAG, "onThreadPolicyViolation; penalty=" + info.mPenaltyMask);
            }
            if (info.penaltyEnabled(Integer.MIN_VALUE)) {
                ArrayList<ViolationInfo> violations = gatheredViolations.get();
                if (violations == null) {
                    violations = new ArrayList(1);
                    gatheredViolations.set(violations);
                }
                for (ViolationInfo previous : violations) {
                    if (!info.getStackTrace().equals(previous.getStackTrace())) continue;
                    return;
                }
                violations.add(info);
                return;
            }
            Integer crashFingerprint = info.hashCode();
            long lastViolationTime = 0L;
            long now = SystemClock.uptimeMillis();
            if (sLogger == LOGCAT_LOGGER) {
                if (this.mRealLastViolationTime != null) {
                    Long vtime = this.mRealLastViolationTime.get(crashFingerprint);
                    if (vtime != null) {
                        lastViolationTime = vtime;
                    }
                    StrictMode.clampViolationTimeMap(this.mRealLastViolationTime, Math.max(1000L, Math.max(30000L, 3000L)));
                } else {
                    this.mRealLastViolationTime = new SparseLongArray(1);
                }
                this.mRealLastViolationTime.put(crashFingerprint, now);
            }
            long l = timeSinceLastViolationMillis = lastViolationTime == 0L ? Long.MAX_VALUE : now - lastViolationTime;
            if (info.penaltyEnabled(0x40000000) && timeSinceLastViolationMillis > 1000L) {
                sLogger.log(info);
            }
            Violation violation = info.mViolation;
            int penaltyMask = 0;
            if (info.penaltyEnabled(0x20000000) && timeSinceLastViolationMillis > 30000L) {
                penaltyMask |= 0x20000000;
            }
            if (info.penaltyEnabled(0x4000000) && timeSinceLastViolationMillis > 3000L) {
                penaltyMask |= 0x4000000;
            }
            if (penaltyMask != 0) {
                boolean justDropBox;
                boolean bl = justDropBox = info.mPenaltyMask == 0x4000000;
                if (justDropBox) {
                    StrictMode.dropboxViolationAsync(penaltyMask, info);
                } else {
                    StrictMode.handleApplicationStrictModeViolation(penaltyMask, info);
                }
            }
            if (info.penaltyEnabled(0x10000000)) {
                throw new RuntimeException("StrictMode ThreadPolicy violation", violation);
            }
            OnThreadViolationListener listener = sThreadViolationListener.get();
            Executor executor = sThreadViolationExecutor.get();
            if (listener != null && executor != null) {
                try {
                    executor.execute(() -> {
                        ThreadPolicy oldPolicy = StrictMode.allowThreadViolations();
                        try {
                            listener.onThreadViolation(violation);
                        }
                        finally {
                            StrictMode.setThreadPolicy(oldPolicy);
                        }
                    });
                }
                catch (RejectedExecutionException e) {
                    Log.e(StrictMode.TAG, "ThreadPolicy penaltyCallback failed", e);
                }
            }
        }
    }

    private static class AndroidCloseGuardReporter
    implements CloseGuard.Reporter {
        private AndroidCloseGuardReporter() {
        }

        @Override
        public void report(String message, Throwable allocationSite) {
            StrictMode.onVmPolicyViolation(new LeakedClosableViolation(message, allocationSite));
        }

        @Override
        public void report(String message) {
            StrictMode.onVmPolicyViolation(new LeakedClosableViolation(message));
        }
    }

    public static class VmPolicy {
        public static final VmPolicy LAX = new VmPolicy(0, EMPTY_CLASS_LIMIT_MAP, null, null);
        @UnsupportedAppUsage
        final int mask;
        final OnVmViolationListener mListener;
        final Executor mCallbackExecutor;
        final HashMap<Class, Integer> classInstanceLimit;

        private VmPolicy(int mask, HashMap<Class, Integer> classInstanceLimit, OnVmViolationListener listener, Executor executor) {
            if (classInstanceLimit == null) {
                throw new NullPointerException("classInstanceLimit == null");
            }
            this.mask = mask;
            this.classInstanceLimit = classInstanceLimit;
            this.mListener = listener;
            this.mCallbackExecutor = executor;
        }

        public String toString() {
            return "[StrictMode.VmPolicy; mask=" + this.mask + "]";
        }

        public static class Builder {
            @UnsupportedAppUsage
            private int mMask;
            private OnVmViolationListener mListener;
            private Executor mExecutor;
            private HashMap<Class, Integer> mClassInstanceLimit;
            private boolean mClassInstanceLimitNeedCow = false;

            public Builder() {
                this.mMask = 0;
            }

            public Builder(VmPolicy base) {
                this.mMask = base.mask;
                this.mClassInstanceLimitNeedCow = true;
                this.mClassInstanceLimit = base.classInstanceLimit;
                this.mListener = base.mListener;
                this.mExecutor = base.mCallbackExecutor;
            }

            public Builder setClassInstanceLimit(Class klass, int instanceLimit) {
                if (klass == null) {
                    throw new NullPointerException("klass == null");
                }
                if (this.mClassInstanceLimitNeedCow) {
                    if (this.mClassInstanceLimit.containsKey(klass) && this.mClassInstanceLimit.get(klass) == instanceLimit) {
                        return this;
                    }
                    this.mClassInstanceLimitNeedCow = false;
                    this.mClassInstanceLimit = (HashMap)this.mClassInstanceLimit.clone();
                } else if (this.mClassInstanceLimit == null) {
                    this.mClassInstanceLimit = new HashMap();
                }
                this.mMask |= 8;
                this.mClassInstanceLimit.put(klass, instanceLimit);
                return this;
            }

            public Builder detectActivityLeaks() {
                return this.enable(4);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Builder permitActivityLeaks() {
                Class<StrictMode> clazz = StrictMode.class;
                synchronized (StrictMode.class) {
                    sExpectedActivityInstanceCount.clear();
                    // ** MonitorExit[var1_1] (shouldn't be in output)
                    return this.disable(4);
                }
            }

            public Builder detectNonSdkApiUsage() {
                return this.enable(512);
            }

            public Builder permitNonSdkApiUsage() {
                return this.disable(512);
            }

            public Builder detectAll() {
                this.detectLeakedSqlLiteObjects();
                int targetSdk = VMRuntime.getRuntime().getTargetSdkVersion();
                if (targetSdk >= 11) {
                    this.detectActivityLeaks();
                    this.detectLeakedClosableObjects();
                }
                if (targetSdk >= 16) {
                    this.detectLeakedRegistrationObjects();
                }
                if (targetSdk >= 18) {
                    this.detectFileUriExposure();
                }
                if (targetSdk >= 23 && SystemProperties.getBoolean(StrictMode.CLEARTEXT_PROPERTY, false)) {
                    this.detectCleartextNetwork();
                }
                if (targetSdk >= 26) {
                    this.detectContentUriWithoutPermission();
                    this.detectUntaggedSockets();
                }
                if (targetSdk >= 29) {
                    this.detectCredentialProtectedWhileLocked();
                }
                if (targetSdk >= 30) {
                    this.detectIncorrectContextUse();
                }
                if (targetSdk >= 31) {
                    this.detectUnsafeIntentLaunch();
                }
                return this;
            }

            public Builder detectLeakedSqlLiteObjects() {
                return this.enable(1);
            }

            public Builder detectLeakedClosableObjects() {
                return this.enable(2);
            }

            public Builder detectLeakedRegistrationObjects() {
                return this.enable(16);
            }

            public Builder detectFileUriExposure() {
                return this.enable(32);
            }

            public Builder detectCleartextNetwork() {
                return this.enable(64);
            }

            public Builder detectContentUriWithoutPermission() {
                return this.enable(128);
            }

            public Builder detectUntaggedSockets() {
                return this.enable(256);
            }

            public Builder permitUntaggedSockets() {
                return this.disable(256);
            }

            public Builder detectImplicitDirectBoot() {
                return this.enable(1024);
            }

            public Builder permitImplicitDirectBoot() {
                return this.disable(1024);
            }

            public Builder detectCredentialProtectedWhileLocked() {
                return this.enable(2048);
            }

            public Builder permitCredentialProtectedWhileLocked() {
                return this.disable(2048);
            }

            public Builder detectIncorrectContextUse() {
                return this.enable(4096);
            }

            public Builder permitIncorrectContextUse() {
                return this.disable(4096);
            }

            public Builder detectUnsafeIntentLaunch() {
                return this.enable(8192);
            }

            public Builder permitUnsafeIntentLaunch() {
                return this.disable(8192);
            }

            public Builder penaltyDeath() {
                return this.enable(0x10000000);
            }

            public Builder penaltyDeathOnCleartextNetwork() {
                return this.enable(0x1000000);
            }

            public Builder penaltyDeathOnFileUriExposure() {
                return this.enable(0x800000);
            }

            public Builder penaltyLog() {
                return this.enable(0x40000000);
            }

            public Builder penaltyDropBox() {
                return this.enable(0x4000000);
            }

            public Builder penaltyListener(Executor executor, OnVmViolationListener listener) {
                if (executor == null) {
                    throw new NullPointerException("executor must not be null");
                }
                this.mListener = listener;
                this.mExecutor = executor;
                return this;
            }

            public Builder penaltyListener(OnVmViolationListener listener, Executor executor) {
                return this.penaltyListener(executor, listener);
            }

            private Builder enable(int mask) {
                this.mMask |= mask;
                return this;
            }

            Builder disable(int mask) {
                this.mMask &= ~mask;
                return this;
            }

            public VmPolicy build() {
                if (this.mListener == null && this.mMask != 0 && (this.mMask & 0x74000000) == 0) {
                    this.penaltyLog();
                }
                return new VmPolicy(this.mMask, this.mClassInstanceLimit != null ? this.mClassInstanceLimit : EMPTY_CLASS_LIMIT_MAP, this.mListener, this.mExecutor);
            }
        }
    }

    public static interface OnVmViolationListener {
        public void onVmViolation(Violation var1);
    }

    public static class ViolationInfo
    implements Parcelable {
        private final Violation mViolation;
        private final Deque<StackTraceElement[]> mBinderStack = new ArrayDeque<StackTraceElement[]>();
        private String mStackTrace;
        private final int mPenaltyMask;
        public int durationMillis = -1;
        public int numAnimationsRunning = 0;
        public String[] tags;
        public int violationNumThisLoop;
        public long violationUptimeMillis;
        public String broadcastIntentAction;
        public long numInstances = -1L;
        public static final Parcelable.Creator<ViolationInfo> CREATOR = new Parcelable.Creator<ViolationInfo>(){

            @Override
            public ViolationInfo createFromParcel(Parcel in) {
                return new ViolationInfo(in);
            }

            public ViolationInfo[] newArray(int size) {
                return new ViolationInfo[size];
            }
        };

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        ViolationInfo(Violation tr, int penaltyMask) {
            this.mViolation = tr;
            this.mPenaltyMask = penaltyMask;
            this.violationUptimeMillis = SystemClock.uptimeMillis();
            this.numAnimationsRunning = ValueAnimator.getCurrentAnimationsCount();
            Intent broadcastIntent = ActivityThread.getIntentBeingBroadcast();
            if (broadcastIntent != null) {
                this.broadcastIntentAction = broadcastIntent.getAction();
            }
            ThreadSpanState state = sThisThreadSpanState.get();
            if (tr instanceof InstanceCountViolation) {
                this.numInstances = ((InstanceCountViolation)tr).getNumberOfInstances();
            }
            ThreadSpanState threadSpanState = state;
            synchronized (threadSpanState) {
                int spanActiveCount = state.mActiveSize;
                if (spanActiveCount > 20) {
                    spanActiveCount = 20;
                }
                if (spanActiveCount != 0) {
                    this.tags = new String[spanActiveCount];
                    Span iter = state.mActiveHead;
                    for (int index = 0; iter != null && index < spanActiveCount; ++index) {
                        this.tags[index] = iter.mName;
                        iter = iter.mNext;
                    }
                }
            }
        }

        public String getStackTrace() {
            if (this.mStackTrace == null) {
                StringWriter sw = new StringWriter();
                FastPrintWriter pw = new FastPrintWriter(sw, false, 256);
                this.mViolation.printStackTrace(pw);
                for (StackTraceElement[] traces : this.mBinderStack) {
                    pw.append("# via Binder call with stack:\n");
                    for (StackTraceElement traceElement : traces) {
                        pw.append("\tat ");
                        pw.append(traceElement.toString());
                        pw.append('\n');
                    }
                }
                ((PrintWriter)pw).flush();
                ((PrintWriter)pw).close();
                this.mStackTrace = sw.toString();
            }
            return this.mStackTrace;
        }

        public Class<? extends Violation> getViolationClass() {
            return this.mViolation.getClass();
        }

        public String getViolationDetails() {
            return this.mViolation.getMessage();
        }

        boolean penaltyEnabled(int p) {
            return (this.mPenaltyMask & p) != 0;
        }

        void addLocalStack(Throwable t) {
            this.mBinderStack.addFirst(t.getStackTrace());
        }

        public int hashCode() {
            int result = 17;
            if (this.mViolation != null) {
                result = 37 * result + this.mViolation.hashCode();
            }
            if (this.numAnimationsRunning != 0) {
                result *= 37;
            }
            if (this.broadcastIntentAction != null) {
                result = 37 * result + this.broadcastIntentAction.hashCode();
            }
            if (this.tags != null) {
                for (String tag : this.tags) {
                    result = 37 * result + tag.hashCode();
                }
            }
            return result;
        }

        @UnsupportedAppUsage
        public ViolationInfo(Parcel in) {
            this(in, false);
        }

        public ViolationInfo(Parcel in, boolean unsetGatheringBit) {
            this.mViolation = in.readSerializable(Violation.class.getClassLoader(), Violation.class);
            int binderStackSize = in.readInt();
            for (int i = 0; i < binderStackSize; ++i) {
                StackTraceElement[] traceElements = new StackTraceElement[in.readInt()];
                for (int j = 0; j < traceElements.length; ++j) {
                    StackTraceElement element;
                    traceElements[j] = element = new StackTraceElement(in.readString(), in.readString(), in.readString(), in.readInt());
                }
                this.mBinderStack.add(traceElements);
            }
            int rawPenaltyMask = in.readInt();
            this.mPenaltyMask = unsetGatheringBit ? rawPenaltyMask & Integer.MAX_VALUE : rawPenaltyMask;
            this.durationMillis = in.readInt();
            this.violationNumThisLoop = in.readInt();
            this.numAnimationsRunning = in.readInt();
            this.violationUptimeMillis = in.readLong();
            this.numInstances = in.readLong();
            this.broadcastIntentAction = in.readString();
            this.tags = in.readStringArray();
        }

        @Override
        public void writeToParcel(Parcel dest, int flags) {
            dest.writeSerializable(this.mViolation);
            dest.writeInt(this.mBinderStack.size());
            for (StackTraceElement[] traceElements : this.mBinderStack) {
                dest.writeInt(traceElements.length);
                for (StackTraceElement element : traceElements) {
                    dest.writeString(element.getClassName());
                    dest.writeString(element.getMethodName());
                    dest.writeString(element.getFileName());
                    dest.writeInt(element.getLineNumber());
                }
            }
            int start = dest.dataPosition();
            dest.writeInt(this.mPenaltyMask);
            dest.writeInt(this.durationMillis);
            dest.writeInt(this.violationNumThisLoop);
            dest.writeInt(this.numAnimationsRunning);
            dest.writeLong(this.violationUptimeMillis);
            dest.writeLong(this.numInstances);
            dest.writeString(this.broadcastIntentAction);
            dest.writeStringArray(this.tags);
            int total = dest.dataPosition() - start;
        }

        public void dump(Printer pw, String prefix) {
            pw.println(prefix + "stackTrace: " + this.getStackTrace());
            pw.println(prefix + "penalty: " + this.mPenaltyMask);
            if (this.durationMillis != -1) {
                pw.println(prefix + "durationMillis: " + this.durationMillis);
            }
            if (this.numInstances != -1L) {
                pw.println(prefix + "numInstances: " + this.numInstances);
            }
            if (this.violationNumThisLoop != 0) {
                pw.println(prefix + "violationNumThisLoop: " + this.violationNumThisLoop);
            }
            if (this.numAnimationsRunning != 0) {
                pw.println(prefix + "numAnimationsRunning: " + this.numAnimationsRunning);
            }
            pw.println(prefix + "violationUptimeMillis: " + this.violationUptimeMillis);
            if (this.broadcastIntentAction != null) {
                pw.println(prefix + "broadcastIntentAction: " + this.broadcastIntentAction);
            }
            if (this.tags != null) {
                int index = 0;
                for (String tag : this.tags) {
                    pw.println(prefix + "tag[" + index++ + "]: " + tag);
                }
            }
        }

        @Override
        public int describeContents() {
            return 0;
        }
    }

    private static class UnsafeIntentStrictModeCallback
    extends IUnsafeIntentStrictModeCallback.Stub {
        private UnsafeIntentStrictModeCallback() {
        }

        @Override
        public void onImplicitIntentMatchedInternalComponent(Intent intent) {
            if (StrictMode.vmUnsafeIntentLaunchEnabled()) {
                StrictMode.onUnsafeIntentLaunch(intent, "Launch of unsafe implicit intent: " + intent);
            }
        }
    }

    public static class Span {
        private String mName;
        private long mCreateMillis;
        private Span mNext;
        private Span mPrev;
        private final ThreadSpanState mContainerState;

        Span(ThreadSpanState threadState) {
            this.mContainerState = threadState;
        }

        protected Span() {
            this.mContainerState = null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @UnsupportedAppUsage
        public void finish() {
            ThreadSpanState state;
            ThreadSpanState threadSpanState = state = this.mContainerState;
            synchronized (threadSpanState) {
                if (this.mName == null) {
                    return;
                }
                if (this.mPrev != null) {
                    this.mPrev.mNext = this.mNext;
                }
                if (this.mNext != null) {
                    this.mNext.mPrev = this.mPrev;
                }
                if (state.mActiveHead == this) {
                    state.mActiveHead = this.mNext;
                }
                --state.mActiveSize;
                if (LOG_V) {
                    Log.d(StrictMode.TAG, "Span finished=" + this.mName + "; size=" + state.mActiveSize);
                }
                this.mCreateMillis = -1L;
                this.mName = null;
                this.mPrev = null;
                this.mNext = null;
                if (state.mFreeListSize < 5) {
                    this.mNext = state.mFreeListHead;
                    state.mFreeListHead = this;
                    ++state.mFreeListSize;
                }
            }
        }
    }

    private static class ThreadSpanState {
        public Span mActiveHead;
        public int mActiveSize;
        public Span mFreeListHead;
        public int mFreeListSize;

        private ThreadSpanState() {
        }
    }

    private static class InstanceTracker {
        private static final HashMap<Class<?>, Integer> sInstanceCounts = new HashMap();
        private final Class<?> mKlass;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public InstanceTracker(Object instance) {
            this.mKlass = instance.getClass();
            HashMap<Class<?>, Integer> hashMap = sInstanceCounts;
            synchronized (hashMap) {
                Integer value = sInstanceCounts.get(this.mKlass);
                int newValue = value != null ? value + 1 : 1;
                sInstanceCounts.put(this.mKlass, newValue);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void finalize() throws Throwable {
            try {
                HashMap<Class<?>, Integer> hashMap = sInstanceCounts;
                synchronized (hashMap) {
                    Integer value = sInstanceCounts.get(this.mKlass);
                    if (value != null) {
                        int newValue = value - 1;
                        if (newValue > 0) {
                            sInstanceCounts.put(this.mKlass, newValue);
                        } else {
                            sInstanceCounts.remove(this.mKlass);
                        }
                    }
                }
            }
            finally {
                super.finalize();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static int getInstanceCount(Class<?> klass) {
            HashMap<Class<?>, Integer> hashMap = sInstanceCounts;
            synchronized (hashMap) {
                Integer value = sInstanceCounts.get(klass);
                return value != null ? value : 0;
            }
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface VmPolicyMask {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface ThreadPolicyMask {
    }
}

