/*
 * Decompiled with CFR 0.152.
 */
package android.os;

import android.app.IAlarmManager;
import android.app.time.UnixEpochTime;
import android.app.timedetector.ITimeDetectorService;
import android.compat.annotation.UnsupportedAppUsage;
import android.location.ILocationManager;
import android.location.LocationTime;
import android.os.DeadSystemException;
import android.os.ParcelableException;
import android.os.RemoteException;
import android.os.ServiceManager;
import android.os.SimpleClock;
import android.os.SystemClock_Delegate;
import android.util.Slog;
import com.android.tools.layoutlib.annotations.LayoutlibDelegate;
import dalvik.annotation.optimization.CriticalNative;
import java.time.Clock;
import java.time.DateTimeException;
import java.time.ZoneOffset;

public class SystemClock {
    private static final String TAG = "SystemClock";
    private static volatile IAlarmManager sIAlarmManager;

    @UnsupportedAppUsage
    private SystemClock() {
    }

    public static void sleep(long ms) {
        long start = SystemClock.uptimeMillis();
        long duration = ms;
        boolean interrupted = false;
        do {
            try {
                Thread.sleep(duration);
            }
            catch (InterruptedException e) {
                interrupted = true;
            }
        } while ((duration = start + ms - SystemClock.uptimeMillis()) > 0L);
        if (interrupted) {
            Thread.currentThread().interrupt();
        }
    }

    public static boolean setCurrentTimeMillis(long millis) {
        IAlarmManager mgr = SystemClock.getIAlarmManager();
        if (mgr == null) {
            Slog.e(TAG, "Unable to set RTC: mgr == null");
            return false;
        }
        try {
            return mgr.setTime(millis);
        }
        catch (RemoteException e) {
            Slog.e(TAG, "Unable to set RTC", e);
        }
        catch (SecurityException e) {
            Slog.e(TAG, "Unable to set RTC", e);
        }
        return false;
    }

    private static IAlarmManager getIAlarmManager() {
        if (sIAlarmManager == null) {
            sIAlarmManager = IAlarmManager.Stub.asInterface(ServiceManager.getService("alarm"));
        }
        return sIAlarmManager;
    }

    @LayoutlibDelegate
    @CriticalNative
    public static long uptimeMillis() {
        return SystemClock_Delegate.uptimeMillis();
    }

    @LayoutlibDelegate
    @CriticalNative
    public static long uptimeNanos() {
        return SystemClock_Delegate.uptimeNanos();
    }

    public static Clock uptimeClock() {
        return new SimpleClock(ZoneOffset.UTC){

            @Override
            public long millis() {
                return SystemClock.uptimeMillis();
            }
        };
    }

    @LayoutlibDelegate
    @CriticalNative
    public static long elapsedRealtime() {
        return SystemClock_Delegate.elapsedRealtime();
    }

    public static Clock elapsedRealtimeClock() {
        return new SimpleClock(ZoneOffset.UTC){

            @Override
            public long millis() {
                return SystemClock.elapsedRealtime();
            }
        };
    }

    @LayoutlibDelegate
    @CriticalNative
    public static long elapsedRealtimeNanos() {
        return SystemClock_Delegate.elapsedRealtimeNanos();
    }

    @LayoutlibDelegate
    @CriticalNative
    public static long currentThreadTimeMillis() {
        return SystemClock_Delegate.currentThreadTimeMillis();
    }

    @LayoutlibDelegate
    @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
    @CriticalNative
    public static long currentThreadTimeMicro() {
        return SystemClock_Delegate.currentThreadTimeMicro();
    }

    @LayoutlibDelegate
    @UnsupportedAppUsage
    @CriticalNative
    public static long currentTimeMicro() {
        return SystemClock_Delegate.currentTimeMicro();
    }

    public static long currentNetworkTimeMillis() {
        ITimeDetectorService timeDetectorService = ITimeDetectorService.Stub.asInterface(ServiceManager.getService("time_detector"));
        if (timeDetectorService != null) {
            UnixEpochTime time;
            try {
                time = timeDetectorService.latestNetworkTime();
            }
            catch (ParcelableException e) {
                e.maybeRethrow(DateTimeException.class);
                throw new RuntimeException(e);
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
            if (time == null) {
                throw new DateTimeException("Network based time is not available.");
            }
            long currentMillis = SystemClock.elapsedRealtime();
            long deltaMs = currentMillis - time.getElapsedRealtimeMillis();
            return time.getUnixEpochTimeMillis() + deltaMs;
        }
        throw new RuntimeException(new DeadSystemException());
    }

    public static Clock currentNetworkTimeClock() {
        return new SimpleClock(ZoneOffset.UTC){

            @Override
            public long millis() {
                return SystemClock.currentNetworkTimeMillis();
            }
        };
    }

    public static Clock currentGnssTimeClock() {
        return new SimpleClock(ZoneOffset.UTC){
            private final ILocationManager mMgr = ILocationManager.Stub.asInterface(ServiceManager.getService("location"));

            @Override
            public long millis() {
                LocationTime time;
                try {
                    time = this.mMgr.getGnssTimeMillis();
                }
                catch (RemoteException e) {
                    throw e.rethrowFromSystemServer();
                }
                if (time == null) {
                    throw new DateTimeException("Gnss based time is not available.");
                }
                long currentNanos = SystemClock.elapsedRealtimeNanos();
                long deltaMs = (currentNanos - time.getElapsedRealtimeNanos()) / 1000000L;
                return time.getUnixEpochTimeMillis() + deltaMs;
            }
        };
    }
}

