/*
 * Decompiled with CFR 0.152.
 */
package android.os;

import android.content.Context;
import android.os.Binder;
import android.os.CombinedVibration;
import android.os.IVibratorManagerService;
import android.os.IVibratorStateListener;
import android.os.NullVibrator;
import android.os.RemoteException;
import android.os.ServiceManager;
import android.os.VibrationAttributes;
import android.os.VibrationEffect;
import android.os.Vibrator;
import android.os.VibratorInfo;
import android.os.VibratorManager;
import android.util.ArrayMap;
import android.util.Log;
import android.util.SparseArray;
import com.android.internal.annotations.GuardedBy;
import java.util.Objects;
import java.util.concurrent.Executor;

public class SystemVibratorManager
extends VibratorManager {
    private static final String TAG = "VibratorManager";
    private final IVibratorManagerService mService;
    private final Context mContext;
    private final Binder mToken = new Binder();
    private final Object mLock = new Object();
    @GuardedBy(value={"mLock"})
    private int[] mVibratorIds;
    @GuardedBy(value={"mLock"})
    private final SparseArray<Vibrator> mVibrators = new SparseArray();
    @GuardedBy(value={"mLock"})
    private final ArrayMap<Vibrator.OnVibratorStateChangedListener, OnVibratorStateChangedListenerDelegate> mListeners = new ArrayMap();

    public SystemVibratorManager(Context context) {
        super(context);
        this.mContext = context;
        this.mService = IVibratorManagerService.Stub.asInterface(ServiceManager.getService("vibrator_manager"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int[] getVibratorIds() {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mVibratorIds != null) {
                return this.mVibratorIds;
            }
            try {
                if (this.mService != null) {
                    this.mVibratorIds = this.mService.getVibratorIds();
                    return this.mVibratorIds;
                }
                Log.w(TAG, "Failed to retrieve vibrator ids; no vibrator manager service.");
            }
            catch (RemoteException e) {
                e.rethrowFromSystemServer();
            }
            return new int[0];
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Vibrator getVibrator(int vibratorId) {
        Object object = this.mLock;
        synchronized (object) {
            Vibrator vibrator = this.mVibrators.get(vibratorId);
            if (vibrator != null) {
                return vibrator;
            }
            VibratorInfo info = null;
            try {
                if (this.mService == null) {
                    Log.w(TAG, "Failed to retrieve vibrator; no vibrator manager service.");
                } else {
                    info = this.mService.getVibratorInfo(vibratorId);
                }
            }
            catch (RemoteException e) {
                e.rethrowFromSystemServer();
            }
            if (info != null) {
                vibrator = new SingleVibrator(info);
                this.mVibrators.put(vibratorId, vibrator);
            } else {
                vibrator = NullVibrator.getInstance();
            }
            return vibrator;
        }
    }

    @Override
    public Vibrator getDefaultVibrator() {
        return this.mContext.getSystemService(Vibrator.class);
    }

    @Override
    public boolean setAlwaysOnEffect(int uid, String opPkg, int alwaysOnId, CombinedVibration effect, VibrationAttributes attributes) {
        if (this.mService == null) {
            Log.w(TAG, "Failed to set always-on effect; no vibrator manager service.");
            return false;
        }
        try {
            return this.mService.setAlwaysOnEffect(uid, opPkg, alwaysOnId, effect, attributes);
        }
        catch (RemoteException e) {
            Log.w(TAG, "Failed to set always-on effect.", e);
            return false;
        }
    }

    @Override
    public void vibrate(int uid, String opPkg, CombinedVibration effect, String reason, VibrationAttributes attributes) {
        if (this.mService == null) {
            Log.w(TAG, "Failed to vibrate; no vibrator manager service.");
            return;
        }
        try {
            this.mService.vibrate(uid, this.mContext.getAssociatedDisplayId(), opPkg, effect, attributes, reason, this.mToken);
        }
        catch (RemoteException e) {
            Log.w(TAG, "Failed to vibrate.", e);
        }
    }

    @Override
    public void cancel() {
        this.cancelVibration(-1);
    }

    @Override
    public void cancel(int usageFilter) {
        this.cancelVibration(usageFilter);
    }

    private void cancelVibration(int usageFilter) {
        if (this.mService == null) {
            Log.w(TAG, "Failed to cancel vibration; no vibrator manager service.");
            return;
        }
        try {
            this.mService.cancelVibrate(usageFilter, this.mToken);
        }
        catch (RemoteException e) {
            Log.w(TAG, "Failed to cancel vibration.", e);
        }
    }

    private class SingleVibrator
    extends Vibrator {
        private final VibratorInfo mVibratorInfo;

        SingleVibrator(VibratorInfo vibratorInfo) {
            this.mVibratorInfo = vibratorInfo;
        }

        @Override
        protected VibratorInfo getInfo() {
            return this.mVibratorInfo;
        }

        @Override
        public boolean hasVibrator() {
            return true;
        }

        @Override
        public boolean hasAmplitudeControl() {
            return this.mVibratorInfo.hasAmplitudeControl();
        }

        @Override
        public boolean setAlwaysOnEffect(int uid, String opPkg, int alwaysOnId, VibrationEffect effect, VibrationAttributes attrs) {
            CombinedVibration combined = CombinedVibration.startParallel().addVibrator(this.mVibratorInfo.getId(), effect).combine();
            return SystemVibratorManager.this.setAlwaysOnEffect(uid, opPkg, alwaysOnId, combined, attrs);
        }

        @Override
        public void vibrate(int uid, String opPkg, VibrationEffect vibe, String reason, VibrationAttributes attributes) {
            CombinedVibration combined = CombinedVibration.startParallel().addVibrator(this.mVibratorInfo.getId(), vibe).combine();
            SystemVibratorManager.this.vibrate(uid, opPkg, combined, reason, attributes);
        }

        @Override
        public void cancel() {
            SystemVibratorManager.this.cancel();
        }

        @Override
        public void cancel(int usageFilter) {
            SystemVibratorManager.this.cancel(usageFilter);
        }

        @Override
        public boolean isVibrating() {
            if (SystemVibratorManager.this.mService == null) {
                Log.w(SystemVibratorManager.TAG, "Failed to check status of vibrator " + this.mVibratorInfo.getId() + "; no vibrator service.");
                return false;
            }
            try {
                return SystemVibratorManager.this.mService.isVibrating(this.mVibratorInfo.getId());
            }
            catch (RemoteException e) {
                e.rethrowFromSystemServer();
                return false;
            }
        }

        @Override
        public void addVibratorStateListener(Vibrator.OnVibratorStateChangedListener listener) {
            Objects.requireNonNull(listener);
            if (SystemVibratorManager.this.mContext == null) {
                Log.w(SystemVibratorManager.TAG, "Failed to add vibrate state listener; no vibrator context.");
                return;
            }
            this.addVibratorStateListener(SystemVibratorManager.this.mContext.getMainExecutor(), listener);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void addVibratorStateListener(Executor executor, Vibrator.OnVibratorStateChangedListener listener) {
            Objects.requireNonNull(listener);
            Objects.requireNonNull(executor);
            if (SystemVibratorManager.this.mService == null) {
                Log.w(SystemVibratorManager.TAG, "Failed to add vibrate state listener to vibrator " + this.mVibratorInfo.getId() + "; no vibrator service.");
                return;
            }
            Object object = SystemVibratorManager.this.mLock;
            synchronized (object) {
                if (SystemVibratorManager.this.mListeners.containsKey(listener)) {
                    Log.w(SystemVibratorManager.TAG, "Listener already registered.");
                    return;
                }
                try {
                    OnVibratorStateChangedListenerDelegate delegate = new OnVibratorStateChangedListenerDelegate(listener, executor);
                    if (!SystemVibratorManager.this.mService.registerVibratorStateListener(this.mVibratorInfo.getId(), delegate)) {
                        Log.w(SystemVibratorManager.TAG, "Failed to add vibrate state listener to vibrator " + this.mVibratorInfo.getId());
                        return;
                    }
                    SystemVibratorManager.this.mListeners.put(listener, delegate);
                }
                catch (RemoteException e) {
                    e.rethrowFromSystemServer();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void removeVibratorStateListener(Vibrator.OnVibratorStateChangedListener listener) {
            Objects.requireNonNull(listener);
            if (SystemVibratorManager.this.mService == null) {
                Log.w(SystemVibratorManager.TAG, "Failed to remove vibrate state listener from vibrator " + this.mVibratorInfo.getId() + "; no vibrator service.");
                return;
            }
            Object object = SystemVibratorManager.this.mLock;
            synchronized (object) {
                if (SystemVibratorManager.this.mListeners.containsKey(listener)) {
                    OnVibratorStateChangedListenerDelegate delegate = SystemVibratorManager.this.mListeners.get(listener);
                    try {
                        if (!SystemVibratorManager.this.mService.unregisterVibratorStateListener(this.mVibratorInfo.getId(), delegate)) {
                            Log.w(SystemVibratorManager.TAG, "Failed to remove vibrate state listener from vibrator " + this.mVibratorInfo.getId());
                            return;
                        }
                        SystemVibratorManager.this.mListeners.remove(listener);
                    }
                    catch (RemoteException e) {
                        e.rethrowFromSystemServer();
                    }
                }
            }
        }
    }

    private static class OnVibratorStateChangedListenerDelegate
    extends IVibratorStateListener.Stub {
        private final Executor mExecutor;
        private final Vibrator.OnVibratorStateChangedListener mListener;

        OnVibratorStateChangedListenerDelegate(Vibrator.OnVibratorStateChangedListener listener, Executor executor) {
            this.mExecutor = executor;
            this.mListener = listener;
        }

        @Override
        public void onVibrating(boolean isVibrating) {
            this.mExecutor.execute(() -> this.mListener.onVibratorStateChanged(isVibrating));
        }
    }
}

