/*
 * Decompiled with CFR 0.152.
 */
package android.os;

public class ThreadLocalWorkSource {
    public static final int UID_NONE = -1;
    private static final ThreadLocal<int[]> sWorkSourceUid = ThreadLocal.withInitial(() -> new int[]{-1});

    public static int getUid() {
        return sWorkSourceUid.get()[0];
    }

    public static long setUid(int uid) {
        long token = ThreadLocalWorkSource.getToken();
        ThreadLocalWorkSource.sWorkSourceUid.get()[0] = uid;
        return token;
    }

    public static void restore(long token) {
        ThreadLocalWorkSource.sWorkSourceUid.get()[0] = ThreadLocalWorkSource.parseUidFromToken(token);
    }

    public static long clear() {
        return ThreadLocalWorkSource.setUid(-1);
    }

    private static int parseUidFromToken(long token) {
        return (int)token;
    }

    private static long getToken() {
        return sWorkSourceUid.get()[0];
    }

    private ThreadLocalWorkSource() {
    }
}

