/*
 * Decompiled with CFR 0.152.
 */
package android.os;

import android.media.AudioAttributes;
import android.os.Parcel;
import android.os.Parcelable;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.Objects;

public class VibrationAttributes
implements Parcelable {
    private static final String TAG = "VibrationAttributes";
    public static final int USAGE_FILTER_MATCH_ALL = -1;
    public static final int USAGE_CLASS_UNKNOWN = 0;
    public static final int USAGE_CLASS_ALARM = 1;
    public static final int USAGE_CLASS_FEEDBACK = 2;
    public static final int USAGE_CLASS_MEDIA = 3;
    public static final int USAGE_CLASS_MASK = 15;
    public static final int USAGE_UNKNOWN = 0;
    public static final int USAGE_ALARM = 17;
    public static final int USAGE_RINGTONE = 33;
    public static final int USAGE_NOTIFICATION = 49;
    public static final int USAGE_COMMUNICATION_REQUEST = 65;
    public static final int USAGE_TOUCH = 18;
    public static final int USAGE_PHYSICAL_EMULATION = 34;
    public static final int USAGE_HARDWARE_FEEDBACK = 50;
    public static final int USAGE_ACCESSIBILITY = 66;
    public static final int USAGE_MEDIA = 19;
    public static final int FLAG_BYPASS_INTERRUPTION_POLICY = 1;
    public static final int FLAG_BYPASS_USER_VIBRATION_INTENSITY_OFF = 2;
    public static final int FLAG_INVALIDATE_SETTINGS_CACHE = 4;
    public static final int FLAG_PIPELINED_EFFECT = 8;
    public static final int FLAG_ALL_SUPPORTED = 15;
    private final int mUsage;
    private final int mFlags;
    private final int mOriginalAudioUsage;
    public static final Parcelable.Creator<VibrationAttributes> CREATOR = new Parcelable.Creator<VibrationAttributes>(){

        @Override
        public VibrationAttributes createFromParcel(Parcel p) {
            return new VibrationAttributes(p);
        }

        public VibrationAttributes[] newArray(int size) {
            return new VibrationAttributes[size];
        }
    };

    public static VibrationAttributes createForUsage(int usage) {
        return new Builder().setUsage(usage).build();
    }

    private VibrationAttributes(int usage, int audioUsage, int flags) {
        this.mUsage = usage;
        this.mOriginalAudioUsage = audioUsage;
        this.mFlags = flags & 0xF;
    }

    public int getUsageClass() {
        return this.mUsage & 0xF;
    }

    public int getUsage() {
        return this.mUsage;
    }

    public int getFlags() {
        return this.mFlags;
    }

    public boolean isFlagSet(int flag) {
        return (this.mFlags & flag) > 0;
    }

    public int getAudioUsage() {
        if (this.mOriginalAudioUsage != 0) {
            return this.mOriginalAudioUsage;
        }
        switch (this.mUsage) {
            case 49: {
                return 5;
            }
            case 65: {
                return 2;
            }
            case 33: {
                return 6;
            }
            case 18: {
                return 13;
            }
            case 17: {
                return 4;
            }
            case 66: {
                return 11;
            }
            case 19: {
                return 1;
            }
        }
        return 0;
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        dest.writeInt(this.mUsage);
        dest.writeInt(this.mOriginalAudioUsage);
        dest.writeInt(this.mFlags);
    }

    private VibrationAttributes(Parcel src) {
        this.mUsage = src.readInt();
        this.mOriginalAudioUsage = src.readInt();
        this.mFlags = src.readInt();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        VibrationAttributes rhs = (VibrationAttributes)o;
        return this.mUsage == rhs.mUsage && this.mOriginalAudioUsage == rhs.mOriginalAudioUsage && this.mFlags == rhs.mFlags;
    }

    public int hashCode() {
        return Objects.hash(this.mUsage, this.mOriginalAudioUsage, this.mFlags);
    }

    public String toString() {
        return "VibrationAttributes: Usage=" + this.usageToString() + " Audio Usage= " + AudioAttributes.usageToString(this.mOriginalAudioUsage) + " Flags=" + this.mFlags;
    }

    public String usageToString() {
        return VibrationAttributes.usageToString(this.mUsage);
    }

    public static String usageToString(int usage) {
        switch (usage) {
            case 0: {
                return "UNKNOWN";
            }
            case 17: {
                return "ALARM";
            }
            case 66: {
                return "ACCESSIBILITY";
            }
            case 33: {
                return "RINGTONE";
            }
            case 49: {
                return "NOTIFICATION";
            }
            case 65: {
                return "COMMUNICATION_REQUEST";
            }
            case 19: {
                return "MEDIA";
            }
            case 18: {
                return "TOUCH";
            }
            case 34: {
                return "PHYSICAL_EMULATION";
            }
            case 50: {
                return "HARDWARE_FEEDBACK";
            }
        }
        return "unknown usage " + usage;
    }

    public static class Builder {
        private int mUsage = 0;
        private int mOriginalAudioUsage = 0;
        private int mFlags = 0;

        public Builder() {
        }

        public Builder(VibrationAttributes vib) {
            if (vib != null) {
                this.mUsage = vib.mUsage;
                this.mOriginalAudioUsage = vib.mOriginalAudioUsage;
                this.mFlags = vib.mFlags;
            }
        }

        public Builder(AudioAttributes audio) {
            this.setUsage(audio);
            this.setFlags(audio);
        }

        private void setUsage(AudioAttributes audio) {
            this.mOriginalAudioUsage = audio.getUsage();
            switch (audio.getUsage()) {
                case 5: 
                case 7: 
                case 8: 
                case 9: 
                case 10: {
                    this.mUsage = 49;
                    break;
                }
                case 2: 
                case 3: 
                case 12: 
                case 16: {
                    this.mUsage = 65;
                    break;
                }
                case 6: {
                    this.mUsage = 33;
                    break;
                }
                case 11: {
                    this.mUsage = 66;
                    break;
                }
                case 13: {
                    this.mUsage = 18;
                    break;
                }
                case 4: {
                    this.mUsage = 17;
                    break;
                }
                case 1: 
                case 14: {
                    this.mUsage = 19;
                    break;
                }
                default: {
                    this.mUsage = 0;
                }
            }
        }

        private void setFlags(AudioAttributes audio) {
            if ((audio.getAllFlags() & 0x40) != 0) {
                this.mFlags |= 1;
            }
            if ((audio.getAllFlags() & 0x80) != 0) {
                this.mFlags |= 2;
            }
        }

        public VibrationAttributes build() {
            VibrationAttributes ans = new VibrationAttributes(this.mUsage, this.mOriginalAudioUsage, this.mFlags);
            return ans;
        }

        public Builder setUsage(int usage) {
            this.mOriginalAudioUsage = 0;
            this.mUsage = usage;
            return this;
        }

        public Builder setFlags(int flags, int mask) {
            this.mFlags = this.mFlags & ~(mask &= 0xF) | flags & mask;
            return this;
        }

        public Builder setFlags(int flags) {
            return this.setFlags(flags, 15);
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface Flag {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface Usage {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface UsageClass {
    }
}

