/*
 * Decompiled with CFR 0.152.
 */
package android.os;

import android.compat.annotation.UnsupportedAppUsage;
import android.content.ContentResolver;
import android.content.Context;
import android.net.Uri;
import android.os.Parcel;
import android.os.Parcelable;
import android.os.Vibrator;
import android.os.vibrator.PrebakedSegment;
import android.os.vibrator.PrimitiveSegment;
import android.os.vibrator.RampSegment;
import android.os.vibrator.StepSegment;
import android.os.vibrator.VibrationEffectSegment;
import android.util.MathUtils;
import com.android.internal.util.Preconditions;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;

public abstract class VibrationEffect
implements Parcelable {
    private static final float SCALE_GAMMA = 0.65f;
    private static final long MAX_HAPTIC_FEEDBACK_DURATION = 1000L;
    private static final long MAX_HAPTIC_FEEDBACK_COMPOSITION_SIZE = 3L;
    public static final int DEFAULT_AMPLITUDE = -1;
    public static final int MAX_AMPLITUDE = 255;
    public static final int EFFECT_CLICK = 0;
    public static final int EFFECT_DOUBLE_CLICK = 1;
    public static final int EFFECT_TICK = 2;
    @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
    public static final int EFFECT_THUD = 3;
    @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
    public static final int EFFECT_POP = 4;
    public static final int EFFECT_HEAVY_CLICK = 5;
    public static final int EFFECT_TEXTURE_TICK = 21;
    public static final int EFFECT_STRENGTH_LIGHT = 0;
    public static final int EFFECT_STRENGTH_MEDIUM = 1;
    public static final int EFFECT_STRENGTH_STRONG = 2;
    @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
    public static final int[] RINGTONES = new int[]{6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20};
    public static final Parcelable.Creator<VibrationEffect> CREATOR = new Parcelable.Creator<VibrationEffect>(){

        @Override
        public VibrationEffect createFromParcel(Parcel in) {
            return new Composed(in);
        }

        public VibrationEffect[] newArray(int size) {
            return new VibrationEffect[size];
        }
    };

    public static VibrationEffect createOneShot(long milliseconds, int amplitude) {
        if (amplitude == 0) {
            throw new IllegalArgumentException("amplitude must either be DEFAULT_AMPLITUDE, or between 1 and 255 inclusive (amplitude=" + amplitude + ")");
        }
        return VibrationEffect.createWaveform(new long[]{milliseconds}, new int[]{amplitude}, -1);
    }

    public static VibrationEffect createWaveform(long[] timings, int repeat) {
        int[] amplitudes = new int[timings.length];
        for (int i = 0; i < timings.length / 2; ++i) {
            amplitudes[i * 2 + 1] = -1;
        }
        return VibrationEffect.createWaveform(timings, amplitudes, repeat);
    }

    public abstract long[] computeCreateWaveformOffOnTimingsOrNull();

    public static VibrationEffect createWaveform(long[] timings, int[] amplitudes, int repeat) {
        if (timings.length != amplitudes.length) {
            throw new IllegalArgumentException("timing and amplitude arrays must be of equal length (timings.length=" + timings.length + ", amplitudes.length=" + amplitudes.length + ")");
        }
        ArrayList<StepSegment> segments = new ArrayList<StepSegment>();
        for (int i = 0; i < timings.length; ++i) {
            float parsedAmplitude = amplitudes[i] == -1 ? -1.0f : (float)amplitudes[i] / 255.0f;
            segments.add(new StepSegment(parsedAmplitude, 0.0f, (int)timings[i]));
        }
        Composed effect = new Composed(segments, repeat);
        ((VibrationEffect)effect).validate();
        return effect;
    }

    public static VibrationEffect createPredefined(int effectId) {
        return VibrationEffect.get(effectId, true);
    }

    public static VibrationEffect get(int effectId) {
        return VibrationEffect.get(effectId, true);
    }

    public static VibrationEffect get(int effectId, boolean fallback) {
        Composed effect = new Composed(new PrebakedSegment(effectId, fallback, 1));
        ((VibrationEffect)effect).validate();
        return effect;
    }

    public static VibrationEffect get(Uri uri, Context context) {
        String[] uris = context.getResources().getStringArray(17236126);
        if (uris.length == 0) {
            return null;
        }
        ContentResolver cr = context.getContentResolver();
        Uri uncanonicalUri = cr.uncanonicalize(uri);
        if (uncanonicalUri == null) {
            uncanonicalUri = uri;
        }
        for (int i = 0; i < uris.length && i < RINGTONES.length; ++i) {
            Uri mappedUri;
            if (uris[i] == null || (mappedUri = cr.uncanonicalize(Uri.parse(uris[i]))) == null || !mappedUri.equals(uncanonicalUri)) continue;
            return VibrationEffect.get(RINGTONES[i]);
        }
        return null;
    }

    public static Composition startComposition() {
        return new Composition();
    }

    public static WaveformBuilder startWaveform() {
        return new WaveformBuilder();
    }

    public static WaveformBuilder startWaveform(VibrationParameter initialParameter) {
        WaveformBuilder builder = VibrationEffect.startWaveform();
        builder.addTransition(Duration.ZERO, initialParameter);
        return builder;
    }

    public static WaveformBuilder startWaveform(VibrationParameter initialParameter1, VibrationParameter initialParameter2) {
        WaveformBuilder builder = VibrationEffect.startWaveform();
        builder.addTransition(Duration.ZERO, initialParameter1, initialParameter2);
        return builder;
    }

    @Override
    public int describeContents() {
        return 0;
    }

    public abstract void validate();

    public abstract long getDuration();

    public abstract boolean areVibrationFeaturesSupported(Vibrator var1);

    public boolean isHapticFeedbackCandidate() {
        return false;
    }

    public abstract <T extends VibrationEffect> T resolve(int var1);

    public abstract <T extends VibrationEffect> T scale(float var1);

    public <T extends VibrationEffect> T applyEffectStrength(int effectStrength) {
        return (T)this;
    }

    public static float scale(float intensity, float scaleFactor) {
        float scale = MathUtils.pow(scaleFactor, 1.5384616f);
        if (scaleFactor <= 1.0f) {
            return intensity * scale;
        }
        float extraScale = MathUtils.pow(scaleFactor, 4.0f - scaleFactor);
        float x = intensity * scale * extraScale;
        float maxX = scale * extraScale;
        float expX = MathUtils.exp(x);
        float expMaxX = MathUtils.exp(maxX);
        float a = (expMaxX + 1.0f) / (expMaxX - 1.0f);
        float fx = (expX - 1.0f) / (expX + 1.0f);
        return MathUtils.constrain(a * fx, 0.0f, 1.0f);
    }

    public static String effectIdToString(int effectId) {
        switch (effectId) {
            case 0: {
                return "CLICK";
            }
            case 2: {
                return "TICK";
            }
            case 5: {
                return "HEAVY_CLICK";
            }
            case 1: {
                return "DOUBLE_CLICK";
            }
            case 4: {
                return "POP";
            }
            case 3: {
                return "THUD";
            }
            case 21: {
                return "TEXTURE_TICK";
            }
        }
        return Integer.toString(effectId);
    }

    public static String effectStrengthToString(int effectStrength) {
        switch (effectStrength) {
            case 0: {
                return "LIGHT";
            }
            case 1: {
                return "MEDIUM";
            }
            case 2: {
                return "STRONG";
            }
        }
        return Integer.toString(effectStrength);
    }

    public static class Composed
    extends VibrationEffect {
        private final ArrayList<VibrationEffectSegment> mSegments;
        private final int mRepeatIndex;
        public static final Parcelable.Creator<Composed> CREATOR = new Parcelable.Creator<Composed>(){

            @Override
            public Composed createFromParcel(Parcel in) {
                return new Composed(in);
            }

            public Composed[] newArray(int size) {
                return new Composed[size];
            }
        };

        Composed(Parcel in) {
            this(in.readArrayList(VibrationEffectSegment.class.getClassLoader(), VibrationEffectSegment.class), in.readInt());
        }

        Composed(VibrationEffectSegment segment) {
            this(Arrays.asList(segment), -1);
        }

        public Composed(List<? extends VibrationEffectSegment> segments, int repeatIndex) {
            this.mSegments = new ArrayList<VibrationEffectSegment>(segments);
            this.mRepeatIndex = repeatIndex;
        }

        public List<VibrationEffectSegment> getSegments() {
            return this.mSegments;
        }

        public int getRepeatIndex() {
            return this.mRepeatIndex;
        }

        @Override
        public long[] computeCreateWaveformOffOnTimingsOrNull() {
            if (this.getRepeatIndex() >= 0) {
                return null;
            }
            List<VibrationEffectSegment> segments = this.getSegments();
            long[] patternBuffer = new long[segments.size() + 1];
            int patternIndex = 0;
            for (int i = 0; i < segments.size(); ++i) {
                boolean isCurrentPatternIndexOff;
                StepSegment stepSegment = Composed.castToValidStepSegmentForOffOnTimingsOrNull(segments.get(i));
                if (stepSegment == null) {
                    return null;
                }
                boolean isSegmentOff = stepSegment.getAmplitude() == 0.0f;
                boolean bl = isCurrentPatternIndexOff = patternIndex % 2 == 0;
                if (isSegmentOff != isCurrentPatternIndexOff) {
                    // empty if block
                }
                int n = ++patternIndex;
                patternBuffer[n] = patternBuffer[n] + stepSegment.getDuration();
            }
            return Arrays.copyOf(patternBuffer, patternIndex + 1);
        }

        @Override
        public void validate() {
            int segmentCount = this.mSegments.size();
            boolean hasNonZeroDuration = false;
            for (int i = 0; i < segmentCount; ++i) {
                VibrationEffectSegment segment = this.mSegments.get(i);
                segment.validate();
                hasNonZeroDuration |= segment.getDuration() != 0L;
            }
            if (!hasNonZeroDuration) {
                throw new IllegalArgumentException("at least one timing must be non-zero (segments=" + this.mSegments + ")");
            }
            if (this.mRepeatIndex != -1) {
                Preconditions.checkArgumentInRange(this.mRepeatIndex, 0, segmentCount - 1, "repeat index must be within the bounds of the segments (segments.length=" + segmentCount + ", index=" + this.mRepeatIndex + ")");
            }
        }

        @Override
        public long getDuration() {
            if (this.mRepeatIndex >= 0) {
                return Long.MAX_VALUE;
            }
            int segmentCount = this.mSegments.size();
            long totalDuration = 0L;
            for (int i = 0; i < segmentCount; ++i) {
                long segmentDuration = this.mSegments.get(i).getDuration();
                if (segmentDuration < 0L) {
                    return segmentDuration;
                }
                totalDuration += segmentDuration;
            }
            return totalDuration;
        }

        @Override
        public boolean areVibrationFeaturesSupported(Vibrator vibrator) {
            for (VibrationEffectSegment segment : this.mSegments) {
                if (segment.areVibrationFeaturesSupported(vibrator)) continue;
                return false;
            }
            return true;
        }

        @Override
        public boolean isHapticFeedbackCandidate() {
            long totalDuration = this.getDuration();
            if (totalDuration > 1000L) {
                return false;
            }
            int segmentCount = this.mSegments.size();
            if ((long)segmentCount > 3L) {
                return false;
            }
            totalDuration = 0L;
            for (int i = 0; i < segmentCount; ++i) {
                if (!this.mSegments.get(i).isHapticFeedbackCandidate()) {
                    return false;
                }
                long segmentDuration = this.mSegments.get(i).getDuration();
                if (segmentDuration <= 0L) continue;
                totalDuration += segmentDuration;
            }
            return totalDuration <= 1000L;
        }

        public Composed resolve(int defaultAmplitude) {
            int segmentCount = this.mSegments.size();
            ArrayList resolvedSegments = new ArrayList(segmentCount);
            for (int i = 0; i < segmentCount; ++i) {
                resolvedSegments.add(this.mSegments.get(i).resolve(defaultAmplitude));
            }
            if (resolvedSegments.equals(this.mSegments)) {
                return this;
            }
            Composed resolved = new Composed(resolvedSegments, this.mRepeatIndex);
            resolved.validate();
            return resolved;
        }

        public Composed scale(float scaleFactor) {
            int segmentCount = this.mSegments.size();
            ArrayList scaledSegments = new ArrayList(segmentCount);
            for (int i = 0; i < segmentCount; ++i) {
                scaledSegments.add(this.mSegments.get(i).scale(scaleFactor));
            }
            if (scaledSegments.equals(this.mSegments)) {
                return this;
            }
            Composed scaled = new Composed(scaledSegments, this.mRepeatIndex);
            scaled.validate();
            return scaled;
        }

        public Composed applyEffectStrength(int effectStrength) {
            int segmentCount = this.mSegments.size();
            ArrayList scaledSegments = new ArrayList(segmentCount);
            for (int i = 0; i < segmentCount; ++i) {
                scaledSegments.add(this.mSegments.get(i).applyEffectStrength(effectStrength));
            }
            if (scaledSegments.equals(this.mSegments)) {
                return this;
            }
            Composed scaled = new Composed(scaledSegments, this.mRepeatIndex);
            scaled.validate();
            return scaled;
        }

        public boolean equals(Object o) {
            if (!(o instanceof Composed)) {
                return false;
            }
            Composed other = (Composed)o;
            return this.mSegments.equals(other.mSegments) && this.mRepeatIndex == other.mRepeatIndex;
        }

        public int hashCode() {
            return Objects.hash(this.mSegments, this.mRepeatIndex);
        }

        public String toString() {
            return "Composed{segments=" + this.mSegments + ", repeat=" + this.mRepeatIndex + "}";
        }

        @Override
        public int describeContents() {
            return 0;
        }

        @Override
        public void writeToParcel(Parcel out, int flags) {
            out.writeList(this.mSegments);
            out.writeInt(this.mRepeatIndex);
        }

        private static StepSegment castToValidStepSegmentForOffOnTimingsOrNull(VibrationEffectSegment segment) {
            if (!(segment instanceof StepSegment)) {
                return null;
            }
            StepSegment stepSegment = (StepSegment)segment;
            if (stepSegment.getFrequencyHz() != 0.0f) {
                return null;
            }
            float amplitude = stepSegment.getAmplitude();
            if (amplitude != 0.0f && amplitude != -1.0f) {
                return null;
            }
            return stepSegment;
        }
    }

    public static class Composition {
        public static final int PRIMITIVE_NOOP = 0;
        public static final int PRIMITIVE_CLICK = 1;
        public static final int PRIMITIVE_THUD = 2;
        public static final int PRIMITIVE_SPIN = 3;
        public static final int PRIMITIVE_QUICK_RISE = 4;
        public static final int PRIMITIVE_SLOW_RISE = 5;
        public static final int PRIMITIVE_QUICK_FALL = 6;
        public static final int PRIMITIVE_TICK = 7;
        public static final int PRIMITIVE_LOW_TICK = 8;
        private final ArrayList<VibrationEffectSegment> mSegments = new ArrayList();
        private int mRepeatIndex = -1;

        Composition() {
        }

        public Composition addOffDuration(Duration duration) {
            int durationMs = (int)duration.toMillis();
            Preconditions.checkArgumentNonnegative(durationMs, "Off period must be non-negative");
            if (durationMs > 0) {
                this.addSegment(new StepSegment(0.0f, 0.0f, (int)duration.toMillis()));
            }
            return this;
        }

        public Composition addEffect(VibrationEffect effect) {
            return this.addSegments(effect);
        }

        public Composition repeatEffectIndefinitely(VibrationEffect effect) {
            Preconditions.checkArgument(effect.getDuration() < Long.MAX_VALUE, "Can't repeat an indefinitely repeating effect. Consider addEffect instead.");
            int previousSegmentCount = this.mSegments.size();
            this.addSegments(effect);
            this.mRepeatIndex = previousSegmentCount;
            return this;
        }

        public Composition addPrimitive(int primitiveId) {
            return this.addPrimitive(primitiveId, 1.0f, 0);
        }

        public Composition addPrimitive(int primitiveId, float scale) {
            return this.addPrimitive(primitiveId, scale, 0);
        }

        public Composition addPrimitive(int primitiveId, float scale, int delay) {
            PrimitiveSegment primitive = new PrimitiveSegment(primitiveId, scale, delay);
            primitive.validate();
            return this.addSegment(primitive);
        }

        private Composition addSegment(VibrationEffectSegment segment) {
            if (this.mRepeatIndex >= 0) {
                throw new UnreachableAfterRepeatingIndefinitelyException();
            }
            this.mSegments.add(segment);
            return this;
        }

        private Composition addSegments(VibrationEffect effect) {
            if (this.mRepeatIndex >= 0) {
                throw new UnreachableAfterRepeatingIndefinitelyException();
            }
            Composed composed = (Composed)effect;
            if (composed.getRepeatIndex() >= 0) {
                this.mRepeatIndex = this.mSegments.size() + composed.getRepeatIndex();
            }
            this.mSegments.addAll(composed.getSegments());
            return this;
        }

        public VibrationEffect compose() {
            if (this.mSegments.isEmpty()) {
                throw new IllegalStateException("Composition must have at least one element to compose.");
            }
            Composed effect = new Composed(this.mSegments, this.mRepeatIndex);
            ((VibrationEffect)effect).validate();
            return effect;
        }

        public static String primitiveToString(int id2) {
            switch (id2) {
                case 0: {
                    return "PRIMITIVE_NOOP";
                }
                case 1: {
                    return "PRIMITIVE_CLICK";
                }
                case 2: {
                    return "PRIMITIVE_THUD";
                }
                case 3: {
                    return "PRIMITIVE_SPIN";
                }
                case 4: {
                    return "PRIMITIVE_QUICK_RISE";
                }
                case 5: {
                    return "PRIMITIVE_SLOW_RISE";
                }
                case 6: {
                    return "PRIMITIVE_QUICK_FALL";
                }
                case 7: {
                    return "PRIMITIVE_TICK";
                }
                case 8: {
                    return "PRIMITIVE_LOW_TICK";
                }
            }
            return Integer.toString(id2);
        }

        public static class UnreachableAfterRepeatingIndefinitelyException
        extends IllegalStateException {
            UnreachableAfterRepeatingIndefinitelyException() {
                super("Compositions ending in an indefinitely repeating effect can't be extended");
            }
        }

        @Retention(value=RetentionPolicy.SOURCE)
        public static @interface PrimitiveType {
        }
    }

    public static class WaveformBuilder {
        private static final float EPSILON = 1.0E-5f;
        private ArrayList<VibrationEffectSegment> mSegments = new ArrayList();
        private float mLastAmplitude = 0.0f;
        private float mLastFrequencyHz = 0.0f;

        WaveformBuilder() {
        }

        public WaveformBuilder addTransition(Duration duration, VibrationParameter targetParameter) {
            Preconditions.checkNotNull(duration, "Duration is null");
            this.checkVibrationParameter(targetParameter, "targetParameter");
            float amplitude = this.extractTargetAmplitude(targetParameter, null);
            float frequencyHz = this.extractTargetFrequency(targetParameter, null);
            this.addTransitionSegment(duration, amplitude, frequencyHz);
            return this;
        }

        public WaveformBuilder addTransition(Duration duration, VibrationParameter targetParameter1, VibrationParameter targetParameter2) {
            Preconditions.checkNotNull(duration, "Duration is null");
            this.checkVibrationParameter(targetParameter1, "targetParameter1");
            this.checkVibrationParameter(targetParameter2, "targetParameter2");
            Preconditions.checkArgument(!Objects.equals(targetParameter1.getClass(), targetParameter2.getClass()), "Parameter arguments must specify different parameter types");
            float amplitude = this.extractTargetAmplitude(targetParameter1, targetParameter2);
            float frequencyHz = this.extractTargetFrequency(targetParameter1, targetParameter2);
            this.addTransitionSegment(duration, amplitude, frequencyHz);
            return this;
        }

        public WaveformBuilder addSustain(Duration duration) {
            int durationMs = (int)duration.toMillis();
            Preconditions.checkArgument(durationMs >= 1, "Sustain duration must be >= 1ms");
            this.mSegments.add(new StepSegment(this.mLastAmplitude, this.mLastFrequencyHz, durationMs));
            return this;
        }

        public VibrationEffect build() {
            if (this.mSegments.isEmpty()) {
                throw new IllegalStateException("WaveformBuilder must have at least one transition to build.");
            }
            Composed effect = new Composed(this.mSegments, -1);
            ((VibrationEffect)effect).validate();
            return effect;
        }

        private void checkVibrationParameter(VibrationParameter vibrationParameter, String paramName) {
            Preconditions.checkNotNull(vibrationParameter, "%s is null", paramName);
            Preconditions.checkArgument(vibrationParameter instanceof AmplitudeVibrationParameter || vibrationParameter instanceof FrequencyVibrationParameter, "%s is a unknown parameter", paramName);
        }

        private float extractTargetAmplitude(VibrationParameter target1, VibrationParameter target2) {
            if (target2 instanceof AmplitudeVibrationParameter) {
                return ((AmplitudeVibrationParameter)target2).amplitude;
            }
            if (target1 instanceof AmplitudeVibrationParameter) {
                return ((AmplitudeVibrationParameter)target1).amplitude;
            }
            return this.mLastAmplitude;
        }

        private float extractTargetFrequency(VibrationParameter target1, VibrationParameter target2) {
            if (target2 instanceof FrequencyVibrationParameter) {
                return ((FrequencyVibrationParameter)target2).frequencyHz;
            }
            if (target1 instanceof FrequencyVibrationParameter) {
                return ((FrequencyVibrationParameter)target1).frequencyHz;
            }
            return this.mLastFrequencyHz;
        }

        private void addTransitionSegment(Duration duration, float targetAmplitude, float targetFrequency) {
            Preconditions.checkNotNull(duration, "Duration is null");
            Preconditions.checkArgument(!duration.isNegative(), "Transition duration must be non-negative");
            int durationMs = (int)duration.toMillis();
            if (durationMs > 0) {
                if (Math.abs(this.mLastAmplitude - targetAmplitude) < 1.0E-5f && Math.abs(this.mLastFrequencyHz - targetFrequency) < 1.0E-5f) {
                    this.mSegments.add(new StepSegment(targetAmplitude, targetFrequency, durationMs));
                } else {
                    this.mSegments.add(new RampSegment(this.mLastAmplitude, targetAmplitude, this.mLastFrequencyHz, targetFrequency, durationMs));
                }
            }
            this.mLastAmplitude = targetAmplitude;
            this.mLastFrequencyHz = targetFrequency;
        }
    }

    public static class VibrationParameter {
        VibrationParameter() {
        }

        public static VibrationParameter targetAmplitude(float amplitude) {
            return new AmplitudeVibrationParameter(amplitude);
        }

        public static VibrationParameter targetFrequency(float frequencyHz) {
            return new FrequencyVibrationParameter(frequencyHz);
        }
    }

    private static class FrequencyVibrationParameter
    extends VibrationParameter {
        public final float frequencyHz;

        FrequencyVibrationParameter(float frequencyHz) {
            Preconditions.checkArgument(frequencyHz >= 1.0f, "Frequency must be >= 1");
            Preconditions.checkArgument(Float.isFinite(frequencyHz), "Frequency must be finite");
            this.frequencyHz = frequencyHz;
        }
    }

    private static class AmplitudeVibrationParameter
    extends VibrationParameter {
        public final float amplitude;

        AmplitudeVibrationParameter(float amplitude) {
            Preconditions.checkArgument(amplitude >= 0.0f && amplitude <= 1.0f, "Amplitude must be within [0,1]");
            this.amplitude = amplitude;
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface EffectType {
    }
}

