/*
 * Decompiled with CFR 0.152.
 */
package android.os;

import android.annotation.RequiresPermission;
import android.annotation.SystemApi;
import android.app.ActivityThread;
import android.app.ContextImpl;
import android.compat.annotation.UnsupportedAppUsage;
import android.content.Context;
import android.content.res.Resources;
import android.media.AudioAttributes;
import android.os.Process;
import android.os.VibrationAttributes;
import android.os.VibrationEffect;
import android.os.VibratorInfo;
import android.os.vibrator.VibrationConfig;
import android.os.vibrator.VibratorFrequencyProfile;
import android.util.Log;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.concurrent.Executor;

public abstract class Vibrator {
    private static final String TAG = "Vibrator";
    public static final int VIBRATION_INTENSITY_OFF = 0;
    public static final int VIBRATION_INTENSITY_LOW = 1;
    public static final int VIBRATION_INTENSITY_MEDIUM = 2;
    public static final int VIBRATION_INTENSITY_HIGH = 3;
    public static final int VIBRATION_EFFECT_SUPPORT_UNKNOWN = 0;
    public static final int VIBRATION_EFFECT_SUPPORT_YES = 1;
    public static final int VIBRATION_EFFECT_SUPPORT_NO = 2;
    private final String mPackageName;
    private final Resources mResources;
    private volatile VibrationConfig mVibrationConfig;

    @UnsupportedAppUsage
    public Vibrator() {
        this.mPackageName = ActivityThread.currentPackageName();
        this.mResources = null;
    }

    protected Vibrator(Context context) {
        this.mPackageName = context.getOpPackageName();
        this.mResources = context.getResources();
    }

    protected VibratorInfo getInfo() {
        return VibratorInfo.EMPTY_VIBRATOR_INFO;
    }

    private VibrationConfig getConfig() {
        if (this.mVibrationConfig == null) {
            Resources resources = this.mResources;
            if (resources == null) {
                ContextImpl ctx = ActivityThread.currentActivityThread().getSystemContext();
                resources = ctx != null ? ((Context)ctx).getResources() : null;
            }
            this.mVibrationConfig = new VibrationConfig(resources);
        }
        return this.mVibrationConfig;
    }

    public int getDefaultVibrationIntensity(int usage) {
        return this.getConfig().getDefaultVibrationIntensity(usage);
    }

    public int getId() {
        return this.getInfo().getId();
    }

    public abstract boolean hasVibrator();

    public abstract boolean hasAmplitudeControl();

    public boolean hasFrequencyControl() {
        return this.getInfo().hasCapability(1536L);
    }

    public boolean areVibrationFeaturesSupported(VibrationEffect effect) {
        return effect.areVibrationFeaturesSupported(this);
    }

    public boolean hasExternalControl() {
        return this.getInfo().hasCapability(8L);
    }

    public float getResonantFrequency() {
        return this.getInfo().getResonantFrequencyHz();
    }

    public float getQFactor() {
        return this.getInfo().getQFactor();
    }

    public VibratorFrequencyProfile getFrequencyProfile() {
        VibratorInfo.FrequencyProfile frequencyProfile = this.getInfo().getFrequencyProfile();
        if (frequencyProfile.isEmpty()) {
            return null;
        }
        return new VibratorFrequencyProfile(frequencyProfile);
    }

    public float getHapticChannelMaximumAmplitude() {
        return this.getConfig().getHapticChannelMaximumAmplitude();
    }

    @RequiresPermission(value="android.permission.VIBRATE_ALWAYS_ON")
    public boolean setAlwaysOnEffect(int alwaysOnId, VibrationEffect effect, VibrationAttributes attributes) {
        return this.setAlwaysOnEffect(Process.myUid(), this.mPackageName, alwaysOnId, effect, attributes);
    }

    @RequiresPermission(value="android.permission.VIBRATE_ALWAYS_ON")
    public boolean setAlwaysOnEffect(int uid, String opPkg, int alwaysOnId, VibrationEffect effect, VibrationAttributes attributes) {
        Log.w(TAG, "Always-on effects aren't supported");
        return false;
    }

    @Deprecated
    @RequiresPermission(value="android.permission.VIBRATE")
    public void vibrate(long milliseconds) {
        this.vibrate(milliseconds, null);
    }

    @Deprecated
    @RequiresPermission(value="android.permission.VIBRATE")
    public void vibrate(long milliseconds, AudioAttributes attributes) {
        try {
            VibrationEffect effect = VibrationEffect.createOneShot(milliseconds, -1);
            this.vibrate(effect, attributes);
        }
        catch (IllegalArgumentException iae) {
            Log.e(TAG, "Failed to create VibrationEffect", iae);
        }
    }

    @Deprecated
    @RequiresPermission(value="android.permission.VIBRATE")
    public void vibrate(long[] pattern, int repeat) {
        this.vibrate(pattern, repeat, null);
    }

    @Deprecated
    @RequiresPermission(value="android.permission.VIBRATE")
    public void vibrate(long[] pattern, int repeat, AudioAttributes attributes) {
        if (repeat < -1 || repeat >= pattern.length) {
            Log.e(TAG, "vibrate called with repeat index out of bounds (pattern.length=" + pattern.length + ", index=" + repeat + ")");
            throw new ArrayIndexOutOfBoundsException();
        }
        try {
            this.vibrate(VibrationEffect.createWaveform(pattern, repeat), attributes);
        }
        catch (IllegalArgumentException iae) {
            Log.e(TAG, "Failed to create VibrationEffect", iae);
        }
    }

    @RequiresPermission(value="android.permission.VIBRATE")
    public void vibrate(VibrationEffect vibe) {
        this.vibrate(vibe, new VibrationAttributes.Builder().build());
    }

    @RequiresPermission(value="android.permission.VIBRATE")
    public void vibrate(VibrationEffect vibe, AudioAttributes attributes) {
        this.vibrate(vibe, attributes == null ? new VibrationAttributes.Builder().build() : new VibrationAttributes.Builder(attributes).build());
    }

    @RequiresPermission(value="android.permission.VIBRATE")
    public void vibrate(VibrationEffect vibe, VibrationAttributes attributes) {
        this.vibrate(Process.myUid(), this.mPackageName, vibe, null, attributes);
    }

    @RequiresPermission(value="android.permission.VIBRATE")
    public abstract void vibrate(int var1, String var2, VibrationEffect var3, String var4, VibrationAttributes var5);

    public int[] areEffectsSupported(int ... effectIds) {
        VibratorInfo info = this.getInfo();
        int[] supported = new int[effectIds.length];
        for (int i = 0; i < effectIds.length; ++i) {
            supported[i] = info.isEffectSupported(effectIds[i]);
        }
        return supported;
    }

    public int areAllEffectsSupported(int ... effectIds) {
        VibratorInfo info = this.getInfo();
        int allSupported = 1;
        block4: for (int effectId : effectIds) {
            switch (info.isEffectSupported(effectId)) {
                case 2: {
                    return 2;
                }
                case 1: {
                    continue block4;
                }
                default: {
                    allSupported = 0;
                }
            }
        }
        return allSupported;
    }

    public boolean[] arePrimitivesSupported(int ... primitiveIds) {
        VibratorInfo info = this.getInfo();
        boolean[] supported = new boolean[primitiveIds.length];
        for (int i = 0; i < primitiveIds.length; ++i) {
            supported[i] = info.isPrimitiveSupported(primitiveIds[i]);
        }
        return supported;
    }

    public boolean areAllPrimitivesSupported(int ... primitiveIds) {
        VibratorInfo info = this.getInfo();
        for (int primitiveId : primitiveIds) {
            if (info.isPrimitiveSupported(primitiveId)) continue;
            return false;
        }
        return true;
    }

    public int[] getPrimitiveDurations(int ... primitiveIds) {
        VibratorInfo info = this.getInfo();
        int[] durations = new int[primitiveIds.length];
        for (int i = 0; i < primitiveIds.length; ++i) {
            durations[i] = info.getPrimitiveDuration(primitiveIds[i]);
        }
        return durations;
    }

    @RequiresPermission(value="android.permission.VIBRATE")
    public abstract void cancel();

    @RequiresPermission(value="android.permission.VIBRATE")
    public abstract void cancel(int var1);

    @SystemApi
    @RequiresPermission(value="android.permission.ACCESS_VIBRATOR_STATE")
    public boolean isVibrating() {
        return false;
    }

    @SystemApi
    @RequiresPermission(value="android.permission.ACCESS_VIBRATOR_STATE")
    public void addVibratorStateListener(OnVibratorStateChangedListener listener) {
    }

    @SystemApi
    @RequiresPermission(value="android.permission.ACCESS_VIBRATOR_STATE")
    public void addVibratorStateListener(Executor executor, OnVibratorStateChangedListener listener) {
    }

    @SystemApi
    @RequiresPermission(value="android.permission.ACCESS_VIBRATOR_STATE")
    public void removeVibratorStateListener(OnVibratorStateChangedListener listener) {
    }

    @SystemApi
    public static interface OnVibratorStateChangedListener {
        public void onVibratorStateChanged(boolean var1);
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface VibrationIntensity {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface VibrationEffectSupport {
    }
}

