/*
 * Decompiled with CFR 0.152.
 */
package android.os.storage;

import android.os.Binder;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.RemoteException;
import android.os.storage.DiskInfo;
import android.os.storage.VolumeInfo;
import android.os.storage.VolumeRecord;

public interface IStorageEventListener
extends IInterface {
    public void onUsbMassStorageConnectionChanged(boolean var1) throws RemoteException;

    public void onStorageStateChanged(String var1, String var2, String var3) throws RemoteException;

    public void onVolumeStateChanged(VolumeInfo var1, int var2, int var3) throws RemoteException;

    public void onVolumeRecordChanged(VolumeRecord var1) throws RemoteException;

    public void onVolumeForgotten(String var1) throws RemoteException;

    public void onDiskScanned(DiskInfo var1, int var2) throws RemoteException;

    public void onDiskDestroyed(DiskInfo var1) throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements IStorageEventListener {
        public static final String DESCRIPTOR = "android.os.storage.IStorageEventListener";
        static final int TRANSACTION_onUsbMassStorageConnectionChanged = 1;
        static final int TRANSACTION_onStorageStateChanged = 2;
        static final int TRANSACTION_onVolumeStateChanged = 3;
        static final int TRANSACTION_onVolumeRecordChanged = 4;
        static final int TRANSACTION_onVolumeForgotten = 5;
        static final int TRANSACTION_onDiskScanned = 6;
        static final int TRANSACTION_onDiskDestroyed = 7;

        public Stub() {
            this.attachInterface(this, DESCRIPTOR);
        }

        public static IStorageEventListener asInterface(IBinder obj) {
            if (obj == null) {
                return null;
            }
            IInterface iin = obj.queryLocalInterface(DESCRIPTOR);
            if (iin != null && iin instanceof IStorageEventListener) {
                return (IStorageEventListener)iin;
            }
            return new Proxy(obj);
        }

        @Override
        public IBinder asBinder() {
            return this;
        }

        public static String getDefaultTransactionName(int transactionCode) {
            switch (transactionCode) {
                case 1: {
                    return "onUsbMassStorageConnectionChanged";
                }
                case 2: {
                    return "onStorageStateChanged";
                }
                case 3: {
                    return "onVolumeStateChanged";
                }
                case 4: {
                    return "onVolumeRecordChanged";
                }
                case 5: {
                    return "onVolumeForgotten";
                }
                case 6: {
                    return "onDiskScanned";
                }
                case 7: {
                    return "onDiskDestroyed";
                }
            }
            return null;
        }

        @Override
        public String getTransactionName(int transactionCode) {
            return Stub.getDefaultTransactionName(transactionCode);
        }

        @Override
        public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
            String descriptor = DESCRIPTOR;
            if (code >= 1 && code <= 0xFFFFFF) {
                data.enforceInterface(descriptor);
            }
            switch (code) {
                case 1598968902: {
                    reply.writeString(descriptor);
                    return true;
                }
            }
            switch (code) {
                case 1: {
                    boolean _arg0 = data.readBoolean();
                    data.enforceNoDataAvail();
                    this.onUsbMassStorageConnectionChanged(_arg0);
                    break;
                }
                case 2: {
                    String _arg0 = data.readString();
                    String _arg1 = data.readString();
                    String _arg2 = data.readString();
                    data.enforceNoDataAvail();
                    this.onStorageStateChanged(_arg0, _arg1, _arg2);
                    break;
                }
                case 3: {
                    VolumeInfo _arg0 = data.readTypedObject(VolumeInfo.CREATOR);
                    int _arg1 = data.readInt();
                    int _arg2 = data.readInt();
                    data.enforceNoDataAvail();
                    this.onVolumeStateChanged(_arg0, _arg1, _arg2);
                    break;
                }
                case 4: {
                    VolumeRecord _arg0 = data.readTypedObject(VolumeRecord.CREATOR);
                    data.enforceNoDataAvail();
                    this.onVolumeRecordChanged(_arg0);
                    break;
                }
                case 5: {
                    String _arg0 = data.readString();
                    data.enforceNoDataAvail();
                    this.onVolumeForgotten(_arg0);
                    break;
                }
                case 6: {
                    DiskInfo _arg0 = data.readTypedObject(DiskInfo.CREATOR);
                    int _arg1 = data.readInt();
                    data.enforceNoDataAvail();
                    this.onDiskScanned(_arg0, _arg1);
                    break;
                }
                case 7: {
                    DiskInfo _arg0 = data.readTypedObject(DiskInfo.CREATOR);
                    data.enforceNoDataAvail();
                    this.onDiskDestroyed(_arg0);
                    break;
                }
                default: {
                    return super.onTransact(code, data, reply, flags);
                }
            }
            return true;
        }

        @Override
        public int getMaxTransactionId() {
            return 6;
        }

        private static class Proxy
        implements IStorageEventListener {
            private IBinder mRemote;

            Proxy(IBinder remote) {
                this.mRemote = remote;
            }

            @Override
            public IBinder asBinder() {
                return this.mRemote;
            }

            public String getInterfaceDescriptor() {
                return Stub.DESCRIPTOR;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onUsbMassStorageConnectionChanged(boolean connected) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeBoolean(connected);
                    boolean bl = this.mRemote.transact(1, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onStorageStateChanged(String path, String oldState, String newState) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(path);
                    _data.writeString(oldState);
                    _data.writeString(newState);
                    boolean bl = this.mRemote.transact(2, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onVolumeStateChanged(VolumeInfo vol, int oldState, int newState) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedObject(vol, 0);
                    _data.writeInt(oldState);
                    _data.writeInt(newState);
                    boolean bl = this.mRemote.transact(3, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onVolumeRecordChanged(VolumeRecord rec) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedObject(rec, 0);
                    boolean bl = this.mRemote.transact(4, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onVolumeForgotten(String fsUuid) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(fsUuid);
                    boolean bl = this.mRemote.transact(5, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onDiskScanned(DiskInfo disk, int volumeCount) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedObject(disk, 0);
                    _data.writeInt(volumeCount);
                    boolean bl = this.mRemote.transact(6, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onDiskDestroyed(DiskInfo disk) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedObject(disk, 0);
                    boolean bl = this.mRemote.transact(7, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }
        }
    }

    public static class Default
    implements IStorageEventListener {
        @Override
        public void onUsbMassStorageConnectionChanged(boolean connected) throws RemoteException {
        }

        @Override
        public void onStorageStateChanged(String path, String oldState, String newState) throws RemoteException {
        }

        @Override
        public void onVolumeStateChanged(VolumeInfo vol, int oldState, int newState) throws RemoteException {
        }

        @Override
        public void onVolumeRecordChanged(VolumeRecord rec) throws RemoteException {
        }

        @Override
        public void onVolumeForgotten(String fsUuid) throws RemoteException {
        }

        @Override
        public void onDiskScanned(DiskInfo disk, int volumeCount) throws RemoteException {
        }

        @Override
        public void onDiskDestroyed(DiskInfo disk) throws RemoteException {
        }

        @Override
        public IBinder asBinder() {
            return null;
        }
    }
}

