/*
 * Decompiled with CFR 0.152.
 */
package android.os.vibrator;

import android.os.Parcel;
import android.os.Parcelable;
import android.os.VibrationEffect;
import android.os.Vibrator;
import android.os.vibrator.VibrationEffectSegment;
import com.android.internal.util.Preconditions;
import java.util.Objects;

public class RampSegment
extends VibrationEffectSegment {
    private final float mStartAmplitude;
    private final float mStartFrequencyHz;
    private final float mEndAmplitude;
    private final float mEndFrequencyHz;
    private final int mDuration;
    public static final Parcelable.Creator<RampSegment> CREATOR = new Parcelable.Creator<RampSegment>(){

        @Override
        public RampSegment createFromParcel(Parcel in) {
            in.readInt();
            return new RampSegment(in);
        }

        public RampSegment[] newArray(int size) {
            return new RampSegment[size];
        }
    };

    RampSegment(Parcel in) {
        this(in.readFloat(), in.readFloat(), in.readFloat(), in.readFloat(), in.readInt());
    }

    public RampSegment(float startAmplitude, float endAmplitude, float startFrequencyHz, float endFrequencyHz, int duration) {
        this.mStartAmplitude = startAmplitude;
        this.mEndAmplitude = endAmplitude;
        this.mStartFrequencyHz = startFrequencyHz;
        this.mEndFrequencyHz = endFrequencyHz;
        this.mDuration = duration;
    }

    public boolean equals(Object o) {
        if (!(o instanceof RampSegment)) {
            return false;
        }
        RampSegment other = (RampSegment)o;
        return Float.compare(this.mStartAmplitude, other.mStartAmplitude) == 0 && Float.compare(this.mEndAmplitude, other.mEndAmplitude) == 0 && Float.compare(this.mStartFrequencyHz, other.mStartFrequencyHz) == 0 && Float.compare(this.mEndFrequencyHz, other.mEndFrequencyHz) == 0 && this.mDuration == other.mDuration;
    }

    public float getStartAmplitude() {
        return this.mStartAmplitude;
    }

    public float getEndAmplitude() {
        return this.mEndAmplitude;
    }

    public float getStartFrequencyHz() {
        return this.mStartFrequencyHz;
    }

    public float getEndFrequencyHz() {
        return this.mEndFrequencyHz;
    }

    @Override
    public long getDuration() {
        return this.mDuration;
    }

    @Override
    public boolean areVibrationFeaturesSupported(Vibrator vibrator) {
        boolean areFeaturesSupported = true;
        if (this.mStartFrequencyHz != this.mEndFrequencyHz || RampSegment.frequencyRequiresFrequencyControl(this.mStartFrequencyHz)) {
            areFeaturesSupported &= vibrator.hasFrequencyControl();
        }
        if (this.mStartAmplitude != this.mEndAmplitude || RampSegment.amplitudeRequiresAmplitudeControl(this.mStartAmplitude)) {
            areFeaturesSupported &= vibrator.hasAmplitudeControl();
        }
        return areFeaturesSupported;
    }

    @Override
    public boolean isHapticFeedbackCandidate() {
        return true;
    }

    @Override
    public boolean hasNonZeroAmplitude() {
        return this.mStartAmplitude > 0.0f || this.mEndAmplitude > 0.0f;
    }

    @Override
    public void validate() {
        VibrationEffectSegment.checkFrequencyArgument(this.mStartFrequencyHz, "startFrequencyHz");
        VibrationEffectSegment.checkFrequencyArgument(this.mEndFrequencyHz, "endFrequencyHz");
        VibrationEffectSegment.checkDurationArgument(this.mDuration, "duration");
        Preconditions.checkArgumentInRange(this.mStartAmplitude, 0.0f, 1.0f, "startAmplitude");
        Preconditions.checkArgumentInRange(this.mEndAmplitude, 0.0f, 1.0f, "endAmplitude");
    }

    public RampSegment resolve(int defaultAmplitude) {
        return this;
    }

    public RampSegment scale(float scaleFactor) {
        float newStartAmplitude = VibrationEffect.scale(this.mStartAmplitude, scaleFactor);
        float newEndAmplitude = VibrationEffect.scale(this.mEndAmplitude, scaleFactor);
        if (Float.compare(this.mStartAmplitude, newStartAmplitude) == 0 && Float.compare(this.mEndAmplitude, newEndAmplitude) == 0) {
            return this;
        }
        return new RampSegment(newStartAmplitude, newEndAmplitude, this.mStartFrequencyHz, this.mEndFrequencyHz, this.mDuration);
    }

    public RampSegment applyEffectStrength(int effectStrength) {
        return this;
    }

    public int hashCode() {
        return Objects.hash(Float.valueOf(this.mStartAmplitude), Float.valueOf(this.mEndAmplitude), Float.valueOf(this.mStartFrequencyHz), Float.valueOf(this.mEndFrequencyHz), this.mDuration);
    }

    public String toString() {
        return "Ramp{startAmplitude=" + this.mStartAmplitude + ", endAmplitude=" + this.mEndAmplitude + ", startFrequencyHz=" + this.mStartFrequencyHz + ", endFrequencyHz=" + this.mEndFrequencyHz + ", duration=" + this.mDuration + "}";
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel out, int flags) {
        out.writeInt(4);
        out.writeFloat(this.mStartAmplitude);
        out.writeFloat(this.mEndAmplitude);
        out.writeFloat(this.mStartFrequencyHz);
        out.writeFloat(this.mEndFrequencyHz);
        out.writeInt(this.mDuration);
    }
}

