/*
 * Decompiled with CFR 0.152.
 */
package android.permission;

import android.os.Binder;
import android.os.Bundle;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.ParcelFileDescriptor;
import android.os.RemoteException;
import android.os.UserHandle;
import android.permission.AdminPermissionControlParams;
import com.android.internal.infra.AndroidFuture;
import java.util.ArrayList;
import java.util.List;

public interface IPermissionController
extends IInterface {
    public static final String DESCRIPTOR = "android.permission.IPermissionController";

    public void revokeRuntimePermissions(Bundle var1, boolean var2, int var3, String var4, AndroidFuture var5) throws RemoteException;

    public void getRuntimePermissionBackup(UserHandle var1, ParcelFileDescriptor var2) throws RemoteException;

    public void stageAndApplyRuntimePermissionsBackup(UserHandle var1, ParcelFileDescriptor var2) throws RemoteException;

    public void applyStagedRuntimePermissionBackup(String var1, UserHandle var2, AndroidFuture var3) throws RemoteException;

    public void getAppPermissions(String var1, AndroidFuture var2) throws RemoteException;

    public void revokeRuntimePermission(String var1, String var2) throws RemoteException;

    public void countPermissionApps(List<String> var1, int var2, AndroidFuture var3) throws RemoteException;

    public void getPermissionUsages(boolean var1, long var2, AndroidFuture var4) throws RemoteException;

    public void setRuntimePermissionGrantStateByDeviceAdminFromParams(String var1, AdminPermissionControlParams var2, AndroidFuture var3) throws RemoteException;

    public void grantOrUpgradeDefaultRuntimePermissions(AndroidFuture var1) throws RemoteException;

    public void notifyOneTimePermissionSessionTimeout(String var1) throws RemoteException;

    public void updateUserSensitiveForApp(int var1, AndroidFuture var2) throws RemoteException;

    public void getPrivilegesDescriptionStringForProfile(String var1, AndroidFuture<String> var2) throws RemoteException;

    public void getPlatformPermissionsForGroup(String var1, AndroidFuture<List<String>> var2) throws RemoteException;

    public void getGroupOfPlatformPermission(String var1, AndroidFuture<String> var2) throws RemoteException;

    public void getUnusedAppCount(AndroidFuture var1) throws RemoteException;

    public void getHibernationEligibility(String var1, AndroidFuture var2) throws RemoteException;

    public void revokeSelfPermissionsOnKill(String var1, List<String> var2, AndroidFuture var3) throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements IPermissionController {
        static final int TRANSACTION_revokeRuntimePermissions = 1;
        static final int TRANSACTION_getRuntimePermissionBackup = 2;
        static final int TRANSACTION_stageAndApplyRuntimePermissionsBackup = 3;
        static final int TRANSACTION_applyStagedRuntimePermissionBackup = 4;
        static final int TRANSACTION_getAppPermissions = 5;
        static final int TRANSACTION_revokeRuntimePermission = 6;
        static final int TRANSACTION_countPermissionApps = 7;
        static final int TRANSACTION_getPermissionUsages = 8;
        static final int TRANSACTION_setRuntimePermissionGrantStateByDeviceAdminFromParams = 9;
        static final int TRANSACTION_grantOrUpgradeDefaultRuntimePermissions = 10;
        static final int TRANSACTION_notifyOneTimePermissionSessionTimeout = 11;
        static final int TRANSACTION_updateUserSensitiveForApp = 12;
        static final int TRANSACTION_getPrivilegesDescriptionStringForProfile = 13;
        static final int TRANSACTION_getPlatformPermissionsForGroup = 14;
        static final int TRANSACTION_getGroupOfPlatformPermission = 15;
        static final int TRANSACTION_getUnusedAppCount = 16;
        static final int TRANSACTION_getHibernationEligibility = 17;
        static final int TRANSACTION_revokeSelfPermissionsOnKill = 18;

        public Stub() {
            this.attachInterface(this, IPermissionController.DESCRIPTOR);
        }

        public static IPermissionController asInterface(IBinder obj) {
            if (obj == null) {
                return null;
            }
            IInterface iin = obj.queryLocalInterface(IPermissionController.DESCRIPTOR);
            if (iin != null && iin instanceof IPermissionController) {
                return (IPermissionController)iin;
            }
            return new Proxy(obj);
        }

        @Override
        public IBinder asBinder() {
            return this;
        }

        public static String getDefaultTransactionName(int transactionCode) {
            switch (transactionCode) {
                case 1: {
                    return "revokeRuntimePermissions";
                }
                case 2: {
                    return "getRuntimePermissionBackup";
                }
                case 3: {
                    return "stageAndApplyRuntimePermissionsBackup";
                }
                case 4: {
                    return "applyStagedRuntimePermissionBackup";
                }
                case 5: {
                    return "getAppPermissions";
                }
                case 6: {
                    return "revokeRuntimePermission";
                }
                case 7: {
                    return "countPermissionApps";
                }
                case 8: {
                    return "getPermissionUsages";
                }
                case 9: {
                    return "setRuntimePermissionGrantStateByDeviceAdminFromParams";
                }
                case 10: {
                    return "grantOrUpgradeDefaultRuntimePermissions";
                }
                case 11: {
                    return "notifyOneTimePermissionSessionTimeout";
                }
                case 12: {
                    return "updateUserSensitiveForApp";
                }
                case 13: {
                    return "getPrivilegesDescriptionStringForProfile";
                }
                case 14: {
                    return "getPlatformPermissionsForGroup";
                }
                case 15: {
                    return "getGroupOfPlatformPermission";
                }
                case 16: {
                    return "getUnusedAppCount";
                }
                case 17: {
                    return "getHibernationEligibility";
                }
                case 18: {
                    return "revokeSelfPermissionsOnKill";
                }
            }
            return null;
        }

        @Override
        public String getTransactionName(int transactionCode) {
            return Stub.getDefaultTransactionName(transactionCode);
        }

        @Override
        public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
            String descriptor = IPermissionController.DESCRIPTOR;
            if (code >= 1 && code <= 0xFFFFFF) {
                data.enforceInterface(descriptor);
            }
            switch (code) {
                case 1598968902: {
                    reply.writeString(descriptor);
                    return true;
                }
            }
            switch (code) {
                case 1: {
                    Bundle _arg0 = data.readTypedObject(Bundle.CREATOR);
                    boolean _arg1 = data.readBoolean();
                    int _arg2 = data.readInt();
                    String _arg3 = data.readString();
                    AndroidFuture _arg4 = data.readTypedObject(AndroidFuture.CREATOR);
                    data.enforceNoDataAvail();
                    this.revokeRuntimePermissions(_arg0, _arg1, _arg2, _arg3, _arg4);
                    break;
                }
                case 2: {
                    UserHandle _arg0 = data.readTypedObject(UserHandle.CREATOR);
                    ParcelFileDescriptor _arg1 = data.readTypedObject(ParcelFileDescriptor.CREATOR);
                    data.enforceNoDataAvail();
                    this.getRuntimePermissionBackup(_arg0, _arg1);
                    break;
                }
                case 3: {
                    UserHandle _arg0 = data.readTypedObject(UserHandle.CREATOR);
                    ParcelFileDescriptor _arg1 = data.readTypedObject(ParcelFileDescriptor.CREATOR);
                    data.enforceNoDataAvail();
                    this.stageAndApplyRuntimePermissionsBackup(_arg0, _arg1);
                    break;
                }
                case 4: {
                    String _arg0 = data.readString();
                    UserHandle _arg1 = data.readTypedObject(UserHandle.CREATOR);
                    AndroidFuture _arg2 = data.readTypedObject(AndroidFuture.CREATOR);
                    data.enforceNoDataAvail();
                    this.applyStagedRuntimePermissionBackup(_arg0, _arg1, _arg2);
                    break;
                }
                case 5: {
                    String _arg0 = data.readString();
                    AndroidFuture _arg1 = data.readTypedObject(AndroidFuture.CREATOR);
                    data.enforceNoDataAvail();
                    this.getAppPermissions(_arg0, _arg1);
                    break;
                }
                case 6: {
                    String _arg0 = data.readString();
                    String _arg1 = data.readString();
                    data.enforceNoDataAvail();
                    this.revokeRuntimePermission(_arg0, _arg1);
                    break;
                }
                case 7: {
                    ArrayList<String> _arg0 = data.createStringArrayList();
                    int _arg1 = data.readInt();
                    AndroidFuture _arg2 = data.readTypedObject(AndroidFuture.CREATOR);
                    data.enforceNoDataAvail();
                    this.countPermissionApps(_arg0, _arg1, _arg2);
                    break;
                }
                case 8: {
                    boolean _arg0 = data.readBoolean();
                    long _arg1 = data.readLong();
                    AndroidFuture _arg2 = data.readTypedObject(AndroidFuture.CREATOR);
                    data.enforceNoDataAvail();
                    this.getPermissionUsages(_arg0, _arg1, _arg2);
                    break;
                }
                case 9: {
                    String _arg0 = data.readString();
                    AdminPermissionControlParams _arg1 = data.readTypedObject(AdminPermissionControlParams.CREATOR);
                    AndroidFuture _arg2 = data.readTypedObject(AndroidFuture.CREATOR);
                    data.enforceNoDataAvail();
                    this.setRuntimePermissionGrantStateByDeviceAdminFromParams(_arg0, _arg1, _arg2);
                    break;
                }
                case 10: {
                    AndroidFuture _arg0 = data.readTypedObject(AndroidFuture.CREATOR);
                    data.enforceNoDataAvail();
                    this.grantOrUpgradeDefaultRuntimePermissions(_arg0);
                    break;
                }
                case 11: {
                    String _arg0 = data.readString();
                    data.enforceNoDataAvail();
                    this.notifyOneTimePermissionSessionTimeout(_arg0);
                    break;
                }
                case 12: {
                    int _arg0 = data.readInt();
                    AndroidFuture _arg1 = data.readTypedObject(AndroidFuture.CREATOR);
                    data.enforceNoDataAvail();
                    this.updateUserSensitiveForApp(_arg0, _arg1);
                    break;
                }
                case 13: {
                    String _arg0 = data.readString();
                    AndroidFuture _arg1 = data.readTypedObject(AndroidFuture.CREATOR);
                    data.enforceNoDataAvail();
                    this.getPrivilegesDescriptionStringForProfile(_arg0, _arg1);
                    break;
                }
                case 14: {
                    String _arg0 = data.readString();
                    AndroidFuture _arg1 = data.readTypedObject(AndroidFuture.CREATOR);
                    data.enforceNoDataAvail();
                    this.getPlatformPermissionsForGroup(_arg0, _arg1);
                    break;
                }
                case 15: {
                    String _arg0 = data.readString();
                    AndroidFuture _arg1 = data.readTypedObject(AndroidFuture.CREATOR);
                    data.enforceNoDataAvail();
                    this.getGroupOfPlatformPermission(_arg0, _arg1);
                    break;
                }
                case 16: {
                    AndroidFuture _arg0 = data.readTypedObject(AndroidFuture.CREATOR);
                    data.enforceNoDataAvail();
                    this.getUnusedAppCount(_arg0);
                    break;
                }
                case 17: {
                    String _arg0 = data.readString();
                    AndroidFuture _arg1 = data.readTypedObject(AndroidFuture.CREATOR);
                    data.enforceNoDataAvail();
                    this.getHibernationEligibility(_arg0, _arg1);
                    break;
                }
                case 18: {
                    String _arg0 = data.readString();
                    ArrayList<String> _arg1 = data.createStringArrayList();
                    AndroidFuture _arg2 = data.readTypedObject(AndroidFuture.CREATOR);
                    data.enforceNoDataAvail();
                    this.revokeSelfPermissionsOnKill(_arg0, _arg1, _arg2);
                    break;
                }
                default: {
                    return super.onTransact(code, data, reply, flags);
                }
            }
            return true;
        }

        @Override
        public int getMaxTransactionId() {
            return 17;
        }

        private static class Proxy
        implements IPermissionController {
            private IBinder mRemote;

            Proxy(IBinder remote) {
                this.mRemote = remote;
            }

            @Override
            public IBinder asBinder() {
                return this.mRemote;
            }

            public String getInterfaceDescriptor() {
                return IPermissionController.DESCRIPTOR;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void revokeRuntimePermissions(Bundle request, boolean doDryRun, int reason, String callerPackageName, AndroidFuture callback) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(IPermissionController.DESCRIPTOR);
                    _data.writeTypedObject(request, 0);
                    _data.writeBoolean(doDryRun);
                    _data.writeInt(reason);
                    _data.writeString(callerPackageName);
                    _data.writeTypedObject(callback, 0);
                    boolean bl = this.mRemote.transact(1, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void getRuntimePermissionBackup(UserHandle user, ParcelFileDescriptor pipe) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(IPermissionController.DESCRIPTOR);
                    _data.writeTypedObject(user, 0);
                    _data.writeTypedObject(pipe, 0);
                    boolean bl = this.mRemote.transact(2, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void stageAndApplyRuntimePermissionsBackup(UserHandle user, ParcelFileDescriptor pipe) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(IPermissionController.DESCRIPTOR);
                    _data.writeTypedObject(user, 0);
                    _data.writeTypedObject(pipe, 0);
                    boolean bl = this.mRemote.transact(3, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void applyStagedRuntimePermissionBackup(String packageName, UserHandle user, AndroidFuture callback) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(IPermissionController.DESCRIPTOR);
                    _data.writeString(packageName);
                    _data.writeTypedObject(user, 0);
                    _data.writeTypedObject(callback, 0);
                    boolean bl = this.mRemote.transact(4, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void getAppPermissions(String packageName, AndroidFuture callback) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(IPermissionController.DESCRIPTOR);
                    _data.writeString(packageName);
                    _data.writeTypedObject(callback, 0);
                    boolean bl = this.mRemote.transact(5, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void revokeRuntimePermission(String packageName, String permissionName) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(IPermissionController.DESCRIPTOR);
                    _data.writeString(packageName);
                    _data.writeString(permissionName);
                    boolean bl = this.mRemote.transact(6, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void countPermissionApps(List<String> permissionNames, int flags, AndroidFuture callback) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(IPermissionController.DESCRIPTOR);
                    _data.writeStringList(permissionNames);
                    _data.writeInt(flags);
                    _data.writeTypedObject(callback, 0);
                    boolean bl = this.mRemote.transact(7, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void getPermissionUsages(boolean countSystem, long numMillis, AndroidFuture callback) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(IPermissionController.DESCRIPTOR);
                    _data.writeBoolean(countSystem);
                    _data.writeLong(numMillis);
                    _data.writeTypedObject(callback, 0);
                    boolean bl = this.mRemote.transact(8, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setRuntimePermissionGrantStateByDeviceAdminFromParams(String callerPackageName, AdminPermissionControlParams params, AndroidFuture callback) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(IPermissionController.DESCRIPTOR);
                    _data.writeString(callerPackageName);
                    _data.writeTypedObject(params, 0);
                    _data.writeTypedObject(callback, 0);
                    boolean bl = this.mRemote.transact(9, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void grantOrUpgradeDefaultRuntimePermissions(AndroidFuture callback) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(IPermissionController.DESCRIPTOR);
                    _data.writeTypedObject(callback, 0);
                    boolean bl = this.mRemote.transact(10, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void notifyOneTimePermissionSessionTimeout(String packageName) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(IPermissionController.DESCRIPTOR);
                    _data.writeString(packageName);
                    boolean bl = this.mRemote.transact(11, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void updateUserSensitiveForApp(int uid, AndroidFuture callback) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(IPermissionController.DESCRIPTOR);
                    _data.writeInt(uid);
                    _data.writeTypedObject(callback, 0);
                    boolean bl = this.mRemote.transact(12, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void getPrivilegesDescriptionStringForProfile(String deviceProfileName, AndroidFuture<String> callback) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(IPermissionController.DESCRIPTOR);
                    _data.writeString(deviceProfileName);
                    _data.writeTypedObject(callback, 0);
                    boolean bl = this.mRemote.transact(13, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void getPlatformPermissionsForGroup(String permissionGroupName, AndroidFuture<List<String>> callback) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(IPermissionController.DESCRIPTOR);
                    _data.writeString(permissionGroupName);
                    _data.writeTypedObject(callback, 0);
                    boolean bl = this.mRemote.transact(14, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void getGroupOfPlatformPermission(String permissionName, AndroidFuture<String> callback) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(IPermissionController.DESCRIPTOR);
                    _data.writeString(permissionName);
                    _data.writeTypedObject(callback, 0);
                    boolean bl = this.mRemote.transact(15, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void getUnusedAppCount(AndroidFuture callback) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(IPermissionController.DESCRIPTOR);
                    _data.writeTypedObject(callback, 0);
                    boolean bl = this.mRemote.transact(16, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void getHibernationEligibility(String packageName, AndroidFuture callback) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(IPermissionController.DESCRIPTOR);
                    _data.writeString(packageName);
                    _data.writeTypedObject(callback, 0);
                    boolean bl = this.mRemote.transact(17, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void revokeSelfPermissionsOnKill(String packageName, List<String> permissions, AndroidFuture callback) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(IPermissionController.DESCRIPTOR);
                    _data.writeString(packageName);
                    _data.writeStringList(permissions);
                    _data.writeTypedObject(callback, 0);
                    boolean bl = this.mRemote.transact(18, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }
        }
    }

    public static class Default
    implements IPermissionController {
        @Override
        public void revokeRuntimePermissions(Bundle request, boolean doDryRun, int reason, String callerPackageName, AndroidFuture callback) throws RemoteException {
        }

        @Override
        public void getRuntimePermissionBackup(UserHandle user, ParcelFileDescriptor pipe) throws RemoteException {
        }

        @Override
        public void stageAndApplyRuntimePermissionsBackup(UserHandle user, ParcelFileDescriptor pipe) throws RemoteException {
        }

        @Override
        public void applyStagedRuntimePermissionBackup(String packageName, UserHandle user, AndroidFuture callback) throws RemoteException {
        }

        @Override
        public void getAppPermissions(String packageName, AndroidFuture callback) throws RemoteException {
        }

        @Override
        public void revokeRuntimePermission(String packageName, String permissionName) throws RemoteException {
        }

        @Override
        public void countPermissionApps(List<String> permissionNames, int flags, AndroidFuture callback) throws RemoteException {
        }

        @Override
        public void getPermissionUsages(boolean countSystem, long numMillis, AndroidFuture callback) throws RemoteException {
        }

        @Override
        public void setRuntimePermissionGrantStateByDeviceAdminFromParams(String callerPackageName, AdminPermissionControlParams params, AndroidFuture callback) throws RemoteException {
        }

        @Override
        public void grantOrUpgradeDefaultRuntimePermissions(AndroidFuture callback) throws RemoteException {
        }

        @Override
        public void notifyOneTimePermissionSessionTimeout(String packageName) throws RemoteException {
        }

        @Override
        public void updateUserSensitiveForApp(int uid, AndroidFuture callback) throws RemoteException {
        }

        @Override
        public void getPrivilegesDescriptionStringForProfile(String deviceProfileName, AndroidFuture<String> callback) throws RemoteException {
        }

        @Override
        public void getPlatformPermissionsForGroup(String permissionGroupName, AndroidFuture<List<String>> callback) throws RemoteException {
        }

        @Override
        public void getGroupOfPlatformPermission(String permissionName, AndroidFuture<String> callback) throws RemoteException {
        }

        @Override
        public void getUnusedAppCount(AndroidFuture callback) throws RemoteException {
        }

        @Override
        public void getHibernationEligibility(String packageName, AndroidFuture callback) throws RemoteException {
        }

        @Override
        public void revokeSelfPermissionsOnKill(String packageName, List<String> permissions, AndroidFuture callback) throws RemoteException {
        }

        @Override
        public IBinder asBinder() {
            return null;
        }
    }
}

