/*
 * Decompiled with CFR 0.152.
 */
package android.print;

import android.content.ComponentName;
import android.graphics.drawable.Icon;
import android.os.Binder;
import android.os.Bundle;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.RemoteException;
import android.print.IPrintDocumentAdapter;
import android.print.IPrintJobStateChangeListener;
import android.print.IPrintServicesChangeListener;
import android.print.IPrinterDiscoveryObserver;
import android.print.PrintAttributes;
import android.print.PrintJobId;
import android.print.PrintJobInfo;
import android.print.PrinterId;
import android.printservice.PrintServiceInfo;
import android.printservice.recommendation.IRecommendationsChangeListener;
import android.printservice.recommendation.RecommendationInfo;
import java.util.ArrayList;
import java.util.List;

public interface IPrintManager
extends IInterface {
    public List<PrintJobInfo> getPrintJobInfos(int var1, int var2) throws RemoteException;

    public PrintJobInfo getPrintJobInfo(PrintJobId var1, int var2, int var3) throws RemoteException;

    public Bundle print(String var1, IPrintDocumentAdapter var2, PrintAttributes var3, String var4, int var5, int var6) throws RemoteException;

    public void cancelPrintJob(PrintJobId var1, int var2, int var3) throws RemoteException;

    public void restartPrintJob(PrintJobId var1, int var2, int var3) throws RemoteException;

    public void addPrintJobStateChangeListener(IPrintJobStateChangeListener var1, int var2, int var3) throws RemoteException;

    public void removePrintJobStateChangeListener(IPrintJobStateChangeListener var1, int var2) throws RemoteException;

    public void addPrintServicesChangeListener(IPrintServicesChangeListener var1, int var2) throws RemoteException;

    public void removePrintServicesChangeListener(IPrintServicesChangeListener var1, int var2) throws RemoteException;

    public List<PrintServiceInfo> getPrintServices(int var1, int var2) throws RemoteException;

    public void setPrintServiceEnabled(ComponentName var1, boolean var2, int var3) throws RemoteException;

    public boolean isPrintServiceEnabled(ComponentName var1, int var2) throws RemoteException;

    public void addPrintServiceRecommendationsChangeListener(IRecommendationsChangeListener var1, int var2) throws RemoteException;

    public void removePrintServiceRecommendationsChangeListener(IRecommendationsChangeListener var1, int var2) throws RemoteException;

    public List<RecommendationInfo> getPrintServiceRecommendations(int var1) throws RemoteException;

    public void createPrinterDiscoverySession(IPrinterDiscoveryObserver var1, int var2) throws RemoteException;

    public void startPrinterDiscovery(IPrinterDiscoveryObserver var1, List<PrinterId> var2, int var3) throws RemoteException;

    public void stopPrinterDiscovery(IPrinterDiscoveryObserver var1, int var2) throws RemoteException;

    public void validatePrinters(List<PrinterId> var1, int var2) throws RemoteException;

    public void startPrinterStateTracking(PrinterId var1, int var2) throws RemoteException;

    public Icon getCustomPrinterIcon(PrinterId var1, int var2) throws RemoteException;

    public void stopPrinterStateTracking(PrinterId var1, int var2) throws RemoteException;

    public void destroyPrinterDiscoverySession(IPrinterDiscoveryObserver var1, int var2) throws RemoteException;

    public boolean getBindInstantServiceAllowed(int var1) throws RemoteException;

    public void setBindInstantServiceAllowed(int var1, boolean var2) throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements IPrintManager {
        public static final String DESCRIPTOR = "android.print.IPrintManager";
        static final int TRANSACTION_getPrintJobInfos = 1;
        static final int TRANSACTION_getPrintJobInfo = 2;
        static final int TRANSACTION_print = 3;
        static final int TRANSACTION_cancelPrintJob = 4;
        static final int TRANSACTION_restartPrintJob = 5;
        static final int TRANSACTION_addPrintJobStateChangeListener = 6;
        static final int TRANSACTION_removePrintJobStateChangeListener = 7;
        static final int TRANSACTION_addPrintServicesChangeListener = 8;
        static final int TRANSACTION_removePrintServicesChangeListener = 9;
        static final int TRANSACTION_getPrintServices = 10;
        static final int TRANSACTION_setPrintServiceEnabled = 11;
        static final int TRANSACTION_isPrintServiceEnabled = 12;
        static final int TRANSACTION_addPrintServiceRecommendationsChangeListener = 13;
        static final int TRANSACTION_removePrintServiceRecommendationsChangeListener = 14;
        static final int TRANSACTION_getPrintServiceRecommendations = 15;
        static final int TRANSACTION_createPrinterDiscoverySession = 16;
        static final int TRANSACTION_startPrinterDiscovery = 17;
        static final int TRANSACTION_stopPrinterDiscovery = 18;
        static final int TRANSACTION_validatePrinters = 19;
        static final int TRANSACTION_startPrinterStateTracking = 20;
        static final int TRANSACTION_getCustomPrinterIcon = 21;
        static final int TRANSACTION_stopPrinterStateTracking = 22;
        static final int TRANSACTION_destroyPrinterDiscoverySession = 23;
        static final int TRANSACTION_getBindInstantServiceAllowed = 24;
        static final int TRANSACTION_setBindInstantServiceAllowed = 25;

        public Stub() {
            this.attachInterface(this, DESCRIPTOR);
        }

        public static IPrintManager asInterface(IBinder obj) {
            if (obj == null) {
                return null;
            }
            IInterface iin = obj.queryLocalInterface(DESCRIPTOR);
            if (iin != null && iin instanceof IPrintManager) {
                return (IPrintManager)iin;
            }
            return new Proxy(obj);
        }

        @Override
        public IBinder asBinder() {
            return this;
        }

        public static String getDefaultTransactionName(int transactionCode) {
            switch (transactionCode) {
                case 1: {
                    return "getPrintJobInfos";
                }
                case 2: {
                    return "getPrintJobInfo";
                }
                case 3: {
                    return "print";
                }
                case 4: {
                    return "cancelPrintJob";
                }
                case 5: {
                    return "restartPrintJob";
                }
                case 6: {
                    return "addPrintJobStateChangeListener";
                }
                case 7: {
                    return "removePrintJobStateChangeListener";
                }
                case 8: {
                    return "addPrintServicesChangeListener";
                }
                case 9: {
                    return "removePrintServicesChangeListener";
                }
                case 10: {
                    return "getPrintServices";
                }
                case 11: {
                    return "setPrintServiceEnabled";
                }
                case 12: {
                    return "isPrintServiceEnabled";
                }
                case 13: {
                    return "addPrintServiceRecommendationsChangeListener";
                }
                case 14: {
                    return "removePrintServiceRecommendationsChangeListener";
                }
                case 15: {
                    return "getPrintServiceRecommendations";
                }
                case 16: {
                    return "createPrinterDiscoverySession";
                }
                case 17: {
                    return "startPrinterDiscovery";
                }
                case 18: {
                    return "stopPrinterDiscovery";
                }
                case 19: {
                    return "validatePrinters";
                }
                case 20: {
                    return "startPrinterStateTracking";
                }
                case 21: {
                    return "getCustomPrinterIcon";
                }
                case 22: {
                    return "stopPrinterStateTracking";
                }
                case 23: {
                    return "destroyPrinterDiscoverySession";
                }
                case 24: {
                    return "getBindInstantServiceAllowed";
                }
                case 25: {
                    return "setBindInstantServiceAllowed";
                }
            }
            return null;
        }

        @Override
        public String getTransactionName(int transactionCode) {
            return Stub.getDefaultTransactionName(transactionCode);
        }

        @Override
        public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
            String descriptor = DESCRIPTOR;
            if (code >= 1 && code <= 0xFFFFFF) {
                data.enforceInterface(descriptor);
            }
            switch (code) {
                case 1598968902: {
                    reply.writeString(descriptor);
                    return true;
                }
            }
            switch (code) {
                case 1: {
                    int _arg0 = data.readInt();
                    int _arg1 = data.readInt();
                    data.enforceNoDataAvail();
                    List<PrintJobInfo> _result = this.getPrintJobInfos(_arg0, _arg1);
                    reply.writeNoException();
                    reply.writeTypedList(_result, 1);
                    break;
                }
                case 2: {
                    PrintJobId _arg0 = data.readTypedObject(PrintJobId.CREATOR);
                    int _arg1 = data.readInt();
                    int _arg2 = data.readInt();
                    data.enforceNoDataAvail();
                    PrintJobInfo _result = this.getPrintJobInfo(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    reply.writeTypedObject(_result, 1);
                    break;
                }
                case 3: {
                    String _arg0 = data.readString();
                    IPrintDocumentAdapter _arg1 = IPrintDocumentAdapter.Stub.asInterface(data.readStrongBinder());
                    PrintAttributes _arg2 = data.readTypedObject(PrintAttributes.CREATOR);
                    String _arg3 = data.readString();
                    int _arg4 = data.readInt();
                    int _arg5 = data.readInt();
                    data.enforceNoDataAvail();
                    Bundle _result = this.print(_arg0, _arg1, _arg2, _arg3, _arg4, _arg5);
                    reply.writeNoException();
                    reply.writeTypedObject(_result, 1);
                    break;
                }
                case 4: {
                    PrintJobId _arg0 = data.readTypedObject(PrintJobId.CREATOR);
                    int _arg1 = data.readInt();
                    int _arg2 = data.readInt();
                    data.enforceNoDataAvail();
                    this.cancelPrintJob(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    break;
                }
                case 5: {
                    PrintJobId _arg0 = data.readTypedObject(PrintJobId.CREATOR);
                    int _arg1 = data.readInt();
                    int _arg2 = data.readInt();
                    data.enforceNoDataAvail();
                    this.restartPrintJob(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    break;
                }
                case 6: {
                    IPrintJobStateChangeListener _arg0 = IPrintJobStateChangeListener.Stub.asInterface(data.readStrongBinder());
                    int _arg1 = data.readInt();
                    int _arg2 = data.readInt();
                    data.enforceNoDataAvail();
                    this.addPrintJobStateChangeListener(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    break;
                }
                case 7: {
                    IPrintJobStateChangeListener _arg0 = IPrintJobStateChangeListener.Stub.asInterface(data.readStrongBinder());
                    int _arg1 = data.readInt();
                    data.enforceNoDataAvail();
                    this.removePrintJobStateChangeListener(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                case 8: {
                    IPrintServicesChangeListener _arg0 = IPrintServicesChangeListener.Stub.asInterface(data.readStrongBinder());
                    int _arg1 = data.readInt();
                    data.enforceNoDataAvail();
                    this.addPrintServicesChangeListener(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                case 9: {
                    IPrintServicesChangeListener _arg0 = IPrintServicesChangeListener.Stub.asInterface(data.readStrongBinder());
                    int _arg1 = data.readInt();
                    data.enforceNoDataAvail();
                    this.removePrintServicesChangeListener(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                case 10: {
                    int _arg0 = data.readInt();
                    int _arg1 = data.readInt();
                    data.enforceNoDataAvail();
                    List<PrintServiceInfo> _result = this.getPrintServices(_arg0, _arg1);
                    reply.writeNoException();
                    reply.writeTypedList(_result, 1);
                    break;
                }
                case 11: {
                    ComponentName _arg0 = data.readTypedObject(ComponentName.CREATOR);
                    boolean _arg1 = data.readBoolean();
                    int _arg2 = data.readInt();
                    data.enforceNoDataAvail();
                    this.setPrintServiceEnabled(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    break;
                }
                case 12: {
                    ComponentName _arg0 = data.readTypedObject(ComponentName.CREATOR);
                    int _arg1 = data.readInt();
                    data.enforceNoDataAvail();
                    boolean _result = this.isPrintServiceEnabled(_arg0, _arg1);
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 13: {
                    IRecommendationsChangeListener _arg0 = IRecommendationsChangeListener.Stub.asInterface(data.readStrongBinder());
                    int _arg1 = data.readInt();
                    data.enforceNoDataAvail();
                    this.addPrintServiceRecommendationsChangeListener(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                case 14: {
                    IRecommendationsChangeListener _arg0 = IRecommendationsChangeListener.Stub.asInterface(data.readStrongBinder());
                    int _arg1 = data.readInt();
                    data.enforceNoDataAvail();
                    this.removePrintServiceRecommendationsChangeListener(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                case 15: {
                    int _arg0 = data.readInt();
                    data.enforceNoDataAvail();
                    List<RecommendationInfo> _result = this.getPrintServiceRecommendations(_arg0);
                    reply.writeNoException();
                    reply.writeTypedList(_result, 1);
                    break;
                }
                case 16: {
                    IPrinterDiscoveryObserver _arg0 = IPrinterDiscoveryObserver.Stub.asInterface(data.readStrongBinder());
                    int _arg1 = data.readInt();
                    data.enforceNoDataAvail();
                    this.createPrinterDiscoverySession(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                case 17: {
                    IPrinterDiscoveryObserver _arg0 = IPrinterDiscoveryObserver.Stub.asInterface(data.readStrongBinder());
                    ArrayList<PrinterId> _arg1 = data.createTypedArrayList(PrinterId.CREATOR);
                    int _arg2 = data.readInt();
                    data.enforceNoDataAvail();
                    this.startPrinterDiscovery(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    break;
                }
                case 18: {
                    IPrinterDiscoveryObserver _arg0 = IPrinterDiscoveryObserver.Stub.asInterface(data.readStrongBinder());
                    int _arg1 = data.readInt();
                    data.enforceNoDataAvail();
                    this.stopPrinterDiscovery(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                case 19: {
                    ArrayList<PrinterId> _arg0 = data.createTypedArrayList(PrinterId.CREATOR);
                    int _arg1 = data.readInt();
                    data.enforceNoDataAvail();
                    this.validatePrinters(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                case 20: {
                    PrinterId _arg0 = data.readTypedObject(PrinterId.CREATOR);
                    int _arg1 = data.readInt();
                    data.enforceNoDataAvail();
                    this.startPrinterStateTracking(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                case 21: {
                    PrinterId _arg0 = data.readTypedObject(PrinterId.CREATOR);
                    int _arg1 = data.readInt();
                    data.enforceNoDataAvail();
                    Icon _result = this.getCustomPrinterIcon(_arg0, _arg1);
                    reply.writeNoException();
                    reply.writeTypedObject(_result, 1);
                    break;
                }
                case 22: {
                    PrinterId _arg0 = data.readTypedObject(PrinterId.CREATOR);
                    int _arg1 = data.readInt();
                    data.enforceNoDataAvail();
                    this.stopPrinterStateTracking(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                case 23: {
                    IPrinterDiscoveryObserver _arg0 = IPrinterDiscoveryObserver.Stub.asInterface(data.readStrongBinder());
                    int _arg1 = data.readInt();
                    data.enforceNoDataAvail();
                    this.destroyPrinterDiscoverySession(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                case 24: {
                    int _arg0 = data.readInt();
                    data.enforceNoDataAvail();
                    boolean _result = this.getBindInstantServiceAllowed(_arg0);
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 25: {
                    int _arg0 = data.readInt();
                    boolean _arg1 = data.readBoolean();
                    data.enforceNoDataAvail();
                    this.setBindInstantServiceAllowed(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                default: {
                    return super.onTransact(code, data, reply, flags);
                }
            }
            return true;
        }

        @Override
        public int getMaxTransactionId() {
            return 24;
        }

        private static class Proxy
        implements IPrintManager {
            private IBinder mRemote;

            Proxy(IBinder remote) {
                this.mRemote = remote;
            }

            @Override
            public IBinder asBinder() {
                return this.mRemote;
            }

            public String getInterfaceDescriptor() {
                return Stub.DESCRIPTOR;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public List<PrintJobInfo> getPrintJobInfos(int appId, int userId) throws RemoteException {
                ArrayList<PrintJobInfo> _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(appId);
                    _data.writeInt(userId);
                    boolean _status = this.mRemote.transact(1, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.createTypedArrayList(PrintJobInfo.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public PrintJobInfo getPrintJobInfo(PrintJobId printJobId, int appId, int userId) throws RemoteException {
                PrintJobInfo _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedObject(printJobId, 0);
                    _data.writeInt(appId);
                    _data.writeInt(userId);
                    boolean _status = this.mRemote.transact(2, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readTypedObject(PrintJobInfo.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Bundle print(String printJobName, IPrintDocumentAdapter printAdapter, PrintAttributes attributes, String packageName, int appId, int userId) throws RemoteException {
                Bundle _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(printJobName);
                    _data.writeStrongInterface(printAdapter);
                    _data.writeTypedObject(attributes, 0);
                    _data.writeString(packageName);
                    _data.writeInt(appId);
                    _data.writeInt(userId);
                    boolean _status = this.mRemote.transact(3, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readTypedObject(Bundle.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void cancelPrintJob(PrintJobId printJobId, int appId, int userId) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedObject(printJobId, 0);
                    _data.writeInt(appId);
                    _data.writeInt(userId);
                    boolean _status = this.mRemote.transact(4, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void restartPrintJob(PrintJobId printJobId, int appId, int userId) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedObject(printJobId, 0);
                    _data.writeInt(appId);
                    _data.writeInt(userId);
                    boolean _status = this.mRemote.transact(5, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void addPrintJobStateChangeListener(IPrintJobStateChangeListener listener, int appId, int userId) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongInterface(listener);
                    _data.writeInt(appId);
                    _data.writeInt(userId);
                    boolean _status = this.mRemote.transact(6, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void removePrintJobStateChangeListener(IPrintJobStateChangeListener listener, int userId) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongInterface(listener);
                    _data.writeInt(userId);
                    boolean _status = this.mRemote.transact(7, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void addPrintServicesChangeListener(IPrintServicesChangeListener listener, int userId) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongInterface(listener);
                    _data.writeInt(userId);
                    boolean _status = this.mRemote.transact(8, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void removePrintServicesChangeListener(IPrintServicesChangeListener listener, int userId) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongInterface(listener);
                    _data.writeInt(userId);
                    boolean _status = this.mRemote.transact(9, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public List<PrintServiceInfo> getPrintServices(int selectionFlags, int userId) throws RemoteException {
                ArrayList<PrintServiceInfo> _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(selectionFlags);
                    _data.writeInt(userId);
                    boolean _status = this.mRemote.transact(10, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.createTypedArrayList(PrintServiceInfo.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setPrintServiceEnabled(ComponentName service, boolean isEnabled, int userId) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedObject(service, 0);
                    _data.writeBoolean(isEnabled);
                    _data.writeInt(userId);
                    boolean _status = this.mRemote.transact(11, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean isPrintServiceEnabled(ComponentName service, int userId) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedObject(service, 0);
                    _data.writeInt(userId);
                    boolean _status = this.mRemote.transact(12, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void addPrintServiceRecommendationsChangeListener(IRecommendationsChangeListener listener, int userId) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongInterface(listener);
                    _data.writeInt(userId);
                    boolean _status = this.mRemote.transact(13, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void removePrintServiceRecommendationsChangeListener(IRecommendationsChangeListener listener, int userId) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongInterface(listener);
                    _data.writeInt(userId);
                    boolean _status = this.mRemote.transact(14, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public List<RecommendationInfo> getPrintServiceRecommendations(int userId) throws RemoteException {
                ArrayList<RecommendationInfo> _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(userId);
                    boolean _status = this.mRemote.transact(15, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.createTypedArrayList(RecommendationInfo.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void createPrinterDiscoverySession(IPrinterDiscoveryObserver observer, int userId) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongInterface(observer);
                    _data.writeInt(userId);
                    boolean _status = this.mRemote.transact(16, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void startPrinterDiscovery(IPrinterDiscoveryObserver observer, List<PrinterId> priorityList, int userId) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongInterface(observer);
                    _data.writeTypedList(priorityList, 0);
                    _data.writeInt(userId);
                    boolean _status = this.mRemote.transact(17, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void stopPrinterDiscovery(IPrinterDiscoveryObserver observer, int userId) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongInterface(observer);
                    _data.writeInt(userId);
                    boolean _status = this.mRemote.transact(18, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void validatePrinters(List<PrinterId> printerIds, int userId) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedList(printerIds, 0);
                    _data.writeInt(userId);
                    boolean _status = this.mRemote.transact(19, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void startPrinterStateTracking(PrinterId printerId, int userId) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedObject(printerId, 0);
                    _data.writeInt(userId);
                    boolean _status = this.mRemote.transact(20, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Icon getCustomPrinterIcon(PrinterId printerId, int userId) throws RemoteException {
                Icon _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedObject(printerId, 0);
                    _data.writeInt(userId);
                    boolean _status = this.mRemote.transact(21, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readTypedObject(Icon.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void stopPrinterStateTracking(PrinterId printerId, int userId) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedObject(printerId, 0);
                    _data.writeInt(userId);
                    boolean _status = this.mRemote.transact(22, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void destroyPrinterDiscoverySession(IPrinterDiscoveryObserver observer, int userId) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongInterface(observer);
                    _data.writeInt(userId);
                    boolean _status = this.mRemote.transact(23, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean getBindInstantServiceAllowed(int userId) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(userId);
                    boolean _status = this.mRemote.transact(24, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setBindInstantServiceAllowed(int userId, boolean allowed) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(userId);
                    _data.writeBoolean(allowed);
                    boolean _status = this.mRemote.transact(25, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }
        }
    }

    public static class Default
    implements IPrintManager {
        @Override
        public List<PrintJobInfo> getPrintJobInfos(int appId, int userId) throws RemoteException {
            return null;
        }

        @Override
        public PrintJobInfo getPrintJobInfo(PrintJobId printJobId, int appId, int userId) throws RemoteException {
            return null;
        }

        @Override
        public Bundle print(String printJobName, IPrintDocumentAdapter printAdapter, PrintAttributes attributes, String packageName, int appId, int userId) throws RemoteException {
            return null;
        }

        @Override
        public void cancelPrintJob(PrintJobId printJobId, int appId, int userId) throws RemoteException {
        }

        @Override
        public void restartPrintJob(PrintJobId printJobId, int appId, int userId) throws RemoteException {
        }

        @Override
        public void addPrintJobStateChangeListener(IPrintJobStateChangeListener listener, int appId, int userId) throws RemoteException {
        }

        @Override
        public void removePrintJobStateChangeListener(IPrintJobStateChangeListener listener, int userId) throws RemoteException {
        }

        @Override
        public void addPrintServicesChangeListener(IPrintServicesChangeListener listener, int userId) throws RemoteException {
        }

        @Override
        public void removePrintServicesChangeListener(IPrintServicesChangeListener listener, int userId) throws RemoteException {
        }

        @Override
        public List<PrintServiceInfo> getPrintServices(int selectionFlags, int userId) throws RemoteException {
            return null;
        }

        @Override
        public void setPrintServiceEnabled(ComponentName service, boolean isEnabled, int userId) throws RemoteException {
        }

        @Override
        public boolean isPrintServiceEnabled(ComponentName service, int userId) throws RemoteException {
            return false;
        }

        @Override
        public void addPrintServiceRecommendationsChangeListener(IRecommendationsChangeListener listener, int userId) throws RemoteException {
        }

        @Override
        public void removePrintServiceRecommendationsChangeListener(IRecommendationsChangeListener listener, int userId) throws RemoteException {
        }

        @Override
        public List<RecommendationInfo> getPrintServiceRecommendations(int userId) throws RemoteException {
            return null;
        }

        @Override
        public void createPrinterDiscoverySession(IPrinterDiscoveryObserver observer, int userId) throws RemoteException {
        }

        @Override
        public void startPrinterDiscovery(IPrinterDiscoveryObserver observer, List<PrinterId> priorityList, int userId) throws RemoteException {
        }

        @Override
        public void stopPrinterDiscovery(IPrinterDiscoveryObserver observer, int userId) throws RemoteException {
        }

        @Override
        public void validatePrinters(List<PrinterId> printerIds, int userId) throws RemoteException {
        }

        @Override
        public void startPrinterStateTracking(PrinterId printerId, int userId) throws RemoteException {
        }

        @Override
        public Icon getCustomPrinterIcon(PrinterId printerId, int userId) throws RemoteException {
            return null;
        }

        @Override
        public void stopPrinterStateTracking(PrinterId printerId, int userId) throws RemoteException {
        }

        @Override
        public void destroyPrinterDiscoverySession(IPrinterDiscoveryObserver observer, int userId) throws RemoteException {
        }

        @Override
        public boolean getBindInstantServiceAllowed(int userId) throws RemoteException {
            return false;
        }

        @Override
        public void setBindInstantServiceAllowed(int userId, boolean allowed) throws RemoteException {
        }

        @Override
        public IBinder asBinder() {
            return null;
        }
    }
}

