/*
 * Decompiled with CFR 0.152.
 */
package android.provider;

import android.annotation.RequiresPermission;
import android.annotation.SuppressLint;
import android.annotation.SystemApi;
import android.content.ContentResolver;
import android.database.ContentObserver;
import android.net.Uri;
import android.provider.DeviceConfig_Delegate;
import android.provider.Settings;
import android.provider.WritableFlags;
import android.util.ArrayMap;
import android.util.Log;
import android.util.Pair;
import com.android.internal.annotations.GuardedBy;
import com.android.tools.layoutlib.annotations.LayoutlibDelegate;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.Executor;

@SystemApi
public class DeviceConfig {
    @SystemApi
    public static final String NAMESPACE_ACCESSIBILITY = "accessibility";
    @SystemApi
    public static final String NAMESPACE_ACTIVITY_MANAGER = "activity_manager";
    @SystemApi(client=SystemApi.Client.MODULE_LIBRARIES)
    public static final String NAMESPACE_ACTIVITY_MANAGER_COMPONENT_ALIAS = "activity_manager_ca";
    @SystemApi
    public static final String NAMESPACE_AUTO_PIN_CONFIRMATION = "auto_pin_confirmation";
    @SystemApi
    public static final String NAMESPACE_ACTIVITY_MANAGER_NATIVE_BOOT = "activity_manager_native_boot";
    @SystemApi(client=SystemApi.Client.MODULE_LIBRARIES)
    public static final String NAMESPACE_ALARM_MANAGER = "alarm_manager";
    @SystemApi
    public static final String NAMESPACE_APP_COMPAT = "app_compat";
    @SystemApi
    public static final String NAMESPACE_APP_HIBERNATION = "app_hibernation";
    @SystemApi
    public static final String NAMESPACE_APPSEARCH = "appsearch";
    @SystemApi(client=SystemApi.Client.MODULE_LIBRARIES)
    public static final String NAMESPACE_APP_STANDBY = "app_standby";
    @SystemApi(client=SystemApi.Client.MODULE_LIBRARIES)
    public static final String NAMESPACE_APP_CLONING = "app_cloning";
    @SystemApi
    public static final String NAMESPACE_ATTENTION_MANAGER_SERVICE = "attention_manager_service";
    @SystemApi
    public static final String NAMESPACE_AUTOFILL = "autofill";
    @SystemApi
    public static final String NAMESPACE_BATTERY_SAVER = "battery_saver";
    @SystemApi(client=SystemApi.Client.MODULE_LIBRARIES)
    public static final String NAMESPACE_BATTERY_STATS = "battery_stats";
    @SystemApi
    public static final String NAMESPACE_BLOBSTORE = "blobstore";
    @SystemApi
    public static final String NAMESPACE_BLUETOOTH = "bluetooth";
    @SystemApi
    public static final String NAMESPACE_CAMERA_NATIVE = "camera_native";
    @SystemApi
    public static final String NAMESPACE_CELLULAR_SECURITY = "cellular_security";
    @SystemApi
    public static final String NAMESPACE_CLIPBOARD = "clipboard";
    @SystemApi
    public static final String NAMESPACE_CONNECTIVITY = "connectivity";
    @SystemApi
    public static final String NAMESPACE_CAPTIVEPORTALLOGIN = "captive_portal_login";
    @SystemApi
    public static final String NAMESPACE_EDGETPU_NATIVE = "edgetpu_native";
    @SystemApi
    public static final String NAMESPACE_HEALTH_FITNESS = "health_fitness";
    @SystemApi
    public static final String NAMESPACE_TETHERING = "tethering";
    @SystemApi
    public static final String NAMESPACE_NEARBY = "nearby";
    @SystemApi
    public static final String NAMESPACE_CONTENT_CAPTURE = "content_capture";
    @SystemApi
    public static final String NAMESPACE_CREDENTIAL = "credential_manager";
    @SystemApi(client=SystemApi.Client.MODULE_LIBRARIES)
    public static final String NAMESPACE_DEVICE_IDLE = "device_idle";
    @Deprecated
    @SystemApi
    public static final String NAMESPACE_DEX_BOOT = "dex_boot";
    @SystemApi
    public static final String NAMESPACE_DISPLAY_MANAGER = "display_manager";
    @SystemApi
    public static final String NAMESPACE_GAME_DRIVER = "game_driver";
    @SystemApi
    public static final String NAMESPACE_HDMI_CONTROL = "hdmi_control";
    @SystemApi
    public static final String NAMESPACE_INPUT_NATIVE_BOOT = "input_native_boot";
    @SystemApi
    public static final String NAMESPACE_INTELLIGENCE_ATTENTION = "intelligence_attention";
    @SystemApi(client=SystemApi.Client.MODULE_LIBRARIES)
    public static final String NAMESPACE_INTELLIGENCE_CONTENT_SUGGESTIONS = "intelligence_content_suggestions";
    @SystemApi
    public static final String NAMESPACE_JOB_SCHEDULER = "jobscheduler";
    @SystemApi
    public static final String NAMESPACE_LMKD_NATIVE = "lmkd_native";
    @SystemApi
    public static final String NAMESPACE_LOCATION = "location";
    @SystemApi
    public static final String NAMESPACE_MEDIA = "media";
    @SystemApi
    public static final String NAMESPACE_MEDIA_NATIVE = "media_native";
    @SystemApi(client=SystemApi.Client.MODULE_LIBRARIES)
    public static final String NAMESPACE_MGLRU_NATIVE = "mglru_native";
    @SystemApi
    public static final String NAMESPACE_NETD_NATIVE = "netd_native";
    @SystemApi
    public static final String NAMESPACE_NNAPI_NATIVE = "nnapi_native";
    @SystemApi
    public static final String NAMESPACE_ON_DEVICE_PERSONALIZATION = "on_device_personalization";
    @SystemApi
    public static final String NAMESPACE_PACKAGE_MANAGER_SERVICE = "package_manager_service";
    @SystemApi
    public static final String NAMESPACE_PROFCOLLECT_NATIVE_BOOT = "profcollect_native_boot";
    @SystemApi
    public static final String NAMESPACE_REBOOT_READINESS = "reboot_readiness";
    @SystemApi(client=SystemApi.Client.MODULE_LIBRARIES)
    public static final String NAMESPACE_REMOTE_KEY_PROVISIONING_NATIVE = "remote_key_provisioning_native";
    @SystemApi
    public static final String NAMESPACE_ROLLBACK = "rollback";
    @SystemApi
    public static final String NAMESPACE_ROLLBACK_BOOT = "rollback_boot";
    @SystemApi(client=SystemApi.Client.MODULE_LIBRARIES)
    public static final String NAMESPACE_ROTATION_RESOLVER = "rotation_resolver";
    @SystemApi
    public static final String NAMESPACE_RUNTIME = "runtime";
    @SystemApi
    public static final String NAMESPACE_RUNTIME_NATIVE = "runtime_native";
    @SystemApi
    public static final String NAMESPACE_RUNTIME_NATIVE_BOOT = "runtime_native_boot";
    @SystemApi
    public static final String NAMESPACE_SCHEDULER = "scheduler";
    @SystemApi
    public static final String NAMESPACE_SDK_SANDBOX = "sdk_sandbox";
    @SystemApi(client=SystemApi.Client.MODULE_LIBRARIES)
    public static final String NAMESPACE_SETTINGS_STATS = "settings_stats";
    @SystemApi
    public static final String NAMESPACE_STATSD_JAVA = "statsd_java";
    @SystemApi
    public static final String NAMESPACE_STATSD_JAVA_BOOT = "statsd_java_boot";
    @SystemApi
    public static final String NAMESPACE_STATSD_NATIVE = "statsd_native";
    @SystemApi
    public static final String NAMESPACE_STATSD_NATIVE_BOOT = "statsd_native_boot";
    @Deprecated
    @SystemApi
    public static final String NAMESPACE_STORAGE = "storage";
    @SystemApi
    public static final String NAMESPACE_STORAGE_NATIVE_BOOT = "storage_native_boot";
    @SystemApi
    public static final String NAMESPACE_ADSERVICES = "adservices";
    @SystemApi
    public static final String NAMESPACE_SURFACE_FLINGER_NATIVE_BOOT = "surface_flinger_native_boot";
    @SystemApi
    public static final String NAMESPACE_SWCODEC_NATIVE = "swcodec_native";
    @SystemApi
    public static final String NAMESPACE_SYSTEMUI = "systemui";
    @SystemApi
    public static final String NAMESPACE_SYSTEM_TIME = "system_time";
    @SystemApi(client=SystemApi.Client.MODULE_LIBRARIES)
    public static final String NAMESPACE_TARE = "tare";
    @SystemApi
    public static final String NAMESPACE_TELEPHONY = "telephony";
    @SystemApi
    public static final String NAMESPACE_TEXTCLASSIFIER = "textclassifier";
    @SystemApi(client=SystemApi.Client.MODULE_LIBRARIES)
    public static final String NAMESPACE_CONTACTS_PROVIDER = "contacts_provider";
    @SystemApi(client=SystemApi.Client.MODULE_LIBRARIES)
    public static final String NAMESPACE_SETTINGS_UI = "settings_ui";
    @SystemApi
    public static final String NAMESPACE_ANDROID = "android";
    @SystemApi(client=SystemApi.Client.MODULE_LIBRARIES)
    public static final String NAMESPACE_WINDOW_MANAGER = "window_manager";
    @SystemApi
    public static final String NAMESPACE_WINDOW_MANAGER_NATIVE_BOOT = "window_manager_native_boot";
    @SystemApi
    public static final String NAMESPACE_SELECTION_TOOLBAR = "selection_toolbar";
    @SystemApi(client=SystemApi.Client.MODULE_LIBRARIES)
    public static final String NAMESPACE_VOICE_INTERACTION = "voice_interaction";
    @SystemApi(client=SystemApi.Client.MODULE_LIBRARIES)
    public static final String NAMESPACE_DEVICE_POLICY_MANAGER = "device_policy_manager";
    private static final List<String> PUBLIC_NAMESPACES = Arrays.asList("textclassifier", "runtime", "statsd_java", "statsd_java_boot", "selection_toolbar", "autofill", "device_policy_manager", "content_capture");
    @SystemApi
    public static final String NAMESPACE_PRIVACY = "privacy";
    @SystemApi
    public static final String NAMESPACE_BIOMETRICS = "biometrics";
    @SystemApi
    public static final String NAMESPACE_PERMISSIONS = "permissions";
    @SystemApi
    public static final String NAMESPACE_OTA = "ota";
    @SystemApi(client=SystemApi.Client.MODULE_LIBRARIES)
    public static final String NAMESPACE_WIDGET = "widget";
    @SystemApi(client=SystemApi.Client.MODULE_LIBRARIES)
    public static final String NAMESPACE_CONNECTIVITY_THERMAL_POWER_MANAGER = "connectivity_thermal_power_manager";
    @SystemApi(client=SystemApi.Client.MODULE_LIBRARIES)
    public static final String NAMESPACE_CONFIGURATION = "configuration";
    @SystemApi(client=SystemApi.Client.MODULE_LIBRARIES)
    public static final String NAMESPACE_LATENCY_TRACKER = "latency_tracker";
    @SystemApi(client=SystemApi.Client.MODULE_LIBRARIES)
    @SuppressLint(value={"IntentName"})
    public static final String NAMESPACE_INTERACTION_JANK_MONITOR = "interaction_jank_monitor";
    @SystemApi(client=SystemApi.Client.MODULE_LIBRARIES)
    public static final String NAMESPACE_GAME_OVERLAY = "game_overlay";
    @SystemApi(client=SystemApi.Client.MODULE_LIBRARIES)
    public static final String NAMESPACE_VIRTUALIZATION_FRAMEWORK_NATIVE = "virtualization_framework_native";
    @SystemApi
    public static final String NAMESPACE_CONSTRAIN_DISPLAY_APIS = "constrain_display_apis";
    @SystemApi
    public static final String NAMESPACE_APP_COMPAT_OVERRIDES = "app_compat_overrides";
    @SystemApi
    public static final String NAMESPACE_UWB = "uwb";
    @SystemApi
    public static final String NAMESPACE_AMBIENT_CONTEXT_MANAGER_SERVICE = "ambient_context_manager_service";
    @SystemApi
    public static final String NAMESPACE_WEARABLE_SENSING = "wearable_sensing";
    @SystemApi(client=SystemApi.Client.MODULE_LIBRARIES)
    public static final String NAMESPACE_VENDOR_SYSTEM_NATIVE = "vendor_system_native";
    @SystemApi(client=SystemApi.Client.MODULE_LIBRARIES)
    public static final String NAMESPACE_VENDOR_SYSTEM_NATIVE_BOOT = "vendor_system_native_boot";
    @SystemApi(client=SystemApi.Client.MODULE_LIBRARIES)
    public static final String NAMESPACE_MEMORY_SAFETY_NATIVE_BOOT = "memory_safety_native_boot";
    @SystemApi(client=SystemApi.Client.MODULE_LIBRARIES)
    public static final String NAMESPACE_MEMORY_SAFETY_NATIVE = "memory_safety_native";
    @SystemApi(client=SystemApi.Client.MODULE_LIBRARIES)
    public static final String NAMESPACE_WEAR = "wear";
    @SystemApi
    public static final String NAMESPACE_INPUT_METHOD_MANAGER = "input_method_manager";
    @SystemApi
    public static final String NAMESPACE_BACKUP_AND_RESTORE = "backup_and_restore";
    @SystemApi(client=SystemApi.Client.MODULE_LIBRARIES)
    public static final String NAMESPACE_ARC_APP_COMPAT = "arc_app_compat";
    @SystemApi
    public static final String NAMESPACE_REMOTE_AUTH = "remote_auth";
    @SystemApi
    public static final int SYNC_DISABLED_MODE_NONE = 0;
    @SystemApi
    public static final int SYNC_DISABLED_MODE_PERSISTENT = 1;
    @SystemApi
    public static final int SYNC_DISABLED_MODE_UNTIL_REBOOT = 2;
    private static final Object sLock = new Object();
    @GuardedBy(value={"sLock"})
    private static ArrayMap<OnPropertiesChangedListener, Pair<String, Executor>> sListeners = new ArrayMap();
    @GuardedBy(value={"sLock"})
    private static Map<String, Pair<ContentObserver, Integer>> sNamespaces = new HashMap<String, Pair<ContentObserver, Integer>>();
    private static final String TAG = "DeviceConfig";

    private DeviceConfig() {
    }

    @SystemApi
    @RequiresPermission(value="android.permission.READ_DEVICE_CONFIG")
    public static String getProperty_Original(String namespace, String name) {
        return DeviceConfig.getProperties(namespace, name).getString(name, null);
    }

    @LayoutlibDelegate
    public static String getProperty(String string2, String string3) {
        return DeviceConfig_Delegate.getProperty(string2, string3);
    }

    @SystemApi
    @RequiresPermission(value="android.permission.READ_DEVICE_CONFIG")
    public static Properties getProperties(String namespace, String ... names) {
        return new Properties(namespace, Settings.Config.getStrings(namespace, Arrays.asList(names)));
    }

    @SystemApi
    @RequiresPermission(value="android.permission.READ_DEVICE_CONFIG")
    public static String getString_Original(String namespace, String name, String defaultValue) {
        String value = DeviceConfig.getProperty(namespace, name);
        return value != null ? value : defaultValue;
    }

    @LayoutlibDelegate
    public static String getString(String string2, String string3, String string4) {
        return DeviceConfig_Delegate.getString(string2, string3, string4);
    }

    @SystemApi
    @RequiresPermission(value="android.permission.READ_DEVICE_CONFIG")
    public static boolean getBoolean_Original(String namespace, String name, boolean defaultValue) {
        String value = DeviceConfig.getProperty(namespace, name);
        return value != null ? Boolean.parseBoolean(value) : defaultValue;
    }

    @LayoutlibDelegate
    public static boolean getBoolean(String string2, String string3, boolean bl) {
        return DeviceConfig_Delegate.getBoolean(string2, string3, bl);
    }

    @SystemApi
    @RequiresPermission(value="android.permission.READ_DEVICE_CONFIG")
    public static int getInt_Original(String namespace, String name, int defaultValue) {
        String value = DeviceConfig.getProperty(namespace, name);
        if (value == null) {
            return defaultValue;
        }
        try {
            return Integer.parseInt(value);
        }
        catch (NumberFormatException e) {
            Log.e(TAG, "Parsing integer failed for " + namespace + ":" + name);
            return defaultValue;
        }
    }

    @LayoutlibDelegate
    public static int getInt(String string2, String string3, int n) {
        return DeviceConfig_Delegate.getInt(string2, string3, n);
    }

    @SystemApi
    @RequiresPermission(value="android.permission.READ_DEVICE_CONFIG")
    public static long getLong_Original(String namespace, String name, long defaultValue) {
        String value = DeviceConfig.getProperty(namespace, name);
        if (value == null) {
            return defaultValue;
        }
        try {
            return Long.parseLong(value);
        }
        catch (NumberFormatException e) {
            Log.e(TAG, "Parsing long failed for " + namespace + ":" + name);
            return defaultValue;
        }
    }

    @LayoutlibDelegate
    public static long getLong(String string2, String string3, long l) {
        return DeviceConfig_Delegate.getLong(string2, string3, l);
    }

    @SystemApi
    @RequiresPermission(value="android.permission.READ_DEVICE_CONFIG")
    public static float getFloat_Original(String namespace, String name, float defaultValue) {
        String value = DeviceConfig.getProperty(namespace, name);
        if (value == null) {
            return defaultValue;
        }
        try {
            return Float.parseFloat(value);
        }
        catch (NumberFormatException e) {
            Log.e(TAG, "Parsing float failed for " + namespace + ":" + name);
            return defaultValue;
        }
    }

    @LayoutlibDelegate
    public static float getFloat(String string2, String string3, float f) {
        return DeviceConfig_Delegate.getFloat(string2, string3, f);
    }

    @SystemApi
    @RequiresPermission(anyOf={"android.permission.WRITE_DEVICE_CONFIG", "android.permission.WRITE_ALLOWLISTED_DEVICE_CONFIG"})
    public static boolean setProperty(String namespace, String name, String value, boolean makeDefault) {
        return Settings.Config.putString(namespace, name, value, makeDefault);
    }

    @SystemApi
    @RequiresPermission(anyOf={"android.permission.WRITE_DEVICE_CONFIG", "android.permission.WRITE_ALLOWLISTED_DEVICE_CONFIG"})
    public static boolean setProperties(Properties properties) throws BadConfigException {
        return Settings.Config.setStrings(properties.getNamespace(), properties.mMap);
    }

    @SystemApi
    @RequiresPermission(anyOf={"android.permission.WRITE_DEVICE_CONFIG", "android.permission.WRITE_ALLOWLISTED_DEVICE_CONFIG"})
    public static boolean deleteProperty(String namespace, String name) {
        return Settings.Config.deleteString(namespace, name);
    }

    @SystemApi
    @RequiresPermission(anyOf={"android.permission.WRITE_DEVICE_CONFIG", "android.permission.WRITE_ALLOWLISTED_DEVICE_CONFIG"})
    public static void resetToDefaults(int resetMode, String namespace) {
        Settings.Config.resetToDefaults(resetMode, namespace);
    }

    @SystemApi
    @RequiresPermission(anyOf={"android.permission.WRITE_DEVICE_CONFIG", "android.permission.READ_WRITE_SYNC_DISABLED_MODE_CONFIG"})
    public static void setSyncDisabledMode(int syncDisabledMode) {
        Settings.Config.setSyncDisabledMode(syncDisabledMode);
    }

    @SystemApi
    @RequiresPermission(anyOf={"android.permission.WRITE_DEVICE_CONFIG", "android.permission.READ_WRITE_SYNC_DISABLED_MODE_CONFIG"})
    public static int getSyncDisabledMode() {
        return Settings.Config.getSyncDisabledMode();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SystemApi
    public static void addOnPropertiesChangedListener(String namespace, Executor executor, OnPropertiesChangedListener onPropertiesChangedListener) {
        Object object = sLock;
        synchronized (object) {
            Pair<String, Executor> oldNamespace = sListeners.get(onPropertiesChangedListener);
            if (oldNamespace == null) {
                sListeners.put(onPropertiesChangedListener, new Pair<String, Executor>(namespace, executor));
                DeviceConfig.incrementNamespace(namespace);
            } else if (namespace.equals(oldNamespace.first)) {
                sListeners.put(onPropertiesChangedListener, new Pair<String, Executor>(namespace, executor));
            } else {
                DeviceConfig.decrementNamespace((String)DeviceConfig.sListeners.get((Object)onPropertiesChangedListener).first);
                sListeners.put(onPropertiesChangedListener, new Pair<String, Executor>(namespace, executor));
                DeviceConfig.incrementNamespace(namespace);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SystemApi
    public static void removeOnPropertiesChangedListener(OnPropertiesChangedListener onPropertiesChangedListener) {
        Objects.requireNonNull(onPropertiesChangedListener);
        Object object = sLock;
        synchronized (object) {
            if (sListeners.containsKey(onPropertiesChangedListener)) {
                DeviceConfig.decrementNamespace((String)DeviceConfig.sListeners.get((Object)onPropertiesChangedListener).first);
                sListeners.remove(onPropertiesChangedListener);
            }
        }
    }

    @SystemApi
    @RequiresPermission(value="android.permission.MONITOR_DEVICE_CONFIG_ACCESS")
    public static void setMonitorCallback(ContentResolver resolver, Executor executor, MonitorCallback callback) {
        Settings.Config.setMonitorCallback(resolver, executor, callback);
    }

    @SystemApi
    @RequiresPermission(value="android.permission.MONITOR_DEVICE_CONFIG_ACCESS")
    public static void clearMonitorCallback(ContentResolver resolver) {
        Settings.Config.clearMonitorCallback(resolver);
    }

    @GuardedBy(value={"sLock"})
    private static void incrementNamespace(String namespace) {
        Objects.requireNonNull(namespace);
        Pair<ContentObserver, Integer> namespaceCount = sNamespaces.get(namespace);
        if (namespaceCount != null) {
            sNamespaces.put(namespace, new Pair<ContentObserver, Integer>((ContentObserver)namespaceCount.first, (Integer)namespaceCount.second + 1));
        } else {
            ContentObserver contentObserver = new ContentObserver(null){

                @Override
                public void onChange(boolean selfChange, Uri uri) {
                    if (uri != null) {
                        DeviceConfig.handleChange(uri);
                    }
                }
            };
            Settings.Config.registerContentObserver(namespace, true, contentObserver);
            sNamespaces.put(namespace, new Pair<1, Integer>(contentObserver, 1));
        }
    }

    @GuardedBy(value={"sLock"})
    private static void decrementNamespace(String namespace) {
        Objects.requireNonNull(namespace);
        Pair<ContentObserver, Integer> namespaceCount = sNamespaces.get(namespace);
        if (namespaceCount == null) {
            return;
        }
        if ((Integer)namespaceCount.second > 1) {
            sNamespaces.put(namespace, new Pair<ContentObserver, Integer>((ContentObserver)namespaceCount.first, (Integer)namespaceCount.second - 1));
        } else {
            Settings.Config.unregisterContentObserver((ContentObserver)namespaceCount.first);
            sNamespaces.remove(namespace);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void handleChange(Uri uri) {
        Objects.requireNonNull(uri);
        List<String> pathSegments = uri.getPathSegments();
        String namespace = pathSegments.get(1);
        Properties.Builder propBuilder = new Properties.Builder(namespace);
        try {
            Properties allProperties = DeviceConfig.getProperties(namespace, new String[0]);
            for (int i = 2; i < pathSegments.size(); ++i) {
                String key = pathSegments.get(i);
                propBuilder.setString(key, allProperties.getString(key, null));
            }
        }
        catch (SecurityException e) {
            Log.e(TAG, "OnPropertyChangedListener update failed: permission violation.");
            return;
        }
        Properties properties = propBuilder.build();
        Object object = sLock;
        synchronized (object) {
            for (int i = 0; i < sListeners.size(); ++i) {
                if (!namespace.equals(DeviceConfig.sListeners.valueAt((int)i).first)) continue;
                OnPropertiesChangedListener listener = sListeners.keyAt(i);
                ((Executor)DeviceConfig.sListeners.valueAt((int)i).second).execute(() -> listener.onPropertiesChanged(properties));
            }
        }
    }

    @SystemApi
    public static List<String> getPublicNamespaces() {
        return PUBLIC_NAMESPACES;
    }

    @SystemApi
    public static Set<String> getAdbWritableFlags() {
        return WritableFlags.ALLOWLIST;
    }

    @SystemApi
    public static class Properties {
        private final String mNamespace;
        private final HashMap<String, String> mMap;
        private Set<String> mKeyset;

        @SystemApi(client=SystemApi.Client.MODULE_LIBRARIES)
        public Properties(String namespace, Map<String, String> keyValueMap) {
            Objects.requireNonNull(namespace);
            this.mNamespace = namespace;
            this.mMap = new HashMap();
            if (keyValueMap != null) {
                this.mMap.putAll(keyValueMap);
            }
        }

        public String getNamespace() {
            return this.mNamespace;
        }

        public Set<String> getKeyset() {
            if (this.mKeyset == null) {
                this.mKeyset = Collections.unmodifiableSet(this.mMap.keySet());
            }
            return this.mKeyset;
        }

        public String getString(String name, String defaultValue) {
            Objects.requireNonNull(name);
            String value = this.mMap.get(name);
            return value != null ? value : defaultValue;
        }

        public boolean getBoolean(String name, boolean defaultValue) {
            Objects.requireNonNull(name);
            String value = this.mMap.get(name);
            return value != null ? Boolean.parseBoolean(value) : defaultValue;
        }

        public int getInt(String name, int defaultValue) {
            Objects.requireNonNull(name);
            String value = this.mMap.get(name);
            if (value == null) {
                return defaultValue;
            }
            try {
                return Integer.parseInt(value);
            }
            catch (NumberFormatException e) {
                Log.e(DeviceConfig.TAG, "Parsing int failed for " + name);
                return defaultValue;
            }
        }

        public long getLong(String name, long defaultValue) {
            Objects.requireNonNull(name);
            String value = this.mMap.get(name);
            if (value == null) {
                return defaultValue;
            }
            try {
                return Long.parseLong(value);
            }
            catch (NumberFormatException e) {
                Log.e(DeviceConfig.TAG, "Parsing long failed for " + name);
                return defaultValue;
            }
        }

        public float getFloat(String name, float defaultValue) {
            Objects.requireNonNull(name);
            String value = this.mMap.get(name);
            if (value == null) {
                return defaultValue;
            }
            try {
                return Float.parseFloat(value);
            }
            catch (NumberFormatException e) {
                Log.e(DeviceConfig.TAG, "Parsing float failed for " + name);
                return defaultValue;
            }
        }

        public static class Builder {
            private final String mNamespace;
            private final Map<String, String> mKeyValues = new HashMap<String, String>();

            public Builder(String namespace) {
                this.mNamespace = namespace;
            }

            public Builder setString(String name, String value) {
                this.mKeyValues.put(name, value);
                return this;
            }

            public Builder setBoolean(String name, boolean value) {
                this.mKeyValues.put(name, Boolean.toString(value));
                return this;
            }

            public Builder setInt(String name, int value) {
                this.mKeyValues.put(name, Integer.toString(value));
                return this;
            }

            public Builder setLong(String name, long value) {
                this.mKeyValues.put(name, Long.toString(value));
                return this;
            }

            public Builder setFloat(String name, float value) {
                this.mKeyValues.put(name, Float.toString(value));
                return this;
            }

            public Properties build() {
                return new Properties(this.mNamespace, this.mKeyValues);
            }
        }
    }

    @SystemApi
    public static interface MonitorCallback {
        @SystemApi
        public void onNamespaceUpdate(String var1);

        @SystemApi
        public void onDeviceConfigAccess(String var1, String var2);
    }

    @SystemApi
    public static interface OnPropertiesChangedListener {
        public void onPropertiesChanged(Properties var1);
    }

    @SystemApi
    public static class BadConfigException
    extends Exception {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    @Target(value={ElementType.TYPE_PARAMETER, ElementType.TYPE_USE})
    public static @interface SyncDisabledMode {
    }
}

