/*
 * Decompiled with CFR 0.152.
 */
package android.safetycenter;

import android.os.Binder;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.RemoteException;
import android.safetycenter.IOnSafetyCenterDataChangedListener;
import android.safetycenter.SafetyCenterData;
import android.safetycenter.SafetyEvent;
import android.safetycenter.SafetySourceData;
import android.safetycenter.SafetySourceErrorDetails;
import android.safetycenter.config.SafetyCenterConfig;
import java.util.ArrayList;
import java.util.List;

public interface ISafetyCenterManager
extends IInterface {
    public static final String DESCRIPTOR = "android.safetycenter.ISafetyCenterManager";

    public boolean isSafetyCenterEnabled() throws RemoteException;

    public void setSafetySourceData(String var1, SafetySourceData var2, SafetyEvent var3, String var4, int var5) throws RemoteException;

    public SafetySourceData getSafetySourceData(String var1, String var2, int var3) throws RemoteException;

    public void reportSafetySourceError(String var1, SafetySourceErrorDetails var2, String var3, int var4) throws RemoteException;

    public void refreshSafetySources(int var1, int var2) throws RemoteException;

    public void refreshSpecificSafetySources(int var1, int var2, List<String> var3) throws RemoteException;

    public SafetyCenterConfig getSafetyCenterConfig() throws RemoteException;

    public SafetyCenterData getSafetyCenterData(String var1, int var2) throws RemoteException;

    public void addOnSafetyCenterDataChangedListener(IOnSafetyCenterDataChangedListener var1, String var2, int var3) throws RemoteException;

    public void removeOnSafetyCenterDataChangedListener(IOnSafetyCenterDataChangedListener var1, int var2) throws RemoteException;

    public void dismissSafetyCenterIssue(String var1, int var2) throws RemoteException;

    public void executeSafetyCenterIssueAction(String var1, String var2, int var3) throws RemoteException;

    public void clearAllSafetySourceDataForTests() throws RemoteException;

    public void setSafetyCenterConfigForTests(SafetyCenterConfig var1) throws RemoteException;

    public void clearSafetyCenterConfigForTests() throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements ISafetyCenterManager {
        static final int TRANSACTION_isSafetyCenterEnabled = 1;
        static final int TRANSACTION_setSafetySourceData = 2;
        static final int TRANSACTION_getSafetySourceData = 3;
        static final int TRANSACTION_reportSafetySourceError = 4;
        static final int TRANSACTION_refreshSafetySources = 5;
        static final int TRANSACTION_refreshSpecificSafetySources = 6;
        static final int TRANSACTION_getSafetyCenterConfig = 7;
        static final int TRANSACTION_getSafetyCenterData = 8;
        static final int TRANSACTION_addOnSafetyCenterDataChangedListener = 9;
        static final int TRANSACTION_removeOnSafetyCenterDataChangedListener = 10;
        static final int TRANSACTION_dismissSafetyCenterIssue = 11;
        static final int TRANSACTION_executeSafetyCenterIssueAction = 12;
        static final int TRANSACTION_clearAllSafetySourceDataForTests = 13;
        static final int TRANSACTION_setSafetyCenterConfigForTests = 14;
        static final int TRANSACTION_clearSafetyCenterConfigForTests = 15;

        public Stub() {
            this.attachInterface(this, ISafetyCenterManager.DESCRIPTOR);
        }

        public static ISafetyCenterManager asInterface(IBinder obj) {
            if (obj == null) {
                return null;
            }
            IInterface iin = obj.queryLocalInterface(ISafetyCenterManager.DESCRIPTOR);
            if (iin != null && iin instanceof ISafetyCenterManager) {
                return (ISafetyCenterManager)iin;
            }
            return new Proxy(obj);
        }

        @Override
        public IBinder asBinder() {
            return this;
        }

        public static String getDefaultTransactionName(int transactionCode) {
            switch (transactionCode) {
                case 1: {
                    return "isSafetyCenterEnabled";
                }
                case 2: {
                    return "setSafetySourceData";
                }
                case 3: {
                    return "getSafetySourceData";
                }
                case 4: {
                    return "reportSafetySourceError";
                }
                case 5: {
                    return "refreshSafetySources";
                }
                case 6: {
                    return "refreshSpecificSafetySources";
                }
                case 7: {
                    return "getSafetyCenterConfig";
                }
                case 8: {
                    return "getSafetyCenterData";
                }
                case 9: {
                    return "addOnSafetyCenterDataChangedListener";
                }
                case 10: {
                    return "removeOnSafetyCenterDataChangedListener";
                }
                case 11: {
                    return "dismissSafetyCenterIssue";
                }
                case 12: {
                    return "executeSafetyCenterIssueAction";
                }
                case 13: {
                    return "clearAllSafetySourceDataForTests";
                }
                case 14: {
                    return "setSafetyCenterConfigForTests";
                }
                case 15: {
                    return "clearSafetyCenterConfigForTests";
                }
            }
            return null;
        }

        @Override
        public String getTransactionName(int transactionCode) {
            return Stub.getDefaultTransactionName(transactionCode);
        }

        @Override
        public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
            String descriptor = ISafetyCenterManager.DESCRIPTOR;
            if (code >= 1 && code <= 0xFFFFFF) {
                data.enforceInterface(descriptor);
            }
            switch (code) {
                case 1598968902: {
                    reply.writeString(descriptor);
                    return true;
                }
            }
            switch (code) {
                case 1: {
                    boolean _result = this.isSafetyCenterEnabled();
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 2: {
                    String _arg0 = data.readString();
                    SafetySourceData _arg1 = data.readTypedObject(SafetySourceData.CREATOR);
                    SafetyEvent _arg2 = data.readTypedObject(SafetyEvent.CREATOR);
                    String _arg3 = data.readString();
                    int _arg4 = data.readInt();
                    this.setSafetySourceData(_arg0, _arg1, _arg2, _arg3, _arg4);
                    reply.writeNoException();
                    break;
                }
                case 3: {
                    String _arg0 = data.readString();
                    String _arg1 = data.readString();
                    int _arg2 = data.readInt();
                    SafetySourceData _result = this.getSafetySourceData(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    reply.writeTypedObject(_result, 1);
                    break;
                }
                case 4: {
                    String _arg0 = data.readString();
                    SafetySourceErrorDetails _arg1 = data.readTypedObject(SafetySourceErrorDetails.CREATOR);
                    String _arg2 = data.readString();
                    int _arg3 = data.readInt();
                    this.reportSafetySourceError(_arg0, _arg1, _arg2, _arg3);
                    reply.writeNoException();
                    break;
                }
                case 5: {
                    int _arg0 = data.readInt();
                    int _arg1 = data.readInt();
                    this.refreshSafetySources(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                case 6: {
                    int _arg0 = data.readInt();
                    int _arg1 = data.readInt();
                    ArrayList<String> _arg2 = data.createStringArrayList();
                    this.refreshSpecificSafetySources(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    break;
                }
                case 7: {
                    SafetyCenterConfig _result = this.getSafetyCenterConfig();
                    reply.writeNoException();
                    reply.writeTypedObject(_result, 1);
                    break;
                }
                case 8: {
                    String _arg0 = data.readString();
                    int _arg1 = data.readInt();
                    SafetyCenterData _result = this.getSafetyCenterData(_arg0, _arg1);
                    reply.writeNoException();
                    reply.writeTypedObject(_result, 1);
                    break;
                }
                case 9: {
                    IOnSafetyCenterDataChangedListener _arg0 = IOnSafetyCenterDataChangedListener.Stub.asInterface(data.readStrongBinder());
                    String _arg1 = data.readString();
                    int _arg2 = data.readInt();
                    this.addOnSafetyCenterDataChangedListener(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    break;
                }
                case 10: {
                    IOnSafetyCenterDataChangedListener _arg0 = IOnSafetyCenterDataChangedListener.Stub.asInterface(data.readStrongBinder());
                    int _arg1 = data.readInt();
                    this.removeOnSafetyCenterDataChangedListener(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                case 11: {
                    String _arg0 = data.readString();
                    int _arg1 = data.readInt();
                    this.dismissSafetyCenterIssue(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                case 12: {
                    String _arg0 = data.readString();
                    String _arg1 = data.readString();
                    int _arg2 = data.readInt();
                    this.executeSafetyCenterIssueAction(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    break;
                }
                case 13: {
                    this.clearAllSafetySourceDataForTests();
                    reply.writeNoException();
                    break;
                }
                case 14: {
                    SafetyCenterConfig _arg0 = data.readTypedObject(SafetyCenterConfig.CREATOR);
                    this.setSafetyCenterConfigForTests(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 15: {
                    this.clearSafetyCenterConfigForTests();
                    reply.writeNoException();
                    break;
                }
                default: {
                    return super.onTransact(code, data, reply, flags);
                }
            }
            return true;
        }

        @Override
        public int getMaxTransactionId() {
            return 14;
        }

        private static class Proxy
        implements ISafetyCenterManager {
            private IBinder mRemote;

            Proxy(IBinder remote) {
                this.mRemote = remote;
            }

            @Override
            public IBinder asBinder() {
                return this.mRemote;
            }

            public String getInterfaceDescriptor() {
                return ISafetyCenterManager.DESCRIPTOR;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean isSafetyCenterEnabled() throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(ISafetyCenterManager.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(1, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setSafetySourceData(String sourceId, SafetySourceData safetySourceData, SafetyEvent safetyEvent, String packageName, int userId) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(ISafetyCenterManager.DESCRIPTOR);
                    _data.writeString(sourceId);
                    _data.writeTypedObject(safetySourceData, 0);
                    _data.writeTypedObject(safetyEvent, 0);
                    _data.writeString(packageName);
                    _data.writeInt(userId);
                    boolean _status = this.mRemote.transact(2, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public SafetySourceData getSafetySourceData(String safetySourceId, String packageName, int userId) throws RemoteException {
                SafetySourceData _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(ISafetyCenterManager.DESCRIPTOR);
                    _data.writeString(safetySourceId);
                    _data.writeString(packageName);
                    _data.writeInt(userId);
                    boolean _status = this.mRemote.transact(3, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readTypedObject(SafetySourceData.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void reportSafetySourceError(String safetySourceId, SafetySourceErrorDetails safetySourceErrorDetails, String packageName, int userId) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(ISafetyCenterManager.DESCRIPTOR);
                    _data.writeString(safetySourceId);
                    _data.writeTypedObject(safetySourceErrorDetails, 0);
                    _data.writeString(packageName);
                    _data.writeInt(userId);
                    boolean _status = this.mRemote.transact(4, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void refreshSafetySources(int refreshReason, int userId) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(ISafetyCenterManager.DESCRIPTOR);
                    _data.writeInt(refreshReason);
                    _data.writeInt(userId);
                    boolean _status = this.mRemote.transact(5, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void refreshSpecificSafetySources(int refreshReason, int userId, List<String> safetySourceIds) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(ISafetyCenterManager.DESCRIPTOR);
                    _data.writeInt(refreshReason);
                    _data.writeInt(userId);
                    _data.writeStringList(safetySourceIds);
                    boolean _status = this.mRemote.transact(6, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public SafetyCenterConfig getSafetyCenterConfig() throws RemoteException {
                SafetyCenterConfig _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(ISafetyCenterManager.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(7, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readTypedObject(SafetyCenterConfig.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public SafetyCenterData getSafetyCenterData(String packageName, int userId) throws RemoteException {
                SafetyCenterData _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(ISafetyCenterManager.DESCRIPTOR);
                    _data.writeString(packageName);
                    _data.writeInt(userId);
                    boolean _status = this.mRemote.transact(8, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readTypedObject(SafetyCenterData.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void addOnSafetyCenterDataChangedListener(IOnSafetyCenterDataChangedListener listener, String packageName, int userId) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(ISafetyCenterManager.DESCRIPTOR);
                    _data.writeStrongInterface(listener);
                    _data.writeString(packageName);
                    _data.writeInt(userId);
                    boolean _status = this.mRemote.transact(9, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void removeOnSafetyCenterDataChangedListener(IOnSafetyCenterDataChangedListener listener, int userId) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(ISafetyCenterManager.DESCRIPTOR);
                    _data.writeStrongInterface(listener);
                    _data.writeInt(userId);
                    boolean _status = this.mRemote.transact(10, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void dismissSafetyCenterIssue(String issueId, int userId) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(ISafetyCenterManager.DESCRIPTOR);
                    _data.writeString(issueId);
                    _data.writeInt(userId);
                    boolean _status = this.mRemote.transact(11, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void executeSafetyCenterIssueAction(String safetyCenterIssueId, String safetyCenterIssueActionId, int userId) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(ISafetyCenterManager.DESCRIPTOR);
                    _data.writeString(safetyCenterIssueId);
                    _data.writeString(safetyCenterIssueActionId);
                    _data.writeInt(userId);
                    boolean _status = this.mRemote.transact(12, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void clearAllSafetySourceDataForTests() throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(ISafetyCenterManager.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(13, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setSafetyCenterConfigForTests(SafetyCenterConfig safetyCenterConfig) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(ISafetyCenterManager.DESCRIPTOR);
                    _data.writeTypedObject(safetyCenterConfig, 0);
                    boolean _status = this.mRemote.transact(14, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void clearSafetyCenterConfigForTests() throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(ISafetyCenterManager.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(15, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }
        }
    }

    public static class Default
    implements ISafetyCenterManager {
        @Override
        public boolean isSafetyCenterEnabled() throws RemoteException {
            return false;
        }

        @Override
        public void setSafetySourceData(String sourceId, SafetySourceData safetySourceData, SafetyEvent safetyEvent, String packageName, int userId) throws RemoteException {
        }

        @Override
        public SafetySourceData getSafetySourceData(String safetySourceId, String packageName, int userId) throws RemoteException {
            return null;
        }

        @Override
        public void reportSafetySourceError(String safetySourceId, SafetySourceErrorDetails safetySourceErrorDetails, String packageName, int userId) throws RemoteException {
        }

        @Override
        public void refreshSafetySources(int refreshReason, int userId) throws RemoteException {
        }

        @Override
        public void refreshSpecificSafetySources(int refreshReason, int userId, List<String> safetySourceIds) throws RemoteException {
        }

        @Override
        public SafetyCenterConfig getSafetyCenterConfig() throws RemoteException {
            return null;
        }

        @Override
        public SafetyCenterData getSafetyCenterData(String packageName, int userId) throws RemoteException {
            return null;
        }

        @Override
        public void addOnSafetyCenterDataChangedListener(IOnSafetyCenterDataChangedListener listener, String packageName, int userId) throws RemoteException {
        }

        @Override
        public void removeOnSafetyCenterDataChangedListener(IOnSafetyCenterDataChangedListener listener, int userId) throws RemoteException {
        }

        @Override
        public void dismissSafetyCenterIssue(String issueId, int userId) throws RemoteException {
        }

        @Override
        public void executeSafetyCenterIssueAction(String safetyCenterIssueId, String safetyCenterIssueActionId, int userId) throws RemoteException {
        }

        @Override
        public void clearAllSafetySourceDataForTests() throws RemoteException {
        }

        @Override
        public void setSafetyCenterConfigForTests(SafetyCenterConfig safetyCenterConfig) throws RemoteException {
        }

        @Override
        public void clearSafetyCenterConfigForTests() throws RemoteException {
        }

        @Override
        public IBinder asBinder() {
            return null;
        }
    }
}

