/*
 * Decompiled with CFR 0.152.
 */
package android.safetycenter;

import android.annotation.SystemApi;
import android.os.Parcel;
import android.os.Parcelable;
import android.text.TextUtils;
import androidx.annotation.RequiresApi;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.Objects;

@SystemApi
@RequiresApi(value=33)
public class SafetyCenterStatus
implements Parcelable {
    public static final int OVERALL_SEVERITY_LEVEL_UNKNOWN = 1000;
    public static final int OVERALL_SEVERITY_LEVEL_OK = 1100;
    public static final int OVERALL_SEVERITY_LEVEL_RECOMMENDATION = 1200;
    public static final int OVERALL_SEVERITY_LEVEL_CRITICAL_WARNING = 1300;
    public static final int REFRESH_STATUS_NONE = 0;
    public static final int REFRESH_STATUS_DATA_FETCH_IN_PROGRESS = 10100;
    public static final int REFRESH_STATUS_FULL_RESCAN_IN_PROGRESS = 10200;
    public static final Parcelable.Creator<SafetyCenterStatus> CREATOR = new Parcelable.Creator<SafetyCenterStatus>(){

        @Override
        public SafetyCenterStatus createFromParcel(Parcel in) {
            CharSequence title = TextUtils.CHAR_SEQUENCE_CREATOR.createFromParcel(in);
            CharSequence summary = TextUtils.CHAR_SEQUENCE_CREATOR.createFromParcel(in);
            return new Builder(title, summary).setSeverityLevel(in.readInt()).setRefreshStatus(in.readInt()).build();
        }

        public SafetyCenterStatus[] newArray(int size) {
            return new SafetyCenterStatus[size];
        }
    };
    private final CharSequence mTitle;
    private final CharSequence mSummary;
    private final int mSeverityLevel;
    private final int mRefreshStatus;

    private SafetyCenterStatus(CharSequence title, CharSequence summary, int severityLevel, int refreshStatus) {
        this.mTitle = title;
        this.mSummary = summary;
        this.mSeverityLevel = severityLevel;
        this.mRefreshStatus = refreshStatus;
    }

    public CharSequence getTitle() {
        return this.mTitle;
    }

    public CharSequence getSummary() {
        return this.mSummary;
    }

    public int getSeverityLevel() {
        return this.mSeverityLevel;
    }

    public int getRefreshStatus() {
        return this.mRefreshStatus;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof SafetyCenterStatus)) {
            return false;
        }
        SafetyCenterStatus that = (SafetyCenterStatus)o;
        return this.mSeverityLevel == that.mSeverityLevel && this.mRefreshStatus == that.mRefreshStatus && TextUtils.equals(this.mTitle, that.mTitle) && TextUtils.equals(this.mSummary, that.mSummary);
    }

    public int hashCode() {
        return Objects.hash(this.mTitle, this.mSummary, this.mSeverityLevel, this.mRefreshStatus);
    }

    public String toString() {
        return "SafetyCenterStatus{mTitle=" + this.mTitle + ", mSummary=" + this.mSummary + ", mSeverityLevel=" + this.mSeverityLevel + ", mRefreshStatus=" + this.mRefreshStatus + '}';
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        TextUtils.writeToParcel(this.mTitle, dest, flags);
        TextUtils.writeToParcel(this.mSummary, dest, flags);
        dest.writeInt(this.mSeverityLevel);
        dest.writeInt(this.mRefreshStatus);
    }

    private static int validateOverallSeverityLevel(int value) {
        switch (value) {
            case 1000: 
            case 1100: 
            case 1200: 
            case 1300: {
                return value;
            }
        }
        throw new IllegalArgumentException("Unexpected OverallSeverityLevel for SafetyCenterStatus: " + value);
    }

    private static int validateRefreshStatus(int value) {
        switch (value) {
            case 0: 
            case 10100: 
            case 10200: {
                return value;
            }
        }
        throw new IllegalArgumentException("Unexpected RefreshStatus for SafetyCenterStatus: " + value);
    }

    public static class Builder {
        private CharSequence mTitle;
        private CharSequence mSummary;
        private int mSeverityLevel = 1000;
        private int mRefreshStatus = 0;

        public Builder(CharSequence title, CharSequence summary) {
            this.mTitle = Objects.requireNonNull(title);
            this.mSummary = Objects.requireNonNull(summary);
        }

        public Builder(SafetyCenterStatus safetyCenterStatus) {
            this.mTitle = safetyCenterStatus.mTitle;
            this.mSummary = safetyCenterStatus.mSummary;
            this.mSeverityLevel = safetyCenterStatus.mSeverityLevel;
            this.mRefreshStatus = safetyCenterStatus.mRefreshStatus;
        }

        public Builder setTitle(CharSequence title) {
            this.mTitle = Objects.requireNonNull(title);
            return this;
        }

        public Builder setSummary(CharSequence summary) {
            this.mSummary = Objects.requireNonNull(summary);
            return this;
        }

        public Builder setSeverityLevel(int severityLevel) {
            this.mSeverityLevel = SafetyCenterStatus.validateOverallSeverityLevel(severityLevel);
            return this;
        }

        public Builder setRefreshStatus(int refreshStatus) {
            this.mRefreshStatus = SafetyCenterStatus.validateRefreshStatus(refreshStatus);
            return this;
        }

        public SafetyCenterStatus build() {
            return new SafetyCenterStatus(this.mTitle, this.mSummary, this.mSeverityLevel, this.mRefreshStatus);
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface RefreshStatus {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface OverallSeverityLevel {
    }
}

