/*
 * Decompiled with CFR 0.152.
 */
package android.safetycenter.config;

import androidx.annotation.RequiresApi;
import java.util.Collection;
import java.util.Objects;
import java.util.regex.Pattern;

@RequiresApi(value=33)
class BuilderUtils {
    private BuilderUtils() {
    }

    private static void validateAttribute(Object attribute, String name, boolean required, boolean prohibited, Object defaultValue) {
        boolean checkProhibited;
        if (attribute == null && required) {
            BuilderUtils.throwRequiredAttributeMissing(name);
        }
        boolean nonDefaultValueProvided = !Objects.equals(attribute, defaultValue);
        boolean bl = checkProhibited = prohibited && nonDefaultValueProvided;
        if (attribute != null && checkProhibited) {
            BuilderUtils.throwProhibitedAttributePresent(name);
        }
    }

    static void validateAttribute(Object attribute, String name, boolean required, boolean prohibited) {
        BuilderUtils.validateAttribute(attribute, name, required, prohibited, null);
    }

    static void validateId(String id2, String name, boolean required, boolean prohibited) {
        BuilderUtils.validateAttribute(id2, name, required, prohibited, null);
        if (!Pattern.compile("[0-9a-zA-Z_]+").matcher(id2).matches()) {
            throw new IllegalStateException("Attribute " + name + " invalid");
        }
    }

    static int validateResId(Integer value, String name, boolean required, boolean prohibited) {
        BuilderUtils.validateAttribute(value, name, required, prohibited, 0);
        if (value == null) {
            return 0;
        }
        if (required && value == 0) {
            BuilderUtils.throwRequiredAttributeInvalid(name);
        }
        return value;
    }

    static int validateIntDef(Integer value, String name, boolean required, boolean prohibited, int defaultValue, int ... validValues) {
        BuilderUtils.validateAttribute(value, name, required, prohibited, defaultValue);
        if (value == null) {
            return defaultValue;
        }
        boolean found = false;
        for (int i = 0; i < validValues.length; ++i) {
            found |= value == validValues[i];
        }
        if (!found) {
            throw new IllegalStateException("Attribute " + name + " invalid");
        }
        return value;
    }

    static int validateInteger(Integer value, String name, boolean required, boolean prohibited, int defaultValue) {
        BuilderUtils.validateAttribute(value, name, required, prohibited, defaultValue);
        if (value == null) {
            return defaultValue;
        }
        return value;
    }

    static boolean validateBoolean(Boolean value, String name, boolean required, boolean prohibited, boolean defaultValue) {
        BuilderUtils.validateAttribute(value, name, required, prohibited, defaultValue);
        if (value == null) {
            return defaultValue;
        }
        return value;
    }

    static <T> void validateCollection(Collection<T> value, String name, boolean required, boolean prohibited) {
        if (value.isEmpty() && required) {
            BuilderUtils.throwRequiredAttributeMissing(name);
        }
        if (!value.isEmpty() && prohibited) {
            BuilderUtils.throwProhibitedAttributePresent(name);
        }
    }

    static void throwRequiredAttributeMissing(String attribute) {
        throw new IllegalStateException("Required attribute " + attribute + " missing");
    }

    static void throwProhibitedAttributePresent(String attribute) {
        throw new IllegalStateException("Prohibited attribute " + attribute + " present");
    }

    static void throwRequiredAttributeInvalid(String attribute) {
        throw new IllegalStateException("Required attribute " + attribute + " invalid");
    }
}

