/*
 * Decompiled with CFR 0.152.
 */
package android.safetycenter.config;

import android.annotation.SystemApi;
import android.os.Parcel;
import android.os.Parcelable;
import android.permission.jarjar.com.android.modules.utils.build.SdkLevel;
import android.safetycenter.config.BuilderUtils;
import android.util.ArraySet;
import androidx.annotation.RequiresApi;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Set;

@SystemApi
@RequiresApi(value=33)
public class SafetySource
implements Parcelable {
    public static final int SAFETY_SOURCE_TYPE_STATIC = 1;
    public static final int SAFETY_SOURCE_TYPE_DYNAMIC = 2;
    public static final int SAFETY_SOURCE_TYPE_ISSUE_ONLY = 3;
    public static final int PROFILE_NONE = 0;
    public static final int PROFILE_PRIMARY = 1;
    public static final int PROFILE_ALL = 2;
    public static final int INITIAL_DISPLAY_STATE_ENABLED = 0;
    public static final int INITIAL_DISPLAY_STATE_DISABLED = 1;
    public static final int INITIAL_DISPLAY_STATE_HIDDEN = 2;
    public static final Parcelable.Creator<SafetySource> CREATOR = new Parcelable.Creator<SafetySource>(){

        @Override
        public SafetySource createFromParcel(Parcel in) {
            int type = in.readInt();
            Builder builder = new Builder(type).setId(in.readString()).setPackageName(in.readString()).setTitleResId(in.readInt()).setTitleForWorkResId(in.readInt()).setSummaryResId(in.readInt()).setIntentAction(in.readString()).setProfile(in.readInt()).setInitialDisplayState(in.readInt()).setMaxSeverityLevel(in.readInt()).setSearchTermsResId(in.readInt()).setLoggingAllowed(in.readBoolean()).setRefreshOnPageOpenAllowed(in.readBoolean());
            if (SdkLevel.isAtLeastU()) {
                builder.setNotificationsAllowed(in.readBoolean());
                builder.setDeduplicationGroup(in.readString());
                ArrayList<String> certs = in.createStringArrayList();
                for (int i = 0; i < certs.size(); ++i) {
                    builder.addPackageCertificateHash((String)certs.get(i));
                }
            }
            return builder.build();
        }

        public SafetySource[] newArray(int size) {
            return new SafetySource[size];
        }
    };
    private final int mType;
    private final String mId;
    private final String mPackageName;
    private final int mTitleResId;
    private final int mTitleForWorkResId;
    private final int mSummaryResId;
    private final String mIntentAction;
    private final int mProfile;
    private final int mInitialDisplayState;
    private final int mMaxSeverityLevel;
    private final int mSearchTermsResId;
    private final boolean mLoggingAllowed;
    private final boolean mRefreshOnPageOpenAllowed;
    private final boolean mNotificationsAllowed;
    final String mDeduplicationGroup;
    private final Set<String> mPackageCertificateHashes;

    private SafetySource(int type, String id2, String packageName, int titleResId, int titleForWorkResId, int summaryResId, String intentAction, int profile, int initialDisplayState, int maxSeverityLevel, int searchTermsResId, boolean loggingAllowed, boolean refreshOnPageOpenAllowed, boolean notificationsAllowed, String deduplicationGroup, Set<String> packageCertificateHashes) {
        this.mType = type;
        this.mId = id2;
        this.mPackageName = packageName;
        this.mTitleResId = titleResId;
        this.mTitleForWorkResId = titleForWorkResId;
        this.mSummaryResId = summaryResId;
        this.mIntentAction = intentAction;
        this.mProfile = profile;
        this.mInitialDisplayState = initialDisplayState;
        this.mMaxSeverityLevel = maxSeverityLevel;
        this.mSearchTermsResId = searchTermsResId;
        this.mLoggingAllowed = loggingAllowed;
        this.mRefreshOnPageOpenAllowed = refreshOnPageOpenAllowed;
        this.mNotificationsAllowed = notificationsAllowed;
        this.mDeduplicationGroup = deduplicationGroup;
        this.mPackageCertificateHashes = Set.copyOf(packageCertificateHashes);
    }

    public int getType() {
        return this.mType;
    }

    public String getId() {
        return this.mId;
    }

    public String getPackageName() {
        if (this.mType == 1) {
            throw new UnsupportedOperationException("getPackageName unsupported for static safety source");
        }
        return this.mPackageName;
    }

    @RequiresApi(value=34)
    public String getOptionalPackageName() {
        if (!SdkLevel.isAtLeastU()) {
            throw new UnsupportedOperationException();
        }
        return this.mPackageName;
    }

    public int getTitleResId() {
        if (this.mType == 3) {
            throw new UnsupportedOperationException("getTitleResId unsupported for issue-only safety source");
        }
        return this.mTitleResId;
    }

    public int getTitleForWorkResId() {
        if (this.mType == 3) {
            throw new UnsupportedOperationException("getTitleForWorkResId unsupported for issue-only safety source");
        }
        if (this.mProfile == 1) {
            throw new UnsupportedOperationException("getTitleForWorkResId unsupported for primary profile safety source");
        }
        return this.mTitleForWorkResId;
    }

    public int getSummaryResId() {
        if (this.mType == 3) {
            throw new UnsupportedOperationException("getSummaryResId unsupported for issue-only safety source");
        }
        return this.mSummaryResId;
    }

    public String getIntentAction() {
        if (this.mType == 3) {
            throw new UnsupportedOperationException("getIntentAction unsupported for issue-only safety source");
        }
        return this.mIntentAction;
    }

    public int getProfile() {
        return this.mProfile;
    }

    public int getInitialDisplayState() {
        if (this.mType == 1) {
            throw new UnsupportedOperationException("getInitialDisplayState unsupported for static safety source");
        }
        if (this.mType == 3) {
            throw new UnsupportedOperationException("getInitialDisplayState unsupported for issue-only safety source");
        }
        return this.mInitialDisplayState;
    }

    public int getMaxSeverityLevel() {
        if (this.mType == 1) {
            throw new UnsupportedOperationException("getMaxSeverityLevel unsupported for static safety source");
        }
        return this.mMaxSeverityLevel;
    }

    public int getSearchTermsResId() {
        if (this.mType == 3) {
            throw new UnsupportedOperationException("getSearchTermsResId unsupported for issue-only safety source");
        }
        return this.mSearchTermsResId;
    }

    public boolean isLoggingAllowed() {
        if (this.mType == 1) {
            throw new UnsupportedOperationException("isLoggingAllowed unsupported for static safety source");
        }
        return this.mLoggingAllowed;
    }

    public boolean isRefreshOnPageOpenAllowed() {
        if (this.mType == 1) {
            throw new UnsupportedOperationException("isRefreshOnPageOpenAllowed unsupported for static safety source");
        }
        return this.mRefreshOnPageOpenAllowed;
    }

    @RequiresApi(value=34)
    public boolean areNotificationsAllowed() {
        if (!SdkLevel.isAtLeastU()) {
            throw new UnsupportedOperationException();
        }
        return this.mNotificationsAllowed;
    }

    @RequiresApi(value=34)
    public String getDeduplicationGroup() {
        if (!SdkLevel.isAtLeastU()) {
            throw new UnsupportedOperationException();
        }
        return this.mDeduplicationGroup;
    }

    @RequiresApi(value=34)
    public Set<String> getPackageCertificateHashes() {
        if (!SdkLevel.isAtLeastU()) {
            throw new UnsupportedOperationException();
        }
        return this.mPackageCertificateHashes;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof SafetySource)) {
            return false;
        }
        SafetySource that = (SafetySource)o;
        return this.mType == that.mType && Objects.equals(this.mId, that.mId) && Objects.equals(this.mPackageName, that.mPackageName) && this.mTitleResId == that.mTitleResId && this.mTitleForWorkResId == that.mTitleForWorkResId && this.mSummaryResId == that.mSummaryResId && Objects.equals(this.mIntentAction, that.mIntentAction) && this.mProfile == that.mProfile && this.mInitialDisplayState == that.mInitialDisplayState && this.mMaxSeverityLevel == that.mMaxSeverityLevel && this.mSearchTermsResId == that.mSearchTermsResId && this.mLoggingAllowed == that.mLoggingAllowed && this.mRefreshOnPageOpenAllowed == that.mRefreshOnPageOpenAllowed && this.mNotificationsAllowed == that.mNotificationsAllowed && Objects.equals(this.mDeduplicationGroup, that.mDeduplicationGroup) && Objects.equals(this.mPackageCertificateHashes, that.mPackageCertificateHashes);
    }

    public int hashCode() {
        return Objects.hash(this.mType, this.mId, this.mPackageName, this.mTitleResId, this.mTitleForWorkResId, this.mSummaryResId, this.mIntentAction, this.mProfile, this.mInitialDisplayState, this.mMaxSeverityLevel, this.mSearchTermsResId, this.mLoggingAllowed, this.mRefreshOnPageOpenAllowed, this.mNotificationsAllowed, this.mDeduplicationGroup, this.mPackageCertificateHashes);
    }

    public String toString() {
        return "SafetySource{mType=" + this.mType + ", mId=" + this.mId + ", mPackageName=" + this.mPackageName + ", mTitleResId=" + this.mTitleResId + ", mTitleForWorkResId=" + this.mTitleForWorkResId + ", mSummaryResId=" + this.mSummaryResId + ", mIntentAction=" + this.mIntentAction + ", mProfile=" + this.mProfile + ", mInitialDisplayState=" + this.mInitialDisplayState + ", mMaxSeverityLevel=" + this.mMaxSeverityLevel + ", mSearchTermsResId=" + this.mSearchTermsResId + ", mLoggingAllowed=" + this.mLoggingAllowed + ", mRefreshOnPageOpenAllowed=" + this.mRefreshOnPageOpenAllowed + ", mNotificationsAllowed=" + this.mNotificationsAllowed + ", mDeduplicationGroup=" + this.mDeduplicationGroup + ", mPackageCertificateHashes=" + this.mPackageCertificateHashes + '}';
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        dest.writeInt(this.mType);
        dest.writeString(this.mId);
        dest.writeString(this.mPackageName);
        dest.writeInt(this.mTitleResId);
        dest.writeInt(this.mTitleForWorkResId);
        dest.writeInt(this.mSummaryResId);
        dest.writeString(this.mIntentAction);
        dest.writeInt(this.mProfile);
        dest.writeInt(this.mInitialDisplayState);
        dest.writeInt(this.mMaxSeverityLevel);
        dest.writeInt(this.mSearchTermsResId);
        dest.writeBoolean(this.mLoggingAllowed);
        dest.writeBoolean(this.mRefreshOnPageOpenAllowed);
        if (SdkLevel.isAtLeastU()) {
            dest.writeBoolean(this.mNotificationsAllowed);
            dest.writeString(this.mDeduplicationGroup);
            dest.writeStringList(List.copyOf(this.mPackageCertificateHashes));
        }
    }

    public static class Builder {
        private final int mType;
        private String mId;
        private String mPackageName;
        private Integer mTitleResId;
        private Integer mTitleForWorkResId;
        private Integer mSummaryResId;
        private String mIntentAction;
        private Integer mProfile;
        private Integer mInitialDisplayState;
        private Integer mMaxSeverityLevel;
        private Integer mSearchTermsResId;
        private Boolean mLoggingAllowed;
        private Boolean mRefreshOnPageOpenAllowed;
        private Boolean mNotificationsAllowed;
        private String mDeduplicationGroup;
        private final ArraySet<String> mPackageCertificateHashes = new ArraySet();

        public Builder(int type) {
            this.mType = type;
        }

        @RequiresApi(value=34)
        public Builder(SafetySource safetySource) {
            if (!SdkLevel.isAtLeastU()) {
                throw new UnsupportedOperationException();
            }
            Objects.requireNonNull(safetySource);
            this.mType = safetySource.mType;
            this.mId = safetySource.mId;
            this.mPackageName = safetySource.mPackageName;
            this.mTitleResId = safetySource.mTitleResId;
            this.mTitleForWorkResId = safetySource.mTitleForWorkResId;
            this.mSummaryResId = safetySource.mSummaryResId;
            this.mIntentAction = safetySource.mIntentAction;
            this.mProfile = safetySource.mProfile;
            this.mInitialDisplayState = safetySource.mInitialDisplayState;
            this.mMaxSeverityLevel = safetySource.mMaxSeverityLevel;
            this.mSearchTermsResId = safetySource.mSearchTermsResId;
            this.mLoggingAllowed = safetySource.mLoggingAllowed;
            this.mRefreshOnPageOpenAllowed = safetySource.mRefreshOnPageOpenAllowed;
            this.mNotificationsAllowed = safetySource.mNotificationsAllowed;
            this.mDeduplicationGroup = safetySource.mDeduplicationGroup;
            this.mPackageCertificateHashes.addAll(safetySource.mPackageCertificateHashes);
        }

        public Builder setId(String id2) {
            this.mId = id2;
            return this;
        }

        public Builder setPackageName(String packageName) {
            this.mPackageName = packageName;
            return this;
        }

        public Builder setTitleResId(int titleResId) {
            this.mTitleResId = titleResId;
            return this;
        }

        public Builder setTitleForWorkResId(int titleForWorkResId) {
            this.mTitleForWorkResId = titleForWorkResId;
            return this;
        }

        public Builder setSummaryResId(int summaryResId) {
            this.mSummaryResId = summaryResId;
            return this;
        }

        public Builder setIntentAction(String intentAction) {
            this.mIntentAction = intentAction;
            return this;
        }

        public Builder setProfile(int profile) {
            this.mProfile = profile;
            return this;
        }

        public Builder setInitialDisplayState(int initialDisplayState) {
            this.mInitialDisplayState = initialDisplayState;
            return this;
        }

        public Builder setMaxSeverityLevel(int maxSeverityLevel) {
            this.mMaxSeverityLevel = maxSeverityLevel;
            return this;
        }

        public Builder setSearchTermsResId(int searchTermsResId) {
            this.mSearchTermsResId = searchTermsResId;
            return this;
        }

        public Builder setLoggingAllowed(boolean loggingAllowed) {
            this.mLoggingAllowed = loggingAllowed;
            return this;
        }

        public Builder setRefreshOnPageOpenAllowed(boolean refreshOnPageOpenAllowed) {
            this.mRefreshOnPageOpenAllowed = refreshOnPageOpenAllowed;
            return this;
        }

        @RequiresApi(value=34)
        public Builder setNotificationsAllowed(boolean notificationsAllowed) {
            if (!SdkLevel.isAtLeastU()) {
                throw new UnsupportedOperationException();
            }
            this.mNotificationsAllowed = notificationsAllowed;
            return this;
        }

        @RequiresApi(value=34)
        public Builder setDeduplicationGroup(String deduplicationGroup) {
            if (!SdkLevel.isAtLeastU()) {
                throw new UnsupportedOperationException();
            }
            this.mDeduplicationGroup = deduplicationGroup;
            return this;
        }

        @RequiresApi(value=34)
        public Builder addPackageCertificateHash(String packageCertificateHash) {
            if (!SdkLevel.isAtLeastU()) {
                throw new UnsupportedOperationException();
            }
            this.mPackageCertificateHashes.add(packageCertificateHash);
            return this;
        }

        public SafetySource build() {
            int type = this.mType;
            if (type != 1 && type != 2 && type != 3) {
                throw new IllegalStateException("Unexpected type");
            }
            boolean isStatic = type == 1;
            boolean isDynamic = type == 2;
            boolean isIssueOnly = type == 3;
            String id2 = this.mId;
            BuilderUtils.validateId(id2, "id", true, false);
            String packageName = this.mPackageName;
            BuilderUtils.validateAttribute(packageName, "packageName", isDynamic || isIssueOnly, isStatic && !SdkLevel.isAtLeastU());
            int initialDisplayState = BuilderUtils.validateIntDef(this.mInitialDisplayState, "initialDisplayState", false, isStatic || isIssueOnly, 0, 0, 1, 2);
            boolean isEnabled = initialDisplayState == 0;
            boolean isHidden = initialDisplayState == 2;
            boolean isDynamicNotHidden = isDynamic && !isHidden;
            int profile = BuilderUtils.validateIntDef(this.mProfile, "profile", true, false, 0, 1, 2);
            boolean hasWork = profile == 2;
            int searchTermsResId = BuilderUtils.validateResId(this.mSearchTermsResId, "searchTerms", false, isIssueOnly);
            boolean isDynamicHiddenWithSearch = isDynamic && isHidden && searchTermsResId != 0;
            boolean titleRequired = isDynamicNotHidden || isDynamicHiddenWithSearch || isStatic;
            int titleResId = BuilderUtils.validateResId(this.mTitleResId, "title", titleRequired, isIssueOnly);
            int titleForWorkResId = BuilderUtils.validateResId(this.mTitleForWorkResId, "titleForWork", hasWork && titleRequired, !hasWork || isIssueOnly);
            int summaryResId = BuilderUtils.validateResId(this.mSummaryResId, "summary", isDynamicNotHidden, isIssueOnly);
            String intentAction = this.mIntentAction;
            BuilderUtils.validateAttribute(intentAction, "intentAction", isDynamic && isEnabled || isStatic, isIssueOnly);
            int maxSeverityLevel = BuilderUtils.validateInteger(this.mMaxSeverityLevel, "maxSeverityLevel", false, isStatic, Integer.MAX_VALUE);
            boolean loggingAllowed = BuilderUtils.validateBoolean(this.mLoggingAllowed, "loggingAllowed", false, isStatic, true);
            boolean refreshOnPageOpenAllowed = BuilderUtils.validateBoolean(this.mRefreshOnPageOpenAllowed, "refreshOnPageOpenAllowed", false, isStatic, false);
            String deduplicationGroup = this.mDeduplicationGroup;
            boolean notificationsAllowed = false;
            Set<String> packageCertificateHashes = Set.copyOf(this.mPackageCertificateHashes);
            if (SdkLevel.isAtLeastU()) {
                notificationsAllowed = BuilderUtils.validateBoolean(this.mNotificationsAllowed, "notificationsAllowed", false, isStatic, false);
                BuilderUtils.validateAttribute(deduplicationGroup, "deduplicationGroup", false, isStatic);
                BuilderUtils.validateCollection(packageCertificateHashes, "packageCertificateHashes", false, isStatic);
            }
            return new SafetySource(type, id2, packageName, titleResId, titleForWorkResId, summaryResId, intentAction, profile, initialDisplayState, maxSeverityLevel, searchTermsResId, loggingAllowed, refreshOnPageOpenAllowed, notificationsAllowed, deduplicationGroup, packageCertificateHashes);
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface InitialDisplayState {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface Profile {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface SafetySourceType {
    }
}

