/*
 * Decompiled with CFR 0.152.
 */
package android.safetycenter.config;

import android.annotation.SuppressLint;
import android.annotation.SystemApi;
import android.os.Parcel;
import android.os.Parcelable;
import android.permission.jarjar.com.android.modules.utils.build.SdkLevel;
import android.safetycenter.config.BuilderUtils;
import android.safetycenter.config.SafetySource;
import androidx.annotation.RequiresApi;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

@SystemApi
@RequiresApi(value=33)
public class SafetySourcesGroup
implements Parcelable {
    public static final int SAFETY_SOURCES_GROUP_TYPE_COLLAPSIBLE = 0;
    public static final int SAFETY_SOURCES_GROUP_TYPE_STATEFUL = 0;
    public static final int SAFETY_SOURCES_GROUP_TYPE_RIGID = 1;
    public static final int SAFETY_SOURCES_GROUP_TYPE_STATELESS = 1;
    public static final int SAFETY_SOURCES_GROUP_TYPE_HIDDEN = 2;
    public static final int STATELESS_ICON_TYPE_NONE = 0;
    public static final int STATELESS_ICON_TYPE_PRIVACY = 1;
    public static final Parcelable.Creator<SafetySourcesGroup> CREATOR = new Parcelable.Creator<SafetySourcesGroup>(){

        @Override
        public SafetySourcesGroup createFromParcel(Parcel in) {
            Builder builder = new Builder().setId(in.readString()).setTitleResId(in.readInt()).setSummaryResId(in.readInt()).setStatelessIconType(in.readInt());
            List safetySources = Objects.requireNonNull(in.createTypedArrayList(SafetySource.CREATOR));
            for (int i = 0; i < safetySources.size(); ++i) {
                builder.addSafetySource((SafetySource)safetySources.get(i));
            }
            if (SdkLevel.isAtLeastU()) {
                builder.setType(in.readInt());
            }
            return builder.build();
        }

        public SafetySourcesGroup[] newArray(int size) {
            return new SafetySourcesGroup[size];
        }
    };
    private final int mType;
    private final String mId;
    private final int mTitleResId;
    private final int mSummaryResId;
    private final int mStatelessIconType;
    private final List<SafetySource> mSafetySources;

    private SafetySourcesGroup(int type, String id2, int titleResId, int summaryResId, int statelessIconType, List<SafetySource> safetySources) {
        this.mType = type;
        this.mId = id2;
        this.mTitleResId = titleResId;
        this.mSummaryResId = summaryResId;
        this.mStatelessIconType = statelessIconType;
        this.mSafetySources = safetySources;
    }

    public int getType() {
        return this.mType;
    }

    public String getId() {
        return this.mId;
    }

    public int getTitleResId() {
        return this.mTitleResId;
    }

    public int getSummaryResId() {
        return this.mSummaryResId;
    }

    public int getStatelessIconType() {
        return this.mStatelessIconType;
    }

    public List<SafetySource> getSafetySources() {
        return this.mSafetySources;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof SafetySourcesGroup)) {
            return false;
        }
        SafetySourcesGroup that = (SafetySourcesGroup)o;
        return this.mType == that.mType && Objects.equals(this.mId, that.mId) && this.mTitleResId == that.mTitleResId && this.mSummaryResId == that.mSummaryResId && this.mStatelessIconType == that.mStatelessIconType && Objects.equals(this.mSafetySources, that.mSafetySources);
    }

    public int hashCode() {
        return Objects.hash(this.mType, this.mId, this.mTitleResId, this.mSummaryResId, this.mStatelessIconType, this.mSafetySources);
    }

    public String toString() {
        return "SafetySourcesGroup{mType=" + this.mType + ", mId=" + this.mId + ", mTitleResId=" + this.mTitleResId + ", mSummaryResId=" + this.mSummaryResId + ", mStatelessIconType=" + this.mStatelessIconType + ", mSafetySources=" + this.mSafetySources + '}';
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        dest.writeString(this.mId);
        dest.writeInt(this.mTitleResId);
        dest.writeInt(this.mSummaryResId);
        dest.writeInt(this.mStatelessIconType);
        dest.writeTypedList(this.mSafetySources);
        if (SdkLevel.isAtLeastU()) {
            dest.writeInt(this.mType);
        }
    }

    public static class Builder {
        private final List<SafetySource> mSafetySources = new ArrayList<SafetySource>();
        private Integer mType;
        private String mId;
        private Integer mTitleResId;
        private Integer mSummaryResId;
        private Integer mStatelessIconType;

        public Builder() {
        }

        @RequiresApi(value=34)
        public Builder(SafetySourcesGroup original) {
            if (!SdkLevel.isAtLeastU()) {
                throw new UnsupportedOperationException();
            }
            Objects.requireNonNull(original);
            this.mSafetySources.addAll(original.mSafetySources);
            this.mType = original.mType;
            this.mId = original.mId;
            this.mTitleResId = original.mTitleResId;
            this.mSummaryResId = original.mSummaryResId;
            this.mStatelessIconType = original.mStatelessIconType;
        }

        @RequiresApi(value=34)
        public Builder setType(int type) {
            this.mType = type;
            return this;
        }

        public Builder setId(String id2) {
            this.mId = id2;
            return this;
        }

        public Builder setTitleResId(int titleResId) {
            this.mTitleResId = titleResId;
            return this;
        }

        public Builder setSummaryResId(int summaryResId) {
            this.mSummaryResId = summaryResId;
            return this;
        }

        public Builder setStatelessIconType(int statelessIconType) {
            this.mStatelessIconType = statelessIconType;
            return this;
        }

        public Builder addSafetySource(SafetySource safetySource) {
            this.mSafetySources.add(Objects.requireNonNull(safetySource));
            return this;
        }

        public SafetySourcesGroup build() {
            int type;
            String id2 = this.mId;
            BuilderUtils.validateId(id2, "id", true, false);
            List<SafetySource> safetySources = Collections.unmodifiableList(new ArrayList<SafetySource>(this.mSafetySources));
            if (safetySources.isEmpty()) {
                throw new IllegalStateException("Safety sources group empty");
            }
            int summaryResId = BuilderUtils.validateResId(this.mSummaryResId, "summary", false, false);
            int statelessIconType = BuilderUtils.validateIntDef(this.mStatelessIconType, "statelessIconType", false, false, 0, 0, 1);
            boolean hasOnlyIssueOnlySources = true;
            int safetySourcesSize = safetySources.size();
            for (int i = 0; i < safetySourcesSize; ++i) {
                type = safetySources.get(i).getType();
                if (type == 3) continue;
                hasOnlyIssueOnlySources = false;
                break;
            }
            int inferredGroupType = 1;
            if (hasOnlyIssueOnlySources) {
                inferredGroupType = 2;
            } else if (summaryResId != 0 || statelessIconType != 0) {
                inferredGroupType = 0;
            }
            type = BuilderUtils.validateIntDef(this.mType, "type", false, false, inferredGroupType, 0, 1, 2);
            if (type == 2 && !hasOnlyIssueOnlySources) {
                throw new IllegalStateException("Safety sources groups of type hidden can only contain sources of type issue-only");
            }
            if (type != 2 && hasOnlyIssueOnlySources) {
                throw new IllegalStateException("Safety sources groups containing only sources of type issue-only must be of type hidden");
            }
            boolean isStateful = type == 0;
            boolean isStateless = type == 1;
            int titleResId = BuilderUtils.validateResId(this.mTitleResId, "title", isStateful || isStateless, false);
            return new SafetySourcesGroup(type, id2, titleResId, summaryResId, statelessIconType, safetySources);
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface StatelessIconType {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    @SuppressLint(value={"UniqueConstants"})
    public static @interface SafetySourceGroupType {
    }
}

