/*
 * Decompiled with CFR 0.152.
 */
package android.scheduling;

import android.os.Binder;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.RemoteException;
import android.scheduling.IRequestRebootReadinessStatusListener;

public interface IRebootReadinessManager
extends IInterface {
    public static final String DESCRIPTOR = "android.scheduling.IRebootReadinessManager";

    public void markRebootPending(String var1) throws RemoteException;

    public void cancelPendingReboot(String var1) throws RemoteException;

    public boolean isReadyToReboot() throws RemoteException;

    public void addRequestRebootReadinessStatusListener(IRequestRebootReadinessStatusListener var1) throws RemoteException;

    public void removeRequestRebootReadinessStatusListener(IRequestRebootReadinessStatusListener var1) throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements IRebootReadinessManager {
        static final int TRANSACTION_markRebootPending = 1;
        static final int TRANSACTION_cancelPendingReboot = 2;
        static final int TRANSACTION_isReadyToReboot = 3;
        static final int TRANSACTION_addRequestRebootReadinessStatusListener = 4;
        static final int TRANSACTION_removeRequestRebootReadinessStatusListener = 5;

        public Stub() {
            this.attachInterface(this, IRebootReadinessManager.DESCRIPTOR);
        }

        public static IRebootReadinessManager asInterface(IBinder obj) {
            if (obj == null) {
                return null;
            }
            IInterface iin = obj.queryLocalInterface(IRebootReadinessManager.DESCRIPTOR);
            if (iin != null && iin instanceof IRebootReadinessManager) {
                return (IRebootReadinessManager)iin;
            }
            return new Proxy(obj);
        }

        @Override
        public IBinder asBinder() {
            return this;
        }

        public static String getDefaultTransactionName(int transactionCode) {
            switch (transactionCode) {
                case 1: {
                    return "markRebootPending";
                }
                case 2: {
                    return "cancelPendingReboot";
                }
                case 3: {
                    return "isReadyToReboot";
                }
                case 4: {
                    return "addRequestRebootReadinessStatusListener";
                }
                case 5: {
                    return "removeRequestRebootReadinessStatusListener";
                }
            }
            return null;
        }

        @Override
        public String getTransactionName(int transactionCode) {
            return Stub.getDefaultTransactionName(transactionCode);
        }

        @Override
        public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
            String descriptor = IRebootReadinessManager.DESCRIPTOR;
            if (code >= 1 && code <= 0xFFFFFF) {
                data.enforceInterface(descriptor);
            }
            switch (code) {
                case 1598968902: {
                    reply.writeString(descriptor);
                    return true;
                }
            }
            switch (code) {
                case 1: {
                    String _arg0 = data.readString();
                    this.markRebootPending(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 2: {
                    String _arg0 = data.readString();
                    this.cancelPendingReboot(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 3: {
                    boolean _result = this.isReadyToReboot();
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 4: {
                    IRequestRebootReadinessStatusListener _arg0 = IRequestRebootReadinessStatusListener.Stub.asInterface(data.readStrongBinder());
                    this.addRequestRebootReadinessStatusListener(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 5: {
                    IRequestRebootReadinessStatusListener _arg0 = IRequestRebootReadinessStatusListener.Stub.asInterface(data.readStrongBinder());
                    this.removeRequestRebootReadinessStatusListener(_arg0);
                    reply.writeNoException();
                    break;
                }
                default: {
                    return super.onTransact(code, data, reply, flags);
                }
            }
            return true;
        }

        @Override
        public int getMaxTransactionId() {
            return 4;
        }

        private static class Proxy
        implements IRebootReadinessManager {
            private IBinder mRemote;

            Proxy(IBinder remote) {
                this.mRemote = remote;
            }

            @Override
            public IBinder asBinder() {
                return this.mRemote;
            }

            public String getInterfaceDescriptor() {
                return IRebootReadinessManager.DESCRIPTOR;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void markRebootPending(String callingPackage) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IRebootReadinessManager.DESCRIPTOR);
                    _data.writeString(callingPackage);
                    boolean _status = this.mRemote.transact(1, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void cancelPendingReboot(String callingPackage) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IRebootReadinessManager.DESCRIPTOR);
                    _data.writeString(callingPackage);
                    boolean _status = this.mRemote.transact(2, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean isReadyToReboot() throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IRebootReadinessManager.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(3, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void addRequestRebootReadinessStatusListener(IRequestRebootReadinessStatusListener listener) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IRebootReadinessManager.DESCRIPTOR);
                    _data.writeStrongInterface(listener);
                    boolean _status = this.mRemote.transact(4, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void removeRequestRebootReadinessStatusListener(IRequestRebootReadinessStatusListener listener) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IRebootReadinessManager.DESCRIPTOR);
                    _data.writeStrongInterface(listener);
                    boolean _status = this.mRemote.transact(5, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }
        }
    }

    public static class Default
    implements IRebootReadinessManager {
        @Override
        public void markRebootPending(String callingPackage) throws RemoteException {
        }

        @Override
        public void cancelPendingReboot(String callingPackage) throws RemoteException {
        }

        @Override
        public boolean isReadyToReboot() throws RemoteException {
            return false;
        }

        @Override
        public void addRequestRebootReadinessStatusListener(IRequestRebootReadinessStatusListener listener) throws RemoteException {
        }

        @Override
        public void removeRequestRebootReadinessStatusListener(IRequestRebootReadinessStatusListener listener) throws RemoteException {
        }

        @Override
        public IBinder asBinder() {
            return null;
        }
    }
}

