/*
 * Decompiled with CFR 0.152.
 */
package android.security;

import android.compat.annotation.UnsupportedAppUsage;
import android.content.pm.StringParceledListSlice;
import android.net.Uri;
import android.os.Binder;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.RemoteException;
import android.security.AppUriAuthenticationPolicy;
import android.security.keystore.ParcelableKeyGenParameterSpec;
import java.util.ArrayList;
import java.util.List;

public interface IKeyChainService
extends IInterface {
    @UnsupportedAppUsage(overrideSourcePosition="frameworks/base/keystore/java/android/security/IKeyChainService.aidl:32:1:32:25")
    public String requestPrivateKey(String var1) throws RemoteException;

    public byte[] getCertificate(String var1) throws RemoteException;

    public byte[] getCaCertificates(String var1) throws RemoteException;

    public boolean isUserSelectable(String var1) throws RemoteException;

    public void setUserSelectable(String var1, boolean var2) throws RemoteException;

    public int generateKeyPair(String var1, ParcelableKeyGenParameterSpec var2) throws RemoteException;

    public boolean setKeyPairCertificate(String var1, byte[] var2, byte[] var3) throws RemoteException;

    public String installCaCertificate(byte[] var1) throws RemoteException;

    public boolean installKeyPair(byte[] var1, byte[] var2, byte[] var3, String var4, int var5) throws RemoteException;

    public boolean removeKeyPair(String var1) throws RemoteException;

    public boolean containsKeyPair(String var1) throws RemoteException;

    public int[] getGrants(String var1) throws RemoteException;

    public boolean deleteCaCertificate(String var1) throws RemoteException;

    public boolean reset() throws RemoteException;

    public StringParceledListSlice getUserCaAliases() throws RemoteException;

    public StringParceledListSlice getSystemCaAliases() throws RemoteException;

    public boolean containsCaAlias(String var1) throws RemoteException;

    public byte[] getEncodedCaCertificate(String var1, boolean var2) throws RemoteException;

    public List<String> getCaCertificateChainAliases(String var1, boolean var2) throws RemoteException;

    public void setCredentialManagementApp(String var1, AppUriAuthenticationPolicy var2) throws RemoteException;

    public boolean hasCredentialManagementApp() throws RemoteException;

    public String getCredentialManagementAppPackageName() throws RemoteException;

    public AppUriAuthenticationPolicy getCredentialManagementAppPolicy() throws RemoteException;

    public String getPredefinedAliasForPackageAndUri(String var1, Uri var2) throws RemoteException;

    public void removeCredentialManagementApp() throws RemoteException;

    public boolean isCredentialManagementApp(String var1) throws RemoteException;

    public boolean setGrant(int var1, String var2, boolean var3) throws RemoteException;

    public boolean hasGrant(int var1, String var2) throws RemoteException;

    public String getWifiKeyGrantAsUser(String var1) throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements IKeyChainService {
        public static final String DESCRIPTOR = "android.security.IKeyChainService";
        static final int TRANSACTION_requestPrivateKey = 1;
        static final int TRANSACTION_getCertificate = 2;
        static final int TRANSACTION_getCaCertificates = 3;
        static final int TRANSACTION_isUserSelectable = 4;
        static final int TRANSACTION_setUserSelectable = 5;
        static final int TRANSACTION_generateKeyPair = 6;
        static final int TRANSACTION_setKeyPairCertificate = 7;
        static final int TRANSACTION_installCaCertificate = 8;
        static final int TRANSACTION_installKeyPair = 9;
        static final int TRANSACTION_removeKeyPair = 10;
        static final int TRANSACTION_containsKeyPair = 11;
        static final int TRANSACTION_getGrants = 12;
        static final int TRANSACTION_deleteCaCertificate = 13;
        static final int TRANSACTION_reset = 14;
        static final int TRANSACTION_getUserCaAliases = 15;
        static final int TRANSACTION_getSystemCaAliases = 16;
        static final int TRANSACTION_containsCaAlias = 17;
        static final int TRANSACTION_getEncodedCaCertificate = 18;
        static final int TRANSACTION_getCaCertificateChainAliases = 19;
        static final int TRANSACTION_setCredentialManagementApp = 20;
        static final int TRANSACTION_hasCredentialManagementApp = 21;
        static final int TRANSACTION_getCredentialManagementAppPackageName = 22;
        static final int TRANSACTION_getCredentialManagementAppPolicy = 23;
        static final int TRANSACTION_getPredefinedAliasForPackageAndUri = 24;
        static final int TRANSACTION_removeCredentialManagementApp = 25;
        static final int TRANSACTION_isCredentialManagementApp = 26;
        static final int TRANSACTION_setGrant = 27;
        static final int TRANSACTION_hasGrant = 28;
        static final int TRANSACTION_getWifiKeyGrantAsUser = 29;

        public Stub() {
            this.attachInterface(this, DESCRIPTOR);
        }

        public static IKeyChainService asInterface(IBinder obj) {
            if (obj == null) {
                return null;
            }
            IInterface iin = obj.queryLocalInterface(DESCRIPTOR);
            if (iin != null && iin instanceof IKeyChainService) {
                return (IKeyChainService)iin;
            }
            return new Proxy(obj);
        }

        @Override
        public IBinder asBinder() {
            return this;
        }

        public static String getDefaultTransactionName(int transactionCode) {
            switch (transactionCode) {
                case 1: {
                    return "requestPrivateKey";
                }
                case 2: {
                    return "getCertificate";
                }
                case 3: {
                    return "getCaCertificates";
                }
                case 4: {
                    return "isUserSelectable";
                }
                case 5: {
                    return "setUserSelectable";
                }
                case 6: {
                    return "generateKeyPair";
                }
                case 7: {
                    return "setKeyPairCertificate";
                }
                case 8: {
                    return "installCaCertificate";
                }
                case 9: {
                    return "installKeyPair";
                }
                case 10: {
                    return "removeKeyPair";
                }
                case 11: {
                    return "containsKeyPair";
                }
                case 12: {
                    return "getGrants";
                }
                case 13: {
                    return "deleteCaCertificate";
                }
                case 14: {
                    return "reset";
                }
                case 15: {
                    return "getUserCaAliases";
                }
                case 16: {
                    return "getSystemCaAliases";
                }
                case 17: {
                    return "containsCaAlias";
                }
                case 18: {
                    return "getEncodedCaCertificate";
                }
                case 19: {
                    return "getCaCertificateChainAliases";
                }
                case 20: {
                    return "setCredentialManagementApp";
                }
                case 21: {
                    return "hasCredentialManagementApp";
                }
                case 22: {
                    return "getCredentialManagementAppPackageName";
                }
                case 23: {
                    return "getCredentialManagementAppPolicy";
                }
                case 24: {
                    return "getPredefinedAliasForPackageAndUri";
                }
                case 25: {
                    return "removeCredentialManagementApp";
                }
                case 26: {
                    return "isCredentialManagementApp";
                }
                case 27: {
                    return "setGrant";
                }
                case 28: {
                    return "hasGrant";
                }
                case 29: {
                    return "getWifiKeyGrantAsUser";
                }
            }
            return null;
        }

        @Override
        public String getTransactionName(int transactionCode) {
            return Stub.getDefaultTransactionName(transactionCode);
        }

        @Override
        public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
            String descriptor = DESCRIPTOR;
            if (code >= 1 && code <= 0xFFFFFF) {
                data.enforceInterface(descriptor);
            }
            switch (code) {
                case 1598968902: {
                    reply.writeString(descriptor);
                    return true;
                }
            }
            switch (code) {
                case 1: {
                    String _arg0 = data.readString();
                    data.enforceNoDataAvail();
                    String _result = this.requestPrivateKey(_arg0);
                    reply.writeNoException();
                    reply.writeString(_result);
                    break;
                }
                case 2: {
                    String _arg0 = data.readString();
                    data.enforceNoDataAvail();
                    byte[] _result = this.getCertificate(_arg0);
                    reply.writeNoException();
                    reply.writeByteArray(_result);
                    break;
                }
                case 3: {
                    String _arg0 = data.readString();
                    data.enforceNoDataAvail();
                    byte[] _result = this.getCaCertificates(_arg0);
                    reply.writeNoException();
                    reply.writeByteArray(_result);
                    break;
                }
                case 4: {
                    String _arg0 = data.readString();
                    data.enforceNoDataAvail();
                    boolean _result = this.isUserSelectable(_arg0);
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 5: {
                    String _arg0 = data.readString();
                    boolean _arg1 = data.readBoolean();
                    data.enforceNoDataAvail();
                    this.setUserSelectable(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                case 6: {
                    String _arg0 = data.readString();
                    ParcelableKeyGenParameterSpec _arg1 = data.readTypedObject(ParcelableKeyGenParameterSpec.CREATOR);
                    data.enforceNoDataAvail();
                    int _result = this.generateKeyPair(_arg0, _arg1);
                    reply.writeNoException();
                    reply.writeInt(_result);
                    break;
                }
                case 7: {
                    String _arg0 = data.readString();
                    byte[] _arg1 = data.createByteArray();
                    byte[] _arg2 = data.createByteArray();
                    data.enforceNoDataAvail();
                    boolean _result = this.setKeyPairCertificate(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 8: {
                    byte[] _arg0 = data.createByteArray();
                    data.enforceNoDataAvail();
                    String _result = this.installCaCertificate(_arg0);
                    reply.writeNoException();
                    reply.writeString(_result);
                    break;
                }
                case 9: {
                    byte[] _arg0 = data.createByteArray();
                    byte[] _arg1 = data.createByteArray();
                    byte[] _arg2 = data.createByteArray();
                    String _arg3 = data.readString();
                    int _arg4 = data.readInt();
                    data.enforceNoDataAvail();
                    boolean _result = this.installKeyPair(_arg0, _arg1, _arg2, _arg3, _arg4);
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 10: {
                    String _arg0 = data.readString();
                    data.enforceNoDataAvail();
                    boolean _result = this.removeKeyPair(_arg0);
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 11: {
                    String _arg0 = data.readString();
                    data.enforceNoDataAvail();
                    boolean _result = this.containsKeyPair(_arg0);
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 12: {
                    String _arg0 = data.readString();
                    data.enforceNoDataAvail();
                    int[] _result = this.getGrants(_arg0);
                    reply.writeNoException();
                    reply.writeIntArray(_result);
                    break;
                }
                case 13: {
                    String _arg0 = data.readString();
                    data.enforceNoDataAvail();
                    boolean _result = this.deleteCaCertificate(_arg0);
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 14: {
                    boolean _result = this.reset();
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 15: {
                    StringParceledListSlice _result = this.getUserCaAliases();
                    reply.writeNoException();
                    reply.writeTypedObject(_result, 1);
                    break;
                }
                case 16: {
                    StringParceledListSlice _result = this.getSystemCaAliases();
                    reply.writeNoException();
                    reply.writeTypedObject(_result, 1);
                    break;
                }
                case 17: {
                    String _arg0 = data.readString();
                    data.enforceNoDataAvail();
                    boolean _result = this.containsCaAlias(_arg0);
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 18: {
                    String _arg0 = data.readString();
                    boolean _arg1 = data.readBoolean();
                    data.enforceNoDataAvail();
                    byte[] _result = this.getEncodedCaCertificate(_arg0, _arg1);
                    reply.writeNoException();
                    reply.writeByteArray(_result);
                    break;
                }
                case 19: {
                    String _arg0 = data.readString();
                    boolean _arg1 = data.readBoolean();
                    data.enforceNoDataAvail();
                    List<String> _result = this.getCaCertificateChainAliases(_arg0, _arg1);
                    reply.writeNoException();
                    reply.writeStringList(_result);
                    break;
                }
                case 20: {
                    String _arg0 = data.readString();
                    AppUriAuthenticationPolicy _arg1 = data.readTypedObject(AppUriAuthenticationPolicy.CREATOR);
                    data.enforceNoDataAvail();
                    this.setCredentialManagementApp(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                case 21: {
                    boolean _result = this.hasCredentialManagementApp();
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 22: {
                    String _result = this.getCredentialManagementAppPackageName();
                    reply.writeNoException();
                    reply.writeString(_result);
                    break;
                }
                case 23: {
                    AppUriAuthenticationPolicy _result = this.getCredentialManagementAppPolicy();
                    reply.writeNoException();
                    reply.writeTypedObject(_result, 1);
                    break;
                }
                case 24: {
                    String _arg0 = data.readString();
                    Uri _arg1 = data.readTypedObject(Uri.CREATOR);
                    data.enforceNoDataAvail();
                    String _result = this.getPredefinedAliasForPackageAndUri(_arg0, _arg1);
                    reply.writeNoException();
                    reply.writeString(_result);
                    break;
                }
                case 25: {
                    this.removeCredentialManagementApp();
                    reply.writeNoException();
                    break;
                }
                case 26: {
                    String _arg0 = data.readString();
                    data.enforceNoDataAvail();
                    boolean _result = this.isCredentialManagementApp(_arg0);
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 27: {
                    int _arg0 = data.readInt();
                    String _arg1 = data.readString();
                    boolean _arg2 = data.readBoolean();
                    data.enforceNoDataAvail();
                    boolean _result = this.setGrant(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 28: {
                    int _arg0 = data.readInt();
                    String _arg1 = data.readString();
                    data.enforceNoDataAvail();
                    boolean _result = this.hasGrant(_arg0, _arg1);
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 29: {
                    String _arg0 = data.readString();
                    data.enforceNoDataAvail();
                    String _result = this.getWifiKeyGrantAsUser(_arg0);
                    reply.writeNoException();
                    reply.writeString(_result);
                    break;
                }
                default: {
                    return super.onTransact(code, data, reply, flags);
                }
            }
            return true;
        }

        @Override
        public int getMaxTransactionId() {
            return 28;
        }

        private static class Proxy
        implements IKeyChainService {
            private IBinder mRemote;

            Proxy(IBinder remote) {
                this.mRemote = remote;
            }

            @Override
            public IBinder asBinder() {
                return this.mRemote;
            }

            public String getInterfaceDescriptor() {
                return Stub.DESCRIPTOR;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public String requestPrivateKey(String alias) throws RemoteException {
                String _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(alias);
                    boolean _status = this.mRemote.transact(1, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readString();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public byte[] getCertificate(String alias) throws RemoteException {
                byte[] _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(alias);
                    boolean _status = this.mRemote.transact(2, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.createByteArray();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public byte[] getCaCertificates(String alias) throws RemoteException {
                byte[] _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(alias);
                    boolean _status = this.mRemote.transact(3, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.createByteArray();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean isUserSelectable(String alias) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(alias);
                    boolean _status = this.mRemote.transact(4, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setUserSelectable(String alias, boolean isUserSelectable) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(alias);
                    _data.writeBoolean(isUserSelectable);
                    boolean _status = this.mRemote.transact(5, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int generateKeyPair(String algorithm, ParcelableKeyGenParameterSpec spec) throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(algorithm);
                    _data.writeTypedObject(spec, 0);
                    boolean _status = this.mRemote.transact(6, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean setKeyPairCertificate(String alias, byte[] userCert, byte[] certChain) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(alias);
                    _data.writeByteArray(userCert);
                    _data.writeByteArray(certChain);
                    boolean _status = this.mRemote.transact(7, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public String installCaCertificate(byte[] caCertificate) throws RemoteException {
                String _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeByteArray(caCertificate);
                    boolean _status = this.mRemote.transact(8, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readString();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean installKeyPair(byte[] privateKey, byte[] userCert, byte[] certChain, String alias, int uid) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeByteArray(privateKey);
                    _data.writeByteArray(userCert);
                    _data.writeByteArray(certChain);
                    _data.writeString(alias);
                    _data.writeInt(uid);
                    boolean _status = this.mRemote.transact(9, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean removeKeyPair(String alias) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(alias);
                    boolean _status = this.mRemote.transact(10, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean containsKeyPair(String alias) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(alias);
                    boolean _status = this.mRemote.transact(11, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int[] getGrants(String alias) throws RemoteException {
                int[] _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(alias);
                    boolean _status = this.mRemote.transact(12, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.createIntArray();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean deleteCaCertificate(String alias) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(alias);
                    boolean _status = this.mRemote.transact(13, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean reset() throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(14, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public StringParceledListSlice getUserCaAliases() throws RemoteException {
                StringParceledListSlice _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(15, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readTypedObject(StringParceledListSlice.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public StringParceledListSlice getSystemCaAliases() throws RemoteException {
                StringParceledListSlice _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(16, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readTypedObject(StringParceledListSlice.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean containsCaAlias(String alias) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(alias);
                    boolean _status = this.mRemote.transact(17, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public byte[] getEncodedCaCertificate(String alias, boolean includeDeletedSystem) throws RemoteException {
                byte[] _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(alias);
                    _data.writeBoolean(includeDeletedSystem);
                    boolean _status = this.mRemote.transact(18, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.createByteArray();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public List<String> getCaCertificateChainAliases(String rootAlias, boolean includeDeletedSystem) throws RemoteException {
                ArrayList<String> _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(rootAlias);
                    _data.writeBoolean(includeDeletedSystem);
                    boolean _status = this.mRemote.transact(19, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.createStringArrayList();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setCredentialManagementApp(String packageName, AppUriAuthenticationPolicy policy) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(packageName);
                    _data.writeTypedObject(policy, 0);
                    boolean _status = this.mRemote.transact(20, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean hasCredentialManagementApp() throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(21, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public String getCredentialManagementAppPackageName() throws RemoteException {
                String _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(22, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readString();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public AppUriAuthenticationPolicy getCredentialManagementAppPolicy() throws RemoteException {
                AppUriAuthenticationPolicy _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(23, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readTypedObject(AppUriAuthenticationPolicy.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public String getPredefinedAliasForPackageAndUri(String packageName, Uri uri) throws RemoteException {
                String _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(packageName);
                    _data.writeTypedObject(uri, 0);
                    boolean _status = this.mRemote.transact(24, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readString();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void removeCredentialManagementApp() throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(25, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean isCredentialManagementApp(String packageName) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(packageName);
                    boolean _status = this.mRemote.transact(26, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean setGrant(int uid, String alias, boolean value) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(uid);
                    _data.writeString(alias);
                    _data.writeBoolean(value);
                    boolean _status = this.mRemote.transact(27, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean hasGrant(int uid, String alias) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(uid);
                    _data.writeString(alias);
                    boolean _status = this.mRemote.transact(28, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public String getWifiKeyGrantAsUser(String alias) throws RemoteException {
                String _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(alias);
                    boolean _status = this.mRemote.transact(29, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readString();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }
        }
    }

    public static class Default
    implements IKeyChainService {
        @Override
        public String requestPrivateKey(String alias) throws RemoteException {
            return null;
        }

        @Override
        public byte[] getCertificate(String alias) throws RemoteException {
            return null;
        }

        @Override
        public byte[] getCaCertificates(String alias) throws RemoteException {
            return null;
        }

        @Override
        public boolean isUserSelectable(String alias) throws RemoteException {
            return false;
        }

        @Override
        public void setUserSelectable(String alias, boolean isUserSelectable) throws RemoteException {
        }

        @Override
        public int generateKeyPair(String algorithm, ParcelableKeyGenParameterSpec spec) throws RemoteException {
            return 0;
        }

        @Override
        public boolean setKeyPairCertificate(String alias, byte[] userCert, byte[] certChain) throws RemoteException {
            return false;
        }

        @Override
        public String installCaCertificate(byte[] caCertificate) throws RemoteException {
            return null;
        }

        @Override
        public boolean installKeyPair(byte[] privateKey, byte[] userCert, byte[] certChain, String alias, int uid) throws RemoteException {
            return false;
        }

        @Override
        public boolean removeKeyPair(String alias) throws RemoteException {
            return false;
        }

        @Override
        public boolean containsKeyPair(String alias) throws RemoteException {
            return false;
        }

        @Override
        public int[] getGrants(String alias) throws RemoteException {
            return null;
        }

        @Override
        public boolean deleteCaCertificate(String alias) throws RemoteException {
            return false;
        }

        @Override
        public boolean reset() throws RemoteException {
            return false;
        }

        @Override
        public StringParceledListSlice getUserCaAliases() throws RemoteException {
            return null;
        }

        @Override
        public StringParceledListSlice getSystemCaAliases() throws RemoteException {
            return null;
        }

        @Override
        public boolean containsCaAlias(String alias) throws RemoteException {
            return false;
        }

        @Override
        public byte[] getEncodedCaCertificate(String alias, boolean includeDeletedSystem) throws RemoteException {
            return null;
        }

        @Override
        public List<String> getCaCertificateChainAliases(String rootAlias, boolean includeDeletedSystem) throws RemoteException {
            return null;
        }

        @Override
        public void setCredentialManagementApp(String packageName, AppUriAuthenticationPolicy policy) throws RemoteException {
        }

        @Override
        public boolean hasCredentialManagementApp() throws RemoteException {
            return false;
        }

        @Override
        public String getCredentialManagementAppPackageName() throws RemoteException {
            return null;
        }

        @Override
        public AppUriAuthenticationPolicy getCredentialManagementAppPolicy() throws RemoteException {
            return null;
        }

        @Override
        public String getPredefinedAliasForPackageAndUri(String packageName, Uri uri) throws RemoteException {
            return null;
        }

        @Override
        public void removeCredentialManagementApp() throws RemoteException {
        }

        @Override
        public boolean isCredentialManagementApp(String packageName) throws RemoteException {
            return false;
        }

        @Override
        public boolean setGrant(int uid, String alias, boolean value) throws RemoteException {
            return false;
        }

        @Override
        public boolean hasGrant(int uid, String alias) throws RemoteException {
            return false;
        }

        @Override
        public String getWifiKeyGrantAsUser(String alias) throws RemoteException {
            return null;
        }

        @Override
        public IBinder asBinder() {
            return null;
        }
    }
}

