/*
 * Decompiled with CFR 0.152.
 */
package android.security.keystore2;

import android.hardware.security.keymint.KeyParameter;
import android.security.KeyStoreException;
import android.security.KeyStoreOperation;
import android.security.keystore.KeyStoreCryptoOperation;
import android.security.keystore2.AndroidKeyStoreKey;
import android.security.keystore2.AndroidKeyStorePrivateKey;
import android.security.keystore2.KeyStore2ParameterUtils;
import android.security.keystore2.KeyStoreCryptoOperationChunkedStreamer;
import android.security.keystore2.KeyStoreCryptoOperationStreamer;
import android.security.keystore2.KeyStoreCryptoOperationUtils;
import android.system.keystore2.Authorization;
import java.nio.BufferOverflowException;
import java.nio.ByteBuffer;
import java.security.AlgorithmParameters;
import java.security.GeneralSecurityException;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.InvalidParameterException;
import java.security.Key;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.ProviderException;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.MGF1ParameterSpec;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import java.util.ArrayList;
import java.util.List;
import javax.crypto.AEADBadTagException;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.CipherSpi;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.ShortBufferException;
import javax.crypto.spec.OAEPParameterSpec;
import javax.crypto.spec.PSource;
import javax.crypto.spec.SecretKeySpec;
import libcore.util.EmptyArray;

abstract class AndroidKeyStoreCipherSpiBase
extends CipherSpi
implements KeyStoreCryptoOperation {
    private static final String TAG = "AndroidKeyStoreCipherSpiBase";
    public static final String DEFAULT_MGF1_DIGEST = "SHA-1";
    private boolean mEncrypting = false;
    private int mKeymasterPurposeOverride = -1;
    private AndroidKeyStoreKey mKey = null;
    private SecureRandom mRng = null;
    private KeyStoreOperation mOperation = null;
    private long mOperationChallenge = 0L;
    private KeyStoreCryptoOperationStreamer mMainDataStreamer = null;
    private KeyStoreCryptoOperationStreamer mAdditionalAuthenticationDataStreamer = null;
    private boolean mAdditionalAuthenticationDataStreamerClosed = false;
    private Exception mCachedException = null;
    private Cipher mCipher = null;

    AndroidKeyStoreCipherSpiBase() {
    }

    private Authorization[] getKeyCharacteristics(Key key) {
        if (!(key instanceof AndroidKeyStoreKey)) {
            return new Authorization[0];
        }
        return ((AndroidKeyStoreKey)key).getAuthorizations();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void engineInit(int opmode, Key key, SecureRandom random) throws InvalidKeyException {
        this.resetAll();
        if (!(key instanceof AndroidKeyStorePrivateKey) && (key instanceof PrivateKey || key instanceof PublicKey)) {
            try {
                this.mCipher = Cipher.getInstance(this.getTransform());
                String transform = this.getTransform();
                if ("RSA/ECB/OAEPWithSHA-224AndMGF1Padding".equals(transform)) {
                    OAEPParameterSpec spec = new OAEPParameterSpec("SHA-224", "MGF1", new MGF1ParameterSpec(DEFAULT_MGF1_DIGEST), PSource.PSpecified.DEFAULT);
                    this.mCipher.init(opmode, key, spec, random);
                } else if ("RSA/ECB/OAEPWithSHA-256AndMGF1Padding".equals(transform)) {
                    OAEPParameterSpec spec = new OAEPParameterSpec("SHA-256", "MGF1", new MGF1ParameterSpec(DEFAULT_MGF1_DIGEST), PSource.PSpecified.DEFAULT);
                    this.mCipher.init(opmode, key, spec, random);
                } else if ("RSA/ECB/OAEPWithSHA-384AndMGF1Padding".equals(transform)) {
                    OAEPParameterSpec spec = new OAEPParameterSpec("SHA-384", "MGF1", new MGF1ParameterSpec(DEFAULT_MGF1_DIGEST), PSource.PSpecified.DEFAULT);
                    this.mCipher.init(opmode, key, spec, random);
                } else if ("RSA/ECB/OAEPWithSHA-512AndMGF1Padding".equals(transform)) {
                    OAEPParameterSpec spec = new OAEPParameterSpec("SHA-512", "MGF1", new MGF1ParameterSpec(DEFAULT_MGF1_DIGEST), PSource.PSpecified.DEFAULT);
                    this.mCipher.init(opmode, key, spec, random);
                } else {
                    this.mCipher.init(opmode, key, random);
                }
                return;
            }
            catch (InvalidAlgorithmParameterException | NoSuchAlgorithmException | NoSuchPaddingException e) {
                throw new InvalidKeyException(e);
            }
        }
        boolean success = false;
        try {
            this.init(opmode, key, random);
            this.initAlgorithmSpecificParameters();
            try {
                this.ensureKeystoreOperationInitialized(this.getKeyCharacteristics(key));
            }
            catch (InvalidAlgorithmParameterException e) {
                throw new InvalidKeyException(e);
            }
            success = true;
        }
        finally {
            if (!success) {
                this.resetAll();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void engineInit(int opmode, Key key, AlgorithmParameters params, SecureRandom random) throws InvalidKeyException, InvalidAlgorithmParameterException {
        this.resetAll();
        if (!(key instanceof AndroidKeyStorePrivateKey) && (key instanceof PrivateKey || key instanceof PublicKey)) {
            try {
                this.mCipher = Cipher.getInstance(this.getTransform());
                this.mCipher.init(opmode, key, params, random);
                return;
            }
            catch (NoSuchAlgorithmException | NoSuchPaddingException e) {
                throw new InvalidKeyException(e);
            }
        }
        boolean success = false;
        try {
            this.init(opmode, key, random);
            this.initAlgorithmSpecificParameters(params);
            this.ensureKeystoreOperationInitialized(this.getKeyCharacteristics(key));
            success = true;
        }
        finally {
            if (!success) {
                this.resetAll();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void engineInit(int opmode, Key key, AlgorithmParameterSpec params, SecureRandom random) throws InvalidKeyException, InvalidAlgorithmParameterException {
        this.resetAll();
        if (!(key instanceof AndroidKeyStorePrivateKey) && (key instanceof PrivateKey || key instanceof PublicKey)) {
            try {
                this.mCipher = Cipher.getInstance(this.getTransform());
                this.mCipher.init(opmode, key, params, random);
                return;
            }
            catch (NoSuchAlgorithmException | NoSuchPaddingException e) {
                throw new InvalidKeyException(e);
            }
        }
        boolean success = false;
        try {
            this.init(opmode, key, random);
            this.initAlgorithmSpecificParameters(params);
            this.ensureKeystoreOperationInitialized(this.getKeyCharacteristics(key));
            success = true;
        }
        finally {
            if (!success) {
                this.resetAll();
            }
        }
    }

    private void init(int opmode, Key key, SecureRandom random) throws InvalidKeyException {
        switch (opmode) {
            case 1: 
            case 3: {
                this.mEncrypting = true;
                break;
            }
            case 2: 
            case 4: {
                this.mEncrypting = false;
                break;
            }
            default: {
                throw new InvalidParameterException("Unsupported opmode: " + opmode);
            }
        }
        this.initKey(opmode, key);
        if (this.mKey == null) {
            throw new ProviderException("initKey did not initialize the key");
        }
        this.mRng = random;
    }

    private void abortOperation() {
        KeyStoreCryptoOperationUtils.abortOperation(this.mOperation);
        this.mOperation = null;
    }

    protected void resetAll() {
        this.abortOperation();
        this.mEncrypting = false;
        this.mKeymasterPurposeOverride = -1;
        this.mKey = null;
        this.mRng = null;
        this.mOperationChallenge = 0L;
        this.mMainDataStreamer = null;
        this.mAdditionalAuthenticationDataStreamer = null;
        this.mAdditionalAuthenticationDataStreamerClosed = false;
        this.mCachedException = null;
        this.mCipher = null;
    }

    protected void resetWhilePreservingInitState() {
        this.abortOperation();
        this.mOperationChallenge = 0L;
        this.mMainDataStreamer = null;
        this.mAdditionalAuthenticationDataStreamer = null;
        this.mAdditionalAuthenticationDataStreamerClosed = false;
        this.mCachedException = null;
    }

    private void ensureKeystoreOperationInitialized(Authorization[] keyCharacteristics) throws InvalidKeyException, InvalidAlgorithmParameterException {
        block7: {
            if (this.mMainDataStreamer != null) {
                return;
            }
            if (this.mCachedException != null) {
                return;
            }
            if (this.mKey == null) {
                throw new IllegalStateException("Not initialized");
            }
            ArrayList<KeyParameter> parameters = new ArrayList<KeyParameter>();
            this.addAlgorithmSpecificParametersToBegin(parameters, keyCharacteristics);
            int purpose = this.mKeymasterPurposeOverride != -1 ? this.mKeymasterPurposeOverride : (this.mEncrypting ? 0 : 1);
            parameters.add(KeyStore2ParameterUtils.makeEnum(0x20000001, purpose));
            try {
                this.mOperation = this.mKey.getSecurityLevel().createOperation(this.mKey.getKeyIdDescriptor(), parameters);
            }
            catch (KeyStoreException keyStoreException) {
                GeneralSecurityException e = KeyStoreCryptoOperationUtils.getExceptionForCipherInit(this.mKey, keyStoreException);
                if (e == null) break block7;
                if (e instanceof InvalidKeyException) {
                    throw (InvalidKeyException)e;
                }
                if (e instanceof InvalidAlgorithmParameterException) {
                    throw (InvalidAlgorithmParameterException)e;
                }
                throw new ProviderException("Unexpected exception type", e);
            }
        }
        this.mOperationChallenge = KeyStoreCryptoOperationUtils.getOrMakeOperationChallenge(this.mOperation, this.mKey);
        this.loadAlgorithmSpecificParametersFromBeginResult(this.mOperation.getParameters());
        this.mMainDataStreamer = this.createMainDataStreamer(this.mOperation);
        this.mAdditionalAuthenticationDataStreamer = this.createAdditionalAuthenticationDataStreamer(this.mOperation);
        this.mAdditionalAuthenticationDataStreamerClosed = false;
    }

    protected KeyStoreCryptoOperationStreamer createMainDataStreamer(KeyStoreOperation operation) {
        return new KeyStoreCryptoOperationChunkedStreamer(new KeyStoreCryptoOperationChunkedStreamer.MainDataStream(operation), 0);
    }

    protected KeyStoreCryptoOperationStreamer createAdditionalAuthenticationDataStreamer(KeyStoreOperation operation) {
        return null;
    }

    @Override
    protected byte[] engineUpdate(byte[] input, int inputOffset, int inputLen) {
        byte[] output;
        if (this.mCipher != null) {
            return this.mCipher.update(input, inputOffset, inputLen);
        }
        if (this.mCachedException != null) {
            return null;
        }
        try {
            this.ensureKeystoreOperationInitialized(this.getKeyCharacteristics(this.mKey));
        }
        catch (InvalidAlgorithmParameterException | InvalidKeyException e) {
            this.mCachedException = e;
            return null;
        }
        if (inputLen == 0) {
            return null;
        }
        try {
            this.flushAAD();
            output = this.mMainDataStreamer.update(input, inputOffset, inputLen);
        }
        catch (KeyStoreException e) {
            this.mCachedException = e;
            return null;
        }
        if (output.length == 0) {
            return null;
        }
        return output;
    }

    private void flushAAD() throws KeyStoreException {
        if (this.mAdditionalAuthenticationDataStreamer != null && !this.mAdditionalAuthenticationDataStreamerClosed) {
            byte[] output;
            try {
                output = this.mAdditionalAuthenticationDataStreamer.doFinal(EmptyArray.BYTE, 0, 0, null);
            }
            finally {
                this.mAdditionalAuthenticationDataStreamerClosed = true;
            }
            if (output != null && output.length > 0) {
                throw new ProviderException("AAD update unexpectedly returned data: " + output.length + " bytes");
            }
        }
    }

    @Override
    protected int engineUpdate(byte[] input, int inputOffset, int inputLen, byte[] output, int outputOffset) throws ShortBufferException {
        if (this.mCipher != null) {
            return this.mCipher.update(input, inputOffset, inputLen, output);
        }
        byte[] outputCopy = this.engineUpdate(input, inputOffset, inputLen);
        if (outputCopy == null) {
            return 0;
        }
        int outputAvailable = output.length - outputOffset;
        if (outputCopy.length > outputAvailable) {
            throw new ShortBufferException("Output buffer too short. Produced: " + outputCopy.length + ", available: " + outputAvailable);
        }
        System.arraycopy(outputCopy, 0, output, outputOffset, outputCopy.length);
        return outputCopy.length;
    }

    @Override
    protected int engineUpdate(ByteBuffer input, ByteBuffer output) throws ShortBufferException {
        int outputSize;
        byte[] outputArray;
        if (this.mCipher != null) {
            return this.mCipher.update(input, output);
        }
        if (input == null) {
            throw new NullPointerException("input == null");
        }
        if (output == null) {
            throw new NullPointerException("output == null");
        }
        int inputSize = input.remaining();
        if (input.hasArray()) {
            outputArray = this.engineUpdate(input.array(), input.arrayOffset() + input.position(), inputSize);
            input.position(input.position() + inputSize);
        } else {
            byte[] inputArray = new byte[inputSize];
            input.get(inputArray);
            outputArray = this.engineUpdate(inputArray, 0, inputSize);
        }
        int n = outputSize = outputArray != null ? outputArray.length : 0;
        if (outputSize > 0) {
            int outputBufferAvailable = output.remaining();
            try {
                output.put(outputArray);
            }
            catch (BufferOverflowException e) {
                throw new ShortBufferException("Output buffer too small. Produced: " + outputSize + ", available: " + outputBufferAvailable);
            }
        }
        return outputSize;
    }

    @Override
    protected void engineUpdateAAD(byte[] input, int inputOffset, int inputLen) {
        byte[] output;
        if (this.mCipher != null) {
            this.mCipher.updateAAD(input, inputOffset, inputLen);
            return;
        }
        if (this.mCachedException != null) {
            return;
        }
        try {
            this.ensureKeystoreOperationInitialized(this.getKeyCharacteristics(this.mKey));
        }
        catch (InvalidAlgorithmParameterException | InvalidKeyException e) {
            this.mCachedException = e;
            return;
        }
        if (this.mAdditionalAuthenticationDataStreamerClosed) {
            throw new IllegalStateException("AAD can only be provided before Cipher.update is invoked");
        }
        if (this.mAdditionalAuthenticationDataStreamer == null) {
            throw new IllegalStateException("This cipher does not support AAD");
        }
        try {
            output = this.mAdditionalAuthenticationDataStreamer.update(input, inputOffset, inputLen);
        }
        catch (KeyStoreException e) {
            this.mCachedException = e;
            return;
        }
        if (output != null && output.length > 0) {
            throw new ProviderException("AAD update unexpectedly produced output: " + output.length + " bytes");
        }
    }

    @Override
    protected void engineUpdateAAD(ByteBuffer src) {
        int inputLen;
        int inputOffset;
        byte[] input;
        if (this.mCipher != null) {
            this.mCipher.updateAAD(src);
            return;
        }
        if (src == null) {
            throw new IllegalArgumentException("src == null");
        }
        if (!src.hasRemaining()) {
            return;
        }
        if (src.hasArray()) {
            input = src.array();
            inputOffset = src.arrayOffset() + src.position();
            inputLen = src.remaining();
            src.position(src.limit());
        } else {
            input = new byte[src.remaining()];
            inputOffset = 0;
            inputLen = input.length;
            src.get(input);
        }
        this.engineUpdateAAD(input, inputOffset, inputLen);
    }

    @Override
    protected byte[] engineDoFinal(byte[] input, int inputOffset, int inputLen) throws IllegalBlockSizeException, BadPaddingException {
        byte[] output;
        if (this.mCipher != null) {
            if (input == null && inputLen == 0) {
                return this.mCipher.doFinal();
            }
            return this.mCipher.doFinal(input, inputOffset, inputLen);
        }
        if (this.mCachedException != null) {
            throw (IllegalBlockSizeException)new IllegalBlockSizeException().initCause(this.mCachedException);
        }
        try {
            this.ensureKeystoreOperationInitialized(this.getKeyCharacteristics(this.mKey));
        }
        catch (InvalidAlgorithmParameterException | InvalidKeyException e) {
            throw (IllegalBlockSizeException)new IllegalBlockSizeException().initCause(e);
        }
        try {
            this.flushAAD();
            output = this.mMainDataStreamer.doFinal(input, inputOffset, inputLen, null);
        }
        catch (KeyStoreException e) {
            switch (e.getErrorCode()) {
                case -38: {
                    throw (BadPaddingException)new BadPaddingException().initCause(e);
                }
                case -30: {
                    throw (AEADBadTagException)new AEADBadTagException().initCause(e);
                }
            }
            throw (IllegalBlockSizeException)new IllegalBlockSizeException().initCause(e);
        }
        this.resetWhilePreservingInitState();
        return output;
    }

    @Override
    protected int engineDoFinal(byte[] input, int inputOffset, int inputLen, byte[] output, int outputOffset) throws ShortBufferException, IllegalBlockSizeException, BadPaddingException {
        if (this.mCipher != null) {
            return this.mCipher.doFinal(input, inputOffset, inputLen, output);
        }
        byte[] outputCopy = this.engineDoFinal(input, inputOffset, inputLen);
        if (outputCopy == null) {
            return 0;
        }
        int outputAvailable = output.length - outputOffset;
        if (outputCopy.length > outputAvailable) {
            throw new ShortBufferException("Output buffer too short. Produced: " + outputCopy.length + ", available: " + outputAvailable);
        }
        System.arraycopy(outputCopy, 0, output, outputOffset, outputCopy.length);
        return outputCopy.length;
    }

    @Override
    protected int engineDoFinal(ByteBuffer input, ByteBuffer output) throws ShortBufferException, IllegalBlockSizeException, BadPaddingException {
        int outputSize;
        byte[] outputArray;
        if (this.mCipher != null) {
            return this.mCipher.doFinal(input, output);
        }
        if (input == null) {
            throw new NullPointerException("input == null");
        }
        if (output == null) {
            throw new NullPointerException("output == null");
        }
        int inputSize = input.remaining();
        if (input.hasArray()) {
            outputArray = this.engineDoFinal(input.array(), input.arrayOffset() + input.position(), inputSize);
            input.position(input.position() + inputSize);
        } else {
            byte[] inputArray = new byte[inputSize];
            input.get(inputArray);
            outputArray = this.engineDoFinal(inputArray, 0, inputSize);
        }
        int n = outputSize = outputArray != null ? outputArray.length : 0;
        if (outputSize > 0) {
            int outputBufferAvailable = output.remaining();
            try {
                output.put(outputArray);
            }
            catch (BufferOverflowException e) {
                throw new ShortBufferException("Output buffer too small. Produced: " + outputSize + ", available: " + outputBufferAvailable);
            }
        }
        return outputSize;
    }

    @Override
    protected byte[] engineWrap(Key key) throws IllegalBlockSizeException, InvalidKeyException {
        Object keyFactory;
        if (this.mCipher != null) {
            return this.mCipher.wrap(key);
        }
        if (this.mKey == null) {
            throw new IllegalStateException("Not initilized");
        }
        if (!this.isEncrypting()) {
            throw new IllegalStateException("Cipher must be initialized in Cipher.WRAP_MODE to wrap keys");
        }
        if (key == null) {
            throw new NullPointerException("key == null");
        }
        byte[] encoded = null;
        if (key instanceof SecretKey) {
            if ("RAW".equalsIgnoreCase(key.getFormat())) {
                encoded = key.getEncoded();
            }
            if (encoded == null) {
                try {
                    keyFactory = SecretKeyFactory.getInstance(key.getAlgorithm());
                    SecretKeySpec spec = (SecretKeySpec)((SecretKeyFactory)keyFactory).getKeySpec((SecretKey)key, SecretKeySpec.class);
                    encoded = spec.getEncoded();
                }
                catch (NoSuchAlgorithmException | InvalidKeySpecException e) {
                    throw new InvalidKeyException("Failed to wrap key because it does not export its key material", e);
                }
            }
        } else if (key instanceof PrivateKey) {
            if ("PKCS8".equalsIgnoreCase(key.getFormat())) {
                encoded = key.getEncoded();
            }
            if (encoded == null) {
                try {
                    keyFactory = KeyFactory.getInstance(key.getAlgorithm());
                    PKCS8EncodedKeySpec spec = ((KeyFactory)keyFactory).getKeySpec(key, PKCS8EncodedKeySpec.class);
                    encoded = spec.getEncoded();
                }
                catch (NoSuchAlgorithmException | InvalidKeySpecException e) {
                    throw new InvalidKeyException("Failed to wrap key because it does not export its key material", e);
                }
            }
        } else if (key instanceof PublicKey) {
            if ("X.509".equalsIgnoreCase(key.getFormat())) {
                encoded = key.getEncoded();
            }
            if (encoded == null) {
                try {
                    keyFactory = KeyFactory.getInstance(key.getAlgorithm());
                    X509EncodedKeySpec spec = ((KeyFactory)keyFactory).getKeySpec(key, X509EncodedKeySpec.class);
                    encoded = spec.getEncoded();
                }
                catch (NoSuchAlgorithmException | InvalidKeySpecException e) {
                    throw new InvalidKeyException("Failed to wrap key because it does not export its key material", e);
                }
            }
        } else {
            throw new InvalidKeyException("Unsupported key type: " + key.getClass().getName());
        }
        if (encoded == null) {
            throw new InvalidKeyException("Failed to wrap key because it does not export its key material");
        }
        try {
            return this.engineDoFinal(encoded, 0, encoded.length);
        }
        catch (BadPaddingException e) {
            throw (IllegalBlockSizeException)new IllegalBlockSizeException().initCause(e);
        }
    }

    @Override
    protected Key engineUnwrap(byte[] wrappedKey, String wrappedKeyAlgorithm, int wrappedKeyType) throws InvalidKeyException, NoSuchAlgorithmException {
        byte[] encoded;
        if (this.mCipher != null) {
            return this.mCipher.unwrap(wrappedKey, wrappedKeyAlgorithm, wrappedKeyType);
        }
        if (this.mKey == null) {
            throw new IllegalStateException("Not initilized");
        }
        if (this.isEncrypting()) {
            throw new IllegalStateException("Cipher must be initialized in Cipher.WRAP_MODE to wrap keys");
        }
        if (wrappedKey == null) {
            throw new NullPointerException("wrappedKey == null");
        }
        try {
            encoded = this.engineDoFinal(wrappedKey, 0, wrappedKey.length);
        }
        catch (BadPaddingException | IllegalBlockSizeException e) {
            throw new InvalidKeyException("Failed to unwrap key", e);
        }
        switch (wrappedKeyType) {
            case 3: {
                return new SecretKeySpec(encoded, wrappedKeyAlgorithm);
            }
            case 2: {
                KeyFactory keyFactory = KeyFactory.getInstance(wrappedKeyAlgorithm);
                try {
                    return keyFactory.generatePrivate(new PKCS8EncodedKeySpec(encoded));
                }
                catch (InvalidKeySpecException e) {
                    throw new InvalidKeyException("Failed to create private key from its PKCS#8 encoded form", e);
                }
            }
            case 1: {
                KeyFactory keyFactory = KeyFactory.getInstance(wrappedKeyAlgorithm);
                try {
                    return keyFactory.generatePublic(new X509EncodedKeySpec(encoded));
                }
                catch (InvalidKeySpecException e) {
                    throw new InvalidKeyException("Failed to create public key from its X.509 encoded form", e);
                }
            }
        }
        throw new InvalidParameterException("Unsupported wrappedKeyType: " + wrappedKeyType);
    }

    @Override
    protected void engineSetMode(String mode) throws NoSuchAlgorithmException {
        throw new UnsupportedOperationException();
    }

    @Override
    protected void engineSetPadding(String arg0) throws NoSuchPaddingException {
        throw new UnsupportedOperationException();
    }

    @Override
    protected int engineGetKeySize(Key key) throws InvalidKeyException {
        throw new UnsupportedOperationException();
    }

    public void finalize() throws Throwable {
        try {
            this.abortOperation();
        }
        finally {
            super.finalize();
        }
    }

    @Override
    public long getOperationHandle() {
        return this.mOperationChallenge;
    }

    protected void setKey(AndroidKeyStoreKey key) {
        this.mKey = key;
    }

    protected void setKeymasterPurposeOverride(int keymasterPurpose) {
        this.mKeymasterPurposeOverride = keymasterPurpose;
    }

    protected int getKeymasterPurposeOverride() {
        return this.mKeymasterPurposeOverride;
    }

    protected boolean isEncrypting() {
        return this.mEncrypting;
    }

    protected long getConsumedInputSizeBytes() {
        if (this.mMainDataStreamer == null) {
            throw new IllegalStateException("Not initialized");
        }
        return this.mMainDataStreamer.getConsumedInputSizeBytes();
    }

    protected long getProducedOutputSizeBytes() {
        if (this.mMainDataStreamer == null) {
            throw new IllegalStateException("Not initialized");
        }
        return this.mMainDataStreamer.getProducedOutputSizeBytes();
    }

    static String opmodeToString(int opmode) {
        switch (opmode) {
            case 1: {
                return "ENCRYPT_MODE";
            }
            case 2: {
                return "DECRYPT_MODE";
            }
            case 3: {
                return "WRAP_MODE";
            }
            case 4: {
                return "UNWRAP_MODE";
            }
        }
        return String.valueOf(opmode);
    }

    protected abstract void initKey(int var1, Key var2) throws InvalidKeyException;

    @Override
    protected abstract AlgorithmParameters engineGetParameters();

    protected abstract void initAlgorithmSpecificParameters() throws InvalidKeyException;

    protected abstract void initAlgorithmSpecificParameters(AlgorithmParameterSpec var1) throws InvalidAlgorithmParameterException;

    protected abstract void initAlgorithmSpecificParameters(AlgorithmParameters var1) throws InvalidAlgorithmParameterException;

    protected abstract int getAdditionalEntropyAmountForBegin();

    protected abstract int getAdditionalEntropyAmountForFinish();

    protected abstract void addAlgorithmSpecificParametersToBegin(List<KeyParameter> var1);

    protected void addAlgorithmSpecificParametersToBegin(List<KeyParameter> parameters, Authorization[] keyCharacteristics) {
        this.addAlgorithmSpecificParametersToBegin(parameters);
    }

    protected abstract void loadAlgorithmSpecificParametersFromBeginResult(KeyParameter[] var1);

    protected abstract String getTransform();
}

