/*
 * Decompiled with CFR 0.152.
 */
package android.security.keystore2;

import android.security.KeyStoreSecurityLevel;
import android.security.keystore2.AndroidKeyStoreECPrivateKey;
import android.security.keystore2.AndroidKeyStorePrivateKey;
import android.security.keystore2.AndroidKeyStorePublicKey;
import android.security.keystore2.KeymasterUtils;
import android.system.keystore2.Authorization;
import android.system.keystore2.KeyDescriptor;
import android.system.keystore2.KeyMetadata;
import java.security.interfaces.ECPublicKey;
import java.security.spec.ECParameterSpec;
import java.security.spec.ECPoint;

public class AndroidKeyStoreECPublicKey
extends AndroidKeyStorePublicKey
implements ECPublicKey {
    private final ECParameterSpec mParams;
    private final ECPoint mW;

    public AndroidKeyStoreECPublicKey(KeyDescriptor descriptor, KeyMetadata metadata, byte[] x509EncodedForm, KeyStoreSecurityLevel securityLevel, ECParameterSpec params, ECPoint w) {
        super(descriptor, metadata, x509EncodedForm, "EC", securityLevel);
        this.mParams = params;
        this.mW = w;
    }

    public AndroidKeyStoreECPublicKey(KeyDescriptor descriptor, KeyMetadata metadata, KeyStoreSecurityLevel securityLevel, ECPublicKey info) {
        this(descriptor, metadata, info.getEncoded(), securityLevel, info.getParams(), info.getW());
        if (!"X.509".equalsIgnoreCase(info.getFormat())) {
            throw new IllegalArgumentException("Unsupported key export format: " + info.getFormat());
        }
    }

    @Override
    public AndroidKeyStorePrivateKey getPrivateKey() {
        ECParameterSpec params = this.mParams;
        for (Authorization a : this.getAuthorizations()) {
            try {
                if (a.keyParameter.tag != 0x1000000A) continue;
                params = KeymasterUtils.getCurveSpec(KeymasterUtils.getEcCurveFromKeymaster(a.keyParameter.value.getEcCurve()));
                break;
            }
            catch (Exception e) {
                throw new RuntimeException("Unable to parse EC curve " + a.keyParameter.value.getEcCurve());
            }
        }
        return new AndroidKeyStoreECPrivateKey(this.getUserKeyDescriptor(), this.getKeyIdDescriptor().nspace, this.getAuthorizations(), this.getSecurityLevel(), params);
    }

    @Override
    public ECParameterSpec getParams() {
        return this.mParams;
    }

    @Override
    public ECPoint getW() {
        return this.mW;
    }
}

