/*
 * Decompiled with CFR 0.152.
 */
package android.security.keystore2;

import android.app.ActivityThread;
import android.hardware.biometrics.BiometricManager;
import android.security.GateKeeper;
import android.security.KeyStoreException;
import android.security.KeyStoreOperation;
import android.security.keystore.KeyExpiredException;
import android.security.keystore.KeyNotYetValidException;
import android.security.keystore.KeyPermanentlyInvalidatedException;
import android.security.keystore.UserNotAuthenticatedException;
import android.security.keystore2.AndroidKeyStoreKey;
import android.system.keystore2.Authorization;
import android.util.Log;
import java.security.GeneralSecurityException;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.SecureRandom;
import java.util.ArrayList;
import libcore.util.EmptyArray;

abstract class KeyStoreCryptoOperationUtils {
    private static volatile SecureRandom sRng;

    private KeyStoreCryptoOperationUtils() {
    }

    public static boolean canUserAuthorizationSucceed(AndroidKeyStoreKey key) {
        ArrayList<Long> keySids = new ArrayList<Long>();
        block3: for (Authorization p : key.getAuthorizations()) {
            switch (p.keyParameter.tag) {
                case -1610612234: {
                    keySids.add(p.keyParameter.value.getLongInteger());
                    continue block3;
                }
            }
        }
        if (keySids.isEmpty()) {
            return false;
        }
        long rootSid = GateKeeper.getSecureUserId();
        if (rootSid != 0L && keySids.contains(rootSid)) {
            return true;
        }
        long[] biometricSids = ActivityThread.currentApplication().getSystemService(BiometricManager.class).getAuthenticatorIds();
        boolean canUnlockViaBiometrics = biometricSids.length > 0;
        for (long sid : biometricSids) {
            if (keySids.contains(sid)) continue;
            canUnlockViaBiometrics = false;
            break;
        }
        return canUnlockViaBiometrics;
    }

    public static InvalidKeyException getInvalidKeyException(AndroidKeyStoreKey key, KeyStoreException e) {
        switch (e.getErrorCode()) {
            case -25: {
                return new KeyExpiredException();
            }
            case -24: {
                return new KeyNotYetValidException();
            }
            case 7: 
            case 17: {
                return new KeyPermanentlyInvalidatedException();
            }
            case -26: 
            case 2: 
            case 3: {
                return new UserNotAuthenticatedException();
            }
        }
        return new InvalidKeyException("Keystore operation failed", e);
    }

    public static GeneralSecurityException getExceptionForCipherInit(AndroidKeyStoreKey key, KeyStoreException e) {
        if (e.getErrorCode() == 1) {
            return null;
        }
        switch (e.getErrorCode()) {
            case -52: {
                return new InvalidAlgorithmParameterException("Invalid IV");
            }
            case -55: {
                return new InvalidAlgorithmParameterException("Caller-provided IV not permitted");
            }
        }
        return KeyStoreCryptoOperationUtils.getInvalidKeyException(key, e);
    }

    static byte[] getRandomBytesToMixIntoKeystoreRng(SecureRandom rng, int sizeBytes) {
        if (sizeBytes <= 0) {
            return EmptyArray.BYTE;
        }
        if (rng == null) {
            rng = KeyStoreCryptoOperationUtils.getRng();
        }
        byte[] result = new byte[sizeBytes];
        rng.nextBytes(result);
        return result;
    }

    private static SecureRandom getRng() {
        if (sRng == null) {
            sRng = new SecureRandom();
        }
        return sRng;
    }

    static void abortOperation(KeyStoreOperation operation) {
        block3: {
            if (operation != null) {
                try {
                    operation.abort();
                }
                catch (KeyStoreException e) {
                    if (e.getErrorCode() == -28) break block3;
                    Log.w("KeyStoreCryptoOperationUtils", "Encountered error trying to abort a keystore operation.", e);
                }
            }
        }
    }

    static long getOrMakeOperationChallenge(KeyStoreOperation operation, AndroidKeyStoreKey key) throws KeyPermanentlyInvalidatedException {
        if (operation.getChallenge() != null) {
            if (!KeyStoreCryptoOperationUtils.canUserAuthorizationSucceed(key)) {
                throw new KeyPermanentlyInvalidatedException();
            }
            return operation.getChallenge();
        }
        return KeyStoreCryptoOperationUtils.getRng().nextLong();
    }
}

