/*
 * Decompiled with CFR 0.152.
 */
package android.security.keystore2;

import android.security.keymaster.KeymasterArguments;
import android.security.keystore.KeyProperties;
import com.android.internal.util.ArrayUtils;
import java.security.AlgorithmParameters;
import java.security.NoSuchAlgorithmException;
import java.security.ProviderException;
import java.security.spec.ECGenParameterSpec;
import java.security.spec.ECParameterSpec;
import java.security.spec.InvalidParameterSpecException;

public abstract class KeymasterUtils {
    private KeymasterUtils() {
    }

    static int getDigestOutputSizeBits(int keymasterDigest) {
        switch (keymasterDigest) {
            case 0: {
                return -1;
            }
            case 1: {
                return 128;
            }
            case 2: {
                return 160;
            }
            case 3: {
                return 224;
            }
            case 4: {
                return 256;
            }
            case 5: {
                return 384;
            }
            case 6: {
                return 512;
            }
        }
        throw new IllegalArgumentException("Unknown digest: " + keymasterDigest);
    }

    static boolean isKeymasterBlockModeIndCpaCompatibleWithSymmetricCrypto(int keymasterBlockMode) {
        switch (keymasterBlockMode) {
            case 1: {
                return false;
            }
            case 2: 
            case 3: 
            case 32: {
                return true;
            }
        }
        throw new IllegalArgumentException("Unsupported block mode: " + keymasterBlockMode);
    }

    static boolean isKeymasterPaddingSchemeIndCpaCompatibleWithAsymmetricCrypto(int keymasterPadding) {
        switch (keymasterPadding) {
            case 1: {
                return false;
            }
            case 2: 
            case 4: {
                return true;
            }
        }
        throw new IllegalArgumentException("Unsupported asymmetric encryption padding scheme: " + keymasterPadding);
    }

    public static void addMinMacLengthAuthorizationIfNecessary(KeymasterArguments args, int keymasterAlgorithm, int[] keymasterBlockModes, int[] keymasterDigests) {
        switch (keymasterAlgorithm) {
            case 32: {
                if (!ArrayUtils.contains(keymasterBlockModes, 32)) break;
                args.addUnsignedInt(0x30000008, 96L);
                break;
            }
            case 128: {
                if (keymasterDigests.length != 1) {
                    throw new ProviderException("Unsupported number of authorized digests for HMAC key: " + keymasterDigests.length + ". Exactly one digest must be authorized");
                }
                int keymasterDigest = keymasterDigests[0];
                int digestOutputSizeBits = KeymasterUtils.getDigestOutputSizeBits(keymasterDigest);
                if (digestOutputSizeBits == -1) {
                    throw new ProviderException("HMAC key authorized for unsupported digest: " + KeyProperties.Digest.fromKeymaster(keymasterDigest));
                }
                args.addUnsignedInt(0x30000008, digestOutputSizeBits);
            }
        }
    }

    static String getEcCurveFromKeymaster(int ecCurve) {
        switch (ecCurve) {
            case 0: {
                return "secp224r1";
            }
            case 1: {
                return "secp256r1";
            }
            case 2: {
                return "secp384r1";
            }
            case 3: {
                return "secp521r1";
            }
        }
        return "";
    }

    static int getKeymasterEcCurve(String ecCurveName) {
        if (ecCurveName.equals("secp224r1")) {
            return 0;
        }
        if (ecCurveName.equals("secp256r1")) {
            return 1;
        }
        if (ecCurveName.equals("secp384r1")) {
            return 2;
        }
        if (ecCurveName.equals("secp521r1")) {
            return 3;
        }
        return -1;
    }

    static ECParameterSpec getCurveSpec(String name) throws NoSuchAlgorithmException, InvalidParameterSpecException {
        AlgorithmParameters parameters = AlgorithmParameters.getInstance("EC");
        parameters.init(new ECGenParameterSpec(name));
        return parameters.getParameterSpec(ECParameterSpec.class);
    }

    static String getCurveName(ECParameterSpec spec) {
        if (KeymasterUtils.isECParameterSpecOfCurve(spec, "secp224r1")) {
            return "secp224r1";
        }
        if (KeymasterUtils.isECParameterSpecOfCurve(spec, "secp256r1")) {
            return "secp256r1";
        }
        if (KeymasterUtils.isECParameterSpecOfCurve(spec, "secp384r1")) {
            return "secp384r1";
        }
        if (KeymasterUtils.isECParameterSpecOfCurve(spec, "secp521r1")) {
            return "secp521r1";
        }
        return null;
    }

    private static boolean isECParameterSpecOfCurve(ECParameterSpec spec, String curveName) {
        try {
            ECParameterSpec curveSpec = KeymasterUtils.getCurveSpec(curveName);
            if (curveSpec.getCurve().equals(spec.getCurve()) && curveSpec.getOrder().equals(spec.getOrder()) && curveSpec.getGenerator().equals(spec.getGenerator())) {
                return true;
            }
        }
        catch (NoSuchAlgorithmException | InvalidParameterSpecException e) {
            return false;
        }
        return false;
    }
}

