/*
 * Decompiled with CFR 0.152.
 */
package android.security.net.config;

import android.os.Environment;
import android.os.UserHandle;
import android.security.net.config.DirectoryCertificateSource;
import java.io.File;

public class SystemCertificateSource
extends DirectoryCertificateSource {
    private final File mUserRemovedCaDir;

    private SystemCertificateSource() {
        super(SystemCertificateSource.getDirectory());
        File configDir = Environment.getUserConfigDirectory(UserHandle.myUserId());
        this.mUserRemovedCaDir = new File(configDir, "cacerts-removed");
    }

    private static File getDirectory() {
        if (System.getProperty("system.certs.enabled") != null && System.getProperty("system.certs.enabled").equals("true")) {
            return new File(System.getenv("ANDROID_ROOT") + "/etc/security/cacerts");
        }
        File updatable_dir = new File("/apex/com.android.conscrypt/cacerts");
        if (updatable_dir.exists() && updatable_dir.list().length != 0) {
            return updatable_dir;
        }
        return new File(System.getenv("ANDROID_ROOT") + "/etc/security/cacerts");
    }

    public static SystemCertificateSource getInstance() {
        return NoPreloadHolder.INSTANCE;
    }

    @Override
    protected boolean isCertMarkedAsRemoved(String caFile) {
        return new File(this.mUserRemovedCaDir, caFile).exists();
    }

    private static class NoPreloadHolder {
        private static final SystemCertificateSource INSTANCE = new SystemCertificateSource();

        private NoPreloadHolder() {
        }
    }
}

