/*
 * Decompiled with CFR 0.152.
 */
package android.service.credentials;

import android.annotation.NonNull;
import android.os.Bundle;
import android.os.Parcel;
import android.os.Parcelable;
import com.android.internal.util.AnnotationValidations;
import com.android.internal.util.Preconditions;

public class BeginGetCredentialOption
implements Parcelable {
    private static final String BUNDLE_ID_KEY = "android.service.credentials.BeginGetCredentialOption.BUNDLE_ID_KEY";
    private final String mId;
    private final String mType;
    private final Bundle mCandidateQueryData;
    public static final Parcelable.Creator<BeginGetCredentialOption> CREATOR = new Parcelable.Creator<BeginGetCredentialOption>(){

        public BeginGetCredentialOption[] newArray(int size) {
            return new BeginGetCredentialOption[size];
        }

        @Override
        public BeginGetCredentialOption createFromParcel(Parcel in) {
            return new BeginGetCredentialOption(in);
        }
    };

    public String getId() {
        return this.mId;
    }

    public String getType() {
        return this.mType;
    }

    public Bundle getCandidateQueryData() {
        return this.mCandidateQueryData;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        dest.writeString8(this.mType);
        dest.writeBundle(this.mCandidateQueryData);
        dest.writeString8(this.mId);
    }

    @Override
    public int describeContents() {
        return 0;
    }

    public String toString() {
        return "GetCredentialOption {type=" + this.mType + ", candidateQueryData=" + this.mCandidateQueryData + ", id=" + this.mId + "}";
    }

    public BeginGetCredentialOption(String id2, String type, Bundle candidateQueryData) {
        this.mId = Preconditions.checkStringNotEmpty(id2, "id must not be empty");
        this.mType = Preconditions.checkStringNotEmpty(type, "type must not be empty");
        Bundle bundle = new Bundle();
        bundle.putAll(candidateQueryData);
        this.mCandidateQueryData = bundle;
        this.addIdToBundle();
    }

    private void addIdToBundle() {
        this.mCandidateQueryData.putString(BUNDLE_ID_KEY, this.mId);
    }

    private BeginGetCredentialOption(Parcel in) {
        String type = in.readString8();
        Bundle candidateQueryData = in.readBundle();
        String id2 = in.readString8();
        this.mType = type;
        AnnotationValidations.validate(NonNull.class, null, (Object)this.mType);
        this.mCandidateQueryData = candidateQueryData;
        AnnotationValidations.validate(NonNull.class, null, (Object)this.mCandidateQueryData);
        this.mId = id2;
    }
}

