/*
 * Decompiled with CFR 0.152.
 */
package android.service.credentials;

import android.app.slice.Slice;
import android.os.Parcel;
import android.os.Parcelable;
import android.service.credentials.BeginGetCredentialOption;
import com.android.internal.util.Preconditions;
import java.util.Objects;

public class CredentialEntry
implements Parcelable {
    private final String mBeginGetCredentialOptionId;
    private final String mType;
    private final Slice mSlice;
    public static final Parcelable.Creator<CredentialEntry> CREATOR = new Parcelable.Creator<CredentialEntry>(){

        @Override
        public CredentialEntry createFromParcel(Parcel in) {
            return new CredentialEntry(in);
        }

        public CredentialEntry[] newArray(int size) {
            return new CredentialEntry[size];
        }
    };

    public CredentialEntry(String beginGetCredentialOptionId, String type, Slice slice) {
        this.mBeginGetCredentialOptionId = Preconditions.checkStringNotEmpty(beginGetCredentialOptionId, "beginGetCredentialOptionId must not be null, or empty");
        this.mType = Preconditions.checkStringNotEmpty(type, "type must not be null, or empty");
        this.mSlice = Objects.requireNonNull(slice, "slice must not be null");
    }

    public CredentialEntry(BeginGetCredentialOption beginGetCredentialOption, Slice slice) {
        Objects.requireNonNull(beginGetCredentialOption, "beginGetCredentialOption must not be null");
        this.mBeginGetCredentialOptionId = Preconditions.checkStringNotEmpty(beginGetCredentialOption.getId(), "Id in beginGetCredentialOption must not be null");
        this.mType = Preconditions.checkStringNotEmpty(beginGetCredentialOption.getType(), "type in beginGetCredentialOption must not be null");
        this.mSlice = Objects.requireNonNull(slice, "slice must not be null");
    }

    public CredentialEntry(String type, Slice slice) {
        this.mBeginGetCredentialOptionId = null;
        this.mType = Objects.requireNonNull(type, "type must not be null");
        this.mSlice = Objects.requireNonNull(slice, "slice must not be null");
    }

    private CredentialEntry(Parcel in) {
        Objects.requireNonNull(in, "parcel must not be null");
        this.mType = in.readString8();
        this.mSlice = in.readTypedObject(Slice.CREATOR);
        this.mBeginGetCredentialOptionId = in.readString8();
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        dest.writeString8(this.mType);
        dest.writeTypedObject(this.mSlice, flags);
        dest.writeString8(this.mBeginGetCredentialOptionId);
    }

    public String getBeginGetCredentialOptionId() {
        return this.mBeginGetCredentialOptionId;
    }

    public String getType() {
        return this.mType;
    }

    public Slice getSlice() {
        return this.mSlice;
    }
}

