/*
 * Decompiled with CFR 0.152.
 */
package android.service.notification;

import android.annotation.SystemApi;
import android.os.Bundle;
import android.os.Parcel;
import android.os.Parcelable;
import android.os.UserHandle;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;

@SystemApi
public class Adjustment
implements Parcelable {
    private final String mPackage;
    private final String mKey;
    private final CharSequence mExplanation;
    private final Bundle mSignals;
    private final int mUser;
    private String mIssuer;
    @SystemApi
    public static final String KEY_PEOPLE = "key_people";
    public static final String KEY_SNOOZE_CRITERIA = "key_snooze_criteria";
    public static final String KEY_GROUP_KEY = "key_group_key";
    public static final String KEY_USER_SENTIMENT = "key_user_sentiment";
    public static final String KEY_CONTEXTUAL_ACTIONS = "key_contextual_actions";
    public static final String KEY_TEXT_REPLIES = "key_text_replies";
    public static final String KEY_IMPORTANCE = "key_importance";
    public static final String KEY_IMPORTANCE_PROPOSAL = "key_importance_proposal";
    public static final String KEY_SENSITIVE_CONTENT = "key_sensitive_content";
    public static final String KEY_RANKING_SCORE = "key_ranking_score";
    @SystemApi
    public static final String KEY_NOT_CONVERSATION = "key_not_conversation";
    public static final Parcelable.Creator<Adjustment> CREATOR = new Parcelable.Creator<Adjustment>(){

        @Override
        public Adjustment createFromParcel(Parcel in) {
            return new Adjustment(in);
        }

        public Adjustment[] newArray(int size) {
            return new Adjustment[size];
        }
    };

    @SystemApi
    public Adjustment(String pkg, String key, Bundle signals, CharSequence explanation, int user) {
        this.mPackage = pkg;
        this.mKey = key;
        this.mSignals = signals;
        this.mExplanation = explanation;
        this.mUser = user;
    }

    public Adjustment(String pkg, String key, Bundle signals, CharSequence explanation, UserHandle userHandle) {
        this.mPackage = pkg;
        this.mKey = key;
        this.mSignals = signals;
        this.mExplanation = explanation;
        this.mUser = userHandle.getIdentifier();
    }

    @SystemApi
    protected Adjustment(Parcel in) {
        this.mPackage = in.readInt() == 1 ? in.readString() : null;
        this.mKey = in.readInt() == 1 ? in.readString() : null;
        this.mExplanation = in.readInt() == 1 ? in.readCharSequence() : null;
        this.mSignals = in.readBundle();
        this.mUser = in.readInt();
        this.mIssuer = in.readString();
    }

    public String getPackage() {
        return this.mPackage;
    }

    public String getKey() {
        return this.mKey;
    }

    public CharSequence getExplanation() {
        return this.mExplanation;
    }

    public Bundle getSignals() {
        return this.mSignals;
    }

    @SystemApi
    public int getUser() {
        return this.mUser;
    }

    public UserHandle getUserHandle() {
        return UserHandle.of(this.mUser);
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        if (this.mPackage != null) {
            dest.writeInt(1);
            dest.writeString(this.mPackage);
        } else {
            dest.writeInt(0);
        }
        if (this.mKey != null) {
            dest.writeInt(1);
            dest.writeString(this.mKey);
        } else {
            dest.writeInt(0);
        }
        if (this.mExplanation != null) {
            dest.writeInt(1);
            dest.writeCharSequence(this.mExplanation);
        } else {
            dest.writeInt(0);
        }
        dest.writeBundle(this.mSignals);
        dest.writeInt(this.mUser);
        dest.writeString(this.mIssuer);
    }

    public String toString() {
        return "Adjustment{mSignals=" + this.mSignals + '}';
    }

    public void setIssuer(String issuer) {
        this.mIssuer = issuer;
    }

    public String getIssuer() {
        return this.mIssuer;
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface Keys {
    }
}

