/*
 * Decompiled with CFR 0.152.
 */
package android.service.selectiontoolbar;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.animation.AnimatorSet;
import android.animation.ObjectAnimator;
import android.animation.ValueAnimator;
import android.content.Context;
import android.graphics.Point;
import android.graphics.Rect;
import android.graphics.drawable.AnimatedVectorDrawable;
import android.graphics.drawable.Drawable;
import android.os.IBinder;
import android.service.selectiontoolbar.FloatingToolbarRoot;
import android.service.selectiontoolbar.SelectionToolbarRenderService;
import android.text.TextUtils;
import android.util.Log;
import android.util.Size;
import android.view.ContextThemeWrapper;
import android.view.LayoutInflater;
import android.view.MotionEvent;
import android.view.SurfaceControlViewHost;
import android.view.View;
import android.view.ViewConfiguration;
import android.view.ViewGroup;
import android.view.animation.Animation;
import android.view.animation.AnimationSet;
import android.view.animation.AnimationUtils;
import android.view.animation.Interpolator;
import android.view.animation.Transformation;
import android.view.selectiontoolbar.ShowInfo;
import android.view.selectiontoolbar.ToolbarMenuItem;
import android.view.selectiontoolbar.WidgetInfo;
import android.widget.ArrayAdapter;
import android.widget.ImageButton;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.ListView;
import android.widget.TextView;
import com.android.internal.util.Preconditions;
import java.io.PrintWriter;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;

class RemoteSelectionToolbar {
    private static final String TAG = "RemoteSelectionToolbar";
    private static final int MIN_OVERFLOW_SIZE = 2;
    private static final int MAX_OVERFLOW_SIZE = 4;
    private final Context mContext;
    private final int mMarginHorizontal;
    private final int mMarginVertical;
    private final ViewGroup mContentContainer;
    private final ViewGroup mMainPanel;
    private final OverflowPanel mOverflowPanel;
    private final ImageButton mOverflowButton;
    private final Drawable mArrow;
    private final Drawable mOverflow;
    private final AnimatedVectorDrawable mToArrow;
    private final AnimatedVectorDrawable mToOverflow;
    private final OverflowPanelViewHelper mOverflowPanelViewHelper;
    private final Interpolator mLogAccelerateInterpolator;
    private final Interpolator mFastOutSlowInInterpolator;
    private final Interpolator mLinearOutSlowInInterpolator;
    private final Interpolator mFastOutLinearInInterpolator;
    private final AnimatorSet mShowAnimation;
    private final AnimatorSet mDismissAnimation;
    private final AnimatorSet mHideAnimation;
    private final AnimationSet mOpenOverflowAnimation;
    private final AnimationSet mCloseOverflowAnimation;
    private final Animation.AnimationListener mOverflowAnimationListener;
    private final Rect mViewPortOnScreen = new Rect();
    private final int mLineHeight;
    private final int mIconTextSpacing;
    private final long mSelectionToolbarToken;
    private IBinder mHostInputToken;
    private final SelectionToolbarRenderService.RemoteCallbackWrapper mCallbackWrapper;
    private final SelectionToolbarRenderService.TransferTouchListener mTransferTouchListener;
    private int mPopupWidth;
    private int mPopupHeight;
    private final Point mRelativeCoordsForToolbar = new Point();
    private List<ToolbarMenuItem> mMenuItems;
    private SurfaceControlViewHost mSurfaceControlViewHost;
    private SurfaceControlViewHost.SurfacePackage mSurfacePackage;
    private final Runnable mPreparePopupContentRTLHelper = new Runnable(){

        @Override
        public void run() {
            RemoteSelectionToolbar.this.setPanelsStatesAtRestingPosition();
            RemoteSelectionToolbar.this.mContentContainer.setAlpha(1.0f);
        }
    };
    private boolean mDismissed = true;
    private boolean mHidden;
    private final Size mOverflowButtonSize;
    private Size mOverflowPanelSize;
    private Size mMainPanelSize;
    private final View.OnClickListener mMenuItemButtonOnClickListener;
    private boolean mOpenOverflowUpwards;
    private boolean mIsOverflowOpen;
    private int mTransitionDurationScale;
    private final Rect mPreviousContentRect = new Rect();
    private final Rect mTempContentRect = new Rect();
    private final Rect mTempContentRectForRoot = new Rect();
    private final int[] mTempCoords = new int[2];

    RemoteSelectionToolbar(Context context, long selectionToolbarToken, ShowInfo showInfo, SelectionToolbarRenderService.RemoteCallbackWrapper callbackWrapper, SelectionToolbarRenderService.TransferTouchListener transferTouchListener) {
        this.mContext = RemoteSelectionToolbar.applyDefaultTheme(context, showInfo.isIsLightTheme());
        this.mSelectionToolbarToken = selectionToolbarToken;
        this.mCallbackWrapper = callbackWrapper;
        this.mTransferTouchListener = transferTouchListener;
        this.mHostInputToken = showInfo.getHostInputToken();
        this.mContentContainer = RemoteSelectionToolbar.createContentContainer(this.mContext);
        this.mMarginHorizontal = this.mContext.getResources().getDimensionPixelSize(17105224);
        this.mMarginVertical = this.mContext.getResources().getDimensionPixelSize(0x1050155);
        this.mLineHeight = this.mContext.getResources().getDimensionPixelSize(17105223);
        this.mIconTextSpacing = this.mContext.getResources().getDimensionPixelSize(17105225);
        this.mLogAccelerateInterpolator = new LogAccelerateInterpolator();
        this.mFastOutSlowInInterpolator = AnimationUtils.loadInterpolator(this.mContext, 17563661);
        this.mLinearOutSlowInInterpolator = AnimationUtils.loadInterpolator(this.mContext, 17563662);
        this.mFastOutLinearInInterpolator = AnimationUtils.loadInterpolator(this.mContext, 17563663);
        this.mArrow = this.mContext.getResources().getDrawable(17302279, this.mContext.getTheme());
        this.mArrow.setAutoMirrored(true);
        this.mOverflow = this.mContext.getResources().getDrawable(17302277, this.mContext.getTheme());
        this.mOverflow.setAutoMirrored(true);
        this.mToArrow = (AnimatedVectorDrawable)this.mContext.getResources().getDrawable(17302278, this.mContext.getTheme());
        this.mToArrow.setAutoMirrored(true);
        this.mToOverflow = (AnimatedVectorDrawable)this.mContext.getResources().getDrawable(17302280, this.mContext.getTheme());
        this.mToOverflow.setAutoMirrored(true);
        this.mOverflowButton = this.createOverflowButton();
        this.mOverflowButtonSize = RemoteSelectionToolbar.measure(this.mOverflowButton);
        this.mMainPanel = this.createMainPanel();
        this.mOverflowPanelViewHelper = new OverflowPanelViewHelper(this.mContext, this.mIconTextSpacing);
        this.mOverflowPanel = this.createOverflowPanel();
        this.mOverflowAnimationListener = this.createOverflowAnimationListener();
        this.mOpenOverflowAnimation = new AnimationSet(true);
        this.mOpenOverflowAnimation.setAnimationListener(this.mOverflowAnimationListener);
        this.mCloseOverflowAnimation = new AnimationSet(true);
        this.mCloseOverflowAnimation.setAnimationListener(this.mOverflowAnimationListener);
        this.mShowAnimation = RemoteSelectionToolbar.createEnterAnimation(this.mContentContainer, new AnimatorListenerAdapter(){

            @Override
            public void onAnimationEnd(Animator animation) {
                RemoteSelectionToolbar.this.updateFloatingToolbarRootContentRect();
            }
        });
        this.mDismissAnimation = RemoteSelectionToolbar.createExitAnimation(this.mContentContainer, 150, new AnimatorListenerAdapter(){

            @Override
            public void onAnimationEnd(Animator animation) {
                RemoteSelectionToolbar.this.mContentContainer.removeAllViews();
                RemoteSelectionToolbar.this.mSurfaceControlViewHost.release();
                RemoteSelectionToolbar.this.mSurfaceControlViewHost = null;
                RemoteSelectionToolbar.this.mSurfacePackage = null;
            }
        });
        this.mHideAnimation = RemoteSelectionToolbar.createExitAnimation(this.mContentContainer, 0, null);
        this.mMenuItemButtonOnClickListener = v -> {
            Object tag = v.getTag();
            if (!(tag instanceof ToolbarMenuItem)) {
                return;
            }
            this.mCallbackWrapper.onMenuItemClicked((ToolbarMenuItem)tag);
        };
    }

    private void updateFloatingToolbarRootContentRect() {
        if (this.mSurfaceControlViewHost == null) {
            return;
        }
        FloatingToolbarRoot root = (FloatingToolbarRoot)this.mSurfaceControlViewHost.getView();
        this.mContentContainer.getLocationOnScreen(this.mTempCoords);
        int contentLeft = this.mTempCoords[0];
        int contentTop = this.mTempCoords[1];
        this.mTempContentRectForRoot.set(contentLeft, contentTop, contentLeft + this.mContentContainer.getWidth(), contentTop + this.mContentContainer.getHeight());
        root.setContentRect(this.mTempContentRectForRoot);
    }

    private WidgetInfo createWidgetInfo() {
        this.mTempContentRect.set(this.mRelativeCoordsForToolbar.x, this.mRelativeCoordsForToolbar.y, this.mRelativeCoordsForToolbar.x + this.mPopupWidth, this.mRelativeCoordsForToolbar.y + this.mPopupHeight);
        return new WidgetInfo(this.mSelectionToolbarToken, this.mTempContentRect, this.getSurfacePackage());
    }

    private SurfaceControlViewHost.SurfacePackage getSurfacePackage() {
        if (this.mSurfaceControlViewHost == null) {
            FloatingToolbarRoot contentHolder = new FloatingToolbarRoot(this.mContext, this.mHostInputToken, this.mTransferTouchListener);
            contentHolder.addView(this.mContentContainer);
            this.mSurfaceControlViewHost = new SurfaceControlViewHost(this.mContext, this.mContext.getDisplay(), this.mHostInputToken, TAG);
            this.mSurfaceControlViewHost.setView(contentHolder, this.mPopupWidth, this.mPopupHeight);
        }
        if (this.mSurfacePackage == null) {
            this.mSurfacePackage = this.mSurfaceControlViewHost.getSurfacePackage();
        }
        return this.mSurfacePackage;
    }

    private void layoutMenuItems(List<ToolbarMenuItem> menuItems, int suggestedWidth) {
        this.cancelOverflowAnimations();
        this.clearPanels();
        menuItems = this.layoutMainPanelItems(menuItems, this.getAdjustedToolbarWidth(suggestedWidth));
        if (!menuItems.isEmpty()) {
            this.layoutOverflowPanelItems(menuItems);
        }
        this.updatePopupSize();
    }

    public void onToolbarShowTimeout() {
        this.mCallbackWrapper.onToolbarShowTimeout();
    }

    public void show(ShowInfo showInfo) {
        RemoteSelectionToolbar.debugLog("show() for " + showInfo);
        this.mMenuItems = showInfo.getMenuItems();
        this.mViewPortOnScreen.set(showInfo.getViewPortOnScreen());
        RemoteSelectionToolbar.debugLog("show(): layoutRequired=" + showInfo.isLayoutRequired());
        if (showInfo.isLayoutRequired()) {
            this.layoutMenuItems(this.mMenuItems, showInfo.getSuggestedWidth());
        }
        Rect contentRect = showInfo.getContentRect();
        if (!this.isShowing()) {
            this.show(contentRect);
        } else if (!this.mPreviousContentRect.equals(contentRect)) {
            this.updateCoordinates(contentRect);
        }
        this.mPreviousContentRect.set(contentRect);
    }

    private void show(Rect contentRectOnScreen) {
        Objects.requireNonNull(contentRectOnScreen);
        this.mHidden = false;
        this.mDismissed = false;
        this.cancelDismissAndHideAnimations();
        this.cancelOverflowAnimations();
        this.refreshCoordinatesAndOverflowDirection(contentRectOnScreen);
        this.preparePopupContent();
        this.mCallbackWrapper.onShown(this.createWidgetInfo());
        this.mShowAnimation.start();
    }

    public void dismiss(long floatingToolbarToken) {
        RemoteSelectionToolbar.debugLog("dismiss for " + floatingToolbarToken);
        if (this.mDismissed) {
            return;
        }
        this.mHidden = false;
        this.mDismissed = true;
        this.mHideAnimation.cancel();
        this.mDismissAnimation.start();
    }

    public void hide(long floatingToolbarToken) {
        RemoteSelectionToolbar.debugLog("hide for " + floatingToolbarToken);
        if (!this.isShowing()) {
            return;
        }
        this.mHidden = true;
        this.mHideAnimation.start();
    }

    public boolean isShowing() {
        return !this.mDismissed && !this.mHidden;
    }

    private void updateCoordinates(Rect contentRectOnScreen) {
        Objects.requireNonNull(contentRectOnScreen);
        if (!this.isShowing()) {
            return;
        }
        this.cancelOverflowAnimations();
        this.refreshCoordinatesAndOverflowDirection(contentRectOnScreen);
        this.preparePopupContent();
        WidgetInfo widgetInfo = this.createWidgetInfo();
        this.mSurfaceControlViewHost.relayout(this.mPopupWidth, this.mPopupHeight);
        this.mCallbackWrapper.onWidgetUpdated(widgetInfo);
    }

    private void refreshCoordinatesAndOverflowDirection(Rect contentRectOnScreen) {
        int y;
        int x = Math.min(contentRectOnScreen.centerX() - this.mPopupWidth / 2, this.mViewPortOnScreen.right - this.mPopupWidth);
        int availableHeightAboveContent = contentRectOnScreen.top - this.mViewPortOnScreen.top;
        int availableHeightBelowContent = this.mViewPortOnScreen.bottom - contentRectOnScreen.bottom;
        int margin = 2 * this.mMarginVertical;
        int toolbarHeightWithVerticalMargin = this.mLineHeight + margin;
        if (!this.hasOverflow()) {
            y = availableHeightAboveContent >= toolbarHeightWithVerticalMargin ? contentRectOnScreen.top - toolbarHeightWithVerticalMargin : (availableHeightBelowContent >= toolbarHeightWithVerticalMargin ? contentRectOnScreen.bottom : (availableHeightBelowContent >= this.mLineHeight ? contentRectOnScreen.bottom - this.mMarginVertical : Math.max(this.mViewPortOnScreen.top, contentRectOnScreen.top - toolbarHeightWithVerticalMargin)));
        } else {
            int minimumOverflowHeightWithMargin = this.calculateOverflowHeight(2) + margin;
            int availableHeightThroughContentDown = this.mViewPortOnScreen.bottom - contentRectOnScreen.top + toolbarHeightWithVerticalMargin;
            int availableHeightThroughContentUp = contentRectOnScreen.bottom - this.mViewPortOnScreen.top + toolbarHeightWithVerticalMargin;
            if (availableHeightAboveContent >= minimumOverflowHeightWithMargin) {
                this.updateOverflowHeight(availableHeightAboveContent - margin);
                y = contentRectOnScreen.top - this.mPopupHeight;
                this.mOpenOverflowUpwards = true;
            } else if (availableHeightAboveContent >= toolbarHeightWithVerticalMargin && availableHeightThroughContentDown >= minimumOverflowHeightWithMargin) {
                this.updateOverflowHeight(availableHeightThroughContentDown - margin);
                y = contentRectOnScreen.top - toolbarHeightWithVerticalMargin;
                this.mOpenOverflowUpwards = false;
            } else if (availableHeightBelowContent >= minimumOverflowHeightWithMargin) {
                this.updateOverflowHeight(availableHeightBelowContent - margin);
                y = contentRectOnScreen.bottom;
                this.mOpenOverflowUpwards = false;
            } else if (availableHeightBelowContent >= toolbarHeightWithVerticalMargin && this.mViewPortOnScreen.height() >= minimumOverflowHeightWithMargin) {
                this.updateOverflowHeight(availableHeightThroughContentUp - margin);
                y = contentRectOnScreen.bottom + toolbarHeightWithVerticalMargin - this.mPopupHeight;
                this.mOpenOverflowUpwards = true;
            } else {
                this.updateOverflowHeight(this.mViewPortOnScreen.height() - margin);
                y = this.mViewPortOnScreen.top;
                this.mOpenOverflowUpwards = false;
            }
        }
        this.mRelativeCoordsForToolbar.set(x, y);
    }

    private void cancelDismissAndHideAnimations() {
        this.mDismissAnimation.cancel();
        this.mHideAnimation.cancel();
    }

    private void cancelOverflowAnimations() {
        this.mContentContainer.clearAnimation();
        this.mMainPanel.animate().cancel();
        this.mOverflowPanel.animate().cancel();
        this.mToArrow.stop();
        this.mToOverflow.stop();
    }

    private void openOverflow() {
        final int targetWidth = this.mOverflowPanelSize.getWidth();
        final int targetHeight = this.mOverflowPanelSize.getHeight();
        final int startWidth = this.mContentContainer.getWidth();
        final int startHeight = this.mContentContainer.getHeight();
        final float startY = this.mContentContainer.getY();
        final float left = this.mContentContainer.getX();
        final float right = left + (float)this.mContentContainer.getWidth();
        Animation widthAnimation = new Animation(){

            @Override
            protected void applyTransformation(float interpolatedTime, Transformation t) {
                int deltaWidth = (int)(interpolatedTime * (float)(targetWidth - startWidth));
                RemoteSelectionToolbar.setWidth(RemoteSelectionToolbar.this.mContentContainer, startWidth + deltaWidth);
                if (RemoteSelectionToolbar.this.isInRTLMode()) {
                    RemoteSelectionToolbar.this.mContentContainer.setX(left);
                    RemoteSelectionToolbar.this.mMainPanel.setX(0.0f);
                    RemoteSelectionToolbar.this.mOverflowPanel.setX(0.0f);
                } else {
                    RemoteSelectionToolbar.this.mContentContainer.setX(right - (float)RemoteSelectionToolbar.this.mContentContainer.getWidth());
                    RemoteSelectionToolbar.this.mMainPanel.setX(RemoteSelectionToolbar.this.mContentContainer.getWidth() - startWidth);
                    RemoteSelectionToolbar.this.mOverflowPanel.setX(RemoteSelectionToolbar.this.mContentContainer.getWidth() - targetWidth);
                }
            }
        };
        Animation heightAnimation = new Animation(){

            @Override
            protected void applyTransformation(float interpolatedTime, Transformation t) {
                int deltaHeight = (int)(interpolatedTime * (float)(targetHeight - startHeight));
                RemoteSelectionToolbar.setHeight(RemoteSelectionToolbar.this.mContentContainer, startHeight + deltaHeight);
                if (RemoteSelectionToolbar.this.mOpenOverflowUpwards) {
                    RemoteSelectionToolbar.this.mContentContainer.setY(startY - (float)(RemoteSelectionToolbar.this.mContentContainer.getHeight() - startHeight));
                    RemoteSelectionToolbar.this.positionContentYCoordinatesIfOpeningOverflowUpwards();
                }
            }
        };
        final float overflowButtonStartX = this.mOverflowButton.getX();
        final float overflowButtonTargetX = this.isInRTLMode() ? overflowButtonStartX + (float)targetWidth - (float)this.mOverflowButton.getWidth() : overflowButtonStartX - (float)targetWidth + (float)this.mOverflowButton.getWidth();
        Animation overflowButtonAnimation = new Animation(){

            @Override
            protected void applyTransformation(float interpolatedTime, Transformation t) {
                float overflowButtonX = overflowButtonStartX + interpolatedTime * (overflowButtonTargetX - overflowButtonStartX);
                float deltaContainerWidth = RemoteSelectionToolbar.this.isInRTLMode() ? 0.0f : (float)(RemoteSelectionToolbar.this.mContentContainer.getWidth() - startWidth);
                float actualOverflowButtonX = overflowButtonX + deltaContainerWidth;
                RemoteSelectionToolbar.this.mOverflowButton.setX(actualOverflowButtonX);
                RemoteSelectionToolbar.this.updateFloatingToolbarRootContentRect();
            }
        };
        widthAnimation.setInterpolator(this.mLogAccelerateInterpolator);
        widthAnimation.setDuration(this.getAnimationDuration());
        heightAnimation.setInterpolator(this.mFastOutSlowInInterpolator);
        heightAnimation.setDuration(this.getAnimationDuration());
        overflowButtonAnimation.setInterpolator(this.mFastOutSlowInInterpolator);
        overflowButtonAnimation.setDuration(this.getAnimationDuration());
        this.mOpenOverflowAnimation.getAnimations().clear();
        this.mOpenOverflowAnimation.addAnimation(widthAnimation);
        this.mOpenOverflowAnimation.addAnimation(heightAnimation);
        this.mOpenOverflowAnimation.addAnimation(overflowButtonAnimation);
        this.mContentContainer.startAnimation(this.mOpenOverflowAnimation);
        this.mIsOverflowOpen = true;
        this.mMainPanel.animate().alpha(0.0f).withLayer().setInterpolator(this.mLinearOutSlowInInterpolator).setDuration(250L).start();
        this.mOverflowPanel.setAlpha(1.0f);
    }

    private void closeOverflow() {
        final int targetWidth = this.mMainPanelSize.getWidth();
        final int startWidth = this.mContentContainer.getWidth();
        final float left = this.mContentContainer.getX();
        final float right = left + (float)this.mContentContainer.getWidth();
        Animation widthAnimation = new Animation(){

            @Override
            protected void applyTransformation(float interpolatedTime, Transformation t) {
                int deltaWidth = (int)(interpolatedTime * (float)(targetWidth - startWidth));
                RemoteSelectionToolbar.setWidth(RemoteSelectionToolbar.this.mContentContainer, startWidth + deltaWidth);
                if (RemoteSelectionToolbar.this.isInRTLMode()) {
                    RemoteSelectionToolbar.this.mContentContainer.setX(left);
                    RemoteSelectionToolbar.this.mMainPanel.setX(0.0f);
                    RemoteSelectionToolbar.this.mOverflowPanel.setX(0.0f);
                } else {
                    RemoteSelectionToolbar.this.mContentContainer.setX(right - (float)RemoteSelectionToolbar.this.mContentContainer.getWidth());
                    RemoteSelectionToolbar.this.mMainPanel.setX(RemoteSelectionToolbar.this.mContentContainer.getWidth() - targetWidth);
                    RemoteSelectionToolbar.this.mOverflowPanel.setX(RemoteSelectionToolbar.this.mContentContainer.getWidth() - startWidth);
                }
            }
        };
        final int targetHeight = this.mMainPanelSize.getHeight();
        final int startHeight = this.mContentContainer.getHeight();
        final float bottom = this.mContentContainer.getY() + (float)this.mContentContainer.getHeight();
        Animation heightAnimation = new Animation(){

            @Override
            protected void applyTransformation(float interpolatedTime, Transformation t) {
                int deltaHeight = (int)(interpolatedTime * (float)(targetHeight - startHeight));
                RemoteSelectionToolbar.setHeight(RemoteSelectionToolbar.this.mContentContainer, startHeight + deltaHeight);
                if (RemoteSelectionToolbar.this.mOpenOverflowUpwards) {
                    RemoteSelectionToolbar.this.mContentContainer.setY(bottom - (float)RemoteSelectionToolbar.this.mContentContainer.getHeight());
                    RemoteSelectionToolbar.this.positionContentYCoordinatesIfOpeningOverflowUpwards();
                }
            }
        };
        final float overflowButtonStartX = this.mOverflowButton.getX();
        final float overflowButtonTargetX = this.isInRTLMode() ? overflowButtonStartX - (float)startWidth + (float)this.mOverflowButton.getWidth() : overflowButtonStartX + (float)startWidth - (float)this.mOverflowButton.getWidth();
        Animation overflowButtonAnimation = new Animation(){

            @Override
            protected void applyTransformation(float interpolatedTime, Transformation t) {
                float overflowButtonX = overflowButtonStartX + interpolatedTime * (overflowButtonTargetX - overflowButtonStartX);
                float deltaContainerWidth = RemoteSelectionToolbar.this.isInRTLMode() ? 0.0f : (float)(RemoteSelectionToolbar.this.mContentContainer.getWidth() - startWidth);
                float actualOverflowButtonX = overflowButtonX + deltaContainerWidth;
                RemoteSelectionToolbar.this.mOverflowButton.setX(actualOverflowButtonX);
                RemoteSelectionToolbar.this.updateFloatingToolbarRootContentRect();
            }
        };
        widthAnimation.setInterpolator(this.mFastOutSlowInInterpolator);
        widthAnimation.setDuration(this.getAnimationDuration());
        heightAnimation.setInterpolator(this.mLogAccelerateInterpolator);
        heightAnimation.setDuration(this.getAnimationDuration());
        overflowButtonAnimation.setInterpolator(this.mFastOutSlowInInterpolator);
        overflowButtonAnimation.setDuration(this.getAnimationDuration());
        this.mCloseOverflowAnimation.getAnimations().clear();
        this.mCloseOverflowAnimation.addAnimation(widthAnimation);
        this.mCloseOverflowAnimation.addAnimation(heightAnimation);
        this.mCloseOverflowAnimation.addAnimation(overflowButtonAnimation);
        this.mContentContainer.startAnimation(this.mCloseOverflowAnimation);
        this.mIsOverflowOpen = false;
        this.mMainPanel.animate().alpha(1.0f).withLayer().setInterpolator(this.mFastOutLinearInInterpolator).setDuration(100L).start();
        this.mOverflowPanel.animate().alpha(0.0f).withLayer().setInterpolator(this.mLinearOutSlowInInterpolator).setDuration(150L).start();
    }

    private void setPanelsStatesAtRestingPosition() {
        this.mOverflowButton.setEnabled(true);
        this.mOverflowPanel.awakenScrollBars();
        if (this.mIsOverflowOpen) {
            Size containerSize = this.mOverflowPanelSize;
            RemoteSelectionToolbar.setSize(this.mContentContainer, containerSize);
            this.mMainPanel.setAlpha(0.0f);
            this.mMainPanel.setVisibility(4);
            this.mOverflowPanel.setAlpha(1.0f);
            this.mOverflowPanel.setVisibility(0);
            this.mOverflowButton.setImageDrawable(this.mArrow);
            this.mOverflowButton.setContentDescription(this.mContext.getString(17040361));
            if (this.isInRTLMode()) {
                this.mContentContainer.setX(this.mMarginHorizontal);
                this.mMainPanel.setX(0.0f);
                this.mOverflowButton.setX(containerSize.getWidth() - this.mOverflowButtonSize.getWidth());
                this.mOverflowPanel.setX(0.0f);
            } else {
                this.mContentContainer.setX(this.mPopupWidth - containerSize.getWidth() - this.mMarginHorizontal);
                this.mMainPanel.setX(-this.mContentContainer.getX());
                this.mOverflowButton.setX(0.0f);
                this.mOverflowPanel.setX(0.0f);
            }
            if (this.mOpenOverflowUpwards) {
                this.mContentContainer.setY(this.mMarginVertical);
                this.mMainPanel.setY(containerSize.getHeight() - this.mContentContainer.getHeight());
                this.mOverflowButton.setY(containerSize.getHeight() - this.mOverflowButtonSize.getHeight());
                this.mOverflowPanel.setY(0.0f);
            } else {
                this.mContentContainer.setY(this.mMarginVertical);
                this.mMainPanel.setY(0.0f);
                this.mOverflowButton.setY(0.0f);
                this.mOverflowPanel.setY(this.mOverflowButtonSize.getHeight());
            }
        } else {
            Size containerSize = this.mMainPanelSize;
            RemoteSelectionToolbar.setSize(this.mContentContainer, containerSize);
            this.mMainPanel.setAlpha(1.0f);
            this.mMainPanel.setVisibility(0);
            this.mOverflowPanel.setAlpha(0.0f);
            this.mOverflowPanel.setVisibility(4);
            this.mOverflowButton.setImageDrawable(this.mOverflow);
            this.mOverflowButton.setContentDescription(this.mContext.getString(17040362));
            if (this.hasOverflow()) {
                if (this.isInRTLMode()) {
                    this.mContentContainer.setX(this.mMarginHorizontal);
                    this.mMainPanel.setX(0.0f);
                    this.mOverflowButton.setX(0.0f);
                    this.mOverflowPanel.setX(0.0f);
                } else {
                    this.mContentContainer.setX(this.mPopupWidth - containerSize.getWidth() - this.mMarginHorizontal);
                    this.mMainPanel.setX(0.0f);
                    this.mOverflowButton.setX(containerSize.getWidth() - this.mOverflowButtonSize.getWidth());
                    this.mOverflowPanel.setX(containerSize.getWidth() - this.mOverflowPanelSize.getWidth());
                }
                if (this.mOpenOverflowUpwards) {
                    this.mContentContainer.setY(this.mMarginVertical + this.mOverflowPanelSize.getHeight() - containerSize.getHeight());
                    this.mMainPanel.setY(0.0f);
                    this.mOverflowButton.setY(0.0f);
                    this.mOverflowPanel.setY(containerSize.getHeight() - this.mOverflowPanelSize.getHeight());
                } else {
                    this.mContentContainer.setY(this.mMarginVertical);
                    this.mMainPanel.setY(0.0f);
                    this.mOverflowButton.setY(0.0f);
                    this.mOverflowPanel.setY(this.mOverflowButtonSize.getHeight());
                }
            } else {
                this.mContentContainer.setX(this.mMarginHorizontal);
                this.mContentContainer.setY(this.mMarginVertical);
                this.mMainPanel.setX(0.0f);
                this.mMainPanel.setY(0.0f);
            }
        }
    }

    private void updateOverflowHeight(int suggestedHeight) {
        if (this.hasOverflow()) {
            int maxItemSize = (suggestedHeight - this.mOverflowButtonSize.getHeight()) / this.mLineHeight;
            int newHeight = this.calculateOverflowHeight(maxItemSize);
            if (this.mOverflowPanelSize.getHeight() != newHeight) {
                this.mOverflowPanelSize = new Size(this.mOverflowPanelSize.getWidth(), newHeight);
            }
            RemoteSelectionToolbar.setSize(this.mOverflowPanel, this.mOverflowPanelSize);
            if (this.mIsOverflowOpen) {
                RemoteSelectionToolbar.setSize(this.mContentContainer, this.mOverflowPanelSize);
                if (this.mOpenOverflowUpwards) {
                    int deltaHeight = this.mOverflowPanelSize.getHeight() - newHeight;
                    this.mContentContainer.setY(this.mContentContainer.getY() + (float)deltaHeight);
                    this.mOverflowButton.setY(this.mOverflowButton.getY() - (float)deltaHeight);
                }
            } else {
                RemoteSelectionToolbar.setSize(this.mContentContainer, this.mMainPanelSize);
            }
            this.updatePopupSize();
        }
    }

    private void updatePopupSize() {
        int width = 0;
        int height = 0;
        if (this.mMainPanelSize != null) {
            width = Math.max(width, this.mMainPanelSize.getWidth());
            height = Math.max(height, this.mMainPanelSize.getHeight());
        }
        if (this.mOverflowPanelSize != null) {
            width = Math.max(width, this.mOverflowPanelSize.getWidth());
            height = Math.max(height, this.mOverflowPanelSize.getHeight());
        }
        this.mPopupWidth = width + this.mMarginHorizontal * 2;
        this.mPopupHeight = height + this.mMarginVertical * 2;
        this.maybeComputeTransitionDurationScale();
    }

    private int getAdjustedToolbarWidth(int suggestedWidth) {
        int width = suggestedWidth;
        int maximumWidth = this.mViewPortOnScreen.width() - 2 * this.mContext.getResources().getDimensionPixelSize(17105224);
        if (width <= 0) {
            width = this.mContext.getResources().getDimensionPixelSize(17105235);
        }
        return Math.min(width, maximumWidth);
    }

    private boolean isInRTLMode() {
        return this.mContext.getApplicationInfo().hasRtlSupport() && this.mContext.getResources().getConfiguration().getLayoutDirection() == 1;
    }

    private boolean hasOverflow() {
        return this.mOverflowPanelSize != null;
    }

    private List<ToolbarMenuItem> layoutMainPanelItems(List<ToolbarMenuItem> menuItems, int toolbarWidth) {
        LinkedList<ToolbarMenuItem> remainingMenuItems = new LinkedList<ToolbarMenuItem>();
        LinkedList<ToolbarMenuItem> overflowMenuItems = new LinkedList<ToolbarMenuItem>();
        for (ToolbarMenuItem menuItem : menuItems) {
            if (menuItem.getItemId() != 16908353 && menuItem.getPriority() == 2) {
                overflowMenuItems.add(menuItem);
                continue;
            }
            remainingMenuItems.add(menuItem);
        }
        remainingMenuItems.addAll(overflowMenuItems);
        this.mMainPanel.removeAllViews();
        this.mMainPanel.setPaddingRelative(0, 0, 0, 0);
        int availableWidth = toolbarWidth;
        boolean isFirstItem = true;
        while (!remainingMenuItems.isEmpty()) {
            boolean canFitNoOverflow;
            boolean isLastItem;
            ToolbarMenuItem menuItem = (ToolbarMenuItem)remainingMenuItems.peek();
            if (!isFirstItem && menuItem.getPriority() == 2) break;
            boolean showIcon = isFirstItem && menuItem.getItemId() == 16908353;
            View menuItemButton = RemoteSelectionToolbar.createMenuItemButton(this.mContext, menuItem, this.mIconTextSpacing, showIcon);
            if (!showIcon && menuItemButton instanceof LinearLayout) {
                ((LinearLayout)menuItemButton).setGravity(17);
            }
            if (isFirstItem) {
                menuItemButton.setPaddingRelative((int)(1.5 * (double)menuItemButton.getPaddingStart()), menuItemButton.getPaddingTop(), menuItemButton.getPaddingEnd(), menuItemButton.getPaddingBottom());
            }
            boolean bl = isLastItem = remainingMenuItems.size() == 1;
            if (isLastItem) {
                menuItemButton.setPaddingRelative(menuItemButton.getPaddingStart(), menuItemButton.getPaddingTop(), (int)(1.5 * (double)menuItemButton.getPaddingEnd()), menuItemButton.getPaddingBottom());
            }
            menuItemButton.measure(0, 0);
            int menuItemButtonWidth = Math.min(menuItemButton.getMeasuredWidth(), toolbarWidth);
            boolean canFitWithOverflow = menuItemButtonWidth <= availableWidth - this.mOverflowButtonSize.getWidth();
            boolean bl2 = canFitNoOverflow = isLastItem && menuItemButtonWidth <= availableWidth;
            if (!canFitWithOverflow && !canFitNoOverflow) break;
            menuItemButton.setTag(menuItem);
            menuItemButton.setOnClickListener(this.mMenuItemButtonOnClickListener);
            menuItemButton.setTooltipText(menuItem.getTooltipText());
            this.mMainPanel.addView(menuItemButton);
            ViewGroup.LayoutParams params = menuItemButton.getLayoutParams();
            params.width = menuItemButtonWidth;
            menuItemButton.setLayoutParams(params);
            availableWidth -= menuItemButtonWidth;
            remainingMenuItems.pop();
            isFirstItem = false;
        }
        if (!remainingMenuItems.isEmpty()) {
            this.mMainPanel.setPaddingRelative(0, 0, this.mOverflowButtonSize.getWidth(), 0);
        }
        this.mMainPanelSize = RemoteSelectionToolbar.measure(this.mMainPanel);
        return remainingMenuItems;
    }

    private void layoutOverflowPanelItems(List<ToolbarMenuItem> menuItems) {
        ArrayAdapter overflowPanelAdapter = (ArrayAdapter)this.mOverflowPanel.getAdapter();
        overflowPanelAdapter.clear();
        int size = menuItems.size();
        for (int i = 0; i < size; ++i) {
            overflowPanelAdapter.add(menuItems.get(i));
        }
        this.mOverflowPanel.setAdapter(overflowPanelAdapter);
        if (this.mOpenOverflowUpwards) {
            this.mOverflowPanel.setY(0.0f);
        } else {
            this.mOverflowPanel.setY(this.mOverflowButtonSize.getHeight());
        }
        int width = Math.max(this.getOverflowWidth(), this.mOverflowButtonSize.getWidth());
        int height = this.calculateOverflowHeight(4);
        this.mOverflowPanelSize = new Size(width, height);
        RemoteSelectionToolbar.setSize(this.mOverflowPanel, this.mOverflowPanelSize);
    }

    private void preparePopupContent() {
        this.mContentContainer.removeAllViews();
        if (this.hasOverflow()) {
            this.mContentContainer.addView(this.mOverflowPanel);
        }
        this.mContentContainer.addView(this.mMainPanel);
        if (this.hasOverflow()) {
            this.mContentContainer.addView(this.mOverflowButton);
        }
        this.setPanelsStatesAtRestingPosition();
        if (this.isInRTLMode()) {
            this.mContentContainer.setAlpha(0.0f);
            this.mContentContainer.post(this.mPreparePopupContentRTLHelper);
        }
    }

    private void clearPanels() {
        this.mIsOverflowOpen = false;
        this.mMainPanelSize = null;
        this.mMainPanel.removeAllViews();
        this.mOverflowPanelSize = null;
        ArrayAdapter overflowPanelAdapter = (ArrayAdapter)this.mOverflowPanel.getAdapter();
        overflowPanelAdapter.clear();
        this.mOverflowPanel.setAdapter(overflowPanelAdapter);
        this.mContentContainer.removeAllViews();
    }

    private void positionContentYCoordinatesIfOpeningOverflowUpwards() {
        if (this.mOpenOverflowUpwards) {
            this.mMainPanel.setY(this.mContentContainer.getHeight() - this.mMainPanelSize.getHeight());
            this.mOverflowButton.setY(this.mContentContainer.getHeight() - this.mOverflowButton.getHeight());
            this.mOverflowPanel.setY(this.mContentContainer.getHeight() - this.mOverflowPanelSize.getHeight());
        }
    }

    private int getOverflowWidth() {
        int overflowWidth = 0;
        int count = this.mOverflowPanel.getAdapter().getCount();
        for (int i = 0; i < count; ++i) {
            ToolbarMenuItem menuItem = (ToolbarMenuItem)this.mOverflowPanel.getAdapter().getItem(i);
            overflowWidth = Math.max(this.mOverflowPanelViewHelper.calculateWidth(menuItem), overflowWidth);
        }
        return overflowWidth;
    }

    private int calculateOverflowHeight(int maxItemSize) {
        int actualSize = Math.min(4, Math.min(Math.max(2, maxItemSize), this.mOverflowPanel.getCount()));
        int extension = 0;
        if (actualSize < this.mOverflowPanel.getCount()) {
            extension = (int)((float)this.mLineHeight * 0.5f);
        }
        return actualSize * this.mLineHeight + this.mOverflowButtonSize.getHeight() + extension;
    }

    private int getAnimationDuration() {
        if (this.mTransitionDurationScale < 150) {
            return 200;
        }
        if (this.mTransitionDurationScale > 300) {
            return 300;
        }
        return (int)(250.0f * ValueAnimator.getDurationScale());
    }

    private void maybeComputeTransitionDurationScale() {
        if (this.mMainPanelSize != null && this.mOverflowPanelSize != null) {
            int w = this.mMainPanelSize.getWidth() - this.mOverflowPanelSize.getWidth();
            int h = this.mOverflowPanelSize.getHeight() - this.mMainPanelSize.getHeight();
            this.mTransitionDurationScale = (int)(Math.sqrt(w * w + h * h) / (double)this.mContentContainer.getContext().getResources().getDisplayMetrics().density);
        }
    }

    private ViewGroup createMainPanel() {
        return new LinearLayout(this.mContext){

            @Override
            protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
                if (RemoteSelectionToolbar.this.isOverflowAnimating()) {
                    widthMeasureSpec = View.MeasureSpec.makeMeasureSpec(RemoteSelectionToolbar.this.mMainPanelSize.getWidth(), 0x40000000);
                }
                super.onMeasure(widthMeasureSpec, heightMeasureSpec);
            }

            @Override
            public boolean onInterceptTouchEvent(MotionEvent ev) {
                return RemoteSelectionToolbar.this.isOverflowAnimating();
            }
        };
    }

    private ImageButton createOverflowButton() {
        ImageButton overflowButton = (ImageButton)LayoutInflater.from(this.mContext).inflate(17367168, null);
        overflowButton.setImageDrawable(this.mOverflow);
        overflowButton.setOnClickListener(v -> {
            if (this.isShowing()) {
                this.preparePopupContent();
                WidgetInfo widgetInfo = this.createWidgetInfo();
                this.mSurfaceControlViewHost.relayout(this.mPopupWidth, this.mPopupHeight);
                this.mCallbackWrapper.onWidgetUpdated(widgetInfo);
            }
            if (this.mIsOverflowOpen) {
                overflowButton.setImageDrawable(this.mToOverflow);
                this.mToOverflow.start();
                this.closeOverflow();
            } else {
                overflowButton.setImageDrawable(this.mToArrow);
                this.mToArrow.start();
                this.openOverflow();
            }
        });
        return overflowButton;
    }

    private OverflowPanel createOverflowPanel() {
        OverflowPanel overflowPanel = new OverflowPanel(this);
        overflowPanel.setLayoutParams(new ViewGroup.LayoutParams(-1, -1));
        overflowPanel.setDivider(null);
        overflowPanel.setDividerHeight(0);
        ArrayAdapter<ToolbarMenuItem> adapter = new ArrayAdapter<ToolbarMenuItem>(this.mContext, 0){

            @Override
            public View getView(int position, View convertView, ViewGroup parent) {
                return RemoteSelectionToolbar.this.mOverflowPanelViewHelper.getView((ToolbarMenuItem)this.getItem(position), RemoteSelectionToolbar.this.mOverflowPanelSize.getWidth(), convertView);
            }
        };
        overflowPanel.setAdapter(adapter);
        overflowPanel.setOnItemClickListener((parent, view, position, id2) -> {
            ToolbarMenuItem menuItem = (ToolbarMenuItem)overflowPanel.getAdapter().getItem(position);
            this.mCallbackWrapper.onMenuItemClicked(menuItem);
        });
        return overflowPanel;
    }

    private boolean isOverflowAnimating() {
        boolean overflowOpening = this.mOpenOverflowAnimation.hasStarted() && !this.mOpenOverflowAnimation.hasEnded();
        boolean overflowClosing = this.mCloseOverflowAnimation.hasStarted() && !this.mCloseOverflowAnimation.hasEnded();
        return overflowOpening || overflowClosing;
    }

    private Animation.AnimationListener createOverflowAnimationListener() {
        return new Animation.AnimationListener(){

            @Override
            public void onAnimationStart(Animation animation) {
                RemoteSelectionToolbar.this.mOverflowButton.setEnabled(false);
                RemoteSelectionToolbar.this.mMainPanel.setVisibility(0);
                RemoteSelectionToolbar.this.mOverflowPanel.setVisibility(0);
            }

            @Override
            public void onAnimationEnd(Animation animation) {
                RemoteSelectionToolbar.this.mContentContainer.post(() -> RemoteSelectionToolbar.this.setPanelsStatesAtRestingPosition());
            }

            @Override
            public void onAnimationRepeat(Animation animation) {
            }
        };
    }

    private static Size measure(View view) {
        Preconditions.checkState(view.getParent() == null);
        view.measure(0, 0);
        return new Size(view.getMeasuredWidth(), view.getMeasuredHeight());
    }

    private static void setSize(View view, int width, int height) {
        view.setMinimumWidth(width);
        view.setMinimumHeight(height);
        ViewGroup.LayoutParams params = view.getLayoutParams();
        params = params == null ? new ViewGroup.LayoutParams(0, 0) : params;
        params.width = width;
        params.height = height;
        view.setLayoutParams(params);
    }

    private static void setSize(View view, Size size) {
        RemoteSelectionToolbar.setSize(view, size.getWidth(), size.getHeight());
    }

    private static void setWidth(View view, int width) {
        ViewGroup.LayoutParams params = view.getLayoutParams();
        RemoteSelectionToolbar.setSize(view, width, params.height);
    }

    private static void setHeight(View view, int height) {
        ViewGroup.LayoutParams params = view.getLayoutParams();
        RemoteSelectionToolbar.setSize(view, params.width, height);
    }

    private static View createMenuItemButton(Context context, ToolbarMenuItem menuItem, int iconTextSpacing, boolean showIcon) {
        View menuItemButton = LayoutInflater.from(context).inflate(17367166, null);
        if (menuItem != null) {
            RemoteSelectionToolbar.updateMenuItemButton(menuItemButton, menuItem, iconTextSpacing, showIcon);
        }
        return menuItemButton;
    }

    private static void updateMenuItemButton(View menuItemButton, ToolbarMenuItem menuItem, int iconTextSpacing, boolean showIcon) {
        TextView buttonText = (TextView)menuItemButton.findViewById(16909058);
        buttonText.setEllipsize(null);
        if (TextUtils.isEmpty(menuItem.getTitle())) {
            buttonText.setVisibility(8);
        } else {
            buttonText.setVisibility(0);
            buttonText.setText(menuItem.getTitle());
        }
        ImageView buttonIcon = (ImageView)menuItemButton.findViewById(16909056);
        if (menuItem.getIcon() == null || !showIcon) {
            buttonIcon.setVisibility(8);
            buttonText.setPaddingRelative(0, 0, 0, 0);
        } else {
            buttonIcon.setVisibility(0);
            buttonIcon.setImageDrawable(menuItem.getIcon().loadDrawable(menuItemButton.getContext()));
            buttonText.setPaddingRelative(iconTextSpacing, 0, 0, 0);
        }
        CharSequence contentDescription = menuItem.getContentDescription();
        if (TextUtils.isEmpty(contentDescription)) {
            menuItemButton.setContentDescription(menuItem.getTitle());
        } else {
            menuItemButton.setContentDescription(contentDescription);
        }
    }

    private static ViewGroup createContentContainer(Context context) {
        ViewGroup contentContainer = (ViewGroup)LayoutInflater.from(context).inflate(17367165, null);
        contentContainer.setLayoutParams(new ViewGroup.LayoutParams(-2, -2));
        contentContainer.setTag("floating_toolbar");
        contentContainer.setClipToOutline(true);
        return contentContainer;
    }

    private static AnimatorSet createEnterAnimation(View view, Animator.AnimatorListener listener) {
        AnimatorSet animation = new AnimatorSet();
        animation.playTogether(ObjectAnimator.ofFloat(view, View.ALPHA, 0.0f, 1.0f).setDuration(150L));
        animation.addListener(listener);
        return animation;
    }

    private static AnimatorSet createExitAnimation(View view, int startDelay, Animator.AnimatorListener listener) {
        AnimatorSet animation = new AnimatorSet();
        animation.playTogether(ObjectAnimator.ofFloat(view, View.ALPHA, 1.0f, 0.0f).setDuration(100L));
        animation.setStartDelay(startDelay);
        if (listener != null) {
            animation.addListener(listener);
        }
        return animation;
    }

    private static Context applyDefaultTheme(Context originalContext, boolean isLightTheme) {
        int themeId = isLightTheme ? 16974123 : 16974120;
        return new ContextThemeWrapper(originalContext, themeId);
    }

    private static void debugLog(String message) {
        if (Log.isLoggable("floating_toolbar", 3)) {
            Log.v(TAG, message);
        }
    }

    void dump(String prefix, PrintWriter pw) {
        pw.print(prefix);
        pw.print("toolbar token: ");
        pw.println(this.mSelectionToolbarToken);
        pw.print(prefix);
        pw.print("dismissed: ");
        pw.println(this.mDismissed);
        pw.print(prefix);
        pw.print("hidden: ");
        pw.println(this.mHidden);
        pw.print(prefix);
        pw.print("popup width: ");
        pw.println(this.mPopupWidth);
        pw.print(prefix);
        pw.print("popup height: ");
        pw.println(this.mPopupHeight);
        pw.print(prefix);
        pw.print("relative coords: ");
        pw.println(this.mRelativeCoordsForToolbar);
        pw.print(prefix);
        pw.print("main panel size: ");
        pw.println(this.mMainPanelSize);
        boolean hasOverflow = this.hasOverflow();
        pw.print(prefix);
        pw.print("has overflow: ");
        pw.println(hasOverflow);
        if (hasOverflow) {
            pw.print(prefix);
            pw.print("overflow open: ");
            pw.println(this.mIsOverflowOpen);
            pw.print(prefix);
            pw.print("overflow size: ");
            pw.println(this.mOverflowPanelSize);
        }
        if (this.mSurfaceControlViewHost != null) {
            FloatingToolbarRoot root = (FloatingToolbarRoot)this.mSurfaceControlViewHost.getView();
            root.dump(prefix, pw);
        }
        if (this.mMenuItems != null) {
            int menuItemSize = this.mMenuItems.size();
            pw.print(prefix);
            pw.print("number menu items: ");
            pw.println(menuItemSize);
            for (int i = 0; i < menuItemSize; ++i) {
                pw.print(prefix);
                pw.print("#");
                pw.println(i);
                pw.print(prefix + "  ");
                pw.println(this.mMenuItems.get(i));
            }
        }
    }

    private static class LogAccelerateInterpolator
    implements Interpolator {
        private static final int BASE = 100;
        private static final float LOGS_SCALE = 1.0f / LogAccelerateInterpolator.computeLog(1.0f, 100);

        private LogAccelerateInterpolator() {
        }

        private static float computeLog(float t, int base) {
            return (float)(1.0 - Math.pow(base, -t));
        }

        @Override
        public float getInterpolation(float t) {
            return 1.0f - LogAccelerateInterpolator.computeLog(1.0f - t, 100) * LOGS_SCALE;
        }
    }

    private static class OverflowPanelViewHelper {
        private final Context mContext;
        private final View mCalculator;
        private final int mIconTextSpacing;
        private final int mSidePadding;

        OverflowPanelViewHelper(Context context, int iconTextSpacing) {
            this.mContext = Objects.requireNonNull(context);
            this.mIconTextSpacing = iconTextSpacing;
            this.mSidePadding = context.getResources().getDimensionPixelSize(17105234);
            this.mCalculator = this.createMenuButton(null);
        }

        public View getView(ToolbarMenuItem menuItem, int minimumWidth, View convertView) {
            Objects.requireNonNull(menuItem);
            if (convertView != null) {
                RemoteSelectionToolbar.updateMenuItemButton(convertView, menuItem, this.mIconTextSpacing, this.shouldShowIcon(menuItem));
            } else {
                convertView = this.createMenuButton(menuItem);
            }
            convertView.setMinimumWidth(minimumWidth);
            return convertView;
        }

        public int calculateWidth(ToolbarMenuItem menuItem) {
            RemoteSelectionToolbar.updateMenuItemButton(this.mCalculator, menuItem, this.mIconTextSpacing, this.shouldShowIcon(menuItem));
            this.mCalculator.measure(0, 0);
            return this.mCalculator.getMeasuredWidth();
        }

        private View createMenuButton(ToolbarMenuItem menuItem) {
            View button = RemoteSelectionToolbar.createMenuItemButton(this.mContext, menuItem, this.mIconTextSpacing, this.shouldShowIcon(menuItem));
            button.setPadding(this.mSidePadding, 0, this.mSidePadding, 0);
            return button;
        }

        private boolean shouldShowIcon(ToolbarMenuItem menuItem) {
            if (menuItem != null) {
                return menuItem.getGroupId() == 16908353;
            }
            return false;
        }
    }

    private static class OverflowPanel
    extends ListView {
        private final RemoteSelectionToolbar mPopup;

        OverflowPanel(RemoteSelectionToolbar popup) {
            super(Objects.requireNonNull(popup).mContext);
            this.mPopup = popup;
            this.setScrollBarDefaultDelayBeforeFade(ViewConfiguration.getScrollDefaultDelay() * 3);
            this.setScrollIndicators(3);
        }

        @Override
        protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
            int height = this.mPopup.mOverflowPanelSize.getHeight() - this.mPopup.mOverflowButtonSize.getHeight();
            heightMeasureSpec = View.MeasureSpec.makeMeasureSpec(height, 0x40000000);
            super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        }

        @Override
        public boolean dispatchTouchEvent(MotionEvent ev) {
            if (this.mPopup.isOverflowAnimating()) {
                return true;
            }
            return super.dispatchTouchEvent(ev);
        }

        @Override
        protected boolean awakenScrollBars() {
            return super.awakenScrollBars();
        }
    }
}

