/*
 * Decompiled with CFR 0.152.
 */
package android.service.voice;

import android.annotation.NonNull;
import android.annotation.SystemApi;
import android.content.res.Resources;
import android.media.AudioRecord;
import android.media.MediaSyncEvent;
import android.os.Parcel;
import android.os.Parcelable;
import android.os.PersistableBundle;
import android.service.voice.HotwordAudioStream;
import com.android.internal.util.AnnotationValidations;
import com.android.internal.util.Preconditions;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

@SystemApi
public class HotwordDetectedResult
implements Parcelable {
    public static final int CONFIDENCE_LEVEL_NONE = 0;
    public static final int CONFIDENCE_LEVEL_LOW = 1;
    public static final int CONFIDENCE_LEVEL_LOW_MEDIUM = 2;
    public static final int CONFIDENCE_LEVEL_MEDIUM = 3;
    public static final int CONFIDENCE_LEVEL_MEDIUM_HIGH = 4;
    public static final int CONFIDENCE_LEVEL_HIGH = 5;
    public static final int CONFIDENCE_LEVEL_VERY_HIGH = 6;
    public static final int HOTWORD_OFFSET_UNSET = -1;
    public static final int AUDIO_CHANNEL_UNSET = -1;
    public static final int BACKGROUND_AUDIO_POWER_UNSET = -1;
    private static final int LIMIT_HOTWORD_OFFSET_MAX_VALUE = 3600000;
    private static final int LIMIT_AUDIO_CHANNEL_MAX_VALUE = 63;
    private static final String EXTRA_PROXIMITY = "android.service.voice.extra.PROXIMITY";
    public static final int PROXIMITY_UNKNOWN = -1;
    public static final int PROXIMITY_NEAR = 1;
    public static final int PROXIMITY_FAR = 2;
    @HotwordConfidenceLevelValue
    private final int mConfidenceLevel;
    private MediaSyncEvent mMediaSyncEvent = null;
    private int mHotwordOffsetMillis = -1;
    private int mHotwordDurationMillis = 0;
    private int mAudioChannel = -1;
    private boolean mHotwordDetectionPersonalized = false;
    private final int mScore;
    private final int mPersonalizedScore;
    private final int mHotwordPhraseId;
    private final List<HotwordAudioStream> mAudioStreams;
    private final PersistableBundle mExtras;
    private static int sMaxBundleSize = -1;
    private final int mBackgroundAudioPower;
    public static final Parcelable.Creator<HotwordDetectedResult> CREATOR = new Parcelable.Creator<HotwordDetectedResult>(){

        public HotwordDetectedResult[] newArray(int size) {
            return new HotwordDetectedResult[size];
        }

        @Override
        public HotwordDetectedResult createFromParcel(Parcel in) {
            return new HotwordDetectedResult(in);
        }
    };

    private static int defaultConfidenceLevel() {
        return 0;
    }

    private static int defaultScore() {
        return 0;
    }

    private static int defaultPersonalizedScore() {
        return 0;
    }

    public static int getMaxScore() {
        return 255;
    }

    private static int defaultHotwordPhraseId() {
        return 0;
    }

    public static int getMaxHotwordPhraseId() {
        return 63;
    }

    private static List<HotwordAudioStream> defaultAudioStreams() {
        return Collections.emptyList();
    }

    private static PersistableBundle defaultExtras() {
        return new PersistableBundle();
    }

    public static int getMaxBundleSize() {
        if (sMaxBundleSize < 0) {
            sMaxBundleSize = Resources.getSystem().getInteger(17694850);
        }
        return sMaxBundleSize;
    }

    public MediaSyncEvent getMediaSyncEvent() {
        return this.mMediaSyncEvent;
    }

    private static int defaultBackgroundAudioPower() {
        return -1;
    }

    public static int getMaxBackgroundAudioPower() {
        return 255;
    }

    public static int getParcelableSize(Parcelable parcelable) {
        Parcel p = Parcel.obtain();
        parcelable.writeToParcel(p, 0);
        p.setDataPosition(0);
        int size = p.dataSize();
        p.recycle();
        return size;
    }

    public static int getUsageSize(HotwordDetectedResult hotwordDetectedResult) {
        PersistableBundle persistableBundle;
        int totalBits = 0;
        if (hotwordDetectedResult.getConfidenceLevel() != HotwordDetectedResult.defaultConfidenceLevel()) {
            totalBits += HotwordDetectedResult.bitCount(6L);
        }
        if (hotwordDetectedResult.getHotwordOffsetMillis() != -1) {
            totalBits += HotwordDetectedResult.bitCount(3600000L);
        }
        if (hotwordDetectedResult.getHotwordDurationMillis() != 0) {
            totalBits += HotwordDetectedResult.bitCount(AudioRecord.getMaxSharedAudioHistoryMillis());
        }
        if (hotwordDetectedResult.getAudioChannel() != -1) {
            totalBits += HotwordDetectedResult.bitCount(63L);
        }
        ++totalBits;
        if (hotwordDetectedResult.getScore() != HotwordDetectedResult.defaultScore()) {
            totalBits += HotwordDetectedResult.bitCount(HotwordDetectedResult.getMaxScore());
        }
        if (hotwordDetectedResult.getPersonalizedScore() != HotwordDetectedResult.defaultPersonalizedScore()) {
            totalBits += HotwordDetectedResult.bitCount(HotwordDetectedResult.getMaxScore());
        }
        if (hotwordDetectedResult.getHotwordPhraseId() != HotwordDetectedResult.defaultHotwordPhraseId()) {
            totalBits += HotwordDetectedResult.bitCount(HotwordDetectedResult.getMaxHotwordPhraseId());
        }
        if (!(persistableBundle = hotwordDetectedResult.getExtras()).isEmpty()) {
            totalBits += HotwordDetectedResult.getParcelableSize(persistableBundle) * 8;
        }
        if (hotwordDetectedResult.getBackgroundAudioPower() != HotwordDetectedResult.defaultBackgroundAudioPower()) {
            totalBits += HotwordDetectedResult.bitCount(HotwordDetectedResult.getMaxBackgroundAudioPower());
        }
        return totalBits;
    }

    private static int bitCount(long value) {
        int bits = 0;
        while (value > 0L) {
            ++bits;
            value >>= 1;
        }
        return bits;
    }

    private void onConstructed() {
        Preconditions.checkArgumentInRange(this.mScore, 0, HotwordDetectedResult.getMaxScore(), "score");
        Preconditions.checkArgumentInRange(this.mPersonalizedScore, 0, HotwordDetectedResult.getMaxScore(), "personalizedScore");
        Preconditions.checkArgumentInRange(this.mHotwordPhraseId, 0, HotwordDetectedResult.getMaxHotwordPhraseId(), "hotwordPhraseId");
        if (this.mBackgroundAudioPower != -1) {
            Preconditions.checkArgumentInRange(this.mBackgroundAudioPower, 0, HotwordDetectedResult.getMaxBackgroundAudioPower(), "backgroundAudioPower");
        }
        Preconditions.checkArgumentInRange((long)this.mHotwordDurationMillis, 0L, AudioRecord.getMaxSharedAudioHistoryMillis(), "hotwordDurationMillis");
        if (this.mHotwordOffsetMillis != -1) {
            Preconditions.checkArgumentInRange(this.mHotwordOffsetMillis, 0, 3600000, "hotwordOffsetMillis");
        }
        if (this.mAudioChannel != -1) {
            Preconditions.checkArgumentInRange(this.mAudioChannel, 0, 63, "audioChannel");
        }
        if (!this.mExtras.isEmpty()) {
            if (this.mExtras.containsKey(EXTRA_PROXIMITY)) {
                int proximityValue = this.mExtras.getInt(EXTRA_PROXIMITY);
                this.mExtras.remove(EXTRA_PROXIMITY);
                if (this.mExtras.size() > 0) {
                    Preconditions.checkArgumentInRange(HotwordDetectedResult.getParcelableSize(this.mExtras), 0, HotwordDetectedResult.getMaxBundleSize(), "extras");
                }
                this.mExtras.putInt(EXTRA_PROXIMITY, proximityValue);
            } else {
                Preconditions.checkArgumentInRange(HotwordDetectedResult.getParcelableSize(this.mExtras), 0, HotwordDetectedResult.getMaxBundleSize(), "extras");
            }
        }
    }

    public List<HotwordAudioStream> getAudioStreams() {
        return List.copyOf(this.mAudioStreams);
    }

    public void setProximity(double distance) {
        int proximityLevel = this.convertToProximityLevel(distance);
        if (proximityLevel != -1) {
            this.mExtras.putInt(EXTRA_PROXIMITY, proximityLevel);
        }
    }

    public int getProximity() {
        return this.mExtras.getInt(EXTRA_PROXIMITY, -1);
    }

    private int convertToProximityLevel(double distance) {
        if (distance < 0.0) {
            return -1;
        }
        if (distance <= 3.0) {
            return 1;
        }
        return 2;
    }

    public Builder buildUpon() {
        return new Builder().setConfidenceLevel(this.mConfidenceLevel).setMediaSyncEvent(this.mMediaSyncEvent).setHotwordOffsetMillis(this.mHotwordOffsetMillis).setHotwordDurationMillis(this.mHotwordDurationMillis).setAudioChannel(this.mAudioChannel).setHotwordDetectionPersonalized(this.mHotwordDetectionPersonalized).setScore(this.mScore).setPersonalizedScore(this.mPersonalizedScore).setHotwordPhraseId(this.mHotwordPhraseId).setAudioStreams((List)this.mAudioStreams).setExtras(this.mExtras).setBackgroundAudioPower(this.mBackgroundAudioPower);
    }

    public static String confidenceLevelToString(int value) {
        switch (value) {
            case 0: {
                return "CONFIDENCE_LEVEL_NONE";
            }
            case 1: {
                return "CONFIDENCE_LEVEL_LOW";
            }
            case 2: {
                return "CONFIDENCE_LEVEL_LOW_MEDIUM";
            }
            case 3: {
                return "CONFIDENCE_LEVEL_MEDIUM";
            }
            case 4: {
                return "CONFIDENCE_LEVEL_MEDIUM_HIGH";
            }
            case 5: {
                return "CONFIDENCE_LEVEL_HIGH";
            }
            case 6: {
                return "CONFIDENCE_LEVEL_VERY_HIGH";
            }
        }
        return Integer.toHexString(value);
    }

    static String limitToString(int value) {
        switch (value) {
            case 3600000: {
                return "LIMIT_HOTWORD_OFFSET_MAX_VALUE";
            }
            case 63: {
                return "LIMIT_AUDIO_CHANNEL_MAX_VALUE";
            }
        }
        return Integer.toHexString(value);
    }

    public static String proximityToString(int value) {
        switch (value) {
            case -1: {
                return "PROXIMITY_UNKNOWN";
            }
            case 1: {
                return "PROXIMITY_NEAR";
            }
            case 2: {
                return "PROXIMITY_FAR";
            }
        }
        return Integer.toHexString(value);
    }

    HotwordDetectedResult(@HotwordConfidenceLevelValue int confidenceLevel, MediaSyncEvent mediaSyncEvent, int hotwordOffsetMillis, int hotwordDurationMillis, int audioChannel, boolean hotwordDetectionPersonalized, int score, int personalizedScore, int hotwordPhraseId, List<HotwordAudioStream> audioStreams, PersistableBundle extras, int backgroundAudioPower) {
        this.mConfidenceLevel = confidenceLevel;
        AnnotationValidations.validate(HotwordConfidenceLevelValue.class, null, this.mConfidenceLevel);
        this.mMediaSyncEvent = mediaSyncEvent;
        this.mHotwordOffsetMillis = hotwordOffsetMillis;
        this.mHotwordDurationMillis = hotwordDurationMillis;
        this.mAudioChannel = audioChannel;
        this.mHotwordDetectionPersonalized = hotwordDetectionPersonalized;
        this.mScore = score;
        this.mPersonalizedScore = personalizedScore;
        this.mHotwordPhraseId = hotwordPhraseId;
        this.mAudioStreams = audioStreams;
        AnnotationValidations.validate(NonNull.class, null, this.mAudioStreams);
        this.mExtras = extras;
        AnnotationValidations.validate(NonNull.class, null, (Object)this.mExtras);
        this.mBackgroundAudioPower = backgroundAudioPower;
        this.onConstructed();
    }

    @HotwordConfidenceLevelValue
    public int getConfidenceLevel() {
        return this.mConfidenceLevel;
    }

    public int getHotwordOffsetMillis() {
        return this.mHotwordOffsetMillis;
    }

    public int getHotwordDurationMillis() {
        return this.mHotwordDurationMillis;
    }

    public int getAudioChannel() {
        return this.mAudioChannel;
    }

    public boolean isHotwordDetectionPersonalized() {
        return this.mHotwordDetectionPersonalized;
    }

    public int getScore() {
        return this.mScore;
    }

    public int getPersonalizedScore() {
        return this.mPersonalizedScore;
    }

    public int getHotwordPhraseId() {
        return this.mHotwordPhraseId;
    }

    public PersistableBundle getExtras() {
        return this.mExtras;
    }

    public int getBackgroundAudioPower() {
        return this.mBackgroundAudioPower;
    }

    public String toString() {
        return "HotwordDetectedResult { confidenceLevel = " + this.mConfidenceLevel + ", mediaSyncEvent = " + this.mMediaSyncEvent + ", hotwordOffsetMillis = " + this.mHotwordOffsetMillis + ", hotwordDurationMillis = " + this.mHotwordDurationMillis + ", audioChannel = " + this.mAudioChannel + ", hotwordDetectionPersonalized = " + this.mHotwordDetectionPersonalized + ", score = " + this.mScore + ", personalizedScore = " + this.mPersonalizedScore + ", hotwordPhraseId = " + this.mHotwordPhraseId + ", audioStreams = " + this.mAudioStreams + ", extras = " + this.mExtras + ", backgroundAudioPower = " + this.mBackgroundAudioPower + " }";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HotwordDetectedResult that = (HotwordDetectedResult)o;
        return this.mConfidenceLevel == that.mConfidenceLevel && Objects.equals(this.mMediaSyncEvent, that.mMediaSyncEvent) && this.mHotwordOffsetMillis == that.mHotwordOffsetMillis && this.mHotwordDurationMillis == that.mHotwordDurationMillis && this.mAudioChannel == that.mAudioChannel && this.mHotwordDetectionPersonalized == that.mHotwordDetectionPersonalized && this.mScore == that.mScore && this.mPersonalizedScore == that.mPersonalizedScore && this.mHotwordPhraseId == that.mHotwordPhraseId && Objects.equals(this.mAudioStreams, that.mAudioStreams) && Objects.equals(this.mExtras, that.mExtras) && this.mBackgroundAudioPower == that.mBackgroundAudioPower;
    }

    public int hashCode() {
        int _hash = 1;
        _hash = 31 * _hash + this.mConfidenceLevel;
        _hash = 31 * _hash + Objects.hashCode(this.mMediaSyncEvent);
        _hash = 31 * _hash + this.mHotwordOffsetMillis;
        _hash = 31 * _hash + this.mHotwordDurationMillis;
        _hash = 31 * _hash + this.mAudioChannel;
        _hash = 31 * _hash + Boolean.hashCode(this.mHotwordDetectionPersonalized);
        _hash = 31 * _hash + this.mScore;
        _hash = 31 * _hash + this.mPersonalizedScore;
        _hash = 31 * _hash + this.mHotwordPhraseId;
        _hash = 31 * _hash + Objects.hashCode(this.mAudioStreams);
        _hash = 31 * _hash + Objects.hashCode(this.mExtras);
        _hash = 31 * _hash + this.mBackgroundAudioPower;
        return _hash;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        int flg = 0;
        if (this.mHotwordDetectionPersonalized) {
            flg |= 0x20;
        }
        if (this.mMediaSyncEvent != null) {
            flg |= 2;
        }
        dest.writeInt(flg);
        dest.writeInt(this.mConfidenceLevel);
        if (this.mMediaSyncEvent != null) {
            dest.writeTypedObject(this.mMediaSyncEvent, flags);
        }
        dest.writeInt(this.mHotwordOffsetMillis);
        dest.writeInt(this.mHotwordDurationMillis);
        dest.writeInt(this.mAudioChannel);
        dest.writeInt(this.mScore);
        dest.writeInt(this.mPersonalizedScore);
        dest.writeInt(this.mHotwordPhraseId);
        dest.writeParcelableList(this.mAudioStreams, flags);
        dest.writeTypedObject(this.mExtras, flags);
        dest.writeInt(this.mBackgroundAudioPower);
    }

    @Override
    public int describeContents() {
        return 0;
    }

    HotwordDetectedResult(Parcel in) {
        int flg = in.readInt();
        boolean hotwordDetectionPersonalized = (flg & 0x20) != 0;
        int confidenceLevel = in.readInt();
        MediaSyncEvent mediaSyncEvent = (flg & 2) == 0 ? null : in.readTypedObject(MediaSyncEvent.CREATOR);
        int hotwordOffsetMillis = in.readInt();
        int hotwordDurationMillis = in.readInt();
        int audioChannel = in.readInt();
        int score = in.readInt();
        int personalizedScore = in.readInt();
        int hotwordPhraseId = in.readInt();
        ArrayList<HotwordAudioStream> audioStreams = new ArrayList<HotwordAudioStream>();
        in.readParcelableList(audioStreams, HotwordAudioStream.class.getClassLoader());
        PersistableBundle extras = in.readTypedObject(PersistableBundle.CREATOR);
        int backgroundAudioPower = in.readInt();
        this.mConfidenceLevel = confidenceLevel;
        AnnotationValidations.validate(HotwordConfidenceLevelValue.class, null, this.mConfidenceLevel);
        this.mMediaSyncEvent = mediaSyncEvent;
        this.mHotwordOffsetMillis = hotwordOffsetMillis;
        this.mHotwordDurationMillis = hotwordDurationMillis;
        this.mAudioChannel = audioChannel;
        this.mHotwordDetectionPersonalized = hotwordDetectionPersonalized;
        this.mScore = score;
        this.mPersonalizedScore = personalizedScore;
        this.mHotwordPhraseId = hotwordPhraseId;
        this.mAudioStreams = audioStreams;
        AnnotationValidations.validate(NonNull.class, null, this.mAudioStreams);
        this.mExtras = extras;
        AnnotationValidations.validate(NonNull.class, null, (Object)this.mExtras);
        this.mBackgroundAudioPower = backgroundAudioPower;
        this.onConstructed();
    }

    @Deprecated
    private void __metadata() {
    }

    public static class Builder
    extends BaseBuilder {
        @HotwordConfidenceLevelValue
        private int mConfidenceLevel;
        private MediaSyncEvent mMediaSyncEvent;
        private int mHotwordOffsetMillis;
        private int mHotwordDurationMillis;
        private int mAudioChannel;
        private boolean mHotwordDetectionPersonalized;
        private int mScore;
        private int mPersonalizedScore;
        private int mHotwordPhraseId;
        private List<HotwordAudioStream> mAudioStreams;
        private PersistableBundle mExtras;
        private int mBackgroundAudioPower;
        private long mBuilderFieldsSet = 0L;

        public Builder setConfidenceLevel(@HotwordConfidenceLevelValue int value) {
            this.checkNotUsed();
            this.mBuilderFieldsSet |= 1L;
            this.mConfidenceLevel = value;
            return this;
        }

        public Builder setMediaSyncEvent(MediaSyncEvent value) {
            this.checkNotUsed();
            this.mBuilderFieldsSet |= 2L;
            this.mMediaSyncEvent = value;
            return this;
        }

        public Builder setHotwordOffsetMillis(int value) {
            this.checkNotUsed();
            this.mBuilderFieldsSet |= 4L;
            this.mHotwordOffsetMillis = value;
            return this;
        }

        public Builder setHotwordDurationMillis(int value) {
            this.checkNotUsed();
            this.mBuilderFieldsSet |= 8L;
            this.mHotwordDurationMillis = value;
            return this;
        }

        public Builder setAudioChannel(int value) {
            this.checkNotUsed();
            this.mBuilderFieldsSet |= 0x10L;
            this.mAudioChannel = value;
            return this;
        }

        public Builder setHotwordDetectionPersonalized(boolean value) {
            this.checkNotUsed();
            this.mBuilderFieldsSet |= 0x20L;
            this.mHotwordDetectionPersonalized = value;
            return this;
        }

        public Builder setScore(int value) {
            this.checkNotUsed();
            this.mBuilderFieldsSet |= 0x40L;
            this.mScore = value;
            return this;
        }

        public Builder setPersonalizedScore(int value) {
            this.checkNotUsed();
            this.mBuilderFieldsSet |= 0x80L;
            this.mPersonalizedScore = value;
            return this;
        }

        public Builder setHotwordPhraseId(int value) {
            this.checkNotUsed();
            this.mBuilderFieldsSet |= 0x100L;
            this.mHotwordPhraseId = value;
            return this;
        }

        public Builder setExtras(PersistableBundle value) {
            this.checkNotUsed();
            this.mBuilderFieldsSet |= 0x400L;
            this.mExtras = value;
            return this;
        }

        public Builder setBackgroundAudioPower(int value) {
            this.checkNotUsed();
            this.mBuilderFieldsSet |= 0x800L;
            this.mBackgroundAudioPower = value;
            return this;
        }

        public HotwordDetectedResult build() {
            this.checkNotUsed();
            this.mBuilderFieldsSet |= 0x1000L;
            if ((this.mBuilderFieldsSet & 1L) == 0L) {
                this.mConfidenceLevel = HotwordDetectedResult.defaultConfidenceLevel();
            }
            if ((this.mBuilderFieldsSet & 2L) == 0L) {
                this.mMediaSyncEvent = null;
            }
            if ((this.mBuilderFieldsSet & 4L) == 0L) {
                this.mHotwordOffsetMillis = -1;
            }
            if ((this.mBuilderFieldsSet & 8L) == 0L) {
                this.mHotwordDurationMillis = 0;
            }
            if ((this.mBuilderFieldsSet & 0x10L) == 0L) {
                this.mAudioChannel = -1;
            }
            if ((this.mBuilderFieldsSet & 0x20L) == 0L) {
                this.mHotwordDetectionPersonalized = false;
            }
            if ((this.mBuilderFieldsSet & 0x40L) == 0L) {
                this.mScore = HotwordDetectedResult.defaultScore();
            }
            if ((this.mBuilderFieldsSet & 0x80L) == 0L) {
                this.mPersonalizedScore = HotwordDetectedResult.defaultPersonalizedScore();
            }
            if ((this.mBuilderFieldsSet & 0x100L) == 0L) {
                this.mHotwordPhraseId = HotwordDetectedResult.defaultHotwordPhraseId();
            }
            if ((this.mBuilderFieldsSet & 0x200L) == 0L) {
                this.mAudioStreams = HotwordDetectedResult.defaultAudioStreams();
            }
            if ((this.mBuilderFieldsSet & 0x400L) == 0L) {
                this.mExtras = HotwordDetectedResult.defaultExtras();
            }
            if ((this.mBuilderFieldsSet & 0x800L) == 0L) {
                this.mBackgroundAudioPower = HotwordDetectedResult.defaultBackgroundAudioPower();
            }
            HotwordDetectedResult o = new HotwordDetectedResult(this.mConfidenceLevel, this.mMediaSyncEvent, this.mHotwordOffsetMillis, this.mHotwordDurationMillis, this.mAudioChannel, this.mHotwordDetectionPersonalized, this.mScore, this.mPersonalizedScore, this.mHotwordPhraseId, this.mAudioStreams, this.mExtras, this.mBackgroundAudioPower);
            return o;
        }

        private void checkNotUsed() {
            if ((this.mBuilderFieldsSet & 0x1000L) != 0L) {
                throw new IllegalStateException("This Builder should not be reused. Use a new Builder instance instead");
            }
        }
    }

    static @interface HotwordConfidenceLevelValue {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface Proximity {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    static @interface Limit {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface ConfidenceLevel {
    }

    static abstract class BaseBuilder {
        BaseBuilder() {
        }

        public Builder setAudioStreams(List<HotwordAudioStream> value) {
            Objects.requireNonNull(value, "value should not be null");
            Builder builder = (Builder)this;
            builder.mBuilderFieldsSet |= 0x200L;
            builder.mAudioStreams = List.copyOf(value);
            return builder;
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface ProximityValue {
    }
}

