/*
 * Decompiled with CFR 0.152.
 */
package android.service.voice;

import android.app.assist.AssistContent;
import android.app.assist.AssistStructure;
import android.content.Intent;
import android.graphics.Bitmap;
import android.os.Binder;
import android.os.Bundle;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.RemoteException;
import android.service.voice.VisibleActivityInfo;
import com.android.internal.app.IVoiceInteractionSessionShowCallback;

public interface IVoiceInteractionSession
extends IInterface {
    public void show(Bundle var1, int var2, IVoiceInteractionSessionShowCallback var3) throws RemoteException;

    public void hide() throws RemoteException;

    public void handleAssist(int var1, IBinder var2, Bundle var3, AssistStructure var4, AssistContent var5, int var6, int var7) throws RemoteException;

    public void handleScreenshot(Bitmap var1) throws RemoteException;

    public void taskStarted(Intent var1, int var2) throws RemoteException;

    public void taskFinished(Intent var1, int var2) throws RemoteException;

    public void closeSystemDialogs() throws RemoteException;

    public void onLockscreenShown() throws RemoteException;

    public void destroy() throws RemoteException;

    public void notifyVisibleActivityInfoChanged(VisibleActivityInfo var1, int var2) throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements IVoiceInteractionSession {
        public static final String DESCRIPTOR = "android.service.voice.IVoiceInteractionSession";
        static final int TRANSACTION_show = 1;
        static final int TRANSACTION_hide = 2;
        static final int TRANSACTION_handleAssist = 3;
        static final int TRANSACTION_handleScreenshot = 4;
        static final int TRANSACTION_taskStarted = 5;
        static final int TRANSACTION_taskFinished = 6;
        static final int TRANSACTION_closeSystemDialogs = 7;
        static final int TRANSACTION_onLockscreenShown = 8;
        static final int TRANSACTION_destroy = 9;
        static final int TRANSACTION_notifyVisibleActivityInfoChanged = 10;

        public Stub() {
            this.attachInterface(this, DESCRIPTOR);
        }

        public static IVoiceInteractionSession asInterface(IBinder obj) {
            if (obj == null) {
                return null;
            }
            IInterface iin = obj.queryLocalInterface(DESCRIPTOR);
            if (iin != null && iin instanceof IVoiceInteractionSession) {
                return (IVoiceInteractionSession)iin;
            }
            return new Proxy(obj);
        }

        @Override
        public IBinder asBinder() {
            return this;
        }

        public static String getDefaultTransactionName(int transactionCode) {
            switch (transactionCode) {
                case 1: {
                    return "show";
                }
                case 2: {
                    return "hide";
                }
                case 3: {
                    return "handleAssist";
                }
                case 4: {
                    return "handleScreenshot";
                }
                case 5: {
                    return "taskStarted";
                }
                case 6: {
                    return "taskFinished";
                }
                case 7: {
                    return "closeSystemDialogs";
                }
                case 8: {
                    return "onLockscreenShown";
                }
                case 9: {
                    return "destroy";
                }
                case 10: {
                    return "notifyVisibleActivityInfoChanged";
                }
            }
            return null;
        }

        @Override
        public String getTransactionName(int transactionCode) {
            return Stub.getDefaultTransactionName(transactionCode);
        }

        @Override
        public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
            String descriptor = DESCRIPTOR;
            if (code >= 1 && code <= 0xFFFFFF) {
                data.enforceInterface(descriptor);
            }
            switch (code) {
                case 1598968902: {
                    reply.writeString(descriptor);
                    return true;
                }
            }
            switch (code) {
                case 1: {
                    Bundle _arg0 = data.readTypedObject(Bundle.CREATOR);
                    int _arg1 = data.readInt();
                    IVoiceInteractionSessionShowCallback _arg2 = IVoiceInteractionSessionShowCallback.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    this.show(_arg0, _arg1, _arg2);
                    break;
                }
                case 2: {
                    this.hide();
                    break;
                }
                case 3: {
                    int _arg0 = data.readInt();
                    IBinder _arg1 = data.readStrongBinder();
                    Bundle _arg2 = data.readTypedObject(Bundle.CREATOR);
                    AssistStructure _arg3 = data.readTypedObject(AssistStructure.CREATOR);
                    AssistContent _arg4 = data.readTypedObject(AssistContent.CREATOR);
                    int _arg5 = data.readInt();
                    int _arg6 = data.readInt();
                    data.enforceNoDataAvail();
                    this.handleAssist(_arg0, _arg1, _arg2, _arg3, _arg4, _arg5, _arg6);
                    break;
                }
                case 4: {
                    Bitmap _arg0 = data.readTypedObject(Bitmap.CREATOR);
                    data.enforceNoDataAvail();
                    this.handleScreenshot(_arg0);
                    break;
                }
                case 5: {
                    Intent _arg0 = data.readTypedObject(Intent.CREATOR);
                    int _arg1 = data.readInt();
                    data.enforceNoDataAvail();
                    this.taskStarted(_arg0, _arg1);
                    break;
                }
                case 6: {
                    Intent _arg0 = data.readTypedObject(Intent.CREATOR);
                    int _arg1 = data.readInt();
                    data.enforceNoDataAvail();
                    this.taskFinished(_arg0, _arg1);
                    break;
                }
                case 7: {
                    this.closeSystemDialogs();
                    break;
                }
                case 8: {
                    this.onLockscreenShown();
                    break;
                }
                case 9: {
                    this.destroy();
                    break;
                }
                case 10: {
                    VisibleActivityInfo _arg0 = data.readTypedObject(VisibleActivityInfo.CREATOR);
                    int _arg1 = data.readInt();
                    data.enforceNoDataAvail();
                    this.notifyVisibleActivityInfoChanged(_arg0, _arg1);
                    break;
                }
                default: {
                    return super.onTransact(code, data, reply, flags);
                }
            }
            return true;
        }

        @Override
        public int getMaxTransactionId() {
            return 9;
        }

        private static class Proxy
        implements IVoiceInteractionSession {
            private IBinder mRemote;

            Proxy(IBinder remote) {
                this.mRemote = remote;
            }

            @Override
            public IBinder asBinder() {
                return this.mRemote;
            }

            public String getInterfaceDescriptor() {
                return Stub.DESCRIPTOR;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void show(Bundle sessionArgs, int flags, IVoiceInteractionSessionShowCallback showCallback) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedObject(sessionArgs, 0);
                    _data.writeInt(flags);
                    _data.writeStrongInterface(showCallback);
                    boolean bl = this.mRemote.transact(1, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            @Override
            public void hide() throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean bl = this.mRemote.transact(2, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void handleAssist(int taskId, IBinder activityId, Bundle assistData, AssistStructure structure, AssistContent content, int index, int count) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(taskId);
                    _data.writeStrongBinder(activityId);
                    _data.writeTypedObject(assistData, 0);
                    _data.writeTypedObject(structure, 0);
                    _data.writeTypedObject(content, 0);
                    _data.writeInt(index);
                    _data.writeInt(count);
                    boolean bl = this.mRemote.transact(3, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void handleScreenshot(Bitmap screenshot) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedObject(screenshot, 0);
                    boolean bl = this.mRemote.transact(4, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void taskStarted(Intent intent, int taskId) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedObject(intent, 0);
                    _data.writeInt(taskId);
                    boolean bl = this.mRemote.transact(5, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void taskFinished(Intent intent, int taskId) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedObject(intent, 0);
                    _data.writeInt(taskId);
                    boolean bl = this.mRemote.transact(6, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            @Override
            public void closeSystemDialogs() throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean bl = this.mRemote.transact(7, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            @Override
            public void onLockscreenShown() throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean bl = this.mRemote.transact(8, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            @Override
            public void destroy() throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean bl = this.mRemote.transact(9, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void notifyVisibleActivityInfoChanged(VisibleActivityInfo visibleActivityInfo, int type) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedObject(visibleActivityInfo, 0);
                    _data.writeInt(type);
                    boolean bl = this.mRemote.transact(10, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }
        }
    }

    public static class Default
    implements IVoiceInteractionSession {
        @Override
        public void show(Bundle sessionArgs, int flags, IVoiceInteractionSessionShowCallback showCallback) throws RemoteException {
        }

        @Override
        public void hide() throws RemoteException {
        }

        @Override
        public void handleAssist(int taskId, IBinder activityId, Bundle assistData, AssistStructure structure, AssistContent content, int index, int count) throws RemoteException {
        }

        @Override
        public void handleScreenshot(Bitmap screenshot) throws RemoteException {
        }

        @Override
        public void taskStarted(Intent intent, int taskId) throws RemoteException {
        }

        @Override
        public void taskFinished(Intent intent, int taskId) throws RemoteException {
        }

        @Override
        public void closeSystemDialogs() throws RemoteException {
        }

        @Override
        public void onLockscreenShown() throws RemoteException {
        }

        @Override
        public void destroy() throws RemoteException {
        }

        @Override
        public void notifyVisibleActivityInfoChanged(VisibleActivityInfo visibleActivityInfo, int type) throws RemoteException {
        }

        @Override
        public IBinder asBinder() {
            return null;
        }
    }
}

