/*
 * Decompiled with CFR 0.152.
 */
package android.service.voice;

import android.annotation.SystemApi;
import android.os.Parcel;
import android.os.Parcelable;
import android.text.TextUtils;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;

@SystemApi
public class VisualQueryDetectionServiceFailure
implements Parcelable {
    public static final int ERROR_CODE_UNKNOWN = 0;
    public static final int ERROR_CODE_BIND_FAILURE = 1;
    public static final int ERROR_CODE_BINDING_DIED = 2;
    public static final int ERROR_CODE_ILLEGAL_ATTENTION_STATE = 3;
    public static final int ERROR_CODE_ILLEGAL_STREAMING_STATE = 4;
    public static final int ERROR_CODE_REMOTE_EXCEPTION = 5;
    private int mErrorCode = 0;
    private String mErrorMessage = "Unknown";
    public static final Parcelable.Creator<VisualQueryDetectionServiceFailure> CREATOR = new Parcelable.Creator<VisualQueryDetectionServiceFailure>(){

        public VisualQueryDetectionServiceFailure[] newArray(int size) {
            return new VisualQueryDetectionServiceFailure[size];
        }

        @Override
        public VisualQueryDetectionServiceFailure createFromParcel(Parcel in) {
            return new VisualQueryDetectionServiceFailure(in.readInt(), in.readString8());
        }
    };

    public VisualQueryDetectionServiceFailure(int errorCode, String errorMessage) {
        if (TextUtils.isEmpty(errorMessage)) {
            throw new IllegalArgumentException("errorMessage is empty or null.");
        }
        this.mErrorCode = errorCode;
        this.mErrorMessage = errorMessage;
    }

    public int getErrorCode() {
        return this.mErrorCode;
    }

    public String getErrorMessage() {
        return this.mErrorMessage;
    }

    public int getSuggestedAction() {
        switch (this.mErrorCode) {
            case 1: 
            case 2: 
            case 3: 
            case 5: {
                return 3;
            }
            case 4: {
                return 4;
            }
        }
        return 1;
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        dest.writeInt(this.mErrorCode);
        dest.writeString8(this.mErrorMessage);
    }

    public String toString() {
        return "VisualQueryDetectionServiceFailure { errorCode = " + this.mErrorCode + ", errorMessage = " + this.mErrorMessage + " }";
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface VisualQueryDetectionServiceErrorCode {
    }
}

