/*
 * Decompiled with CFR 0.152.
 */
package android.sysprop;

import android.os.SystemProperties;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.StringJoiner;
import java.util.function.Function;

public class TelephonyProperties {
    private TelephonyProperties() {
    }

    private static Boolean tryParseBoolean(String str) {
        if (str == null) {
            return null;
        }
        switch (str.toLowerCase(Locale.US)) {
            case "1": 
            case "true": {
                return Boolean.TRUE;
            }
            case "0": 
            case "false": {
                return Boolean.FALSE;
            }
        }
        return null;
    }

    private static Integer tryParseInteger(String str) {
        try {
            return Integer.valueOf(str);
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    private static Integer tryParseUInt(String str) {
        try {
            return Integer.parseUnsignedInt(str);
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    private static Long tryParseLong(String str) {
        try {
            return Long.valueOf(str);
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    private static Long tryParseULong(String str) {
        try {
            return Long.parseUnsignedLong(str);
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    private static Double tryParseDouble(String str) {
        try {
            return Double.valueOf(str);
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    private static String tryParseString(String str) {
        return "".equals(str) ? null : str;
    }

    private static <T extends Enum<T>> T tryParseEnum(Class<T> enumType, String str) {
        try {
            return Enum.valueOf(enumType, str.toUpperCase(Locale.US));
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }

    private static <T> List<T> tryParseList(Function<String, T> elementParser, String str) {
        if ("".equals(str)) {
            return new ArrayList();
        }
        ArrayList<T> ret = new ArrayList<T>();
        int p = 0;
        while (true) {
            StringBuilder sb = new StringBuilder();
            while (p < str.length() && str.charAt(p) != ',') {
                if (str.charAt(p) == '\\') {
                    ++p;
                }
                if (p == str.length()) break;
                sb.append(str.charAt(p++));
            }
            ret.add(elementParser.apply(sb.toString()));
            if (p == str.length()) break;
            ++p;
        }
        return ret;
    }

    private static <T extends Enum<T>> List<T> tryParseEnumList(Class<T> enumType, String str) {
        if ("".equals(str)) {
            return new ArrayList();
        }
        ArrayList<T> ret = new ArrayList<T>();
        for (String element : str.split(",")) {
            ret.add(TelephonyProperties.tryParseEnum(enumType, element));
        }
        return ret;
    }

    private static String escape(String str) {
        return str.replaceAll("([\\\\,])", "\\\\$1");
    }

    private static <T> String formatList(List<T> list) {
        StringJoiner joiner = new StringJoiner(",");
        for (T element : list) {
            joiner.add(element == null ? "" : TelephonyProperties.escape(element.toString()));
        }
        return joiner.toString();
    }

    private static String formatUIntList(List<Integer> list) {
        StringJoiner joiner = new StringJoiner(",");
        for (Integer element : list) {
            joiner.add(element == null ? "" : TelephonyProperties.escape(Integer.toUnsignedString(element)));
        }
        return joiner.toString();
    }

    private static String formatULongList(List<Long> list) {
        StringJoiner joiner = new StringJoiner(",");
        for (Long element : list) {
            joiner.add(element == null ? "" : TelephonyProperties.escape(Long.toUnsignedString(element)));
        }
        return joiner.toString();
    }

    private static <T extends Enum<T>> String formatEnumList(List<T> list, Function<T, String> elementFormatter) {
        StringJoiner joiner = new StringJoiner(",");
        for (Enum element : list) {
            joiner.add(element == null ? "" : (CharSequence)elementFormatter.apply(element));
        }
        return joiner.toString();
    }

    public static Optional<Boolean> airplane_mode_on() {
        String value = SystemProperties.get("persist.radio.airplane_mode_on");
        return Optional.ofNullable(TelephonyProperties.tryParseBoolean(value));
    }

    public static void airplane_mode_on(Boolean value) {
        SystemProperties.set("persist.radio.airplane_mode_on", value == null ? "" : (value != false ? "1" : "0"));
    }

    public static List<String> baseband_version() {
        String value = SystemProperties.get("gsm.version.baseband");
        return TelephonyProperties.tryParseList(v -> TelephonyProperties.tryParseString(v), value);
    }

    public static void baseband_version(List<String> value) {
        SystemProperties.set("gsm.version.baseband", value == null ? "" : TelephonyProperties.formatList(value));
    }

    public static Optional<String> ril_impl() {
        String value = SystemProperties.get("gsm.version.ril-impl");
        return Optional.ofNullable(TelephonyProperties.tryParseString(value));
    }

    public static List<String> operator_alpha() {
        String value = SystemProperties.get("gsm.operator.alpha");
        return TelephonyProperties.tryParseList(v -> TelephonyProperties.tryParseString(v), value);
    }

    public static void operator_alpha(List<String> value) {
        SystemProperties.set("gsm.operator.alpha", value == null ? "" : TelephonyProperties.formatList(value));
    }

    public static List<String> operator_numeric() {
        String value = SystemProperties.get("gsm.operator.numeric");
        return TelephonyProperties.tryParseList(v -> TelephonyProperties.tryParseString(v), value);
    }

    public static void operator_numeric(List<String> value) {
        SystemProperties.set("gsm.operator.numeric", value == null ? "" : TelephonyProperties.formatList(value));
    }

    public static Optional<Boolean> operator_is_manual() {
        String value = SystemProperties.get("operator.ismanual");
        return Optional.ofNullable(TelephonyProperties.tryParseBoolean(value));
    }

    public static List<Boolean> operator_is_roaming() {
        String value = SystemProperties.get("gsm.operator.isroaming");
        return TelephonyProperties.tryParseList(v -> TelephonyProperties.tryParseBoolean(v), value);
    }

    public static void operator_is_roaming(List<Boolean> value) {
        SystemProperties.set("gsm.operator.isroaming", value == null ? "" : TelephonyProperties.formatList(value));
    }

    public static List<String> operator_iso_country() {
        String value = SystemProperties.get("gsm.operator.iso-country");
        return TelephonyProperties.tryParseList(v -> TelephonyProperties.tryParseString(v), value);
    }

    public static void operator_iso_country(List<String> value) {
        SystemProperties.set("gsm.operator.iso-country", value == null ? "" : TelephonyProperties.formatList(value));
    }

    public static Optional<String> lte_on_cdma_product_type() {
        String value = SystemProperties.get("telephony.lteOnCdmaProductType");
        return Optional.ofNullable(TelephonyProperties.tryParseString(value));
    }

    public static Optional<Integer> lte_on_cdma_device() {
        String value = SystemProperties.get("telephony.lteOnCdmaDevice");
        return Optional.ofNullable(TelephonyProperties.tryParseInteger(value));
    }

    public static List<Integer> current_active_phone() {
        String value = SystemProperties.get("gsm.current.phone-type");
        return TelephonyProperties.tryParseList(v -> TelephonyProperties.tryParseInteger(v), value);
    }

    public static void current_active_phone(List<Integer> value) {
        SystemProperties.set("gsm.current.phone-type", value == null ? "" : TelephonyProperties.formatList(value));
    }

    public static List<String> sim_state() {
        String value = SystemProperties.get("gsm.sim.state");
        return TelephonyProperties.tryParseList(v -> TelephonyProperties.tryParseString(v), value);
    }

    public static void sim_state(List<String> value) {
        SystemProperties.set("gsm.sim.state", value == null ? "" : TelephonyProperties.formatList(value));
    }

    public static List<String> icc_operator_numeric() {
        String value = SystemProperties.get("gsm.sim.operator.numeric");
        return TelephonyProperties.tryParseList(v -> TelephonyProperties.tryParseString(v), value);
    }

    public static void icc_operator_numeric(List<String> value) {
        SystemProperties.set("gsm.sim.operator.numeric", value == null ? "" : TelephonyProperties.formatList(value));
    }

    public static List<String> icc_operator_alpha() {
        String value = SystemProperties.get("gsm.sim.operator.alpha");
        return TelephonyProperties.tryParseList(v -> TelephonyProperties.tryParseString(v), value);
    }

    public static void icc_operator_alpha(List<String> value) {
        SystemProperties.set("gsm.sim.operator.alpha", value == null ? "" : TelephonyProperties.formatList(value));
    }

    public static List<String> icc_operator_iso_country() {
        String value = SystemProperties.get("gsm.sim.operator.iso-country");
        return TelephonyProperties.tryParseList(v -> TelephonyProperties.tryParseString(v), value);
    }

    public static void icc_operator_iso_country(List<String> value) {
        SystemProperties.set("gsm.sim.operator.iso-country", value == null ? "" : TelephonyProperties.formatList(value));
    }

    public static List<String> data_network_type() {
        String value = SystemProperties.get("gsm.network.type");
        return TelephonyProperties.tryParseList(v -> TelephonyProperties.tryParseString(v), value);
    }

    public static void data_network_type(List<String> value) {
        SystemProperties.set("gsm.network.type", value == null ? "" : TelephonyProperties.formatList(value));
    }

    public static Optional<Boolean> in_ecm_mode() {
        String value = SystemProperties.get("ril.cdma.inecmmode");
        return Optional.ofNullable(TelephonyProperties.tryParseBoolean(value));
    }

    public static void in_ecm_mode(Boolean value) {
        SystemProperties.set("ril.cdma.inecmmode", value == null ? "" : value.toString());
    }

    public static Optional<Long> ecm_exit_timer() {
        String value = SystemProperties.get("ro.cdma.ecmexittimer");
        return Optional.ofNullable(TelephonyProperties.tryParseLong(value));
    }

    public static Optional<String> operator_idp_string() {
        String value = SystemProperties.get("gsm.operator.idpstring");
        return Optional.ofNullable(TelephonyProperties.tryParseString(value));
    }

    public static void operator_idp_string(String value) {
        SystemProperties.set("gsm.operator.idpstring", value == null ? "" : value.toString());
    }

    public static List<String> otasp_num_schema() {
        String value = SystemProperties.get("ro.cdma.otaspnumschema");
        return TelephonyProperties.tryParseList(v -> TelephonyProperties.tryParseString(v), value);
    }

    public static Optional<Boolean> disable_call() {
        String value = SystemProperties.get("ro.telephony.disable-call");
        return Optional.ofNullable(TelephonyProperties.tryParseBoolean(value));
    }

    public static Optional<Boolean> ril_sends_multiple_call_ring() {
        String value = SystemProperties.get("ro.telephony.call_ring.multiple");
        return Optional.ofNullable(TelephonyProperties.tryParseBoolean(value));
    }

    public static Optional<Integer> call_ring_delay() {
        String value = SystemProperties.get("ro.telephony.call_ring.delay");
        return Optional.ofNullable(TelephonyProperties.tryParseInteger(value));
    }

    public static Optional<Integer> cdma_msg_id() {
        String value = SystemProperties.get("persist.radio.cdma.msgid");
        return Optional.ofNullable(TelephonyProperties.tryParseInteger(value));
    }

    public static void cdma_msg_id(Integer value) {
        SystemProperties.set("persist.radio.cdma.msgid", value == null ? "" : value.toString());
    }

    public static Optional<Integer> wake_lock_timeout() {
        String value = SystemProperties.get("ro.ril.wake_lock_timeout");
        return Optional.ofNullable(TelephonyProperties.tryParseInteger(value));
    }

    public static Optional<Boolean> reset_on_radio_tech_change() {
        String value = SystemProperties.get("persist.radio.reset_on_switch");
        return Optional.ofNullable(TelephonyProperties.tryParseBoolean(value));
    }

    public static List<Boolean> sms_receive() {
        String value = SystemProperties.get("telephony.sms.receive");
        return TelephonyProperties.tryParseList(v -> TelephonyProperties.tryParseBoolean(v), value);
    }

    public static List<Boolean> sms_send() {
        String value = SystemProperties.get("telephony.sms.send");
        return TelephonyProperties.tryParseList(v -> TelephonyProperties.tryParseBoolean(v), value);
    }

    public static Optional<Boolean> test_csim() {
        String value = SystemProperties.get("persist.radio.test-csim");
        return Optional.ofNullable(TelephonyProperties.tryParseBoolean(value));
    }

    public static Optional<Boolean> ignore_nitz() {
        String value = SystemProperties.get("telephony.test.ignore.nitz");
        return Optional.ofNullable(TelephonyProperties.tryParseBoolean(value));
    }

    public static Optional<String> multi_sim_config() {
        String value = SystemProperties.get("persist.radio.multisim.config");
        return Optional.ofNullable(TelephonyProperties.tryParseString(value));
    }

    public static void multi_sim_config(String value) {
        SystemProperties.set("persist.radio.multisim.config", value == null ? "" : value.toString());
    }

    public static Optional<Boolean> reboot_on_modem_change() {
        String value = SystemProperties.get("persist.radio.reboot_on_modem_change");
        return Optional.ofNullable(TelephonyProperties.tryParseBoolean(value));
    }

    public static Optional<Integer> videocall_audio_output() {
        String value = SystemProperties.get("persist.radio.call.audio.output");
        return Optional.ofNullable(TelephonyProperties.tryParseInteger(value));
    }

    public static Optional<Boolean> enable_esim_ui_by_default() {
        String value = SystemProperties.get("esim.enable_esim_system_ui_by_default");
        return Optional.ofNullable(TelephonyProperties.tryParseBoolean(value));
    }

    public static List<Integer> default_network() {
        String value = SystemProperties.get("ro.telephony.default_network");
        return TelephonyProperties.tryParseList(v -> TelephonyProperties.tryParseInteger(v), value);
    }

    public static Optional<Boolean> data_roaming() {
        String value = SystemProperties.get("ro.com.android.dataroaming");
        return Optional.ofNullable(TelephonyProperties.tryParseBoolean(value));
    }

    public static Optional<Boolean> mobile_data() {
        String value = SystemProperties.get("ro.com.android.mobiledata");
        return Optional.ofNullable(TelephonyProperties.tryParseBoolean(value));
    }

    public static Optional<Integer> wps_info() {
        String value = SystemProperties.get("wifidirect.wps");
        return Optional.ofNullable(TelephonyProperties.tryParseInteger(value));
    }

    public static Optional<Integer> max_active_modems() {
        String value = SystemProperties.get("telephony.active_modems.max_count");
        return Optional.ofNullable(TelephonyProperties.tryParseInteger(value));
    }

    public static Optional<Integer> sim_slots_count() {
        String value = SystemProperties.get("ro.telephony.sim_slots.count");
        return Optional.ofNullable(TelephonyProperties.tryParseInteger(value));
    }
}

