/*
 * Decompiled with CFR 0.152.
 */
package android.system.keystore2;

import android.os.Binder;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.Parcelable;
import android.os.RemoteException;
import android.system.keystore2.IKeystoreSecurityLevel;
import android.system.keystore2.KeyDescriptor;
import android.system.keystore2.KeyEntryResponse;

public interface IKeystoreService
extends IInterface {
    public static final int VERSION = 3;
    public static final String HASH = "4f1c704008e5687ed0d6f1590464aed39fc7f64e";
    public static final String DESCRIPTOR = "android$system$keystore2$IKeystoreService".replace('$', '.');

    public IKeystoreSecurityLevel getSecurityLevel(int var1) throws RemoteException;

    public KeyEntryResponse getKeyEntry(KeyDescriptor var1) throws RemoteException;

    public void updateSubcomponent(KeyDescriptor var1, byte[] var2, byte[] var3) throws RemoteException;

    @Deprecated
    public KeyDescriptor[] listEntries(int var1, long var2) throws RemoteException;

    public void deleteKey(KeyDescriptor var1) throws RemoteException;

    public KeyDescriptor grant(KeyDescriptor var1, int var2, int var3) throws RemoteException;

    public void ungrant(KeyDescriptor var1, int var2) throws RemoteException;

    public int getNumberOfEntries(int var1, long var2) throws RemoteException;

    public KeyDescriptor[] listEntriesBatched(int var1, long var2, String var4) throws RemoteException;

    public int getInterfaceVersion() throws RemoteException;

    public String getInterfaceHash() throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements IKeystoreService {
        static final int TRANSACTION_getSecurityLevel = 1;
        static final int TRANSACTION_getKeyEntry = 2;
        static final int TRANSACTION_updateSubcomponent = 3;
        static final int TRANSACTION_listEntries = 4;
        static final int TRANSACTION_deleteKey = 5;
        static final int TRANSACTION_grant = 6;
        static final int TRANSACTION_ungrant = 7;
        static final int TRANSACTION_getNumberOfEntries = 8;
        static final int TRANSACTION_listEntriesBatched = 9;
        static final int TRANSACTION_getInterfaceVersion = 0xFFFFFF;
        static final int TRANSACTION_getInterfaceHash = 0xFFFFFE;

        public Stub() {
            this.markVintfStability();
            this.attachInterface(this, DESCRIPTOR);
        }

        public static IKeystoreService asInterface(IBinder obj) {
            if (obj == null) {
                return null;
            }
            IInterface iin = obj.queryLocalInterface(DESCRIPTOR);
            if (iin != null && iin instanceof IKeystoreService) {
                return (IKeystoreService)iin;
            }
            return new Proxy(obj);
        }

        @Override
        public IBinder asBinder() {
            return this;
        }

        public static String getDefaultTransactionName(int transactionCode) {
            switch (transactionCode) {
                case 1: {
                    return "getSecurityLevel";
                }
                case 2: {
                    return "getKeyEntry";
                }
                case 3: {
                    return "updateSubcomponent";
                }
                case 4: {
                    return "listEntries";
                }
                case 5: {
                    return "deleteKey";
                }
                case 6: {
                    return "grant";
                }
                case 7: {
                    return "ungrant";
                }
                case 8: {
                    return "getNumberOfEntries";
                }
                case 9: {
                    return "listEntriesBatched";
                }
                case 0xFFFFFF: {
                    return "getInterfaceVersion";
                }
                case 0xFFFFFE: {
                    return "getInterfaceHash";
                }
            }
            return null;
        }

        @Override
        public String getTransactionName(int transactionCode) {
            return Stub.getDefaultTransactionName(transactionCode);
        }

        @Override
        public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
            String descriptor = DESCRIPTOR;
            if (code >= 1 && code <= 0xFFFFFF) {
                data.enforceInterface(descriptor);
            }
            switch (code) {
                case 1598968902: {
                    reply.writeString(descriptor);
                    return true;
                }
                case 0xFFFFFF: {
                    reply.writeNoException();
                    reply.writeInt(this.getInterfaceVersion());
                    return true;
                }
                case 0xFFFFFE: {
                    reply.writeNoException();
                    reply.writeString(this.getInterfaceHash());
                    return true;
                }
            }
            switch (code) {
                case 1: {
                    int _arg0 = data.readInt();
                    data.enforceNoDataAvail();
                    IKeystoreSecurityLevel _result = this.getSecurityLevel(_arg0);
                    reply.writeNoException();
                    reply.writeStrongInterface(_result);
                    break;
                }
                case 2: {
                    KeyDescriptor _arg0 = data.readTypedObject(KeyDescriptor.CREATOR);
                    data.enforceNoDataAvail();
                    KeyEntryResponse _result = this.getKeyEntry(_arg0);
                    reply.writeNoException();
                    reply.writeTypedObject(_result, 1);
                    break;
                }
                case 3: {
                    KeyDescriptor _arg0 = data.readTypedObject(KeyDescriptor.CREATOR);
                    byte[] _arg1 = data.createByteArray();
                    byte[] _arg2 = data.createByteArray();
                    data.enforceNoDataAvail();
                    this.updateSubcomponent(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    break;
                }
                case 4: {
                    int _arg0 = data.readInt();
                    long _arg1 = data.readLong();
                    data.enforceNoDataAvail();
                    Parcelable[] _result = this.listEntries(_arg0, _arg1);
                    reply.writeNoException();
                    reply.writeTypedArray(_result, 1);
                    break;
                }
                case 5: {
                    KeyDescriptor _arg0 = data.readTypedObject(KeyDescriptor.CREATOR);
                    data.enforceNoDataAvail();
                    this.deleteKey(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 6: {
                    KeyDescriptor _arg0 = data.readTypedObject(KeyDescriptor.CREATOR);
                    int _arg1 = data.readInt();
                    int _arg2 = data.readInt();
                    data.enforceNoDataAvail();
                    KeyDescriptor _result = this.grant(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    reply.writeTypedObject(_result, 1);
                    break;
                }
                case 7: {
                    KeyDescriptor _arg0 = data.readTypedObject(KeyDescriptor.CREATOR);
                    int _arg1 = data.readInt();
                    data.enforceNoDataAvail();
                    this.ungrant(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                case 8: {
                    int _arg0 = data.readInt();
                    long _arg1 = data.readLong();
                    data.enforceNoDataAvail();
                    int _result = this.getNumberOfEntries(_arg0, _arg1);
                    reply.writeNoException();
                    reply.writeInt(_result);
                    break;
                }
                case 9: {
                    int _arg0 = data.readInt();
                    long _arg1 = data.readLong();
                    String _arg2 = data.readString();
                    data.enforceNoDataAvail();
                    Parcelable[] _result = this.listEntriesBatched(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    reply.writeTypedArray(_result, 1);
                    break;
                }
                default: {
                    return super.onTransact(code, data, reply, flags);
                }
            }
            return true;
        }

        @Override
        public int getMaxTransactionId() {
            return 0xFFFFFE;
        }

        private static class Proxy
        implements IKeystoreService {
            private IBinder mRemote;
            private int mCachedVersion = -1;
            private String mCachedHash = "-1";

            Proxy(IBinder remote) {
                this.mRemote = remote;
            }

            @Override
            public IBinder asBinder() {
                return this.mRemote;
            }

            public String getInterfaceDescriptor() {
                return DESCRIPTOR;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public IKeystoreSecurityLevel getSecurityLevel(int securityLevel) throws RemoteException {
                IKeystoreSecurityLevel _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(DESCRIPTOR);
                    _data.writeInt(securityLevel);
                    boolean _status = this.mRemote.transact(1, _data, _reply, 0);
                    if (!_status) {
                        throw new RemoteException("Method getSecurityLevel is unimplemented.");
                    }
                    _reply.readException();
                    _result = IKeystoreSecurityLevel.Stub.asInterface(_reply.readStrongBinder());
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public KeyEntryResponse getKeyEntry(KeyDescriptor key) throws RemoteException {
                KeyEntryResponse _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(DESCRIPTOR);
                    _data.writeTypedObject(key, 0);
                    boolean _status = this.mRemote.transact(2, _data, _reply, 0);
                    if (!_status) {
                        throw new RemoteException("Method getKeyEntry is unimplemented.");
                    }
                    _reply.readException();
                    _result = _reply.readTypedObject(KeyEntryResponse.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void updateSubcomponent(KeyDescriptor key, byte[] publicCert, byte[] certificateChain) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(DESCRIPTOR);
                    _data.writeTypedObject(key, 0);
                    _data.writeByteArray(publicCert);
                    _data.writeByteArray(certificateChain);
                    boolean _status = this.mRemote.transact(3, _data, _reply, 0);
                    if (!_status) {
                        throw new RemoteException("Method updateSubcomponent is unimplemented.");
                    }
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public KeyDescriptor[] listEntries(int domain, long nspace) throws RemoteException {
                KeyDescriptor[] _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(DESCRIPTOR);
                    _data.writeInt(domain);
                    _data.writeLong(nspace);
                    boolean _status = this.mRemote.transact(4, _data, _reply, 0);
                    if (!_status) {
                        throw new RemoteException("Method listEntries is unimplemented.");
                    }
                    _reply.readException();
                    _result = _reply.createTypedArray(KeyDescriptor.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void deleteKey(KeyDescriptor key) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(DESCRIPTOR);
                    _data.writeTypedObject(key, 0);
                    boolean _status = this.mRemote.transact(5, _data, _reply, 0);
                    if (!_status) {
                        throw new RemoteException("Method deleteKey is unimplemented.");
                    }
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public KeyDescriptor grant(KeyDescriptor key, int granteeUid, int accessVector) throws RemoteException {
                KeyDescriptor _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(DESCRIPTOR);
                    _data.writeTypedObject(key, 0);
                    _data.writeInt(granteeUid);
                    _data.writeInt(accessVector);
                    boolean _status = this.mRemote.transact(6, _data, _reply, 0);
                    if (!_status) {
                        throw new RemoteException("Method grant is unimplemented.");
                    }
                    _reply.readException();
                    _result = _reply.readTypedObject(KeyDescriptor.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void ungrant(KeyDescriptor key, int granteeUid) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(DESCRIPTOR);
                    _data.writeTypedObject(key, 0);
                    _data.writeInt(granteeUid);
                    boolean _status = this.mRemote.transact(7, _data, _reply, 0);
                    if (!_status) {
                        throw new RemoteException("Method ungrant is unimplemented.");
                    }
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int getNumberOfEntries(int domain, long nspace) throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(DESCRIPTOR);
                    _data.writeInt(domain);
                    _data.writeLong(nspace);
                    boolean _status = this.mRemote.transact(8, _data, _reply, 0);
                    if (!_status) {
                        throw new RemoteException("Method getNumberOfEntries is unimplemented.");
                    }
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public KeyDescriptor[] listEntriesBatched(int domain, long nspace, String startingPastAlias) throws RemoteException {
                KeyDescriptor[] _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(DESCRIPTOR);
                    _data.writeInt(domain);
                    _data.writeLong(nspace);
                    _data.writeString(startingPastAlias);
                    boolean _status = this.mRemote.transact(9, _data, _reply, 0);
                    if (!_status) {
                        throw new RemoteException("Method listEntriesBatched is unimplemented.");
                    }
                    _reply.readException();
                    _result = _reply.createTypedArray(KeyDescriptor.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int getInterfaceVersion() throws RemoteException {
                if (this.mCachedVersion == -1) {
                    Parcel data = Parcel.obtain(this.asBinder());
                    Parcel reply = Parcel.obtain();
                    try {
                        data.writeInterfaceToken(DESCRIPTOR);
                        boolean _status = this.mRemote.transact(0xFFFFFF, data, reply, 0);
                        reply.readException();
                        this.mCachedVersion = reply.readInt();
                    }
                    finally {
                        reply.recycle();
                        data.recycle();
                    }
                }
                return this.mCachedVersion;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public synchronized String getInterfaceHash() throws RemoteException {
                if ("-1".equals(this.mCachedHash)) {
                    Parcel data = Parcel.obtain(this.asBinder());
                    Parcel reply = Parcel.obtain();
                    try {
                        data.writeInterfaceToken(DESCRIPTOR);
                        boolean _status = this.mRemote.transact(0xFFFFFE, data, reply, 0);
                        reply.readException();
                        this.mCachedHash = reply.readString();
                    }
                    finally {
                        reply.recycle();
                        data.recycle();
                    }
                }
                return this.mCachedHash;
            }
        }
    }

    public static class Default
    implements IKeystoreService {
        @Override
        public IKeystoreSecurityLevel getSecurityLevel(int securityLevel) throws RemoteException {
            return null;
        }

        @Override
        public KeyEntryResponse getKeyEntry(KeyDescriptor key) throws RemoteException {
            return null;
        }

        @Override
        public void updateSubcomponent(KeyDescriptor key, byte[] publicCert, byte[] certificateChain) throws RemoteException {
        }

        @Override
        public KeyDescriptor[] listEntries(int domain, long nspace) throws RemoteException {
            return null;
        }

        @Override
        public void deleteKey(KeyDescriptor key) throws RemoteException {
        }

        @Override
        public KeyDescriptor grant(KeyDescriptor key, int granteeUid, int accessVector) throws RemoteException {
            return null;
        }

        @Override
        public void ungrant(KeyDescriptor key, int granteeUid) throws RemoteException {
        }

        @Override
        public int getNumberOfEntries(int domain, long nspace) throws RemoteException {
            return 0;
        }

        @Override
        public KeyDescriptor[] listEntriesBatched(int domain, long nspace, String startingPastAlias) throws RemoteException {
            return null;
        }

        @Override
        public int getInterfaceVersion() {
            return 0;
        }

        @Override
        public String getInterfaceHash() {
            return "";
        }

        @Override
        public IBinder asBinder() {
            return null;
        }
    }
}

