/*
 * Decompiled with CFR 0.152.
 */
package android.system.virtualizationservice;

import android.os.Binder;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.RemoteException;

public interface IVirtualMachineCallback
extends IInterface {
    public static final String DESCRIPTOR = "android$system$virtualizationservice$IVirtualMachineCallback".replace('$', '.');

    public void onPayloadStarted(int var1) throws RemoteException;

    public void onPayloadReady(int var1) throws RemoteException;

    public void onPayloadFinished(int var1, int var2) throws RemoteException;

    public void onError(int var1, int var2, String var3) throws RemoteException;

    public void onDied(int var1, int var2) throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements IVirtualMachineCallback {
        static final int TRANSACTION_onPayloadStarted = 1;
        static final int TRANSACTION_onPayloadReady = 2;
        static final int TRANSACTION_onPayloadFinished = 3;
        static final int TRANSACTION_onError = 4;
        static final int TRANSACTION_onDied = 5;

        public Stub() {
            this.attachInterface(this, DESCRIPTOR);
        }

        public static IVirtualMachineCallback asInterface(IBinder obj) {
            if (obj == null) {
                return null;
            }
            IInterface iin = obj.queryLocalInterface(DESCRIPTOR);
            if (iin != null && iin instanceof IVirtualMachineCallback) {
                return (IVirtualMachineCallback)iin;
            }
            return new Proxy(obj);
        }

        @Override
        public IBinder asBinder() {
            return this;
        }

        @Override
        public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
            String descriptor = DESCRIPTOR;
            if (code >= 1 && code <= 0xFFFFFF) {
                data.enforceInterface(descriptor);
            }
            switch (code) {
                case 1598968902: {
                    reply.writeString(descriptor);
                    return true;
                }
            }
            switch (code) {
                case 1: {
                    int _arg0 = data.readInt();
                    data.enforceNoDataAvail();
                    this.onPayloadStarted(_arg0);
                    break;
                }
                case 2: {
                    int _arg0 = data.readInt();
                    data.enforceNoDataAvail();
                    this.onPayloadReady(_arg0);
                    break;
                }
                case 3: {
                    int _arg0 = data.readInt();
                    int _arg1 = data.readInt();
                    data.enforceNoDataAvail();
                    this.onPayloadFinished(_arg0, _arg1);
                    break;
                }
                case 4: {
                    int _arg0 = data.readInt();
                    int _arg1 = data.readInt();
                    String _arg2 = data.readString();
                    data.enforceNoDataAvail();
                    this.onError(_arg0, _arg1, _arg2);
                    break;
                }
                case 5: {
                    int _arg0 = data.readInt();
                    int _arg1 = data.readInt();
                    data.enforceNoDataAvail();
                    this.onDied(_arg0, _arg1);
                    break;
                }
                default: {
                    return super.onTransact(code, data, reply, flags);
                }
            }
            return true;
        }

        private static class Proxy
        implements IVirtualMachineCallback {
            private IBinder mRemote;

            Proxy(IBinder remote) {
                this.mRemote = remote;
            }

            @Override
            public IBinder asBinder() {
                return this.mRemote;
            }

            public String getInterfaceDescriptor() {
                return DESCRIPTOR;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onPayloadStarted(int cid) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(DESCRIPTOR);
                    _data.writeInt(cid);
                    boolean bl = this.mRemote.transact(1, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onPayloadReady(int cid) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(DESCRIPTOR);
                    _data.writeInt(cid);
                    boolean bl = this.mRemote.transact(2, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onPayloadFinished(int cid, int exitCode) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(DESCRIPTOR);
                    _data.writeInt(cid);
                    _data.writeInt(exitCode);
                    boolean bl = this.mRemote.transact(3, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onError(int cid, int errorCode, String message) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(DESCRIPTOR);
                    _data.writeInt(cid);
                    _data.writeInt(errorCode);
                    _data.writeString(message);
                    boolean bl = this.mRemote.transact(4, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onDied(int cid, int reason) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(DESCRIPTOR);
                    _data.writeInt(cid);
                    _data.writeInt(reason);
                    boolean bl = this.mRemote.transact(5, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }
        }
    }

    public static class Default
    implements IVirtualMachineCallback {
        @Override
        public void onPayloadStarted(int cid) throws RemoteException {
        }

        @Override
        public void onPayloadReady(int cid) throws RemoteException {
        }

        @Override
        public void onPayloadFinished(int cid, int exitCode) throws RemoteException {
        }

        @Override
        public void onError(int cid, int errorCode, String message) throws RemoteException {
        }

        @Override
        public void onDied(int cid, int reason) throws RemoteException {
        }

        @Override
        public IBinder asBinder() {
            return null;
        }
    }
}

