/*
 * Decompiled with CFR 0.152.
 */
package android.system.virtualizationservice;

import android.os.Binder;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.ParcelFileDescriptor;
import android.os.Parcelable;
import android.os.RemoteException;
import android.system.virtualizationservice.IVirtualMachine;
import android.system.virtualizationservice.VirtualMachineConfig;
import android.system.virtualizationservice.VirtualMachineDebugInfo;

public interface IVirtualizationService
extends IInterface {
    public static final String DESCRIPTOR = "android$system$virtualizationservice$IVirtualizationService".replace('$', '.');

    public IVirtualMachine createVm(VirtualMachineConfig var1, ParcelFileDescriptor var2, ParcelFileDescriptor var3) throws RemoteException;

    public void initializeWritablePartition(ParcelFileDescriptor var1, long var2, int var4) throws RemoteException;

    public void createOrUpdateIdsigFile(ParcelFileDescriptor var1, ParcelFileDescriptor var2) throws RemoteException;

    public VirtualMachineDebugInfo[] debugListVms() throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements IVirtualizationService {
        static final int TRANSACTION_createVm = 1;
        static final int TRANSACTION_initializeWritablePartition = 2;
        static final int TRANSACTION_createOrUpdateIdsigFile = 3;
        static final int TRANSACTION_debugListVms = 4;

        public Stub() {
            this.attachInterface(this, DESCRIPTOR);
        }

        public static IVirtualizationService asInterface(IBinder obj) {
            if (obj == null) {
                return null;
            }
            IInterface iin = obj.queryLocalInterface(DESCRIPTOR);
            if (iin != null && iin instanceof IVirtualizationService) {
                return (IVirtualizationService)iin;
            }
            return new Proxy(obj);
        }

        @Override
        public IBinder asBinder() {
            return this;
        }

        @Override
        public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
            String descriptor = DESCRIPTOR;
            if (code >= 1 && code <= 0xFFFFFF) {
                data.enforceInterface(descriptor);
            }
            switch (code) {
                case 1598968902: {
                    reply.writeString(descriptor);
                    return true;
                }
            }
            switch (code) {
                case 1: {
                    VirtualMachineConfig _arg0 = data.readTypedObject(VirtualMachineConfig.CREATOR);
                    ParcelFileDescriptor _arg1 = data.readTypedObject(ParcelFileDescriptor.CREATOR);
                    ParcelFileDescriptor _arg2 = data.readTypedObject(ParcelFileDescriptor.CREATOR);
                    data.enforceNoDataAvail();
                    IVirtualMachine _result = this.createVm(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    reply.writeStrongInterface(_result);
                    break;
                }
                case 2: {
                    ParcelFileDescriptor _arg0 = data.readTypedObject(ParcelFileDescriptor.CREATOR);
                    long _arg1 = data.readLong();
                    int _arg2 = data.readInt();
                    data.enforceNoDataAvail();
                    this.initializeWritablePartition(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    break;
                }
                case 3: {
                    ParcelFileDescriptor _arg0 = data.readTypedObject(ParcelFileDescriptor.CREATOR);
                    ParcelFileDescriptor _arg1 = data.readTypedObject(ParcelFileDescriptor.CREATOR);
                    data.enforceNoDataAvail();
                    this.createOrUpdateIdsigFile(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                case 4: {
                    Parcelable[] _result = this.debugListVms();
                    reply.writeNoException();
                    reply.writeTypedArray(_result, 1);
                    break;
                }
                default: {
                    return super.onTransact(code, data, reply, flags);
                }
            }
            return true;
        }

        private static class Proxy
        implements IVirtualizationService {
            private IBinder mRemote;

            Proxy(IBinder remote) {
                this.mRemote = remote;
            }

            @Override
            public IBinder asBinder() {
                return this.mRemote;
            }

            public String getInterfaceDescriptor() {
                return DESCRIPTOR;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public IVirtualMachine createVm(VirtualMachineConfig config, ParcelFileDescriptor consoleFd, ParcelFileDescriptor osLogFd) throws RemoteException {
                IVirtualMachine _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(DESCRIPTOR);
                    _data.writeTypedObject(config, 0);
                    _data.writeTypedObject(consoleFd, 0);
                    _data.writeTypedObject(osLogFd, 0);
                    boolean _status = this.mRemote.transact(1, _data, _reply, 0);
                    _reply.readException();
                    _result = IVirtualMachine.Stub.asInterface(_reply.readStrongBinder());
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void initializeWritablePartition(ParcelFileDescriptor imageFd, long sizeBytes, int type) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(DESCRIPTOR);
                    _data.writeTypedObject(imageFd, 0);
                    _data.writeLong(sizeBytes);
                    _data.writeInt(type);
                    boolean _status = this.mRemote.transact(2, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void createOrUpdateIdsigFile(ParcelFileDescriptor inputFd, ParcelFileDescriptor idsigFd) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(DESCRIPTOR);
                    _data.writeTypedObject(inputFd, 0);
                    _data.writeTypedObject(idsigFd, 0);
                    boolean _status = this.mRemote.transact(3, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public VirtualMachineDebugInfo[] debugListVms() throws RemoteException {
                VirtualMachineDebugInfo[] _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(DESCRIPTOR);
                    boolean _status = this.mRemote.transact(4, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.createTypedArray(VirtualMachineDebugInfo.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }
        }
    }

    public static class Default
    implements IVirtualizationService {
        @Override
        public IVirtualMachine createVm(VirtualMachineConfig config, ParcelFileDescriptor consoleFd, ParcelFileDescriptor osLogFd) throws RemoteException {
            return null;
        }

        @Override
        public void initializeWritablePartition(ParcelFileDescriptor imageFd, long sizeBytes, int type) throws RemoteException {
        }

        @Override
        public void createOrUpdateIdsigFile(ParcelFileDescriptor inputFd, ParcelFileDescriptor idsigFd) throws RemoteException {
        }

        @Override
        public VirtualMachineDebugInfo[] debugListVms() throws RemoteException {
            return null;
        }

        @Override
        public IBinder asBinder() {
            return null;
        }
    }
}

