/*
 * Decompiled with CFR 0.152.
 */
package android.system.virtualmachine;

import android.annotation.RequiresPermission;
import android.annotation.SuppressLint;
import android.annotation.SystemApi;
import android.content.ComponentCallbacks2;
import android.content.Context;
import android.content.res.Configuration;
import android.os.Binder;
import android.os.IBinder;
import android.os.ParcelFileDescriptor;
import android.os.RemoteException;
import android.os.ServiceSpecificException;
import android.system.virtualizationservice.IVirtualMachine;
import android.system.virtualizationservice.IVirtualMachineCallback;
import android.system.virtualizationservice.IVirtualizationService;
import android.system.virtualizationservice.VirtualMachineAppConfig;
import android.system.virtualizationservice.VirtualMachineState;
import android.system.virtualmachine.VirtualMachineCallback;
import android.system.virtualmachine.VirtualMachineConfig;
import android.system.virtualmachine.VirtualMachineDescriptor;
import android.system.virtualmachine.VirtualMachineException;
import android.system.virtualmachine.VirtualizationService;
import android.util.JsonReader;
import android.util.Log;
import com.android.internal.annotations.GuardedBy;
import com.android.internal.lang.System_Delegate;
import com.android.tools.layoutlib.create.OverrideMethod;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.nio.channels.FileChannel;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import java.util.zip.ZipFile;

@SystemApi
public class VirtualMachine
implements AutoCloseable {
    public static final String MANAGE_VIRTUAL_MACHINE_PERMISSION = "android.permission.MANAGE_VIRTUAL_MACHINE";
    public static final String USE_CUSTOM_VIRTUAL_MACHINE_PERMISSION = "android.permission.USE_CUSTOM_VIRTUAL_MACHINE";
    @SuppressLint(value={"MinMaxConstant"})
    public static final long MIN_VSOCK_PORT = 1024L;
    @SuppressLint(value={"MinMaxConstant"})
    public static final long MAX_VSOCK_PORT = 0xFFFFFFFFL;
    public static final int STATUS_STOPPED = 0;
    public static final int STATUS_RUNNING = 1;
    public static final int STATUS_DELETED = 2;
    private static final String TAG = "VirtualMachine";
    private static final String VM_DIR = "vm";
    private static final String CONFIG_FILE = "config.xml";
    private static final String INSTANCE_IMAGE_FILE = "instance.img";
    private static final String IDSIG_FILE = "idsig";
    private static final String EXTRA_IDSIG_FILE_PREFIX = "extra_idsig_";
    private static final long INSTANCE_FILE_SIZE = 0xA00000L;
    private static final String ENCRYPTED_STORE_FILE = "storage.img";
    private final String mPackageName;
    private final String mName;
    private final File mVmRootPath;
    private final File mConfigFilePath;
    private final File mInstanceFilePath;
    private final File mIdsigFilePath;
    private final File mEncryptedStoreFilePath;
    private final List<ExtraApkSpec> mExtraApks;
    private final VirtualizationService mVirtualizationService;
    private final MemoryManagementCallbacks mMemoryManagementCallbacks;
    private final Context mContext;
    private final Object mLock = new Object();
    private final Object mCallbackLock = new Object();
    private final boolean mVmOutputCaptured;
    @GuardedBy(value={"mLock"})
    private VirtualMachineConfig mConfig;
    @GuardedBy(value={"mLock"})
    private IVirtualMachine mVirtualMachine;
    @GuardedBy(value={"mLock"})
    private ParcelFileDescriptor mConsoleReader;
    @GuardedBy(value={"mLock"})
    private ParcelFileDescriptor mConsoleWriter;
    @GuardedBy(value={"mLock"})
    private ParcelFileDescriptor mLogReader;
    @GuardedBy(value={"mLock"})
    private ParcelFileDescriptor mLogWriter;
    @GuardedBy(value={"mLock"})
    private boolean mWasDeleted = false;
    @GuardedBy(value={"mCallbackLock"})
    private VirtualMachineCallback mCallback;
    @GuardedBy(value={"mCallbackLock"})
    private Executor mCallbackExecutor;

    private VirtualMachine(Context context, String name, VirtualMachineConfig config, VirtualizationService service) throws VirtualMachineException {
        File thisVmDir;
        this.mPackageName = context.getPackageName();
        this.mName = Objects.requireNonNull(name, "Name must not be null");
        this.mConfig = Objects.requireNonNull(config, "Config must not be null");
        this.mVirtualizationService = service;
        this.mVmRootPath = thisVmDir = VirtualMachine.getVmDir(context, this.mName);
        this.mConfigFilePath = new File(thisVmDir, CONFIG_FILE);
        this.mInstanceFilePath = new File(thisVmDir, INSTANCE_IMAGE_FILE);
        this.mIdsigFilePath = new File(thisVmDir, IDSIG_FILE);
        this.mExtraApks = VirtualMachine.setupExtraApks(context, config, thisVmDir);
        this.mMemoryManagementCallbacks = new MemoryManagementCallbacks();
        this.mContext = context;
        this.mEncryptedStoreFilePath = config.isEncryptedStorageEnabled() ? new File(thisVmDir, ENCRYPTED_STORE_FILE) : null;
        this.mVmOutputCaptured = config.isVmOutputCaptured();
    }

    @GuardedBy(value={"VirtualMachineManager.sCreateLock"})
    static VirtualMachine fromDescriptor(Context context, String name, VirtualMachineDescriptor vmDescriptor) throws VirtualMachineException {
        File vmDir = VirtualMachine.createVmDir(context, name);
        try {
            VirtualMachine vm;
            block14: {
                try (VirtualMachineDescriptor virtualMachineDescriptor = vmDescriptor;){
                    VirtualMachineConfig config = VirtualMachineConfig.from(vmDescriptor.getConfigFd());
                    vm = new VirtualMachine(context, name, config, VirtualizationService.getInstance());
                    config.serialize(vm.mConfigFilePath);
                    try {
                        vm.mInstanceFilePath.createNewFile();
                    }
                    catch (IOException e) {
                        throw new VirtualMachineException("failed to create instance image", e);
                    }
                    vm.importInstanceFrom(vmDescriptor.getInstanceImgFd());
                    if (vmDescriptor.getEncryptedStoreFd() == null) break block14;
                    try {
                        vm.mEncryptedStoreFilePath.createNewFile();
                    }
                    catch (IOException e) {
                        throw new VirtualMachineException("failed to create encrypted storage image", e);
                    }
                    vm.importEncryptedStoreFrom(vmDescriptor.getEncryptedStoreFd());
                }
            }
            return vm;
        }
        catch (VirtualMachineException | RuntimeException e) {
            try {
                VirtualMachine.deleteRecursively(vmDir);
            }
            catch (IOException innerException) {
                e.addSuppressed(innerException);
            }
            throw e;
        }
    }

    @GuardedBy(value={"VirtualMachineManager.sCreateLock"})
    static VirtualMachine create(Context context, String name, VirtualMachineConfig config) throws VirtualMachineException {
        File vmDir = VirtualMachine.createVmDir(context, name);
        try {
            VirtualMachine vm = new VirtualMachine(context, name, config, VirtualizationService.getInstance());
            config.serialize(vm.mConfigFilePath);
            try {
                vm.mInstanceFilePath.createNewFile();
            }
            catch (IOException e) {
                throw new VirtualMachineException("failed to create instance image", e);
            }
            if (config.isEncryptedStorageEnabled()) {
                try {
                    vm.mEncryptedStoreFilePath.createNewFile();
                }
                catch (IOException e) {
                    throw new VirtualMachineException("failed to create encrypted storage image", e);
                }
            }
            IVirtualizationService service = vm.mVirtualizationService.getBinder();
            try {
                service.initializeWritablePartition(ParcelFileDescriptor.open(vm.mInstanceFilePath, 0x30000000), 0xA00000L, 1);
            }
            catch (FileNotFoundException e) {
                throw new VirtualMachineException("instance image missing", e);
            }
            catch (RemoteException e) {
                throw e.rethrowAsRuntimeException();
            }
            catch (ServiceSpecificException | IllegalArgumentException e) {
                throw new VirtualMachineException("failed to create instance partition", e);
            }
            if (config.isEncryptedStorageEnabled()) {
                try {
                    service.initializeWritablePartition(ParcelFileDescriptor.open(vm.mEncryptedStoreFilePath, 0x30000000), config.getEncryptedStorageBytes(), 2);
                }
                catch (FileNotFoundException e) {
                    throw new VirtualMachineException("encrypted storage image missing", e);
                }
                catch (RemoteException e) {
                    throw e.rethrowAsRuntimeException();
                }
                catch (ServiceSpecificException | IllegalArgumentException e) {
                    throw new VirtualMachineException("failed to create encrypted storage partition", e);
                }
            }
            return vm;
        }
        catch (VirtualMachineException | RuntimeException e) {
            try {
                VirtualMachine.deleteRecursively(vmDir);
            }
            catch (IOException innerException) {
                e.addSuppressed(innerException);
            }
            throw e;
        }
    }

    @GuardedBy(value={"VirtualMachineManager.sCreateLock"})
    static VirtualMachine load(Context context, String name) throws VirtualMachineException {
        File thisVmDir = VirtualMachine.getVmDir(context, name);
        if (!thisVmDir.exists()) {
            return null;
        }
        File configFilePath = new File(thisVmDir, CONFIG_FILE);
        VirtualMachineConfig config = VirtualMachineConfig.from(configFilePath);
        VirtualMachine vm = new VirtualMachine(context, name, config, VirtualizationService.getInstance());
        if (!vm.mInstanceFilePath.exists()) {
            throw new VirtualMachineException("instance image missing");
        }
        if (config.isEncryptedStorageEnabled() && !vm.mEncryptedStoreFilePath.exists()) {
            throw new VirtualMachineException("Storage image missing");
        }
        return vm;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @GuardedBy(value={"VirtualMachineManager.sCreateLock"})
    void delete(Context context, String name) throws VirtualMachineException {
        Object object = this.mLock;
        synchronized (object) {
            this.checkStopped();
            this.mWasDeleted = true;
        }
        VirtualMachine.deleteVmDirectory(context, name);
    }

    static void deleteVmDirectory(Context context, String name) throws VirtualMachineException {
        try {
            VirtualMachine.deleteRecursively(VirtualMachine.getVmDir(context, name));
        }
        catch (IOException e) {
            throw new VirtualMachineException(e);
        }
    }

    @GuardedBy(value={"VirtualMachineManager.sCreateLock"})
    private static File createVmDir(Context context, String name) throws VirtualMachineException {
        File vmDir = VirtualMachine.getVmDir(context, name);
        try {
            Files.createDirectories(vmDir.getParentFile().toPath(), new FileAttribute[0]);
            Files.createDirectory(vmDir.toPath(), new FileAttribute[0]);
        }
        catch (FileAlreadyExistsException e) {
            throw new VirtualMachineException("virtual machine already exists", e);
        }
        catch (IOException e) {
            throw new VirtualMachineException("failed to create directory for VM", e);
        }
        return vmDir;
    }

    private static File getVmDir(Context context, String name) {
        if (name.contains(File.separator) || name.equals(".") || name.equals("..")) {
            throw new IllegalArgumentException("Invalid VM name: " + name);
        }
        File vmRoot = new File(context.getDataDir(), VM_DIR);
        return new File(vmRoot, name);
    }

    @SystemApi
    public String getName() {
        return this.mName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SystemApi
    public VirtualMachineConfig getConfig() {
        Object object = this.mLock;
        synchronized (object) {
            return this.mConfig;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SystemApi
    public int getStatus() {
        int status;
        IVirtualMachine virtualMachine;
        Object object = this.mLock;
        synchronized (object) {
            if (this.mWasDeleted) {
                return 2;
            }
            virtualMachine = this.mVirtualMachine;
        }
        if (virtualMachine == null) {
            status = 0;
        } else {
            try {
                status = this.stateToStatus(virtualMachine.getState());
            }
            catch (RemoteException e) {
                throw e.rethrowAsRuntimeException();
            }
        }
        if (status == 0 && !this.mVmRootPath.exists()) {
            Object object2 = this.mLock;
            synchronized (object2) {
                this.dropVm();
            }
            return 2;
        }
        return status;
    }

    private int stateToStatus(@VirtualMachineState int state) {
        switch (state) {
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                return 1;
            }
        }
        return 0;
    }

    @GuardedBy(value={"mLock"})
    private void checkStopped() throws VirtualMachineException {
        if (this.mWasDeleted || !this.mVmRootPath.exists()) {
            throw new VirtualMachineException("VM has been deleted");
        }
        if (this.mVirtualMachine == null) {
            return;
        }
        try {
            if (this.stateToStatus(this.mVirtualMachine.getState()) != 0) {
                throw new VirtualMachineException("VM is not in stopped state");
            }
        }
        catch (RemoteException e) {
            throw e.rethrowAsRuntimeException();
        }
        this.dropVm();
    }

    @GuardedBy(value={"mLock"})
    private void dropVm() {
        this.mContext.unregisterComponentCallbacks(this.mMemoryManagementCallbacks);
        this.mVirtualMachine = null;
    }

    @GuardedBy(value={"mLock"})
    private IVirtualMachine getRunningVm() throws VirtualMachineException {
        try {
            if (this.mVirtualMachine != null && this.stateToStatus(this.mVirtualMachine.getState()) == 1) {
                return this.mVirtualMachine;
            }
            if (this.mWasDeleted || !this.mVmRootPath.exists()) {
                throw new VirtualMachineException("VM has been deleted");
            }
            throw new VirtualMachineException("VM is not in running state");
        }
        catch (RemoteException e) {
            throw e.rethrowAsRuntimeException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SystemApi
    public void setCallback(Executor executor, VirtualMachineCallback callback) {
        Object object = this.mCallbackLock;
        synchronized (object) {
            this.mCallback = callback;
            this.mCallbackExecutor = executor;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SystemApi
    public void clearCallback() {
        Object object = this.mCallbackLock;
        synchronized (object) {
            this.mCallback = null;
            this.mCallbackExecutor = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void executeCallback(Consumer<VirtualMachineCallback> fn) {
        Executor executor;
        VirtualMachineCallback callback;
        Object object = this.mCallbackLock;
        synchronized (object) {
            callback = this.mCallback;
            executor = this.mCallbackExecutor;
        }
        if (callback == null || executor == null) {
            return;
        }
        long restoreToken = Binder.clearCallingIdentity();
        try {
            executor.execute(() -> fn.accept(callback));
        }
        finally {
            Binder.restoreCallingIdentity(restoreToken);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SystemApi
    @RequiresPermission(value="android.permission.MANAGE_VIRTUAL_MACHINE")
    public void run() throws VirtualMachineException {
        Object object = this.mLock;
        synchronized (object) {
            this.checkStopped();
            try {
                this.mIdsigFilePath.createNewFile();
                for (ExtraApkSpec extraApk : this.mExtraApks) {
                    extraApk.idsig.createNewFile();
                }
            }
            catch (IOException e) {
                throw new VirtualMachineException("Failed to create APK signature file", e);
            }
            IVirtualizationService service = this.mVirtualizationService.getBinder();
            try {
                if (this.mVmOutputCaptured) {
                    this.createVmPipes();
                }
                VirtualMachineAppConfig appConfig = this.getConfig().toVsConfig(this.mContext.getPackageManager());
                appConfig.name = this.mName;
                try {
                    this.createIdSigs(service, appConfig);
                }
                catch (FileNotFoundException e) {
                    throw new VirtualMachineException("Failed to generate APK signature", e);
                }
                android.system.virtualizationservice.VirtualMachineConfig vmConfigParcel = android.system.virtualizationservice.VirtualMachineConfig.appConfig(appConfig);
                this.mVirtualMachine = service.createVm(vmConfigParcel, this.mConsoleWriter, this.mLogWriter);
                this.mVirtualMachine.registerCallback(new CallbackTranslator(service));
                this.mContext.registerComponentCallbacks(this.mMemoryManagementCallbacks);
                this.mVirtualMachine.start();
            }
            catch (ServiceSpecificException | IllegalStateException e) {
                throw new VirtualMachineException(e);
            }
            catch (RemoteException e) {
                throw e.rethrowAsRuntimeException();
            }
        }
    }

    private void createIdSigs(IVirtualizationService service, VirtualMachineAppConfig appConfig) throws RemoteException, FileNotFoundException {
        service.createOrUpdateIdsigFile(appConfig.apk, ParcelFileDescriptor.open(this.mIdsigFilePath, 0x30000000));
        for (ExtraApkSpec extraApk : this.mExtraApks) {
            service.createOrUpdateIdsigFile(ParcelFileDescriptor.open(extraApk.apk, 0x10000000), ParcelFileDescriptor.open(extraApk.idsig, 0x30000000));
        }
        appConfig.idsig = ParcelFileDescriptor.open(this.mIdsigFilePath, 0x10000000);
        appConfig.instanceImage = ParcelFileDescriptor.open(this.mInstanceFilePath, 0x30000000);
        if (this.mEncryptedStoreFilePath != null) {
            appConfig.encryptedStorageImage = ParcelFileDescriptor.open(this.mEncryptedStoreFilePath, 0x30000000);
        }
        ArrayList<ParcelFileDescriptor> extraIdsigs = new ArrayList<ParcelFileDescriptor>();
        for (ExtraApkSpec extraApk : this.mExtraApks) {
            extraIdsigs.add(ParcelFileDescriptor.open(extraApk.idsig, 0x10000000));
        }
        appConfig.extraIdsigs = extraIdsigs;
    }

    @GuardedBy(value={"mLock"})
    private void createVmPipes() throws VirtualMachineException {
        try {
            ParcelFileDescriptor[] pipe;
            if (this.mConsoleReader == null || this.mConsoleWriter == null) {
                pipe = ParcelFileDescriptor.createPipe();
                this.mConsoleReader = pipe[0];
                this.mConsoleWriter = pipe[1];
            }
            if (this.mLogReader == null || this.mLogWriter == null) {
                pipe = ParcelFileDescriptor.createPipe();
                this.mLogReader = pipe[0];
                this.mLogWriter = pipe[1];
            }
        }
        catch (IOException e) {
            throw new VirtualMachineException("Failed to create stream for VM", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SystemApi
    public InputStream getConsoleOutput() throws VirtualMachineException {
        if (!this.mVmOutputCaptured) {
            throw new VirtualMachineException("Capturing vm outputs is turned off");
        }
        Object object = this.mLock;
        synchronized (object) {
            this.createVmPipes();
            return new FileInputStream(this.mConsoleReader.getFileDescriptor());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SystemApi
    public InputStream getLogOutput() throws VirtualMachineException {
        if (!this.mVmOutputCaptured) {
            throw new VirtualMachineException("Capturing vm outputs is turned off");
        }
        Object object = this.mLock;
        synchronized (object) {
            this.createVmPipes();
            return new FileInputStream(this.mLogReader.getFileDescriptor());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SystemApi
    public void stop() throws VirtualMachineException {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mVirtualMachine == null) {
                throw new VirtualMachineException("VM is not running");
            }
            try {
                this.mVirtualMachine.stop();
                this.dropVm();
            }
            catch (RemoteException e) {
                throw e.rethrowAsRuntimeException();
            }
            catch (ServiceSpecificException e) {
                throw new VirtualMachineException(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @SystemApi
    public void close() {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mVirtualMachine == null) {
                return;
            }
            try {
                if (this.stateToStatus(this.mVirtualMachine.getState()) == 1) {
                    this.mVirtualMachine.stop();
                    this.dropVm();
                }
            }
            catch (RemoteException e) {
                throw e.rethrowAsRuntimeException();
            }
            catch (ServiceSpecificException e) {
                Log.i(TAG, "Ignoring error on close()", e);
            }
        }
    }

    private static void deleteRecursively(File dir) throws IOException {
        Files.walkFileTree(dir.toPath(), (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                Files.delete(file);
                return FileVisitResult.CONTINUE;
            }

            @Override
            public FileVisitResult postVisitDirectory(Path dir, IOException e) throws IOException {
                Files.delete(dir);
                return FileVisitResult.CONTINUE;
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SystemApi
    public VirtualMachineConfig setConfig(VirtualMachineConfig newConfig) throws VirtualMachineException {
        Object object = this.mLock;
        synchronized (object) {
            VirtualMachineConfig oldConfig = this.mConfig;
            if (!oldConfig.isCompatibleWith(newConfig)) {
                throw new VirtualMachineException("incompatible config");
            }
            this.checkStopped();
            if (oldConfig != newConfig) {
                this.mConfigFilePath.delete();
                newConfig.serialize(this.mConfigFilePath);
                this.mConfig = newConfig;
            }
            return oldConfig;
        }
    }

    private static IBinder nativeConnectToVsockServer(IBinder iBinder, int n) {
        return (IBinder)OverrideMethod.invokeA("android.system.virtualmachine.VirtualMachine#nativeConnectToVsockServer(Landroid/os/IBinder;I)Landroid/os/IBinder;", true, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SystemApi
    public IBinder connectToVsockServer(long port) throws VirtualMachineException {
        Object object = this.mLock;
        synchronized (object) {
            IBinder iBinder = VirtualMachine.nativeConnectToVsockServer(this.getRunningVm().asBinder(), this.validatePort(port));
            if (iBinder == null) {
                throw new VirtualMachineException("Failed to connect to vsock server");
            }
            return iBinder;
        }
    }

    @SystemApi
    public ParcelFileDescriptor connectVsock(long port) throws VirtualMachineException {
        Object object = this.mLock;
        synchronized (object) {
            try {
                return this.getRunningVm().connectVsock(this.validatePort(port));
            }
            catch (RemoteException e) {
                throw e.rethrowAsRuntimeException();
            }
            catch (ServiceSpecificException e) {
                throw new VirtualMachineException(e);
            }
        }
    }

    private int validatePort(long port) {
        if (port < 1024L || port > 0xFFFFFFFFL) {
            throw new IllegalArgumentException("Bad port " + port);
        }
        return (int)port;
    }

    public File getRootDir() {
        return this.mVmRootPath;
    }

    @SystemApi
    public VirtualMachineDescriptor toDescriptor() throws VirtualMachineException {
        Object object = this.mLock;
        synchronized (object) {
            this.checkStopped();
            try {
                return new VirtualMachineDescriptor(ParcelFileDescriptor.open(this.mConfigFilePath, 0x10000000), ParcelFileDescriptor.open(this.mInstanceFilePath, 0x10000000), this.mEncryptedStoreFilePath != null ? ParcelFileDescriptor.open(this.mEncryptedStoreFilePath, 0x10000000) : null);
            }
            catch (IOException e) {
                throw new VirtualMachineException(e);
            }
        }
    }

    public String toString() {
        VirtualMachineConfig config = this.getConfig();
        String payloadConfigPath = config.getPayloadConfigPath();
        String payloadBinaryName = config.getPayloadBinaryName();
        StringBuilder result = new StringBuilder();
        result.append("VirtualMachine(").append("name:").append(this.getName()).append(", ");
        if (payloadBinaryName != null) {
            result.append("payload:").append(payloadBinaryName).append(", ");
        }
        if (payloadConfigPath != null) {
            result.append("config:").append(payloadConfigPath).append(", ");
        }
        result.append("package: ").append(this.mPackageName).append(")");
        return result.toString();
    }

    private static List<String> parseExtraApkListFromPayloadConfig(JsonReader reader) throws VirtualMachineException {
        try {
            ArrayList<String> apks = new ArrayList<String>();
            reader.beginObject();
            while (reader.hasNext()) {
                if (reader.nextName().equals("extra_apks")) {
                    reader.beginArray();
                    while (reader.hasNext()) {
                        reader.beginObject();
                        String name = reader.nextName();
                        if (name.equals("path")) {
                            apks.add(reader.nextString());
                        } else {
                            reader.skipValue();
                        }
                        reader.endObject();
                    }
                    reader.endArray();
                    continue;
                }
                reader.skipValue();
            }
            reader.endObject();
            return apks;
        }
        catch (IOException e) {
            throw new VirtualMachineException(e);
        }
    }

    private static List<ExtraApkSpec> setupExtraApks(Context context, VirtualMachineConfig config, File vmDir) throws VirtualMachineException {
        List<ExtraApkSpec> list;
        String configPath = config.getPayloadConfigPath();
        if (configPath == null) {
            return Collections.emptyList();
        }
        ZipFile zipFile = new ZipFile(context.getPackageCodePath());
        try {
            InputStream inputStream = zipFile.getInputStream(zipFile.getEntry(configPath));
            List<String> apkList = VirtualMachine.parseExtraApkListFromPayloadConfig(new JsonReader(new InputStreamReader(inputStream)));
            ArrayList<ExtraApkSpec> extraApks = new ArrayList<ExtraApkSpec>();
            for (int i = 0; i < apkList.size(); ++i) {
                extraApks.add(new ExtraApkSpec(new File(apkList.get(i)), new File(vmDir, EXTRA_IDSIG_FILE_PREFIX + i)));
            }
            list = Collections.unmodifiableList(extraApks);
        }
        catch (Throwable throwable) {
            try {
                try {
                    zipFile.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new VirtualMachineException("Couldn't parse extra apks from the vm config", e);
            }
        }
        zipFile.close();
        return list;
    }

    private void importInstanceFrom(ParcelFileDescriptor instanceFd) throws VirtualMachineException {
        try (FileChannel instance = new FileOutputStream(this.mInstanceFilePath).getChannel();
             FileChannel instanceInput = new ParcelFileDescriptor.AutoCloseInputStream(instanceFd).getChannel();){
            instance.transferFrom(instanceInput, 0L, instanceInput.size());
        }
        catch (IOException e) {
            throw new VirtualMachineException("failed to transfer instance image", e);
        }
    }

    private void importEncryptedStoreFrom(ParcelFileDescriptor encryptedStoreFd) throws VirtualMachineException {
        try (FileChannel storeOutput = new FileOutputStream(this.mEncryptedStoreFilePath).getChannel();
             FileChannel storeInput = new ParcelFileDescriptor.AutoCloseInputStream(encryptedStoreFd).getChannel();){
            storeOutput.transferFrom(storeInput, 0L, storeInput.size());
        }
        catch (IOException e) {
            throw new VirtualMachineException("failed to transfer encryptedstore image", e);
        }
    }

    static {
        System_Delegate.loadLibrary("virtualmachine_jni");
    }

    private class MemoryManagementCallbacks
    implements ComponentCallbacks2 {
        private MemoryManagementCallbacks() {
        }

        @Override
        public void onConfigurationChanged(Configuration newConfig) {
        }

        @Override
        public void onLowMemory() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onTrimMemory(int level) {
            int vmTrimLevel;
            switch (level) {
                case 15: {
                    vmTrimLevel = 0;
                    break;
                }
                case 10: {
                    vmTrimLevel = 1;
                    break;
                }
                case 5: {
                    vmTrimLevel = 2;
                    break;
                }
                case 40: 
                case 60: 
                case 80: {
                    vmTrimLevel = 0;
                    break;
                }
                default: {
                    vmTrimLevel = 1;
                }
            }
            Object object = VirtualMachine.this.mLock;
            synchronized (object) {
                try {
                    if (VirtualMachine.this.mVirtualMachine != null) {
                        VirtualMachine.this.mVirtualMachine.onTrimMemory(vmTrimLevel);
                    }
                }
                catch (Exception e) {
                    Log.w(VirtualMachine.TAG, "TrimMemory failed: ", e);
                }
            }
        }
    }

    private static class ExtraApkSpec {
        public final File apk;
        public final File idsig;

        ExtraApkSpec(File apk, File idsig) {
            this.apk = apk;
            this.idsig = idsig;
        }
    }

    private class CallbackTranslator
    extends IVirtualMachineCallback.Stub {
        private final IVirtualizationService mService;
        private final IBinder.DeathRecipient mDeathRecipient;
        private final AtomicBoolean mOnDiedCalled = new AtomicBoolean(false);

        public CallbackTranslator(IVirtualizationService service) throws RemoteException {
            this.mService = service;
            this.mDeathRecipient = () -> this.reportStopped(-1);
            service.asBinder().linkToDeath(this.mDeathRecipient, 0);
        }

        @Override
        public void onPayloadStarted(int cid) {
            VirtualMachine.this.executeCallback(cb -> cb.onPayloadStarted(VirtualMachine.this));
        }

        @Override
        public void onPayloadReady(int cid) {
            VirtualMachine.this.executeCallback(cb -> cb.onPayloadReady(VirtualMachine.this));
        }

        @Override
        public void onPayloadFinished(int cid, int exitCode) {
            VirtualMachine.this.executeCallback(cb -> cb.onPayloadFinished(VirtualMachine.this, exitCode));
        }

        @Override
        public void onError(int cid, int errorCode, String message) {
            int translatedError = this.getTranslatedError(errorCode);
            VirtualMachine.this.executeCallback(cb -> cb.onError(VirtualMachine.this, translatedError, message));
        }

        @Override
        public void onDied(int cid, int reason) {
            int translatedReason = this.getTranslatedReason(reason);
            this.reportStopped(translatedReason);
            this.mService.asBinder().unlinkToDeath(this.mDeathRecipient, 0);
        }

        private void reportStopped(int reason) {
            if (this.mOnDiedCalled.compareAndSet(false, true)) {
                VirtualMachine.this.executeCallback(cb -> cb.onStopped(VirtualMachine.this, reason));
            }
        }

        private int getTranslatedError(int reason) {
            switch (reason) {
                case 1: {
                    return 1;
                }
                case 2: {
                    return 2;
                }
                case 3: {
                    return 3;
                }
            }
            return 0;
        }

        private int getTranslatedReason(int reason) {
            switch (reason) {
                case 0: {
                    return 0;
                }
                case 1: {
                    return 1;
                }
                case 3: {
                    return 3;
                }
                case 4: {
                    return 4;
                }
                case 5: {
                    return 5;
                }
                case 6: {
                    return 6;
                }
                case 7: {
                    return 7;
                }
                case 8: {
                    return 8;
                }
                case 11: {
                    return 11;
                }
                case 12: {
                    return 12;
                }
                case 13: {
                    return 13;
                }
                case 14: {
                    return 14;
                }
                case 15: {
                    return 15;
                }
                case 16: {
                    return 16;
                }
            }
            return 2;
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface Status {
    }
}

