/*
 * Decompiled with CFR 0.152.
 */
package android.system.virtualmachine;

import android.annotation.RequiresPermission;
import android.annotation.SystemApi;
import android.content.Context;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageManager;
import android.os.ParcelFileDescriptor;
import android.os.PersistableBundle;
import android.os._Original_Build;
import android.system.virtualizationservice.VirtualMachineAppConfig;
import android.system.virtualizationservice.VirtualMachinePayloadConfig;
import android.system.virtualmachine.VirtualMachineException;
import android.util.Log;
import com.android.system.virtualmachine.sysprop.HypervisorProperties;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.Objects;
import java.util.zip.ZipFile;

@SystemApi
public class VirtualMachineConfig {
    private static final String TAG = "VirtualMachineConfig";
    private static final String[] EMPTY_STRING_ARRAY = new String[0];
    private static final int VERSION = 6;
    private static final String KEY_VERSION = "version";
    private static final String KEY_PACKAGENAME = "packageName";
    private static final String KEY_APKPATH = "apkPath";
    private static final String KEY_PAYLOADCONFIGPATH = "payloadConfigPath";
    private static final String KEY_PAYLOADBINARYNAME = "payloadBinaryPath";
    private static final String KEY_DEBUGLEVEL = "debugLevel";
    private static final String KEY_PROTECTED_VM = "protectedVm";
    private static final String KEY_MEMORY_BYTES = "memoryBytes";
    private static final String KEY_CPU_TOPOLOGY = "cpuTopology";
    private static final String KEY_ENCRYPTED_STORAGE_BYTES = "encryptedStorageBytes";
    private static final String KEY_VM_OUTPUT_CAPTURED = "vmOutputCaptured";
    @SystemApi
    public static final int DEBUG_LEVEL_NONE = 0;
    @SystemApi
    public static final int DEBUG_LEVEL_FULL = 1;
    @SystemApi
    public static final int CPU_TOPOLOGY_ONE_CPU = 0;
    @SystemApi
    public static final int CPU_TOPOLOGY_MATCH_HOST = 1;
    private final String mPackageName;
    private final String mApkPath;
    private final int mDebugLevel;
    private final boolean mProtectedVm;
    private final long mMemoryBytes;
    private final int mCpuTopology;
    private final String mPayloadConfigPath;
    private final String mPayloadBinaryName;
    private final long mEncryptedStorageBytes;
    private final boolean mVmOutputCaptured;

    private VirtualMachineConfig(String packageName, String apkPath, String payloadConfigPath, String payloadBinaryName, int debugLevel, boolean protectedVm, long memoryBytes, int cpuTopology, long encryptedStorageBytes, boolean vmOutputCaptured) {
        this.mPackageName = packageName;
        this.mApkPath = apkPath;
        this.mPayloadConfigPath = payloadConfigPath;
        this.mPayloadBinaryName = payloadBinaryName;
        this.mDebugLevel = debugLevel;
        this.mProtectedVm = protectedVm;
        this.mMemoryBytes = memoryBytes;
        this.mCpuTopology = cpuTopology;
        this.mEncryptedStorageBytes = encryptedStorageBytes;
        this.mVmOutputCaptured = vmOutputCaptured;
    }

    static VirtualMachineConfig from(File file) throws VirtualMachineException {
        VirtualMachineConfig virtualMachineConfig;
        FileInputStream input = new FileInputStream(file);
        try {
            virtualMachineConfig = VirtualMachineConfig.fromInputStream(input);
        }
        catch (Throwable throwable) {
            try {
                try {
                    input.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new VirtualMachineException("Failed to read VM config from file", e);
            }
        }
        input.close();
        return virtualMachineConfig;
    }

    static VirtualMachineConfig from(ParcelFileDescriptor fd) throws VirtualMachineException {
        VirtualMachineConfig virtualMachineConfig;
        ParcelFileDescriptor.AutoCloseInputStream input = new ParcelFileDescriptor.AutoCloseInputStream(fd);
        try {
            virtualMachineConfig = VirtualMachineConfig.fromInputStream(input);
        }
        catch (Throwable throwable) {
            try {
                try {
                    input.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new VirtualMachineException("failed to read VM config from file descriptor", e);
            }
        }
        input.close();
        return virtualMachineConfig;
    }

    private static VirtualMachineConfig fromInputStream(InputStream input) throws IOException, VirtualMachineException {
        PersistableBundle b = PersistableBundle.readFromStream(input);
        try {
            return VirtualMachineConfig.fromPersistableBundle(b);
        }
        catch (IllegalArgumentException | IllegalStateException | NullPointerException e) {
            throw new VirtualMachineException("Persisted VM config is invalid", e);
        }
    }

    private static VirtualMachineConfig fromPersistableBundle(PersistableBundle b) {
        String payloadConfigPath;
        int version = b.getInt(KEY_VERSION);
        if (version > 6) {
            throw new IllegalArgumentException("Version " + version + " too high; current is " + 6);
        }
        String packageName = b.getString(KEY_PACKAGENAME);
        Builder builder = new Builder(packageName);
        String apkPath = b.getString(KEY_APKPATH);
        if (apkPath != null) {
            builder.setApkPath(apkPath);
        }
        if ((payloadConfigPath = b.getString(KEY_PAYLOADCONFIGPATH)) == null) {
            builder.setPayloadBinaryName(b.getString(KEY_PAYLOADBINARYNAME));
        } else {
            builder.setPayloadConfigPath(payloadConfigPath);
        }
        int debugLevel = b.getInt(KEY_DEBUGLEVEL);
        if (debugLevel != 0 && debugLevel != 1) {
            throw new IllegalArgumentException("Invalid debugLevel: " + debugLevel);
        }
        builder.setDebugLevel(debugLevel);
        builder.setProtectedVm(b.getBoolean(KEY_PROTECTED_VM));
        long memoryBytes = b.getLong(KEY_MEMORY_BYTES);
        if (memoryBytes != 0L) {
            builder.setMemoryBytes(memoryBytes);
        }
        builder.setCpuTopology(b.getInt(KEY_CPU_TOPOLOGY));
        long encryptedStorageBytes = b.getLong(KEY_ENCRYPTED_STORAGE_BYTES);
        if (encryptedStorageBytes != 0L) {
            builder.setEncryptedStorageBytes(encryptedStorageBytes);
        }
        builder.setVmOutputCaptured(b.getBoolean(KEY_VM_OUTPUT_CAPTURED));
        return builder.build();
    }

    void serialize(File file) throws VirtualMachineException {
        try (FileOutputStream output = new FileOutputStream(file);){
            this.serializeOutputStream(output);
        }
        catch (IOException e) {
            throw new VirtualMachineException("failed to write VM config", e);
        }
    }

    private void serializeOutputStream(OutputStream output) throws IOException {
        PersistableBundle b = new PersistableBundle();
        b.putInt(KEY_VERSION, 6);
        if (this.mPackageName != null) {
            b.putString(KEY_PACKAGENAME, this.mPackageName);
        }
        if (this.mApkPath != null) {
            b.putString(KEY_APKPATH, this.mApkPath);
        }
        b.putString(KEY_PAYLOADCONFIGPATH, this.mPayloadConfigPath);
        b.putString(KEY_PAYLOADBINARYNAME, this.mPayloadBinaryName);
        b.putInt(KEY_DEBUGLEVEL, this.mDebugLevel);
        b.putBoolean(KEY_PROTECTED_VM, this.mProtectedVm);
        b.putInt(KEY_CPU_TOPOLOGY, this.mCpuTopology);
        if (this.mMemoryBytes > 0L) {
            b.putLong(KEY_MEMORY_BYTES, this.mMemoryBytes);
        }
        if (this.mEncryptedStorageBytes > 0L) {
            b.putLong(KEY_ENCRYPTED_STORAGE_BYTES, this.mEncryptedStorageBytes);
        }
        b.putBoolean(KEY_VM_OUTPUT_CAPTURED, this.mVmOutputCaptured);
        b.writeToStream(output);
    }

    @SystemApi
    public String getApkPath() {
        return this.mApkPath;
    }

    public String getPayloadConfigPath() {
        return this.mPayloadConfigPath;
    }

    @SystemApi
    public String getPayloadBinaryName() {
        return this.mPayloadBinaryName;
    }

    @SystemApi
    public int getDebugLevel() {
        return this.mDebugLevel;
    }

    @SystemApi
    public boolean isProtectedVm() {
        return this.mProtectedVm;
    }

    @SystemApi
    public long getMemoryBytes() {
        return this.mMemoryBytes;
    }

    @SystemApi
    public int getCpuTopology() {
        return this.mCpuTopology;
    }

    @SystemApi
    public boolean isEncryptedStorageEnabled() {
        return this.mEncryptedStorageBytes > 0L;
    }

    @SystemApi
    public long getEncryptedStorageBytes() {
        return this.mEncryptedStorageBytes;
    }

    @SystemApi
    public boolean isVmOutputCaptured() {
        return this.mVmOutputCaptured;
    }

    @SystemApi
    public boolean isCompatibleWith(VirtualMachineConfig other) {
        if (this == other) {
            return true;
        }
        return this.mDebugLevel == other.mDebugLevel && this.mProtectedVm == other.mProtectedVm && this.mEncryptedStorageBytes == other.mEncryptedStorageBytes && this.mVmOutputCaptured == other.mVmOutputCaptured && Objects.equals(this.mPayloadConfigPath, other.mPayloadConfigPath) && Objects.equals(this.mPayloadBinaryName, other.mPayloadBinaryName) && Objects.equals(this.mPackageName, other.mPackageName) && Objects.equals(this.mApkPath, other.mApkPath);
    }

    VirtualMachineAppConfig toVsConfig(PackageManager packageManager) throws VirtualMachineException {
        VirtualMachineAppConfig vsConfig = new VirtualMachineAppConfig();
        String apkPath = this.mApkPath != null ? this.mApkPath : this.findPayloadApk(packageManager);
        try {
            vsConfig.apk = ParcelFileDescriptor.open(new File(apkPath), 0x10000000);
        }
        catch (FileNotFoundException e) {
            throw new VirtualMachineException("Failed to open APK", e);
        }
        if (this.mPayloadBinaryName != null) {
            VirtualMachinePayloadConfig payloadConfig = new VirtualMachinePayloadConfig();
            payloadConfig.payloadBinaryName = this.mPayloadBinaryName;
            vsConfig.payload = VirtualMachineAppConfig.Payload.payloadConfig(payloadConfig);
        } else {
            vsConfig.payload = VirtualMachineAppConfig.Payload.configPath(this.mPayloadConfigPath);
        }
        switch (this.mDebugLevel) {
            case 1: {
                vsConfig.debugLevel = 1;
                break;
            }
            default: {
                vsConfig.debugLevel = 0;
            }
        }
        vsConfig.protectedVm = this.mProtectedVm;
        vsConfig.memoryMib = this.bytesToMebiBytes(this.mMemoryBytes);
        switch (this.mCpuTopology) {
            case 1: {
                vsConfig.cpuTopology = 1;
                break;
            }
            default: {
                vsConfig.cpuTopology = 0;
            }
        }
        vsConfig.taskProfiles = EMPTY_STRING_ARRAY;
        return vsConfig;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String findPayloadApk(PackageManager packageManager) throws VirtualMachineException {
        ApplicationInfo appInfo;
        try {
            appInfo = packageManager.getApplicationInfo(this.mPackageName, PackageManager.ApplicationInfoFlags.of(0L));
        }
        catch (PackageManager.NameNotFoundException e) {
            throw new VirtualMachineException("Package not found", e);
        }
        String[] splitApkPaths = appInfo.splitSourceDirs;
        String[] abis = _Original_Build.SUPPORTED_64_BIT_ABIS;
        if (this.mPayloadBinaryName == null) return appInfo.sourceDir;
        if (splitApkPaths == null) return appInfo.sourceDir;
        if (abis.length == 0) return appInfo.sourceDir;
        String[] libraryNames = new String[abis.length];
        for (int i = 0; i < abis.length; ++i) {
            libraryNames[i] = "lib/" + abis[i] + "/" + this.mPayloadBinaryName;
        }
        String[] stringArray = splitApkPaths;
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String path = stringArray[n2];
            try (ZipFile zip = new ZipFile(path);){
                for (String name : libraryNames) {
                    if (zip.getEntry(name) == null) continue;
                    Log.i(TAG, "Found payload in " + path);
                    String string2 = path;
                    return string2;
                }
            }
            catch (IOException e) {
                Log.w(TAG, "Failed to scan split APK: " + path, e);
            }
            ++n2;
        }
        return appInfo.sourceDir;
    }

    private int bytesToMebiBytes(long mMemoryBytes) {
        long oneMebi = 0x100000L;
        if (mMemoryBytes > 0x7FFFFFFEL * oneMebi) {
            return Integer.MAX_VALUE;
        }
        return (int)((mMemoryBytes + oneMebi - 1L) / oneMebi);
    }

    @SystemApi
    public static class Builder {
        private final String mPackageName;
        private String mApkPath;
        private String mPayloadConfigPath;
        private String mPayloadBinaryName;
        private int mDebugLevel = 0;
        private boolean mProtectedVm;
        private boolean mProtectedVmSet;
        private long mMemoryBytes;
        private int mCpuTopology = 0;
        private long mEncryptedStorageBytes;
        private boolean mVmOutputCaptured = false;

        @SystemApi
        public Builder(Context context) {
            this.mPackageName = Objects.requireNonNull(context, "context must not be null").getPackageName();
        }

        private Builder(String packageName) {
            this.mPackageName = packageName;
        }

        @SystemApi
        public VirtualMachineConfig build() {
            String apkPath = null;
            String packageName = null;
            if (this.mApkPath != null) {
                apkPath = this.mApkPath;
            } else if (this.mPackageName != null) {
                packageName = this.mPackageName;
            } else {
                throw new IllegalStateException("apkPath or packageName must be specified");
            }
            if (this.mPayloadBinaryName == null) {
                if (this.mPayloadConfigPath == null) {
                    throw new IllegalStateException("setPayloadBinaryName must be called");
                }
            } else if (this.mPayloadConfigPath != null) {
                throw new IllegalStateException("setPayloadBinaryName and setPayloadConfigPath may not both be called");
            }
            if (!this.mProtectedVmSet) {
                throw new IllegalStateException("setProtectedVm must be called explicitly");
            }
            if (this.mVmOutputCaptured && this.mDebugLevel != 1) {
                throw new IllegalStateException("debug level must be FULL to capture output");
            }
            return new VirtualMachineConfig(packageName, apkPath, this.mPayloadConfigPath, this.mPayloadBinaryName, this.mDebugLevel, this.mProtectedVm, this.mMemoryBytes, this.mCpuTopology, this.mEncryptedStorageBytes, this.mVmOutputCaptured);
        }

        @SystemApi
        public Builder setApkPath(String apkPath) {
            Objects.requireNonNull(apkPath, "apkPath must not be null");
            if (!apkPath.startsWith("/")) {
                throw new IllegalArgumentException("APK path must be an absolute path");
            }
            this.mApkPath = apkPath;
            return this;
        }

        @RequiresPermission(value="android.permission.USE_CUSTOM_VIRTUAL_MACHINE")
        public Builder setPayloadConfigPath(String payloadConfigPath) {
            this.mPayloadConfigPath = Objects.requireNonNull(payloadConfigPath, "payloadConfigPath must not be null");
            return this;
        }

        @SystemApi
        public Builder setPayloadBinaryName(String payloadBinaryName) {
            if (payloadBinaryName.contains(File.separator)) {
                throw new IllegalArgumentException("Invalid binary file name: " + payloadBinaryName);
            }
            this.mPayloadBinaryName = Objects.requireNonNull(payloadBinaryName, "payloadBinaryName must not be null");
            return this;
        }

        @SystemApi
        public Builder setDebugLevel(int debugLevel) {
            if (debugLevel != 0 && debugLevel != 1) {
                throw new IllegalArgumentException("Invalid debugLevel: " + debugLevel);
            }
            this.mDebugLevel = debugLevel;
            return this;
        }

        @SystemApi
        public Builder setProtectedVm(boolean protectedVm) {
            if (protectedVm) {
                if (!HypervisorProperties.hypervisor_protected_vm_supported().orElse(false).booleanValue()) {
                    throw new UnsupportedOperationException("Protected VMs are not supported on this device.");
                }
            } else if (!HypervisorProperties.hypervisor_vm_supported().orElse(false).booleanValue()) {
                throw new UnsupportedOperationException("Non-protected VMs are not supported on this device.");
            }
            this.mProtectedVm = protectedVm;
            this.mProtectedVmSet = true;
            return this;
        }

        @SystemApi
        public Builder setMemoryBytes(long memoryBytes) {
            if (memoryBytes <= 0L) {
                throw new IllegalArgumentException("Memory size must be positive");
            }
            this.mMemoryBytes = memoryBytes;
            return this;
        }

        @SystemApi
        public Builder setCpuTopology(int cpuTopology) {
            if (cpuTopology != 0 && cpuTopology != 1) {
                throw new IllegalArgumentException("Invalid cpuTopology: " + cpuTopology);
            }
            this.mCpuTopology = cpuTopology;
            return this;
        }

        @SystemApi
        public Builder setEncryptedStorageBytes(long encryptedStorageBytes) {
            if (encryptedStorageBytes <= 0L) {
                throw new IllegalArgumentException("Encrypted Storage size must be positive");
            }
            this.mEncryptedStorageBytes = encryptedStorageBytes;
            return this;
        }

        @SystemApi
        public Builder setVmOutputCaptured(boolean captured) {
            this.mVmOutputCaptured = captured;
            return this;
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface CpuTopology {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface DebugLevel {
    }
}

