/*
 * Decompiled with CFR 0.152.
 */
package android.system.virtualmachine;

import android.annotation.SystemApi;
import android.os.Parcel;
import android.os.ParcelFileDescriptor;
import android.os.Parcelable;
import java.io.IOException;
import java.util.Objects;

@SystemApi
public class VirtualMachineDescriptor
implements Parcelable,
AutoCloseable {
    private volatile boolean mClosed = false;
    private final ParcelFileDescriptor mConfigFd;
    private final ParcelFileDescriptor mInstanceImgFd;
    private final ParcelFileDescriptor mEncryptedStoreFd;
    public static final Parcelable.Creator<VirtualMachineDescriptor> CREATOR = new Parcelable.Creator<VirtualMachineDescriptor>(){

        @Override
        public VirtualMachineDescriptor createFromParcel(Parcel in) {
            return new VirtualMachineDescriptor(in);
        }

        public VirtualMachineDescriptor[] newArray(int size) {
            return new VirtualMachineDescriptor[size];
        }
    };

    @Override
    public int describeContents() {
        return 1;
    }

    @Override
    public void writeToParcel(Parcel out, int flags) {
        this.checkNotClosed();
        out.writeParcelable(this.mConfigFd, flags);
        out.writeParcelable(this.mInstanceImgFd, flags);
        out.writeParcelable(this.mEncryptedStoreFd, flags);
    }

    ParcelFileDescriptor getConfigFd() {
        this.checkNotClosed();
        return this.mConfigFd;
    }

    ParcelFileDescriptor getInstanceImgFd() {
        this.checkNotClosed();
        return this.mInstanceImgFd;
    }

    ParcelFileDescriptor getEncryptedStoreFd() {
        this.checkNotClosed();
        return this.mEncryptedStoreFd;
    }

    VirtualMachineDescriptor(ParcelFileDescriptor configFd, ParcelFileDescriptor instanceImgFd, ParcelFileDescriptor encryptedStoreFd) {
        this.mConfigFd = Objects.requireNonNull(configFd);
        this.mInstanceImgFd = Objects.requireNonNull(instanceImgFd);
        this.mEncryptedStoreFd = encryptedStoreFd;
    }

    private VirtualMachineDescriptor(Parcel in) {
        this.mConfigFd = Objects.requireNonNull(this.readParcelFileDescriptor(in));
        this.mInstanceImgFd = Objects.requireNonNull(this.readParcelFileDescriptor(in));
        this.mEncryptedStoreFd = this.readParcelFileDescriptor(in);
    }

    private ParcelFileDescriptor readParcelFileDescriptor(Parcel in) {
        return in.readParcelable(ParcelFileDescriptor.class.getClassLoader(), ParcelFileDescriptor.class);
    }

    @Override
    public void close() {
        this.mClosed = true;
        try (ParcelFileDescriptor parcelFileDescriptor = this.mConfigFd;
             ParcelFileDescriptor parcelFileDescriptor2 = this.mInstanceImgFd;){
            ParcelFileDescriptor parcelFileDescriptor3 = this.mEncryptedStoreFd;
            if (parcelFileDescriptor3 != null) {
                parcelFileDescriptor3.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void checkNotClosed() {
        if (this.mClosed) {
            throw new IllegalStateException("Descriptor has been closed");
        }
    }
}

