/*
 * Decompiled with CFR 0.152.
 */
package android.system.virtualmachine;

import android.annotation.RequiresPermission;
import android.annotation.SystemApi;
import android.content.Context;
import android.system.virtualmachine.VirtualMachine;
import android.system.virtualmachine.VirtualMachineConfig;
import android.system.virtualmachine.VirtualMachineDescriptor;
import android.system.virtualmachine.VirtualMachineException;
import android.util.ArrayMap;
import com.android.internal.annotations.GuardedBy;
import com.android.system.virtualmachine.sysprop.HypervisorProperties;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.ref.WeakReference;
import java.util.Map;
import java.util.Objects;

@SystemApi
public class VirtualMachineManager {
    private static final Object sCreateLock = new Object();
    private final Context mContext;
    @GuardedBy(value={"sCreateLock"})
    private final Map<String, WeakReference<VirtualMachine>> mVmsByName = new ArrayMap<String, WeakReference<VirtualMachine>>();
    public static final int CAPABILITY_PROTECTED_VM = 1;
    public static final int CAPABILITY_NON_PROTECTED_VM = 2;

    public VirtualMachineManager(Context context) {
        this.mContext = Objects.requireNonNull(context);
    }

    @SystemApi
    public int getCapabilities() {
        int result = 0;
        if (HypervisorProperties.hypervisor_protected_vm_supported().orElse(false).booleanValue()) {
            result |= 1;
        }
        if (HypervisorProperties.hypervisor_vm_supported().orElse(false).booleanValue()) {
            result |= 2;
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SystemApi
    @RequiresPermission(value="android.permission.MANAGE_VIRTUAL_MACHINE")
    public VirtualMachine create(String name, VirtualMachineConfig config) throws VirtualMachineException {
        Object object = sCreateLock;
        synchronized (object) {
            return this.createLocked(name, config);
        }
    }

    @GuardedBy(value={"sCreateLock"})
    private VirtualMachine createLocked(String name, VirtualMachineConfig config) throws VirtualMachineException {
        VirtualMachine vm = VirtualMachine.create(this.mContext, name, config);
        this.mVmsByName.put(name, new WeakReference<VirtualMachine>(vm));
        return vm;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SystemApi
    public VirtualMachine get(String name) throws VirtualMachineException {
        Object object = sCreateLock;
        synchronized (object) {
            return this.getLocked(name);
        }
    }

    @GuardedBy(value={"sCreateLock"})
    private VirtualMachine getLocked(String name) throws VirtualMachineException {
        VirtualMachine vm = this.getVmByName(name);
        if (vm != null) {
            return vm;
        }
        vm = VirtualMachine.load(this.mContext, name);
        if (vm != null) {
            this.mVmsByName.put(name, new WeakReference<VirtualMachine>(vm));
        }
        return vm;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SystemApi
    public VirtualMachine importFromDescriptor(String name, VirtualMachineDescriptor vmDescriptor) throws VirtualMachineException {
        Object object = sCreateLock;
        synchronized (object) {
            VirtualMachine vm = VirtualMachine.fromDescriptor(this.mContext, name, vmDescriptor);
            this.mVmsByName.put(name, new WeakReference<VirtualMachine>(vm));
            return vm;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SystemApi
    public VirtualMachine getOrCreate(String name, VirtualMachineConfig config) throws VirtualMachineException {
        Object object = sCreateLock;
        synchronized (object) {
            VirtualMachine vm = this.getLocked(name);
            if (vm != null) {
                return vm;
            }
            return this.createLocked(name, config);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SystemApi
    public void delete(String name) throws VirtualMachineException {
        Object object = sCreateLock;
        synchronized (object) {
            VirtualMachine vm = this.getVmByName(name);
            if (vm == null) {
                VirtualMachine.deleteVmDirectory(this.mContext, name);
            } else {
                vm.delete(this.mContext, name);
            }
            this.mVmsByName.remove(name);
        }
    }

    @GuardedBy(value={"sCreateLock"})
    private VirtualMachine getVmByName(String name) {
        VirtualMachine vm;
        Objects.requireNonNull(name);
        WeakReference<VirtualMachine> weakReference = this.mVmsByName.get(name);
        if (weakReference != null && (vm = (VirtualMachine)weakReference.get()) != null && vm.getStatus() != 2) {
            return vm;
        }
        return null;
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface Capability {
    }
}

