/*
 * Decompiled with CFR 0.152.
 */
package android.system.virtualmachine;

import android.os.IBinder;
import android.os.ParcelFileDescriptor;
import android.system.virtualizationservice.IVirtualizationService;
import android.system.virtualmachine.VirtualMachineException;
import com.android.internal.annotations.GuardedBy;
import com.android.internal.lang.System_Delegate;
import com.android.tools.layoutlib.create.OverrideMethod;
import java.lang.ref.WeakReference;

class VirtualizationService {
    @GuardedBy(value={"VirtualMachineManager.sCreateLock"})
    private static WeakReference<VirtualizationService> sInstance;
    private final ParcelFileDescriptor mClientFd;
    private final IVirtualizationService mBinder;

    private static int nativeSpawn() {
        return OverrideMethod.invokeI("android.system.virtualmachine.VirtualizationService#nativeSpawn()I", true, null);
    }

    private IBinder nativeConnect(int n) {
        return (IBinder)OverrideMethod.invokeA("android.system.virtualmachine.VirtualizationService#nativeConnect(I)Landroid/os/IBinder;", true, this);
    }

    private boolean nativeIsOk(int n) {
        return OverrideMethod.invokeI("android.system.virtualmachine.VirtualizationService#nativeIsOk(I)Z", true, this) != 0;
    }

    private VirtualizationService() throws VirtualMachineException {
        int clientFd = VirtualizationService.nativeSpawn();
        if (clientFd < 0) {
            throw new VirtualMachineException("Could not spawn VirtualizationService");
        }
        this.mClientFd = ParcelFileDescriptor.adoptFd(clientFd);
        IBinder binder = this.nativeConnect(this.mClientFd.getFd());
        if (binder == null) {
            throw new VirtualMachineException("Could not connect to VirtualizationService");
        }
        this.mBinder = IVirtualizationService.Stub.asInterface(binder);
    }

    IVirtualizationService getBinder() {
        return this.mBinder;
    }

    private boolean isOk() {
        return this.nativeIsOk(this.mClientFd.getFd());
    }

    @GuardedBy(value={"VirtualMachineManager.sCreateLock"})
    static VirtualizationService getInstance() throws VirtualMachineException {
        VirtualizationService service;
        VirtualizationService virtualizationService = service = sInstance == null ? null : (VirtualizationService)sInstance.get();
        if (service == null || !service.isOk()) {
            service = new VirtualizationService();
            sInstance = new WeakReference<VirtualizationService>(service);
        }
        return service;
    }

    static {
        System_Delegate.loadLibrary("virtualizationservice_jni");
    }
}

