/*
 * Decompiled with CFR 0.152.
 */
package android.telecom;

import android.net.Uri;
import android.os.Parcel;
import android.os.Parcelable;
import android.telecom.Log;
import android.telecom.PhoneAccountHandle;
import android.text.TextUtils;
import java.util.Objects;

public class CallAttributes
implements Parcelable {
    private final PhoneAccountHandle mPhoneAccountHandle;
    private final CharSequence mDisplayName;
    private final Uri mAddress;
    @Direction
    private final int mDirection;
    @CallType
    private final int mCallType;
    @CallCapability
    private final int mCallCapabilities;
    public static final String CALL_CAPABILITIES_KEY = "TelecomCapabilities";
    public static final String DISPLAY_NAME_KEY = "DisplayName";
    public static final String CALLER_PID_KEY = "CallerPid";
    public static final String CALLER_UID_KEY = "CallerUid";
    public static final int DIRECTION_INCOMING = 1;
    public static final int DIRECTION_OUTGOING = 2;
    public static final int AUDIO_CALL = 1;
    public static final int VIDEO_CALL = 2;
    public static final int SUPPORTS_SET_INACTIVE = 2;
    public static final int SUPPORTS_STREAM = 4;
    public static final int SUPPORTS_TRANSFER = 8;
    public static final Parcelable.Creator<CallAttributes> CREATOR = new Parcelable.Creator<CallAttributes>(){

        @Override
        public CallAttributes createFromParcel(Parcel source) {
            return new CallAttributes(source.readParcelable(this.getClass().getClassLoader(), PhoneAccountHandle.class), source.readCharSequence(), source.readParcelable(this.getClass().getClassLoader(), Uri.class), source.readInt(), source.readInt(), source.readInt());
        }

        public CallAttributes[] newArray(int size) {
            return new CallAttributes[size];
        }
    };

    private CallAttributes(PhoneAccountHandle phoneAccountHandle, CharSequence displayName, Uri address, int direction, int callType, int callCapabilities) {
        this.mPhoneAccountHandle = phoneAccountHandle;
        this.mDisplayName = displayName;
        this.mAddress = address;
        this.mDirection = direction;
        this.mCallType = callType;
        this.mCallCapabilities = callCapabilities;
    }

    public PhoneAccountHandle getPhoneAccountHandle() {
        return this.mPhoneAccountHandle;
    }

    public CharSequence getDisplayName() {
        return this.mDisplayName;
    }

    public Uri getAddress() {
        return this.mAddress;
    }

    @Direction
    public int getDirection() {
        return this.mDirection;
    }

    @CallType
    public int getCallType() {
        return this.mCallType;
    }

    @CallCapability
    public int getCallCapabilities() {
        return this.mCallCapabilities;
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        dest.writeParcelable(this.mPhoneAccountHandle, flags);
        dest.writeCharSequence(this.mDisplayName);
        dest.writeParcelable(this.mAddress, flags);
        dest.writeInt(this.mDirection);
        dest.writeInt(this.mCallType);
        dest.writeInt(this.mCallCapabilities);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{ CallAttributes: [phoneAccountHandle: ").append(this.mPhoneAccountHandle).append("], [contactName: ").append(Log.pii(this.mDisplayName)).append("], [address=").append(Log.pii(this.mAddress)).append("], [direction=").append(this.mDirection).append("], [callType=").append(this.mCallType).append("], [mCallCapabilities=").append(this.mCallCapabilities).append("]  }");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        CallAttributes that = (CallAttributes)obj;
        return this.mDirection == that.mDirection && this.mCallType == that.mCallType && this.mCallCapabilities == that.mCallCapabilities && Objects.equals(this.mPhoneAccountHandle, that.mPhoneAccountHandle) && Objects.equals(this.mAddress, that.mAddress) && Objects.equals(this.mDisplayName, that.mDisplayName);
    }

    public int hashCode() {
        return Objects.hash(this.mPhoneAccountHandle, this.mAddress, this.mDisplayName, this.mDirection, this.mCallType, this.mCallCapabilities);
    }

    public static class Builder {
        private final PhoneAccountHandle mPhoneAccountHandle;
        @Direction
        private final int mDirection;
        private final CharSequence mDisplayName;
        private final Uri mAddress;
        @CallType
        private int mCallType = 1;
        @CallCapability
        private int mCallCapabilities = 2;

        public Builder(PhoneAccountHandle phoneAccountHandle, @Direction int callDirection, CharSequence displayName, Uri address) {
            if (!this.isInRange(1, 2, callDirection)) {
                throw new IllegalArgumentException(TextUtils.formatSimple("CallDirection=[%d] is invalid. CallDirections value should be within [%d, %d]", callDirection, 1, 2));
            }
            Objects.requireNonNull(phoneAccountHandle);
            Objects.requireNonNull(displayName);
            Objects.requireNonNull(address);
            this.mPhoneAccountHandle = phoneAccountHandle;
            this.mDirection = callDirection;
            this.mDisplayName = displayName;
            this.mAddress = address;
        }

        public Builder setCallType(@CallType int callType) {
            if (!this.isInRange(1, 2, callType)) {
                throw new IllegalArgumentException(TextUtils.formatSimple("CallType=[%d] is invalid. CallTypes value should be within [%d, %d]", callType, 1, 2));
            }
            this.mCallType = callType;
            return this;
        }

        public Builder setCallCapabilities(@CallCapability int callCapabilities) {
            this.mCallCapabilities = callCapabilities;
            return this;
        }

        public CallAttributes build() {
            return new CallAttributes(this.mPhoneAccountHandle, this.mDisplayName, this.mAddress, this.mDirection, this.mCallType, this.mCallCapabilities);
        }

        private boolean isInRange(int floor, int ceiling, int value) {
            return value >= floor && value <= ceiling;
        }
    }

    public static @interface CallCapability {
    }

    public static @interface CallType {
    }

    public static @interface Direction {
    }
}

