/*
 * Decompiled with CFR 0.152.
 */
package android.telecom;

import android.annotation.SuppressLint;
import android.os.Binder;
import android.os.Bundle;
import android.os.Handler;
import android.os.OutcomeReceiver;
import android.os.ParcelUuid;
import android.os.RemoteException;
import android.os.ResultReceiver;
import android.telecom.CallAttributes;
import android.telecom.CallEndpoint;
import android.telecom.CallException;
import android.telecom.DisconnectCause;
import android.telecom.Log;
import android.telecom.PhoneAccountHandle;
import android.text.TextUtils;
import com.android.internal.telecom.ClientTransactionalServiceRepository;
import com.android.internal.telecom.ICallControl;
import java.util.Objects;
import java.util.concurrent.Executor;

@SuppressLint(value={"NotCloseable"})
public class CallControl {
    private static final String TAG = CallControl.class.getSimpleName();
    private static final String INTERFACE_ERROR_MSG = "Call Control is not available";
    private final String mCallId;
    private final ICallControl mServerInterface;
    private final PhoneAccountHandle mPhoneAccountHandle;
    private final ClientTransactionalServiceRepository mRepository;

    public CallControl(String callId, ICallControl serverInterface, ClientTransactionalServiceRepository repository, PhoneAccountHandle pah) {
        this.mCallId = callId;
        this.mServerInterface = serverInterface;
        this.mRepository = repository;
        this.mPhoneAccountHandle = pah;
    }

    public ParcelUuid getCallId() {
        return ParcelUuid.fromString(this.mCallId);
    }

    public void setActive(Executor executor, OutcomeReceiver<Void, CallException> callback) {
        if (this.mServerInterface != null) {
            try {
                this.mServerInterface.setActive(this.mCallId, new CallControlResultReceiver("setActive", executor, callback));
            }
            catch (RemoteException e) {
                throw e.rethrowAsRuntimeException();
            }
        } else {
            throw new IllegalStateException(INTERFACE_ERROR_MSG);
        }
    }

    public void answer(@CallAttributes.CallType int videoState, Executor executor, OutcomeReceiver<Void, CallException> callback) {
        this.validateVideoState(videoState);
        Objects.requireNonNull(executor);
        Objects.requireNonNull(callback);
        if (this.mServerInterface != null) {
            try {
                this.mServerInterface.answer(videoState, this.mCallId, new CallControlResultReceiver("answer", executor, callback));
            }
            catch (RemoteException e) {
                throw e.rethrowAsRuntimeException();
            }
        } else {
            throw new IllegalStateException(INTERFACE_ERROR_MSG);
        }
    }

    public void setInactive(Executor executor, OutcomeReceiver<Void, CallException> callback) {
        if (this.mServerInterface != null) {
            try {
                this.mServerInterface.setInactive(this.mCallId, new CallControlResultReceiver("setInactive", executor, callback));
            }
            catch (RemoteException e) {
                throw e.rethrowAsRuntimeException();
            }
        } else {
            throw new IllegalStateException(INTERFACE_ERROR_MSG);
        }
    }

    public void disconnect(DisconnectCause disconnectCause, Executor executor, OutcomeReceiver<Void, CallException> callback) {
        Objects.requireNonNull(disconnectCause);
        Objects.requireNonNull(executor);
        Objects.requireNonNull(callback);
        this.validateDisconnectCause(disconnectCause);
        if (this.mServerInterface != null) {
            try {
                this.mServerInterface.disconnect(this.mCallId, disconnectCause, new CallControlResultReceiver("disconnect", executor, callback));
            }
            catch (RemoteException e) {
                throw e.rethrowAsRuntimeException();
            }
        } else {
            throw new IllegalStateException(INTERFACE_ERROR_MSG);
        }
    }

    public void startCallStreaming(Executor executor, OutcomeReceiver<Void, CallException> callback) {
        if (this.mServerInterface != null) {
            try {
                this.mServerInterface.startCallStreaming(this.mCallId, new CallControlResultReceiver("startCallStreaming", executor, callback));
            }
            catch (RemoteException e) {
                throw e.rethrowAsRuntimeException();
            }
        } else {
            throw new IllegalStateException(INTERFACE_ERROR_MSG);
        }
    }

    public void requestCallEndpointChange(CallEndpoint callEndpoint, Executor executor, OutcomeReceiver<Void, CallException> callback) {
        Objects.requireNonNull(callEndpoint);
        Objects.requireNonNull(executor);
        Objects.requireNonNull(callback);
        if (this.mServerInterface != null) {
            try {
                this.mServerInterface.requestCallEndpointChange(callEndpoint, new CallControlResultReceiver("endpointChange", executor, callback));
            }
            catch (RemoteException e) {
                throw e.rethrowAsRuntimeException();
            }
        } else {
            throw new IllegalStateException(INTERFACE_ERROR_MSG);
        }
    }

    public void sendEvent(String event, Bundle extras) {
        Objects.requireNonNull(event);
        Objects.requireNonNull(extras);
        if (this.mServerInterface != null) {
            try {
                this.mServerInterface.sendEvent(this.mCallId, event, extras);
            }
            catch (RemoteException e) {
                throw e.rethrowAsRuntimeException();
            }
        } else {
            throw new IllegalStateException(INTERFACE_ERROR_MSG);
        }
    }

    private CallException getTransactionException(Bundle resultData) {
        String message = "unknown error";
        if (resultData != null && resultData.containsKey("TelecomTransactionalExceptionKey")) {
            return resultData.getParcelable("TelecomTransactionalExceptionKey", CallException.class);
        }
        return new CallException(message, 1);
    }

    private void validateDisconnectCause(DisconnectCause disconnectCause) {
        int code = disconnectCause.getCode();
        if (code != 2 && code != 3 && code != 5 && code != 6) {
            throw new IllegalArgumentException(TextUtils.formatSimple("The DisconnectCause code provided, %d , is not a valid Disconnect code. Valid DisconnectCause codes are limited to [DisconnectCause.LOCAL, DisconnectCause.REMOTE, DisconnectCause.MISSED, or DisconnectCause.REJECTED]", disconnectCause.getCode()));
        }
    }

    private void validateVideoState(@CallAttributes.CallType int videoState) {
        if (videoState != 1 && videoState != 2) {
            throw new IllegalArgumentException(TextUtils.formatSimple("The VideoState argument passed in, %d , is not a valid VideoState. The VideoState choices are limited to CallAttributes.AUDIO_CALL orCallAttributes.VIDEO_CALL", videoState));
        }
    }

    private class CallControlResultReceiver
    extends ResultReceiver {
        private final String mCallingMethod;
        private final Executor mExecutor;
        private final OutcomeReceiver<Void, CallException> mClientCallback;

        CallControlResultReceiver(String method, Executor executor, OutcomeReceiver<Void, CallException> clientCallback) {
            super((Handler)null);
            this.mCallingMethod = method;
            this.mExecutor = executor;
            this.mClientCallback = clientCallback;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void onReceiveResult(int resultCode, Bundle resultData) {
            Log.d(TAG, "%s: oRR: resultCode=[%s]", this.mCallingMethod, resultCode);
            super.onReceiveResult(resultCode, resultData);
            long identity = Binder.clearCallingIdentity();
            try {
                if (resultCode == 0) {
                    this.mExecutor.execute(() -> this.mClientCallback.onResult(null));
                } else {
                    this.mExecutor.execute(() -> this.mClientCallback.onError(CallControl.this.getTransactionException(resultData)));
                }
            }
            finally {
                Binder.restoreCallingIdentity(identity);
            }
        }
    }
}

