/*
 * Decompiled with CFR 0.152.
 */
package android.telecom;

import android.os.Parcel;
import android.os.ParcelUuid;
import android.os.Parcelable;
import android.text.TextUtils;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.Objects;
import java.util.UUID;

public class CallEndpoint
implements Parcelable {
    public static final int ENDPOINT_OPERATION_SUCCESS = 0;
    public static final int ENDPOINT_OPERATION_FAILED = 1;
    public static final int TYPE_UNKNOWN = -1;
    public static final int TYPE_EARPIECE = 1;
    public static final int TYPE_BLUETOOTH = 2;
    public static final int TYPE_WIRED_HEADSET = 3;
    public static final int TYPE_SPEAKER = 4;
    public static final int TYPE_STREAMING = 5;
    private final CharSequence mName;
    private final int mType;
    private final ParcelUuid mIdentifier;
    public static final Parcelable.Creator<CallEndpoint> CREATOR = new Parcelable.Creator<CallEndpoint>(){

        @Override
        public CallEndpoint createFromParcel(Parcel source) {
            CharSequence name = source.readCharSequence();
            int type = source.readInt();
            ParcelUuid id2 = ParcelUuid.CREATOR.createFromParcel(source);
            return new CallEndpoint(name, type, id2);
        }

        public CallEndpoint[] newArray(int size) {
            return new CallEndpoint[size];
        }
    };

    public CallEndpoint(CharSequence name, int type, ParcelUuid id2) {
        this.mName = name;
        this.mType = type;
        this.mIdentifier = id2;
    }

    public CallEndpoint(CharSequence name, int type) {
        this(name, type, new ParcelUuid(UUID.randomUUID()));
    }

    public CallEndpoint(CallEndpoint endpoint) {
        this.mName = endpoint.getEndpointName();
        this.mType = endpoint.getEndpointType();
        this.mIdentifier = endpoint.getIdentifier();
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CallEndpoint)) {
            return false;
        }
        CallEndpoint endpoint = (CallEndpoint)obj;
        return this.getEndpointName().toString().contentEquals(endpoint.getEndpointName()) && this.getEndpointType() == endpoint.getEndpointType() && this.getIdentifier().equals(endpoint.getIdentifier());
    }

    public int hashCode() {
        return Objects.hash(this.mName, this.mType, this.mIdentifier);
    }

    public String toString() {
        return TextUtils.formatSimple("[CallEndpoint Name: %s, Type: %s, Identifier: %s]", this.mName.toString(), CallEndpoint.endpointTypeToString(this.mType), this.mIdentifier.toString());
    }

    public CharSequence getEndpointName() {
        return this.mName;
    }

    public int getEndpointType() {
        return this.mType;
    }

    public ParcelUuid getIdentifier() {
        return this.mIdentifier;
    }

    public static String endpointTypeToString(int endpointType) {
        switch (endpointType) {
            case 1: {
                return "EARPIECE";
            }
            case 2: {
                return "BLUETOOTH";
            }
            case 3: {
                return "WIRED_HEADSET";
            }
            case 4: {
                return "SPEAKER";
            }
            case 5: {
                return "EXTERNAL";
            }
        }
        return "UNKNOWN (" + endpointType + ")";
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel destination, int flags) {
        destination.writeCharSequence(this.mName);
        destination.writeInt(this.mType);
        this.mIdentifier.writeToParcel(destination, flags);
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface EndpointType {
    }
}

